/************************************************************* 
*  This file is part of the Surface Evolver source code.     *
*  Programmer:  Ken Brakke, brakke@susqu.edu                 *
*************************************************************/

/*************************************************************
*
*  File:  proto.h
*
*  Purpose: ANSI function prototypes.
*/

#ifdef  __cplusplus

void loadstub(void);

extern "C" {
#endif

#ifndef drand48
 extern double drand48(void); /* may not be in header file */
#endif

#ifdef MSC
 extern void srand48 (int);
#endif

#ifdef MPI_EVOLVER
#include "mpi_proto.h"
#endif
 
void set_graphics_title(int, char*);
void affinity_mongering(void); // Windows only
void free_element_lists(void);
element_id get_indexed_subtype(struct treenode *, int,element_id,struct expnode*);
void make_thread_lists(void);
edge_id facet_crosscut(facet_id,vertex_id,vertex_id);
void check_edge_vol_methods(edge_id);
void assure_v_constraints(vertex_id);
void convert_lvalue_to_rvalue(struct treenode *);
void free_all_q_info(void);
void setup_q_info(void);
void detorus(void);
void read_array_initializer(struct array *);
int simple_unstar(facetedge_id);
int check_recalc_attr(int);
int check_dont_resize_attr(int);
void check_readonly_attr(int);
void check_special_attr(int);
int  get_name_dim(int,struct locallist_t *);
int  get_name_datatype(int,struct locallist_t *);
char * get_name_name(int,struct locallist_t *);
struct array *get_name_arrayptr(int,REAL*,struct locallist_t *);
int  check_array_dims_same(int ,int, int, int);
void one_sided_volume_adjust(vertex_id);
int one_sided_lagrange_adjust(vertex_id);
int mat_approx_solve(REAL**,int,REAL*);
REAL vertex_total_vol_grad(vertex_id,REAL*);
void calc_one_sided_grads(void);
void mpi_hessian_cleanup(void);
void do_multigrid(struct linsys*);
void mark_recalc_params(void);
int mark_recalc_expr(struct expnode*);
int vertex_facet_check(void);
WRAPTYPE identity_inverse(WRAPTYPE);
WRAPTYPE identity_compose(WRAPTYPE,WRAPTYPE);
void identity_wrap(REAL *,REAL *,WRAPTYPE);
void identity_form_pullback(REAL *,REAL *,REAL *,WRAPTYPE);
void graph_string_facet(facet_id,struct graphdata *,int);
void plain_string_facets(void);
void print_profiling(void);
void reset_profiling(void);
void convert_constraint_to_quantities(int);
int create_body_boundary_content_method(body_id,int);
int create_body_constraint_content_method(body_id,int);
void simplex_to_fe(void);
void check_forwards(void);
int  star_finagle(edge_id);
void cg_restart(void);
REAL cg_sum_calc(void);
void cg_direction_local(void);
REAL ribiere_calc(void);
REAL v_estimate(void);
void add_vgrads_to_update( struct linsys *);
void slice_facet (struct graphdata *);
void slice_edge(struct graphdata *);
void clip_facet(struct graphdata *,facet_id,int);
void clip_edge(struct graphdata *,edge_id,int);
void graph_edge_clip(struct graphdata *,edge_id);
void mark_element_loops(struct treenode *, int);
void mem_list_dump(void);
struct element * elhash_lookup(element_id);
void elhash_delete(element_id);
void elhash_bigger(void);
void elhash_extend(int,int);
struct element *elhash_new_element(int,element_id);
void elhash_insert(element_id,struct element *);
void elhash_replace(element_id,struct element *);
void matrix_multiply_command (struct array*,struct array*,struct array*,REAL*,REAL*,REAL*);
int matrix_inverse_command(struct array*,struct array*,REAL*,REAL*);
REAL matrix_determinant_command(struct array*,REAL*);
void tree_analyze(struct linsys *);
void fixup_edge_content_meths(edge_id);
void fixup_vertex_content_meths(vertex_id);
REAL tetra_vol(REAL*,REAL*,REAL*,REAL*);
int read_single_value(int,char*);
void set_ctypes(void);
void kb_unput(char);
void list_quantity(int);
void list_method_instance(int);
void list_boundary(int);
void list_constraint(int);
void torus_unwrap_edge( edge_id );
int pop_vertex_to_tri( vertex_id, edge_id *);
int pop_vertex_to_quad( vertex_id, edge_id *);
int cubecone_pop( vertex_id, int,struct cone_info * );
void wrap_vertex(vertex_id,int);
void find_cpu_speed(void);
void reset_counts(void);
int pop_constrained_vertex(vertex_id);
int one_con_pop_2(vertex_id,edge_id *,edge_id *,int);
int one_con_pop_3(vertex_id,int ,edge_id *,edge_id *,int);
int one_con_pop_4(vertex_id,edge_id *,int);
int double_con_pop(vertex_id,edge_id,edge_id *);
int triple_con_pop(vertex_id);
void flush_counts(void);
void merge_vertex(vertex_id,vertex_id);
void merge_edge(edge_id,edge_id);
void merge_facet(facet_id,facet_id);
void binary_tree_add(REAL*,REAL);
void  torus_display_period_init(void);
REAL bezier_eval(int, int, int*, REAL *);
void bezier_convert_1D_init( int );
void bezier_convert_2D_init( int );
int t1_edgeswap (edge_id);
void get_edge_tail_tangent(edge_id,REAL*);
int valid_element(element_id);
void bezier_trans_1d(int,int,REAL**);
void bezier_eval_1d(int,int,REAL,REAL**,REAL*);
void lagrange_eval_1d(int,int,REAL,REAL**,REAL*);
void bezier_refine_1d_init (int);
void lagrange_to_bezier(void);
void bezier_to_lagrange(void);

void bezier_trans_2d(int,int,REAL**);
void lagrange_eval_2d(int,int,REAL*,REAL**,REAL*);
void bezier_eval_2d(int,int,REAL*,REAL**,REAL*);
void bezier_refine_2d_init (int);

void detorus_start(void);
void detorus_edge (struct graphdata *, edge_id);
void detorus_facet(struct graphdata *, facet_id);
void detorus_end(void);

void OFF_start(void);
void OFF_edge(struct graphdata *, edge_id);
void OFF_facet (struct graphdata *, facet_id);
void OFF_end(void);

void binary_OFF_start(void);
void binary_OFF_edge (struct graphdata *, edge_id);
void binary_OFF_facet(struct graphdata *, facet_id);
void binary_OFF_end(void);
unsigned int int32hash(unsigned int);
#ifndef NOLONGLONG
unsigned long long int64hash(unsigned long long);
#endif
void partner_move(void);
void partner_shift_grads(int);
void partner_hit_velocity_fix(void);
void partner_hit_volgrad_fix(void);
void detect_bdry_hits(void);
void thread_move_vertices(void);
void thread_calc_facet_volume(void);
void thread_calc_edge_con_volume(void);
void thread_calc_edges(void);
void thread_equiangulate(void);
void torus_period_init(void);
void set_eigenvalue_list_global(REAL*,int);
void set_view_transforms_global(void);
void set_view_transform_generators_global(void);
void set_torus_periods_global(void);
void set_inverse_periods_global(void);
void set_view_matrix_global(void);
void initialize_perm_globals(void);
void allocate_transform_colors(int);
int pop_tri_to_edge(facet_id);
int pop_edge_to_tri(edge_id);
int pop_edge_to_tri_con(edge_id);
int pop_quad_to_quad(facet_id);
void stack_usage(struct expnode *);
void list_top_procedures(int);
void list_procedure(struct global *);
void list_procedure_proto(struct global *);
void list_function_proto(struct global *);
void list_function(struct global *);
void init_local_scope(ident_t,int);
void exit_local_scope(void);
void begin_local_scope(void);
void end_local_scope(void);
void locals_copy(struct locallist_t **,struct locallist_t *);
void locals_copy_perm(struct locallist_t **,struct locallist_t *);
ident_t lookup_local_var(char*);
ident_t add_local_var(char*,int);
void read_attribute_value(struct extra *, void*);
int equiangulate_edge(edge_id);
int calc_view_transform_gens(void);
void force_project( REAL*, vertex_id, REAL *);
int global_meth_needs(int);
int pop_given_vertex (vertex_id);
int pop_string_vertex(vertex_id);
void print_array(struct array *,void*,int);
void print_array_attribute( struct extra*, void*); 
void recalc_facet_area(facet_id);
void rewind_globals(int);
void perm_rewind_globals(int);
void add_warning_message(char*);
void graph_new_surface(void);
void LD_solve(REAL**,REAL*,REAL*,int);
int LD_factor( REAL**, int );
int lookup_global_hash(char*,int,int,int);
void dy_check(void);
void report_quantities(void);
void list_free(char *,int);
void list_free_all(int);
#ifdef MEMSTRINGS
char * list_calloc (size_t,size_t,int,char*,size_t);
char * list_realloc(char *,size_t,int,char*,size_t); 
#else
char * list_calloc (size_t,size_t,int);
char * list_realloc(char *,size_t,int); 
#endif
void mem_list_summary(void);
void mem_check_sanity(void);
void change_hessian_functions(int,int);
int LD_block_factor(REAL **, int);
void LD_block_solve(REAL **, REAL *, REAL *, int);
int find_fixed(void);
void sp_hash_init(struct linsys *,int);
void sp_hash_expand(struct linsys *);
void sp_hash_search(struct linsys *,int,int,REAL);
int sp_hash_end(struct linsys *,int,int,int);
int two_split(facetedge_id,int);
int vertex_degfree(vertex_id);
int edge_degfree(edge_id);
int facet_degfree(facet_id);
void divide_quad(facetedge_id);
int pop_one_edge (edge_id);
void set_scroll_size (int);
REAL ellipticK (REAL);
REAL ellipticE (REAL);
REAL ellipticKdm (REAL);
REAL ellipticEdm (REAL);
REAL ellipticKdmdm (REAL);
REAL ellipticEdmdm (REAL);
REAL incompleteEllipticF(REAL,REAL);
REAL incompleteEllipticFdphi (REAL,REAL);
REAL incompleteEllipticFdm (REAL,REAL);
REAL incompleteEllipticFseconds (REAL,REAL,REAL*,REAL*,REAL*,REAL*,REAL*);
REAL incompleteEllipticE (REAL,REAL);
REAL incompleteEllipticEdphi (REAL,REAL);
REAL incompleteEllipticEdm (REAL,REAL);
REAL incompleteEllipticEseconds (REAL,REAL,REAL*,REAL*,REAL*,REAL*,REAL*);
int INDEX_TO_RGBA(int);
void multi_calc_quants(int);
void m_fix_grads(void);
void m_calc_quant_grads(int);
int mylock_web(void);
int myunlock_web(void);
int mylock_element(element_id);
int myunlock_element(element_id);
element_id thread_next_element(void);
void thread_launch(int,int);
void thread_project_all(int);
void thread_calc_facet_energy(void);
void thread_calc_facet_forces(void);
REAL interp_edge_attribute( edge_id ,struct extra *, int ,int);
REAL interp_facet_attribute ( edge_id ,struct extra *, int ,int);
REAL get_extra_attrib_value ( element_id, struct extra *, int);
void define_array(void);
void userfunc_init(void);
void break_check(void);
int lagrange_facet_normal (vertex_id,facet_id,REAL**);
void test_axial_points( facet_id );
int compare_edge_attr (edge_id, edge_id);
int compare_edge_facet_attr (edge_id,facet_id);
int compare_vertex_edge_attr(vertex_id, edge_id);
int compare_vertex_attr (vertex_id, vertex_id);
void set_body_volume(body_id,REAL,int);
void add_body_volume(body_id,REAL);
void add_body_volume_plain(body_id,REAL);
void add_body_abstotal(body_id,REAL);
void set_body(facet_id,body_id);
int kb_yylex (YYSTYPE*);
void reset_inputbuffer(void);
char *my_fgets(char *,int,FILE *stream);
int method_check(void);
void renumber_all(void);
void reorder_storage(void);
int identtype(char*);
REAL kb_drand(void);
void  kb_initr(int); 
void dump_macros(void);
void move_to_free_front(int,int);
void calc_all_grads (int);
void check_pinning(void);
void convert_forms_to_vectors(int);
void local_convert_forms_to_vectors(int);
void clear_v_conmap(vertex_id);
void list_attributes(void);
void reset_rot_order(void);
void start_logfile(char*);
void stop_logfile(void);
void start_keylogfile (char*);
void stop_keylogfile(void);
void one_sided_adjust(int);
void calc_leftside(void);
void local_calc_leftside(void);
void local_calc_rightside(void);
void load_library (char *);
void unload_libraries(void);
dll_func_type search_libraries(char*);
REAL get_internal_variable(int );
void check_element_type( int, int );
int read_pick(void);
int count_fixed_vol(void);
int oid (element_id);
void flip_toggle (int*,int,char*);
int gram_schmidt(REAL**,int,int);
int new_vertex_average (vertex_id,int);
int lagrange_vertex_average (vertex_id,REAL*);
void keyword_help (char *);
void error_help(char *);
int do_edgeswap (edge_id);
void apply_h_inverse_metric(void);
void list_proc (struct global *,int);
void list_procedures (int);
void linear_to_lagrange (int);
void quad_to_lagrange(int);
void lagrange_to_linear(void);
void lagrange_to_quad(void);
void sparse_permute (struct linsys *);
void do_tree_factor(struct linsys *);
void do_tree_solve(struct linsys *,REAL *,REAL*);
int find_method_instance(char*);
int find_quantity(char*);
void reconvert_bodies_to_quantities(void);
void convert_bodies_to_quantities(void);
int string_rebody(void);
void lagrange_to_lagrange(int);
void simplex_lagrange_to_lagrange (int);
void metis_partition (int,int);
void metis_partition_plain (int,int);
void metis_partition_body (int,int);
void metis_partition_dual (int,int);
void metis_order (struct linsys *);
void metis_vertex_order (int);
int lagrange_index (int,int,int*);
int increment_lagrange_index (int,int*);
void gauss_lagrange_setup (int,int,int);
void det_hess (REAL **,REAL ****,int );
int simplex_delete_facet (facet_id);
int simplex_delete_edge (vertex_id,vertex_id);
void write_hessian (struct linsys *);
REAL gravity_all  (struct qinfo *,int);
void  LQ_decomp (REAL**,int,int,REAL**,REAL**,struct linsys *);
void q_info_free (struct qinfo *);
void q_info_init (struct qinfo *,int);
void make_el_list (int);
int Ord (element_id);
void toggle_save (char*);
void toggle_save_off (char*);
int get_v_constraint_status (vertex_id,int);
int v_hit_constraint_count (vertex_id);
REAL square_grad(void);
void square_grad_forces(void);
void cg_ritz (struct linsys *,int,REAL**,REAL*);
int check_pick(void);
void read_extra (element_id,int);
int simplex_quadrature (int,int,int,REAL**,REAL*);
int eartest (vertex_id,vertex_id,vertex_id,vertex_id);
void convert_string (char*,char*,int);
void hessian_legal(void);
int check_one_sided_constraints(void);
void set_v_global (vertex_id);
void set_v_conmap (vertex_id,conmap_t*);
void set_e_conmap (edge_id,conmap_t*);
void set_f_conmap (facet_id,conmap_t*);
void set_v_constraint_map (vertex_id,int);
void unset_v_constraint_map (vertex_id,int);
void set_v_constraint_status (vertex_id,int);
void unset_v_constraint_status (vertex_id,int);
void clear_v_constraint_status (vertex_id);
void set_e_constraint_map (edge_id,int);
void unset_e_constraint_map (edge_id,int);
void set_f_constraint_map (facet_id,int);
void unset_f_constraint_map (facet_id,int);
int v_on_constraint (vertex_id,int);
int e_on_constraint (edge_id,int);
int f_on_constraint (facet_id,int);
void get_v_common_conmap (vertex_id,vertex_id,conmap_t *,int);
void unset_v_all_constraints(vertex_id);
void unset_e_all_constraints(edge_id);
void unset_f_all_constraints(facet_id);

int simplex_tiny_edges (REAL);
int get_tag (facet_id);
void set_tag (facet_id,int);
void ritz_command (REAL,int);
void do_ritz (struct linsys *,REAL,int,REAL **);
void print_hessian_menu(void);
void expand_attribute (int,int,int*);
void expand_global_hash(void);
int edgeswap ( edge_id);
REAL sparse_metric_dot (REAL*,REAL*,struct linsys *);
void gauss_jacobi (int, REAL , REAL *, REAL *);
void jacobi_eigenpairs ( REAL **, int, REAL *, REAL **, REAL *);
void star_metric_setup ( struct linsys *S, struct linsys *);
void linear_metric_setup (struct linsys *, struct linsys *);
void linear_metric_setup_quadratic ( struct linsys *, struct linsys *);
void linear_metric_setup_lagrange ( struct linsys *, struct linsys *);
REAL get_vertex_length_star (vertex_id);
REAL get_vertex_area_star (vertex_id);
void convert_to_quantities(void);
void convert_body_to_quantity (body_id);
void convert_new_body_to_quantity (body_id);
void long_jiggle(void);
void free_system (struct linsys *);
int simplex_long_edges (REAL);
void lanczos_command (REAL,int);
void eigenprobe_command (REAL,int);
void myfree (char *);
void option_facet (struct graphdata*,facet_id); 
void geomview_command (char*);
void ysmp_numeric_factor(void);
void sp_hessian_mult (struct linsys *, REAL*, REAL*);
void sp_solution (struct linsys *, REAL*, REAL*, int );
void hessian_exit (REAL *);
void hessian_cleanup(void);
void hessian_solve(void); 
void hessian_downhill(void); 
void hessian_move (REAL,int,REAL *);
int  lanczos (struct linsys*,int,REAL*,int);
int  selective_lanczos (struct linsys*,int,REAL*,int);
void tridiag_QL (REAL*,REAL*,int);
void intersect_detect(void);
void bk_mul (struct linsys *, REAL*,REAL*);
void bk_AIJ_setup (int,struct linsys*);
void bk_eigenprobe (struct linsys *);
void bk_inverse_it (struct linsys *, REAL *);
void sp_hessian_solve (struct linsys *,REAL *, REAL *,int);
void sp_hessian_solve_multi (struct linsys *,REAL **, REAL **,int);
void sp_Hessian_solver (struct linsys *, REAL *, REAL **);
void bk_constraint_setup (int, struct linsys *);
void BK_hess_project_setup (struct linsys *);
void xmd_factor (struct linsys *,int);
void xmd_solve (struct linsys *,REAL *,REAL *,int);
void xmd_solve_multi (struct linsys *,REAL **,REAL **,int,int);
void sp_CHinvC (struct linsys *);
void tree_factor (struct linsys *);
void tree_solve (struct linsys *,REAL *,REAL *);
void tree_solve_multi (struct linsys *,REAL **,REAL **,int);
void ysmp_factor (struct linsys *,int);
void ysmp_solve (struct linsys *,REAL *,REAL *,int);
void ysmp_solve_multi (struct linsys *,REAL **,REAL **,int,int);
void mkl_factor (struct linsys *,int);
void mkl_solve (struct linsys *,REAL *,REAL *,int);
void mkl_solve_multi (struct linsys *,REAL **,REAL **,int,int);
void mkl_free (struct linsys *);
void find_ordering (struct hess_verlist *,int,int *);
void hessian_saddle (REAL);
REAL lowest_eigenpair (struct linsys *,REAL *);
REAL cg_lowest_eigenpair (struct linsys *,REAL *);
REAL old_cg_lowest_eigenpair (struct linsys *,REAL *);
REAL new_cg_lowest_eigenpair (struct linsys *,REAL *);
element_id get_ordinal_id (int,int);
element_id get_full_id (int,element_id);
void project_all (int,int);
void chebychev_hess (struct linsys *);
void chebychev_ev (struct linsys *);
void fill_self_entry (struct linsys *,vertex_id,REAL**);
void fill_grad (struct linsys *,struct hess_verlist *,REAL*,REAL *);
int add_attribute (int,char*,int,int,int*,int,struct expnode *,int );
int find_attribute (int,char*);
int find_extra (char *, int *);
int matrix_index (REAL**,int);
int exec_commands (FILE *,char *);
void *mac_exec_commands (FILE *);
void push_fd (FILE *,char *);
void pop_fd(void);
facet_id get_vertex_first_facet (vertex_id);
facet_id get_next_vertex_facet (vertex_id,facet_id);
facet_id get_simplex_next_vertex_facet (vertex_id,facet_id);
void macro_init(void);
REAL ** mat2d_setup (REAL**,REAL*,int,int);
REAL *** mat3d_setup (REAL***,REAL*,int,int,int);
REAL **** mat4d_setup (REAL****,REAL*,int,int,int,int);
void zerohess (struct qinfo *);
void get_facet_normal (facet_id,REAL*);
int get_toggle_value (int);
void force_normalization(void);
void insert_vertex_edge (vertex_id,edge_id);
void remove_vertex_edge (vertex_id,edge_id);
void insert_vertex_facet (vertex_id,facet_id);
void remove_vertex_facet (vertex_id,facet_id);
void catfulltext (char*);
int identcase (char*);
int delete_facet (facet_id);
int string_delete_facet (facet_id);
REAL quantity_attribute ( element_id, int );
REAL instance_attribute ( element_id, int );
int kb_checksum (char *,int);
void apply_quantity (element_id,int);
void unapply_quantity (element_id,int);
void read_instance_attr ( int );
int read_named_quantity(void);
DY_OFFSET dy_calloc (int,int);
DY_OFFSET dy_realloc (DY_OFFSET,int,int);
void dy_free (DY_OFFSET);
void dump_method_specs ( int );
void read_method_attr ( int );
void calc_periods (int);
int read_method_instance(void);
int add_standard_quantity (char *,REAL);
int new_method_instance (char*,char*);
void free_method_instance (struct method_instance *);
int dup_method_instance (char*,char*);
int attach_method ( int, char *);
int attach_method_num ( int, int);
void apply_method ( element_id , char *);
void apply_method_num ( element_id , int);
void unapply_method ( element_id , int);
int rebody(void);
int merge_bodies(void);
int get_body_valence (body_id );
int get_vertex_evalence (vertex_id );
int get_vertex_fvalence (vertex_id );
void make_vfacet_lists(void);
void make_bfacet_lists(void);
void make_vedge_lists(void);
REAL dirichlet (int);
REAL sobolev (int);
int unstar (facetedge_id);
void reduce_string (char *); 
REAL vertex_angle (vertex_id);
void fix_ctm (REAL**,REAL,REAL);
void my_exit (int);
void reverse_orientation_edge (edge_id);
void reverse_orientation_facet (facet_id);
int dissolve_vertex (vertex_id);
int dissolve_edge (edge_id);
int dissolve_facet (facet_id);
int dissolve_body (body_id);
REAL vertex_sq_mean_curvature (vertex_id);
REAL vertex_mean_curvature (vertex_id);
void burchard (int);
void do_gfile (int,char*);
int mat_simplify (REAL***,int);
void transform_gen_expr (char *);
void generate_transforms (int);
void read_transform_generators (int);
int const_expr (char *,REAL *);
REAL wedge_angle (vertex_id);
void begin_normal_motion(void);
void end_normal_motion(void);
REAL gray_level (float *);
void  metric_form_to_vector (REAL*,REAL*);
void end_geomview_object(void);
void calc_quant_grads (int);
int simplex_element_id_edges (REAL);
void quantity_init(void); 
int new_quantity (char *,int);
int new_quantity_alloc(void);
void free_quantity(struct gen_quant *);
void add_quantity (element_id,char*,char*);
REAL calc_quants (int); 
void graph_edge_transforms ( struct graphdata *, edge_id );
void graph_facet_transforms ( struct graphdata *, facet_id );
void other_stuff (struct treenode *,int*,int*,element_id,REAL*,struct locallist_t*);
void more_other_stuff (struct treenode *,int*,int*,element_id,REAL*,struct locallist_t*);

void ask_wrap_display(void);
void print_attr ( struct treenode *, char *);
void print_set_attr ( struct treenode *, char *);
void set_print (struct treenode *, char *, char *,int);
void binary_print ( struct treenode *, int, int, char *, int);
int lookup_global (char*);
int lookup_perm_global (char*);
void klein_area_grad (REAL **,REAL**);
REAL klein_area (REAL**);
void klein_length_grad (REAL*,REAL*,REAL*,REAL*);
REAL klein_length (REAL*,REAL*);
void  geomview_start(void);
void  geomview_facet (struct graphdata *, facet_id);
void  geomview_edge (struct graphdata *, edge_id);
void  geomview_end(void);
void tree_copy ( struct expnode *, struct treenode *);
void perm_tree_copy ( struct expnode *, struct treenode *);
void conf_edge_curv_energy(void);
void conf_edge_curv_force(void);
REAL dihedral (edge_id);
void clear_symtable(void);
void clear_globals(void);
int add_global (char *);
int add_perm_global (char *);
char *keywordname (int);
void subtree_swap (int*,int*);
int begin_scope(void);
void end_scope(void);
void set_scope (int);
struct sym * symbol_add (char*,int);
struct sym *symbol_lookup (char*);
vertex_id void_test (vertex_id *,int);
char *tokname (int);
void update_aggr (int ,REAL *,REAL );
void hessian_init (struct linsys *,REAL **);
void hessian_fill (struct linsys *,REAL **);
void find_hess_entry (struct linsys *, struct hess_verlist*,
                 struct hess_entry *[MAXCOORD][MAXCOORD]);
void fill_hess_entry (struct linsys *, vertex_id,REAL**);
int find_mixed_entry (struct linsys *, struct hess_verlist*,
    struct hess_verlist* ,struct hess_entry *[MAXCOORD][MAXCOORD]);
void fill_mixed_entry (struct linsys *, vertex_id,vertex_id, REAL **); 
int find_hess_entries (struct linsys *, struct hess_verlist*,
        struct hess_verlist*, 
        struct hess_entry *[MAXCOORD][MAXCOORD],
        struct hess_entry *[MAXCOORD][MAXCOORD],
        struct hess_entry *[MAXCOORD][MAXCOORD]);

void area_hessian (struct linsys *,REAL *);
void calc_quant_hess (struct linsys *,int,int,REAL *);
void m_calc_quant_hess (int,int,REAL *);
void m_fix_hess (struct linsys *S);
void difference_hessian (struct linsys *,struct hess_verlist*,REAL *);
void edge_energy_hessian (struct linsys *,REAL *);
void simplex_hessian (struct linsys *,REAL *);
void simplex_facet_hessian (struct linsys *,REAL *);
void simplex_edge_hessian (edge_id,REAL**,REAL****);
void edge_constr_hessian (struct linsys *,edge_id,REAL**,REAL****);
int body_hessian (struct linsys *,REAL*);
void tree_exec ( struct treenode *);
void letter_command (int);
void pop_commandfd(void);
void push_commandfd (FILE*,char*);
void pop_datafd(void);
void push_datafd (FILE*,char*);
void exec_file (FILE*,char*);
void unput_tok(void);
void unput_string (char*);
void set_f_phase_density (facet_id);
void set_e_phase_density (edge_id);
int bdry_basis (vertex_id,REAL**);
int constr_basis (vertex_id,REAL**);
void  sp_factor (struct linsys *,int);
void stability_test(void);
void mobility_cleanup(void);
void mobility_mult (REAL*);
void mobility_setup(void);
void approx_curv_calc (int);
void approx_curvature(void);
int new_popverst (vertex_id,int);
void phase_initialize (char *);
void check_vertex_fe (vertex_id);
void information(void);
void show_volumes(void);
int set_parameters(void);
int minus_type (int);
void string_fixup(void);
void runge_kutta(void);
void autopop_init(void);
void autopop_cleanup(void);
void autopop_pop(void);
void autochop_chop(void);
void autopop_detect (REAL);
vertex_id find_other_vertex (vertex_id *,int,vertex_id);
void simplex_delaunay_test(void);
void push_face (vertex_id *);
int pop_face (vertex_id *);
void end_face_stack(void);
void init_face_stack (int);
int simplex_equiangulate(void);
void calc_simplex_edge_force (edge_id);
int kernel_basis (REAL**,REAL**,int,int);
int kernel_basis_rows (REAL**,REAL**,int,int);
void tr_mat_mul (REAL**,REAL**,REAL**,int,int,int);
void mat_mul_tr (REAL**,REAL**,REAL**,int,int,int);
void  mat_tsquare (REAL**,REAL**,int,int);
void calc_simplex_edge_energy (edge_id,int);
void exterior_product (REAL **,REAL *,int,int);
int binom_coeff (int,int);
void hi_dim_graph(void);
void recalc(void);
void reset_conj_grad(void);
void kusner_energy(void);
void kusner_force(void);
void sqgauss_energy(void);
void sqgauss_force(void);
int prompt (char*,char*,int);
#ifdef USE_READLINE /* CSL */
void save_readline_history(void);
#endif
void update_display(void);
void local_update_display(void);
void set_spinr (REAL);
void set_spinl (REAL);
void set_tipup (REAL);
void set_tipdown (REAL);
void set_clockwise (REAL);
void set_counterclockwise (REAL);
void set_zoom (REAL);
void skinny_histogram(void);
int skinny (REAL);
int get_edge_valence (edge_id);
int get_facet_valence (edge_id);
void alice(void);
void sqcurve_force_string (vertex_id);
void sqcurve_force_string_end(void);
void sqcurve_energy_string (vertex_id);
void sqcurve_energy_string_init(void);
void bad_function(void);
void sqcurve_force_init(void);
void sqcurve_energy_init(void);
void sqcurve_energy (vertex_id*, REAL (*)[MAXCOORD]); 
void sqcurve_force (vertex_id*,edge_id*,REAL(*)[MAXCOORD]); 
void sqcurve_energy_end(void);
void sqcurve_force_end(void);
void top_dump (FILE *);
void bottom_dump (FILE *);
void vertex_dump (vertex_id,FILE *);
void edge_dump (edge_id,FILE *);
void facet_dump (facet_id,FILE *);
void facetedge_dump (facetedge_id,FILE *);
void body_dump (body_id,FILE *);
WRAPTYPE torus_inverse (WRAPTYPE);
WRAPTYPE torus_compose (WRAPTYPE,WRAPTYPE);
void torus_wrap (REAL *,REAL *,WRAPTYPE);
void torus_form_pullback (REAL *,REAL *,REAL *,WRAPTYPE);
WRAPTYPE group_inverse (WRAPTYPE);
WRAPTYPE group_compose (WRAPTYPE,WRAPTYPE);
void group_wrap (REAL *,REAL *,WRAPTYPE);
void group_form_pullback (REAL *,REAL *,REAL *,WRAPTYPE);
void print_matrix ( REAL **, int , int );
REAL simplex_energy_metric (vertex_id*,REAL * *);
void simplex_force_metric (vertex_id *,REAL**, REAL,REAL **);
void gauss_setup(void);
void simplex_grad_l(void);
void end_hash_table(void);
void rehash(void);
void init_hash_table(void);
void check_orientation (struct simplex *,int);
void refine_simplex_init(void);
void refine_simplex (int,int *,struct divedge *,struct simplex *);
void refine_all_simplices(void);
vertex_id simplex_edge_divide (vertex_id,vertex_id);
int poponest (vertex_id,int);
void free_discards (int);
int find_vertex_to_pop(void);
void puff(void);
REAL splinepoly (int,REAL);
REAL splinederiv (int,REAL);
void spline_partial (int *,REAL,int,REAL *);
void spline_partial_t (int *,REAL,REAL *);
void dump_buff (char*,size_t);
int  command (char *,int);
void newcommand (char *);
void new_history (char *);
int old_history (char *);
int  qqparse(void);
#ifdef MEMSTRINGS
char *kb_calloc (size_t,size_t,char*,size_t);
char *KB_realloc (char*,size_t,char*,size_t);
char *kb_temp_calloc (size_t,size_t,char*,size_t);
char *kb_temp_realloc (char*,size_t,char*,size_t);
#else
char *kb_calloc (size_t,size_t);
char *KB_realloc (char*,size_t);
char *kb_temp_calloc (size_t,size_t);
char *kb_temp_realloc (char*,size_t);
#endif
void temp_free (char *);
void temp_free_all(void);
void cg_direction(void);
void cg_calc_gamma(void);
void simplex_facet_average (facet_id,int);
void facet_average (facet_id,int);
void edge_average (edge_id,int);
void recalc_verts(void);
void grule (int , REAL *, REAL *);
void read_facet_edges(void);
void read_faces(void);
void read_edges(void);
void read_vertices(void);
void read_bodies(void);
int read_quantity(void);
int read_const (REAL *);
void lowbound(void);
void ridge_histogram(void);
int collapse_check(void);
#ifndef TCPP
int vvvvcomp (struct vvvv *,struct vvvv *);
#endif
void End_OOGL (void );
void End_geomview (void );
void UpdateOOGL (void );
void Begin_OOGL (void );
void Begin_geomview (char*);
void softimage (void );
void constraint_init (struct constraint *);
void constraint_free (struct constraint *);

REAL find_flux (facet_id);
int is_constant (int);
void free_expr (struct expnode *);
void perm_free_expr (struct expnode *);
void startup (char *);
void reset_view(void);
void read_parameter(void);
void read_transforms (int);
void zoom_vertex (vertex_id,REAL);
REAL distance (vertex_id,vertex_id);
void merge_collapsed_facets(void);
void constr_vol_grad_q (edge_id);
void homothety(void);
void ex_fold (struct treenode *);
void fold_recur (struct treenode *, int *);
int yybegin(void);
void yylex_init(void);
int yyerror (char *);
int yyparse(void);
int  yylook(void);
int  yywrap(void);
int yylex(void);
int yyreject(void);
int gettok (int);
int  kb_input(void);
void rawunput (int);
int  macro(void);
void record_macro(void);
void fe_reorder (edge_id);
void raw_fe_reorder (edge_id);
void pix_start(void);
void pix_facet (struct graphdata *,facet_id);
void pix_end(void);
void constr_edge_force_q (edge_id);
void restore_vertex (vertex_id,struct oldcoord *,int);
REAL normal_change_check(void);
FILE *path_open (char *,int);
void fil_finish(void);
void fil_facet (struct tsort *);
void fil_edge (struct tsort *);
void fil_init(void);
void ps_finish(void);
void ps_facet (struct tsort *);
void ps_edge (struct tsort *);
void ps_init(void);
void display_file (int);
void graph_help(void);
void main_help(void);
REAL edge_grav_density (edge_id);
int facet_body_check(void);
int facetedge_check (int);
int list_check(void);
int run_checks(void);
int pop_vertex (vertex_id,int,struct cone_info *);
int kraynik_pop (vertex_id,int,struct cone_info *);
int popfilm(void);
void face_triangulate (facet_id,int);
void file_wulff (REAL *,REAL *);
void lens_wulff (REAL *,REAL *);
void hemi_wulff (REAL *,REAL *);
int curtest_facet (facet_id);
int curtest_edge (edge_id,facetedge_id,facetedge_id);
void curtest(void);
void fix_volconst(void);
element_id upgrade (element_id);
facet_id dup_facet (facet_id);
body_id dup_body (body_id);
REAL estimate_decrease(void);
void constr_edge_content_q (edge_id);
void constr_edge_energy_q (edge_id);
void tordup (int);
void add_outside(void);
REAL calc_content (int);
void local_calc_content (int);
int equal_constr (element_id ,element_id);
void bdry_spring_energy (edge_id);
void constr_spring_energy (edge_id);
void torus_cells(void);
void torus_edge_clip (struct graphdata *,int );                          
void torus_arc_clip (struct graphdata *,int );                          
void null_function(void);
void diffuse(void);
int cone_analyze (struct verfacet *,int,struct cone_info *);
vertex_id dup_vertex (vertex_id);
edge_id dup_edge (edge_id);
void versplit (facetedge_id ,facetedge_id,int);
int try_prop (facetedge_id *, facetedge_id,int);
int edgepop_film(void);
char * print_express (struct expnode *,int);
void exprint_recur (struct treenode *,int);
char *kb_strstr (char *,char *);
int kb_stricmp (char *,char *);
int kb_strnicmp (char *,char *, int);
void kb_memmove (char *,char *,size_t);
int pixdump(void);
void constr_springs (edge_id);
void save_coords (struct oldcoord *,int);
void local_save_coords (struct oldcoord *,int);
void restore_coords (struct oldcoord *,int);
void local_restore_coords (struct oldcoord *,int);
void unsave_coords (struct oldcoord *,int);
void local_unsave_coords (struct oldcoord *,int);
void enforce_constraints(void);
void kb_strupr (char *);
void b_proj (struct boundary *,REAL *,REAL * *,int, vertex_id );
void b_extrapolate (struct boundary *,REAL *,REAL *,REAL *,REAL *,
   REAL *,vertex_id);
void bdry_force (edge_id );
void calc_bdry_force_v (vertex_id );
void calc_bdry_force_e (edge_id );
void calc_bdry_energy_v (vertex_id );
void calc_bdry_energy_e (edge_id );
void calc_bdry_content_v (vertex_id );
void calc_bdry_content_e (edge_id );
void calc_force (void );
void local_calc_force (void );
void calc_energy(void);
void local_calc_energy(void);
void calc_pressure (void );
void display (void );
int constr_proj (int ,int ,struct constraint * *,REAL *,REAL *,
   REAL *,int *,int,vertex_id);
int constr_proj_matrix ( vertex_id, REAL ** );
int constr_proj_matrix_wall ( vertex_id, REAL ** );
int project_v_constr (vertex_id,int,int );
void calc_constr_force_v (vertex_id );
void calc_constr_force_e (edge_id );
void calc_constr_energy_v (vertex_id );
void calc_constr_energy_e (edge_id );
void calc_constr_content_v (vertex_id );
void calc_constr_content_e (edge_id );
void dump (void );
void do_dump (char *);
REAL eval (struct expnode *,REAL *,element_id,struct eval_frame*);
void eval_all (struct expnode *,REAL *,int,REAL *,REAL *,element_id);
void eval_second (struct expnode *,REAL *,int,REAL *,REAL *,
 REAL**,element_id);
REAL tree_eval (struct treenode *,REAL *);
REAL eval_deriv (struct expnode *,REAL *,int );
REAL tree_eval_deriv (struct treenode *,REAL *,int );
int exparse (int ,struct expnode *,int);
void calc_simplex_forces (facet_id);
void calc_simplex_energy (facet_id,int);
void calc_simplex_volume (facet_id);
void facet_force_l (facet_id );
void facet_energy_l (facet_id,int);
void facet_force_l_hi_d (facet_id );
void facet_energy_l_hi_d (facet_id);
void facet_volume_l (facet_id );
void film_grad_l (void );
void film_bdry_grad (void );
void film_constr_grad (void );
void facet_force_q (facet_id );
void facet_energy_q (facet_id,int );
void facet_volume_q (facet_id );
void film_grad_q (void );
REAL tq7_integral (REAL (*)(REAL,REAL));
REAL intpoly6 (int ,REAL ,REAL );
REAL intpoly6part (int ,int ,REAL ,REAL );
REAL vintzf (REAL ,REAL );
void vcoeff_init (void );
void calc_volgrads (int);
void local_calc_volgrads (int);
void pressure_forces(void);
void calc_lagrange(void);
void lagrange_adjust(void);
int local_lagrange_adjust(void);
void volume_restore (REAL,int);
void local_volume_restore (REAL,int);
int graphgen (void );
void raw_generate(void);
void plain_facets (void );
void plain_edges (void );
void bare_edges (void );
void triple_edges (void );
void torus_clip (struct graphdata *,int, facet_id );
int bfcomp (struct bodyface *,struct bodyface *);
void torus_bodies (void );
void reset_web (void );
void initialize(void);
void read_periods (void );
void read_display_periods (void );
void wulff_initialize (char *);
int  read_boundary(void);
int  read_constraint(void);
void read_surface_energy(void);
void iterate (void );
void fix_vertices (void );
void move_vertices (int,REAL );
void local_move_vertices (int,REAL );
void jiggle (void );
void element_id_jiggle (void );
REAL gaussian (void );
void nrerror (char *);
void matcopy (REAL * *,REAL * *,int ,int );
REAL **perm_matrix2 (int,int);
#ifdef MEMSTRINGS
REAL * *kb_dmatrix (int ,int ,int ,int,char*,int );
REAL * * * kb_dmatrix3 (int ,int ,int,char*,int );
REAL * * * * kb_dmatrix4 (int ,int ,int, int,char*,int );
REAL * *kb_temp_dmatrix (int ,int ,int ,int,char*,int );
REAL * * * kb_temp_dmatrix3 (int ,int ,int,char*,int );
REAL * * * * kb_temp_dmatrix4 (int ,int ,int, int,char*,int );
#else
REAL * *kb_dmatrix (int ,int ,int ,int );
REAL * * * kb_dmatrix3 (int ,int ,int );
REAL * * * * kb_dmatrix4 (int ,int ,int, int );
REAL * *kb_temp_dmatrix (int ,int ,int ,int );
REAL * * * kb_temp_dmatrix3 (int ,int ,int );
REAL * * * * kb_temp_dmatrix4 (int ,int ,int, int );
#endif
REAL *** matrix3_reorder (REAL***,int,int,int);
int *ivector (int ,int );
REAL *vector (int ,int );
void free_ivector (int *,int ,int );
void free_vector (REAL *,int ,int );
void free_matrix (REAL * *);
void free_matrix3 (REAL * * *);
void free_matrix4 (REAL * * * *);
void free_temp_matrix (REAL * *);
void free_temp_matrix3 (REAL * * *);
void free_temp_matrix4 (REAL * * * *);
void vector_add (REAL*,REAL*,int);
void vector_add_smul (REAL*,REAL*,REAL,int);
void vector_sub (REAL*,REAL*,int);
void vnormal (REAL *,REAL *,REAL *,REAL *);
void cross_prod (REAL *,REAL *,REAL *);
REAL triple_prod (REAL *,REAL *,REAL *);
REAL dot (REAL *,REAL *,int );
REAL dotf (float *,float *,int );
REAL dotdf (REAL *,float *,int );
void matvec_mul (REAL * *,REAL *,REAL *,int ,int );
void vec_mat_mul (REAL *,REAL ** ,REAL *,int ,int );
void mat_mult (REAL * *,REAL * *,REAL * *,int ,int ,int );
REAL quadratic_form (REAL *,REAL **,REAL *,int);
int  mat_inv (REAL * *,int );
int  mat_inv_sym (REAL * *,int );
REAL  determinant (REAL * *,int );
REAL  det_adjoint (REAL * *,int );
void change_model (void );
void linear_to_quad (void );
void quad_to_linear (void );
edge_id edge_divide (edge_id );
void cross_cut (facetedge_id ,facetedge_id );
void painter_start (void );
void painter_facet (struct graphdata *,facet_id );
void painter_end (void );
int in_back (struct tsort *,struct tsort *);
int separating_plane (struct tsort *,struct tsort *,int);
int separating_line (struct tsort *,struct tsort *);
void painter_edge (struct graphdata *,edge_id);
int verpop_film (void );
void do_save (void );
void do_restore (void );

int odd4cone_pop (vertex_id,int,struct cone_info *);
void set_facet_fe (facet_id ,facetedge_id );
vertex_id new_vertex (REAL *,element_id);
edge_id new_edge (vertex_id ,vertex_id,element_id );
facet_id new_facet (void );
body_id new_body (void );
facetedge_id new_facetedge (facet_id ,edge_id );
REAL get_edge_length (edge_id );
REAL get_facet_pressure (facet_id );
#ifndef elptr
struct element *elptr (element_id );
#endif
void extend (int,int);
void expand (int,int );
void unfree_element (element_id);
int generate_all (int ,element_id *,element_id *);
void memory_report (void );
void reset_skeleton (void );
void vgrad_init (void);
void vgrad_end (void );
struct volgrad *get_vertex_vgrad (vertex_id);
void set_vertex_vgrad (vertex_id,struct volgrad*);
struct volgrad *get_next_vgrad (struct volgrad *);
struct volgrad *new_vgrad (void );
struct volgrad *get_bv_vgrad (int ,vertex_id );
struct volgrad *get_bv_new_vgrad (int ,vertex_id );
element_id new_element (int,element_id,element_id);
void free_element (element_id );
void edge_force_l (edge_id );
void edge_energy_l (edge_id );
void edge_area_l (edge_id );
void edge_force_l_metric (edge_id );
void edge_energy_l_metric (edge_id );
void edge_force_q_metric (edge_id );
void edge_energy_q_metric (edge_id );
void string_grad_l (void );
void string_bdry_grad (void );
void string_constr_grad (void );
REAL interpoly (int ,REAL );
REAL interpolyderiv (int ,REAL );
void scoeff_init (void );
void edge_force_q (edge_id );
void edge_energy_q (edge_id );
void edge_area_q (edge_id );
void string_grad_q (void );
void do_show (void );
int  view_transform (char *);
void init_view (void );
void resize (void );
int old_menu (char * );
void extrapolate (void );
void save (void );
void restore (char *);
void torvol(void);
void torvol_project (int  );
void refine (void );
void local_refine (void );
int areaweed (REAL );
void area_histogram (void );
int edgeweed (REAL );
void edge_histogram (void );
int delete_edge (edge_id );
void change_vertex (facetedge_id ,vertex_id ,vertex_id ,WRAPTYPE);
int articulate (REAL );
edge_id edge_refine (edge_id );
int equiangulate (void );
int ridge_notcher (REAL );
void outstring ( char *);
void erroutstring (char *);
void getstring (char *,int);
void kb_error (int, char *,int );
void catcher (int );
void calc_edge (edge_id );
void get_edge_side (edge_id ,REAL *);
void get_edge_adjust (edge_id ,REAL *);
REAL calc_vertex_normal (vertex_id,facetedge_id ,REAL *);
void calc_vertex_smooth_normal (vertex_id,facetedge_id ,REAL *);
int new_calc_vertex_normal (vertex_id,REAL **);
int project_vertex_normals ( vertex_id, REAL **, int );
int simplex_vertex_normal (vertex_id,REAL **);
void get_edge_verts (edge_id ,REAL * *,WRAPTYPE*);
void get_facet_verts (facet_id ,REAL * *,WRAPTYPE*);
void get_facet_verts_special (facet_id ,REAL * *,WRAPTYPE*);
void get_facet_verts_q (facet_id ,REAL * *,WRAPTYPE*);
int verpop_str (void );
void dump_force(void);
void vertex_average (int);
void hessian_menu(void);
void hessian_auto(void);
REAL hessian_seek (REAL);
REAL hessian_line_seek (struct linsys *,REAL,REAL*);
void set_facet_body (facet_id ,body_id );

int makenode (NTYPE,NTYPE,NTYPE);

void set_body_fixvol (body_id,REAL);
facet_id get_next_body_facet (facet_id);
facet_id get_prev_body_facet (facet_id);
void set_next_vertex_facet (vertex_id,facet_id,facet_id);
void set_next_body_facet (facet_id,facet_id);
void set_prev_body_facet (facet_id,facet_id);
void set_fe_facet (facetedge_id ,facet_id );

#if !defined (INLINE)
/* some functions replaced by macros in serial version */
int get_meth_offset (int);
char *get_extra (element_id,int);
char *get_extra_ptr (element_id,struct extra *);
void set_body_volconst (body_id,REAL);
void set_fe_edge (facetedge_id ,edge_id );
facet_id get_fe_facet (facetedge_id );
facetedge_id get_prev_facet (facetedge_id );
facetedge_id get_next_facet (facetedge_id );
void set_prev_edge (facetedge_id ,facetedge_id );
void set_next_edge (facetedge_id ,facetedge_id );
void set_prev_facet (facetedge_id ,facetedge_id );
void set_next_facet (facetedge_id ,facetedge_id );
void set_edge_wrap (edge_id ,WRAPTYPE  );
WRAPTYPE get_edge_wrap (edge_id );
void set_edge_fe (edge_id ,facetedge_id );
facetedge_id get_edge_fe (edge_id );
void set_edge_tailv (edge_id ,vertex_id );
void set_edge_headv (edge_id ,vertex_id );
void set_edge_midv (edge_id ,vertex_id );
body_id get_facet_body (facet_id );
facetedge_id get_facet_fe (facet_id );

void set_attr (element_id ,ATTR );
void unset_attr (element_id ,ATTR );
edge_id get_fe_edge (facetedge_id);
facetedge_id get_prev_edge (facetedge_id );
facetedge_id get_next_edge (facetedge_id );
vertex_id get_edge_tailv (edge_id );
vertex_id get_edge_headv (edge_id );
edge_id get_next_tail_edge (edge_id);
edge_id get_next_head_edge (edge_id);
void set_next_tail_edge (edge_id,edge_id);
facetedge_id get_body_fe (body_id);
facetedge_id get_body_facet (body_id);
void set_body_facet (body_id,facetedge_id);
REAL get_body_density (body_id);
REAL get_body_abstotal (body_id);
REAL get_body_volume (body_id);
REAL get_body_fixvol (body_id);
REAL  get_body_pressure (body_id);
REAL get_body_volconst (body_id);
void set_body_density (body_id,REAL);
void set_body_pressure (body_id,REAL);
facetedge_id get_vertex_fe (vertex_id);
  
#endif

#ifdef  __cplusplus
}
#endif
