--
-- SPDX-FileCopyrightText: 2010 Peng Wu <alexepico@gmail.com>
-- SPDX-FileCopyrightText: 2020 Weng Xuetian <wengxt@gmail.com>
--
-- SPDX-License-Identifier: GPL-2.0-or-later
--
---- encoding: UTF-8
local fcitx = require("fcitx")

local SYMBOLS = {
    a = {"，", "。", "？", "！", "、",
         "；", "：", "…", "・", "—",
         "「", "」", "（", "）", "《",
         "》", "『", "』", "〈", "〉",
         "～", "＿", "﹏"},
    b = {"‥", "﹐", "﹒", "˙", "·",
         "‘", "’", "“", "”", "〝",
         "〞", "‵", "′", "〃", "～",
         "＄", "％", "＠", "＆", "＃",
         "＊"},
    c = {"（", "）", "「", "」", "〔", "〕",
         "｛", "｝", "〈", "〉", "『", "』",
         "《", "》", "【", "】", "﹙", "﹚",
         "﹝", "﹞", "﹛", "﹜"},
    d = {"︵", "︶", "﹁", "﹂", "︹", "︺",
         "︷", "︸", "︿", "﹀", "﹃", "﹄",
         "︽", "︾", "︻︼"},
    e = {"α", "β", "γ", "δ", "ε", "ζ",
         "η", "θ", "ι", "κ", "λ", "μ",
         "ν", "ξ", "ο", "π", "ρ", "σ",
         "τ", "υ", "φ", "χ", "ψ", "ω",
         "Α", "Β", "Γ", "Δ", "Ε", "Ζ",
         "Η", "Θ", "Ι", "Κ", "Λ", "Μ",
         "Ν", "Ξ", "Ο", "Π", "Ρ", "Σ",
         "Τ", "Υ", "Φ", "Χ", "Ψ", "Ω"},
    f = {"＋", "－", "×", "÷", "＝",
         "≠", "≒", "∞", "±", "√",
         "＜", "＞", "﹤", "﹥", "≦", "≧",
         "∩", "∪", "ˇ", "⊥", "∠", "∟",
         "⊿", "㏒", "㏑", "∫", "∮",
         "∵", "∴", "╳", "﹢"},
    g = {"↑", "↓", "←", "→", "↖", "↗", "↙", "↘",
         "㊣", "◎", "○", "●", "⊕", "⊙", "○", "●",
         "△", "▲", "☆", "★", "◇", "◆", "□", "■",
         "▽", "▼", "§", "￥", "〒", "￠", "￡", "※",
         "♀", "♂"},
    h = {"♨", "☀", "☁", "☂", "☃", "♠", "♥",
         "♣", "♦", "♩", "♪", "♫", "♬", "☺", "☻"},
    i = {"├", "─", "┼", "┴", "┬", "┤", "┌", "┐",
         "╞", "═", "╪", "╡", "│", "▕", "└", "┘", "╭", "╮", "╰", "╯"},
    j = {"╔", "╦", "╗", "╠", "═", "╬", "╣", "╓",
         "╥", "╖", "╒", "╤", "╕", "║", "╚", "╩",
         "╝", "╟", "╫", "╢", "╙", "╨", "╜", "╞",
         "╪", "╡", "╘", "╧", "╛"},
    k = {"＿", "ˍ", "▁", "▂", "▃", "▄", "▅", "▆",
         "▇", "█", "▏", "▎", "▍", "▌", "▋", "▊",
         "▉", "◢", "◣", "◥", "◤"},
    l = {"﹣", "﹦", "≡", "｜", "∣", "∥", "–",
         "︱", "—", "︳", "╴", "¯", "￣", "﹉", "﹊",
         "﹍", "﹎", "﹋", "﹌", "﹏", "︴", "∕", "﹨",
         "╱", "╲", "／", "＼"},
}

function get_zhuyin_symbol(input)
    if fcitx.currentInputMethod() ~= "zhuyin" then
        return nil
    end
    if input == "" then
        return {
            "…",
            "※",
            {suggest="a", help="標點符號"},
            {suggest="b", help="常用符號"},
            {suggest="c", help="左右括號"},
            {suggest="d", help="上下括號"},
            {suggest="e", help="希臘字母"},
            {suggest="f", help="數學符號"},
            {suggest="g", help="特殊圖形"},
            {suggest="h", help="Unicode"},
            {suggest="i", help="單線框"},
            {suggest="j", help="雙線框"},
            {suggest="k", help="填色方塊"},
            {suggest="l", help="線段"},
        }
    elseif #input == 1 then
        return SYMBOLS[input]
    end
    return nil
end

------------
ime.register_command("sy", "get_zhuyin_symbol", "输入符号", "digit", "")
