// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The configured access rules for the domain's document and search endpoints, and
// the current status of those rules.
type AccessPoliciesStatus struct {

	// The access policy configured for the domain. Access policies can be
	// resource-based, IP-based, or IAM-based. See  Configuring access policies
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies)for
	// more information.
	//
	// This member is required.
	Options *string

	// The status of the access policy for the domain. See OptionStatus for the status
	// information that's included.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// List of limits that are specific to a given InstanceType and for each of its
// InstanceRole .
type AdditionalLimit struct {

	// Additional limit is specific to a given InstanceType and for each of its
	// InstanceRole etc.
	//
	// Attributes and their details:
	//
	// *
	// MaximumNumberOfDataNodesSupported
	//  This attribute is present on the master node
	// only to specify how much data nodes up to which given ESPartitionInstanceType
	// can support as master node.
	// * MaximumNumberOfDataNodesWithoutMasterNode
	//  This
	// attribute is present on data node only to specify how much data nodes of given
	// ESPartitionInstanceType up to which you don't need any master nodes to govern
	// them.
	LimitName *string

	// Value for a given AdditionalLimit$LimitName .
	LimitValues []string

	noSmithyDocumentSerde
}

// Status of the advanced options for the specified domain. Currently, the
// following advanced options are available:
//
// * Option to allow references to
// indices in an HTTP request body. Must be false when configuring access to
// individual sub-resources. By default, the value is true. See Advanced cluster
// parameters
// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
// for more information.
//
// * Option to specify the percentage of heap space
// allocated to field data. By default, this setting is unbounded.
//
// For more
// information, see  Advanced cluster parameters
// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options).
type AdvancedOptionsStatus struct {

	// The status of advanced options for the specified domain.
	//
	// This member is required.
	Options map[string]string

	// The OptionStatus for advanced options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// The advanced security configuration: whether advanced security is enabled,
// whether the internal database option is enabled.
type AdvancedSecurityOptions struct {

	// Specifies the Anonymous Auth Disable Date when Anonymous Auth is enabled.
	AnonymousAuthDisableDate *time.Time

	// True if Anonymous auth is enabled. Anonymous auth can be enabled only when
	// AdvancedSecurity is enabled on existing domains.
	AnonymousAuthEnabled *bool

	// True if advanced security is enabled.
	Enabled *bool

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool

	// Describes the SAML application configured for a domain.
	SAMLOptions *SAMLOptionsOutput

	noSmithyDocumentSerde
}

// The advanced security configuration: whether advanced security is enabled,
// whether the internal database option is enabled, master username and password
// (if internal database is enabled), and master user ARN (if IAM is enabled).
type AdvancedSecurityOptionsInput struct {

	// True if Anonymous auth is enabled. Anonymous auth can be enabled only when
	// AdvancedSecurity is enabled on existing domains.
	AnonymousAuthEnabled *bool

	// True if advanced security is enabled.
	Enabled *bool

	// True if the internal user database is enabled.
	InternalUserDatabaseEnabled *bool

	// Credentials for the master user: username and password, ARN, or both.
	MasterUserOptions *MasterUserOptions

	// The SAML application configuration for the domain.
	SAMLOptions *SAMLOptionsInput

	noSmithyDocumentSerde
}

// The status of advanced security options for the specified domain.
type AdvancedSecurityOptionsStatus struct {

	// Advanced security options for the specified domain.
	//
	// This member is required.
	Options *AdvancedSecurityOptions

	// Status of the advanced security options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies the Auto-Tune type and Auto-Tune action details.
type AutoTune struct {

	// Specifies details about the Auto-Tune action. See  Auto-Tune for Amazon
	// OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	AutoTuneDetails *AutoTuneDetails

	// Specifies the Auto-Tune type. Valid value is SCHEDULED_ACTION.
	AutoTuneType AutoTuneType

	noSmithyDocumentSerde
}

// Specifies details about the Auto-Tune action. See  Auto-Tune for Amazon
// OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type AutoTuneDetails struct {

	// Specifies details about the scheduled Auto-Tune action. See  Auto-Tune for
	// Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	ScheduledAutoTuneDetails *ScheduledAutoTuneDetails

	noSmithyDocumentSerde
}

// Specifies the Auto-Tune maintenance schedule. See  Auto-Tune for Amazon
// OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type AutoTuneMaintenanceSchedule struct {

	// A cron expression for a recurring maintenance schedule. See  Auto-Tune for
	// Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	CronExpressionForRecurrence *string

	// Specifies maintenance schedule duration: duration value and duration unit. See
	// Auto-Tune for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Duration *Duration

	// The timestamp at which the Auto-Tune maintenance schedule starts.
	StartAt *time.Time

	noSmithyDocumentSerde
}

// The Auto-Tune options: the Auto-Tune desired state for the domain, rollback
// state when disabling Auto-Tune options and list of maintenance schedules.
type AutoTuneOptions struct {

	// The Auto-Tune desired state. Valid values are ENABLED and DISABLED.
	DesiredState AutoTuneDesiredState

	// A list of maintenance schedules. See  Auto-Tune for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	MaintenanceSchedules []AutoTuneMaintenanceSchedule

	// The rollback state while disabling Auto-Tune for the domain. Valid values are
	// NO_ROLLBACK and DEFAULT_ROLLBACK.
	RollbackOnDisable RollbackOnDisable

	noSmithyDocumentSerde
}

// The Auto-Tune options: the Auto-Tune desired state for the domain and list of
// maintenance schedules.
type AutoTuneOptionsInput struct {

	// The Auto-Tune desired state. Valid values are ENABLED and DISABLED.
	DesiredState AutoTuneDesiredState

	// A list of maintenance schedules. See  Auto-Tune for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	MaintenanceSchedules []AutoTuneMaintenanceSchedule

	noSmithyDocumentSerde
}

// The Auto-Tune options: the Auto-Tune desired state for the domain and list of
// maintenance schedules.
type AutoTuneOptionsOutput struct {

	// The error message while enabling or disabling Auto-Tune.
	ErrorMessage *string

	// The AutoTuneState for the domain.
	State AutoTuneState

	noSmithyDocumentSerde
}

// The Auto-Tune status for the domain.
type AutoTuneOptionsStatus struct {

	// Specifies Auto-Tune options for the domain.
	Options *AutoTuneOptions

	// The status of the Auto-Tune options for the domain.
	Status *AutoTuneStatus

	noSmithyDocumentSerde
}

// Provides the current Auto-Tune status for the domain.
type AutoTuneStatus struct {

	// The timestamp of the Auto-Tune options creation date.
	//
	// This member is required.
	CreationDate *time.Time

	// The AutoTuneState for the domain.
	//
	// This member is required.
	State AutoTuneState

	// The timestamp of when the Auto-Tune options were last updated.
	//
	// This member is required.
	UpdateDate *time.Time

	// The error message while enabling or disabling Auto-Tune.
	ErrorMessage *string

	// Indicates whether the domain is being deleted.
	PendingDeletion *bool

	// The latest version of the Auto-Tune options.
	UpdateVersion int32

	noSmithyDocumentSerde
}

type AWSDomainInformation struct {

	// The name of an domain. Domain names are unique across the domains owned by an
	// account within an AWS region. Domain names start with a letter or number and can
	// contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// This member is required.
	DomainName *string

	OwnerId *string

	Region *string

	noSmithyDocumentSerde
}

// Specifies change details of the domain configuration change.
type ChangeProgressDetails struct {

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string

	// Contains an optional message associated with the domain configuration change.
	Message *string

	noSmithyDocumentSerde
}

// A progress stage details of a specific domain configuration change.
type ChangeProgressStage struct {

	// The description of the progress stage.
	Description *string

	// The last updated timestamp of the progress stage.
	LastUpdated *time.Time

	// The name of the specific progress stage.
	Name *string

	// The overall status of a specific progress stage.
	Status *string

	noSmithyDocumentSerde
}

// The progress details of a specific domain configuration change.
type ChangeProgressStatusDetails struct {

	// The unique change identifier associated with a specific domain configuration
	// change.
	ChangeId *string

	// The specific stages that the domain is going through to perform the
	// configuration change.
	ChangeProgressStages []ChangeProgressStage

	// The list of properties involved in the domain configuration change that are
	// completed.
	CompletedProperties []string

	// The list of properties involved in the domain configuration change that are
	// still in pending.
	PendingProperties []string

	// The time at which the configuration change is made on the domain.
	StartTime *time.Time

	// The overall status of the domain configuration change. This field can take the
	// following values: PENDING, PROCESSING, COMPLETED and FAILED
	Status OverallChangeStatus

	// The total number of stages required for the configuration change.
	TotalNumberOfStages int32

	noSmithyDocumentSerde
}

// The configuration for the domain cluster, such as the type and number of
// instances.
type ClusterConfig struct {

	// Specifies the ColdStorageOptions config for a Domain
	ColdStorageOptions *ColdStorageOptions

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int32

	// A boolean value to indicate whether a dedicated master node is enabled. See
	// Dedicated master nodes in Amazon OpenSearch Service
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-dedicatedmasternodes)
	// for more information.
	DedicatedMasterEnabled *bool

	// The instance type for a dedicated master node.
	DedicatedMasterType OpenSearchPartitionInstanceType

	// The number of instances in the specified domain cluster.
	InstanceCount *int32

	// The instance type for an OpenSearch cluster. UltraWarm instance types are not
	// supported for data instances.
	InstanceType OpenSearchPartitionInstanceType

	// The number of UltraWarm nodes in the cluster.
	WarmCount *int32

	// True to enable UltraWarm storage.
	WarmEnabled *bool

	// The instance type for the OpenSearch cluster's warm nodes.
	WarmType OpenSearchWarmPartitionInstanceType

	// The zone awareness configuration for a domain when zone awareness is enabled.
	ZoneAwarenessConfig *ZoneAwarenessConfig

	// A boolean value to indicate whether zone awareness is enabled. See Configuring a
	// multi-AZ domain in Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html)
	// for more information.
	ZoneAwarenessEnabled *bool

	noSmithyDocumentSerde
}

// The configuration status for the specified domain.
type ClusterConfigStatus struct {

	// The cluster configuration for the specified domain.
	//
	// This member is required.
	Options *ClusterConfig

	// The cluster configuration status for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Options to specify the Cognito user and identity pools for OpenSearch Dashboards
// authentication. For more information, see Configuring Amazon Cognito
// authentication for OpenSearch Dashboards
// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
type CognitoOptions struct {

	// The option to enable Cognito for OpenSearch Dashboards authentication.
	Enabled *bool

	// The Cognito identity pool ID for OpenSearch Dashboards authentication.
	IdentityPoolId *string

	// The role ARN that provides OpenSearch permissions for accessing Cognito
	// resources.
	RoleArn *string

	// The Cognito user pool ID for OpenSearch Dashboards authentication.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The status of the Cognito options for the specified domain.
type CognitoOptionsStatus struct {

	// Cognito options for the specified domain.
	//
	// This member is required.
	Options *CognitoOptions

	// The status of the Cognito options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies the configuration for cold storage options such as enabled
type ColdStorageOptions struct {

	// Enable cold storage option. Accepted values true or false
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

// A map from an EngineVersion to a list of compatible EngineVersion s to which the
// domain can be upgraded.
type CompatibleVersionsMap struct {

	// The current version of OpenSearch a domain is on.
	SourceVersion *string

	// List of supported OpenSearch versions.
	TargetVersions []string

	noSmithyDocumentSerde
}

// A filter to apply to the DescribePackage response.
type DescribePackagesFilter struct {

	// Any field from PackageDetails.
	Name DescribePackagesFilterName

	// A list of values for the specified field.
	Value []string

	noSmithyDocumentSerde
}

// The configuration of a domain.
type DomainConfig struct {

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus

	// The AdvancedOptions for the domain. See Advanced options
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions *AdvancedOptionsStatus

	// Specifies AdvancedSecurityOptions for the domain.
	AdvancedSecurityOptions *AdvancedSecurityOptionsStatus

	// Specifies AutoTuneOptions for the domain.
	AutoTuneOptions *AutoTuneOptionsStatus

	// Specifies change details of the domain configuration change.
	ChangeProgressDetails *ChangeProgressDetails

	// The ClusterConfig for the domain.
	ClusterConfig *ClusterConfigStatus

	// The CognitoOptions for the specified domain. For more information, see
	// Configuring Amazon Cognito authentication for OpenSearch Dashboards
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *CognitoOptionsStatus

	// The DomainEndpointOptions for the domain.
	DomainEndpointOptions *DomainEndpointOptionsStatus

	// The EBSOptions for the domain.
	EBSOptions *EBSOptionsStatus

	// The EncryptionAtRestOptions for the domain.
	EncryptionAtRestOptions *EncryptionAtRestOptionsStatus

	// String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine
	// version for the OpenSearch or Elasticsearch domain.
	EngineVersion *VersionStatus

	// Log publishing options for the given domain.
	LogPublishingOptions *LogPublishingOptionsStatus

	// The NodeToNodeEncryptionOptions for the domain.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptionsStatus

	// The SnapshotOptions for the domain.
	SnapshotOptions *SnapshotOptionsStatus

	// The VPCOptions for the specified domain. For more information, see  Launching
	// your Amazon OpenSearch Service domains using a VPC
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCDerivedInfoStatus

	noSmithyDocumentSerde
}

// Options to configure the endpoint for the domain.
type DomainEndpointOptions struct {

	// The fully qualified domain for your custom endpoint.
	CustomEndpoint *string

	// The ACM certificate ARN for your custom endpoint.
	CustomEndpointCertificateArn *string

	// Whether to enable a custom endpoint for the domain.
	CustomEndpointEnabled *bool

	// Whether only HTTPS endpoint should be enabled for the domain.
	EnforceHTTPS *bool

	// Specify the TLS security policy to apply to the HTTPS endpoint of the
	// domain.
	//
	// Can be one of the following values:
	//
	// * Policy-Min-TLS-1-0-2019-07: TLS
	// security policy which supports TLSv1.0 and higher.
	//
	// *
	// Policy-Min-TLS-1-2-2019-07: TLS security policy which supports only TLSv1.2
	TLSSecurityPolicy TLSSecurityPolicy

	noSmithyDocumentSerde
}

// The configured endpoint options for the domain and their current status.
type DomainEndpointOptionsStatus struct {

	// Options to configure the endpoint for the domain.
	//
	// This member is required.
	Options *DomainEndpointOptions

	// The status of the endpoint options for the domain. See OptionStatus for the
	// status information that's included.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

type DomainInfo struct {

	// The DomainName.
	DomainName *string

	// Specifies the EngineType of the domain.
	EngineType EngineType

	noSmithyDocumentSerde
}

type DomainInformationContainer struct {
	AWSDomainInformation *AWSDomainInformation

	noSmithyDocumentSerde
}

// Information on a package associated with a domain.
type DomainPackageDetails struct {

	// The name of the domain you've associated a package with.
	DomainName *string

	// State of the association. Values are ASSOCIATING, ASSOCIATION_FAILED, ACTIVE,
	// DISSOCIATING, and DISSOCIATION_FAILED.
	DomainPackageStatus DomainPackageStatus

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails

	// The timestamp of the most recent update to the package association status.
	LastUpdated *time.Time

	// The internal ID of the package.
	PackageID *string

	// User-specified name of the package.
	PackageName *string

	// Currently supports only TXT-DICTIONARY.
	PackageType PackageType

	PackageVersion *string

	// The relative path on Amazon OpenSearch Service nodes, which can be used as
	// synonym_path when the package is a synonym file.
	ReferencePath *string

	noSmithyDocumentSerde
}

// The current status of a domain.
type DomainStatus struct {

	// The Amazon Resource Name (ARN) of a domain. See IAM identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html) in
	// the AWS Identity and Access Management User Guide for more information.
	//
	// This member is required.
	ARN *string

	// The type and number of instances in the domain.
	//
	// This member is required.
	ClusterConfig *ClusterConfig

	// The unique identifier for the specified domain.
	//
	// This member is required.
	DomainId *string

	// The name of a domain. Domain names are unique across the domains owned by an
	// account within an AWS region. Domain names start with a letter or number and can
	// contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
	//
	// This member is required.
	DomainName *string

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string

	// The status of the AdvancedOptions.
	AdvancedOptions map[string]string

	// The current status of the domain's advanced security options.
	AdvancedSecurityOptions *AdvancedSecurityOptions

	// The current status of the domain's Auto-Tune options.
	AutoTuneOptions *AutoTuneOptionsOutput

	// Specifies change details of the domain configuration change.
	ChangeProgressDetails *ChangeProgressDetails

	// The CognitoOptions for the specified domain. For more information, see
	// Configuring Amazon Cognito authentication for OpenSearch Dashboards
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html).
	CognitoOptions *CognitoOptions

	// The domain creation status. True if the creation of a domain is complete.  False
	// if domain creation is still in progress.
	Created *bool

	// The domain deletion status. True if a delete request has been received for the
	// domain but resource cleanup is still in progress. False if the domain has not
	// been deleted. Once domain deletion is complete, the status of the domain is no
	// longer returned.
	Deleted *bool

	// The current status of the domain's endpoint options.
	DomainEndpointOptions *DomainEndpointOptions

	// The EBSOptions for the specified domain.
	EBSOptions *EBSOptions

	// The status of the EncryptionAtRestOptions.
	EncryptionAtRestOptions *EncryptionAtRestOptions

	// The domain endpoint that you use to submit index and search requests.
	Endpoint *string

	// Map containing the domain endpoints used to submit index and search requests.
	// Example key, value:
	// 'vpc','vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com'.
	Endpoints map[string]string

	EngineVersion *string

	// Log publishing options for the given domain.
	LogPublishingOptions map[string]LogPublishingOption

	// The status of the NodeToNodeEncryptionOptions.
	NodeToNodeEncryptionOptions *NodeToNodeEncryptionOptions

	// The status of the domain configuration. True if Amazon OpenSearch Service is
	// processing configuration changes. False if the configuration is active.
	Processing *bool

	// The current status of the domain's service software.
	ServiceSoftwareOptions *ServiceSoftwareOptions

	// The status of the SnapshotOptions.
	SnapshotOptions *SnapshotOptions

	// The status of a domain version upgrade. True if Amazon OpenSearch Service is
	// undergoing a version upgrade. False if the configuration is active.
	UpgradeProcessing *bool

	// The VPCOptions for the specified domain. For more information, see  Launching
	// your Amazon OpenSearch Service domains using a VPC
	// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
	VPCOptions *VPCDerivedInfo

	noSmithyDocumentSerde
}

type DryRunResults struct {

	// Specifies the way in which Amazon OpenSearch Service applies the update.
	// Possible responses are Blue/Green (the update requires a blue/green deployment),
	// DynamicUpdate (no blue/green required), Undetermined (the domain is undergoing
	// an update and can't predict the deployment type; try again after the update is
	// complete), and None (the request doesn't include any configuration changes).
	DeploymentType *string

	// Contains an optional message associated with the DryRunResults.
	Message *string

	noSmithyDocumentSerde
}

// The maintenance schedule duration: duration value and duration unit. See
// Auto-Tune for Amazon OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type Duration struct {

	// The unit of a maintenance schedule duration. Valid value is HOURS. See
	// Auto-Tune for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Unit TimeUnit

	// Integer to specify the value of a maintenance schedule duration. See  Auto-Tune
	// for Amazon OpenSearch Service
	// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
	// for more information.
	Value int64

	noSmithyDocumentSerde
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
type EBSOptions struct {

	// Whether EBS-based storage is enabled.
	EBSEnabled *bool

	// The IOPS for Provisioned IOPS And GP3 EBS volume (SSD).
	Iops *int32

	// The Throughput for GP3 EBS volume (SSD).
	Throughput *int32

	// Integer to specify the size of an EBS volume.
	VolumeSize *int32

	// The volume type for EBS-based storage.
	VolumeType VolumeType

	noSmithyDocumentSerde
}

// Status of the EBS options for the specified domain.
type EBSOptionsStatus struct {

	// The EBS options for the specified domain.
	//
	// This member is required.
	Options *EBSOptions

	// The status of the EBS options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Specifies encryption at rest options.
type EncryptionAtRestOptions struct {

	// The option to enable encryption at rest.
	Enabled *bool

	// The KMS key ID for encryption at rest options.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Status of the encryption At Rest options for the specified domain.
type EncryptionAtRestOptionsStatus struct {

	// The Encryption At Rest options for the specified domain.
	//
	// This member is required.
	Options *EncryptionAtRestOptions

	// The status of the Encryption At Rest options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

type ErrorDetails struct {
	ErrorMessage *string

	ErrorType *string

	noSmithyDocumentSerde
}

// A filter used to limit results when describing inbound or outbound cross-cluster
// connections. Multiple values can be specified per filter. A cross-cluster
// connection must match at least one of the specified values for it to be returned
// from an operation.
type Filter struct {

	// The name of the filter.
	Name *string

	// Contains one or more values for the filter.
	Values []string

	noSmithyDocumentSerde
}

// Details of an inbound connection.
type InboundConnection struct {

	// The connection ID for the inbound cross-cluster connection.
	ConnectionId *string

	// The InboundConnectionStatus for the outbound connection.
	ConnectionStatus *InboundConnectionStatus

	// The AWSDomainInformation for the local OpenSearch domain.
	LocalDomainInfo *DomainInformationContainer

	// The AWSDomainInformation for the remote OpenSearch domain.
	RemoteDomainInfo *DomainInformationContainer

	noSmithyDocumentSerde
}

// The connection status of an inbound cross-cluster connection.
type InboundConnectionStatus struct {

	// Verbose information for the inbound connection status.
	Message *string

	// The state code for the inbound connection. Can be one of the following:
	//
	// *
	// PENDING_ACCEPTANCE: Inbound connection is not yet accepted by the remote domain
	// owner.
	//
	// * APPROVED: Inbound connection is pending acceptance by the remote
	// domain owner.
	//
	// * PROVISIONING: Inbound connection provisioning is in
	// progress.
	//
	// * ACTIVE: Inbound connection is active and ready to use.
	//
	// *
	// REJECTING: Inbound connection rejection is in process.
	//
	// * REJECTED: Inbound
	// connection is rejected.
	//
	// * DELETING: Inbound connection deletion is in
	// progress.
	//
	// * DELETED: Inbound connection is deleted and can no longer be used.
	StatusCode InboundConnectionStatusCode

	noSmithyDocumentSerde
}

// InstanceCountLimits represents the limits on the number of instances that can be
// created in Amazon OpenSearch Service for a given InstanceType.
type InstanceCountLimits struct {

	// Maximum number of instances that can be instantiated for a given InstanceType.
	MaximumInstanceCount int32

	// Minimum number of instances that can be instantiated for a given InstanceType.
	MinimumInstanceCount int32

	noSmithyDocumentSerde
}

// InstanceLimits represents the list of instance-related attributes that are
// available for a given InstanceType.
type InstanceLimits struct {

	// InstanceCountLimits represents the limits on the number of instances that can be
	// created in Amazon OpenSearch Service for a given InstanceType.
	InstanceCountLimits *InstanceCountLimits

	noSmithyDocumentSerde
}

type InstanceTypeDetails struct {
	AdvancedSecurityEnabled *bool

	AppLogsEnabled *bool

	CognitoEnabled *bool

	EncryptionEnabled *bool

	InstanceRole []string

	InstanceType OpenSearchPartitionInstanceType

	WarmEnabled *bool

	noSmithyDocumentSerde
}

// Limits for a given InstanceType and for each of its roles.
//
// Limits contains the
// following: StorageTypes, InstanceLimits, and AdditionalLimits
type Limits struct {

	// List of additional limits that are specific to a given InstanceType and for each
	// of its InstanceRole .
	AdditionalLimits []AdditionalLimit

	// InstanceLimits represents the list of instance-related attributes that are
	// available for a given InstanceType.
	InstanceLimits *InstanceLimits

	// Storage-related types and attributes that are available for a given
	// InstanceType.
	StorageTypes []StorageType

	noSmithyDocumentSerde
}

// Log Publishing option that is set for a given domain.
//
// Attributes and their
// details:
//
// * CloudWatchLogsLogGroupArn: ARN of the Cloudwatch log group to
// publish logs to.
//
// * Enabled: Whether the log publishing for a given log type is
// enabled or not.
type LogPublishingOption struct {

	// ARN of the Cloudwatch log group to publish logs to.
	CloudWatchLogsLogGroupArn *string

	// Whether the given log publishing option is enabled or not.
	Enabled *bool

	noSmithyDocumentSerde
}

// The configured log publishing options for the domain and their current status.
type LogPublishingOptionsStatus struct {

	// The log publishing options configured for the domain.
	Options map[string]LogPublishingOption

	// The status of the log publishing options for the domain. See OptionStatus for
	// the status information that's included.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Credentials for the master user: username and password, ARN, or both.
type MasterUserOptions struct {

	// ARN for the master user (if IAM is enabled).
	MasterUserARN *string

	// The master user's username, which is stored in the Amazon OpenSearch Service
	// domain's internal database.
	MasterUserName *string

	// The master user's password, which is stored in the Amazon OpenSearch Service
	// domain's internal database.
	MasterUserPassword *string

	noSmithyDocumentSerde
}

// The node-to-node encryption options.
type NodeToNodeEncryptionOptions struct {

	// True to enable node-to-node encryption.
	Enabled *bool

	noSmithyDocumentSerde
}

// Status of the node-to-node encryption options for the specified domain.
type NodeToNodeEncryptionOptionsStatus struct {

	// The node-to-node encryption options for the specified domain.
	//
	// This member is required.
	Options *NodeToNodeEncryptionOptions

	// The status of the node-to-node encryption options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Provides the current status of the entity.
type OptionStatus struct {

	// The timestamp of when the entity was created.
	//
	// This member is required.
	CreationDate *time.Time

	// Provides the OptionState for the domain.
	//
	// This member is required.
	State OptionState

	// The timestamp of the last time the entity was updated.
	//
	// This member is required.
	UpdateDate *time.Time

	// Indicates whether the domain is being deleted.
	PendingDeletion *bool

	// The latest version of the entity.
	UpdateVersion int32

	noSmithyDocumentSerde
}

// Specifies details about an outbound connection.
type OutboundConnection struct {

	// The connection alias for the outbound cross-cluster connection.
	ConnectionAlias *string

	// The connection ID for the outbound cross-cluster connection.
	ConnectionId *string

	// The OutboundConnectionStatus for the outbound connection.
	ConnectionStatus *OutboundConnectionStatus

	// The DomainInformation for the local OpenSearch domain.
	LocalDomainInfo *DomainInformationContainer

	// The DomainInformation for the remote OpenSearch domain.
	RemoteDomainInfo *DomainInformationContainer

	noSmithyDocumentSerde
}

// The connection status of an outbound cross-cluster connection.
type OutboundConnectionStatus struct {

	// Verbose information for the outbound connection status.
	Message *string

	// The state code for the outbound connection. Can be one of the following:
	//
	// *
	// VALIDATING: The outbound connection request is being validated.
	//
	// *
	// VALIDATION_FAILED: Validation failed for the connection request.
	//
	// *
	// PENDING_ACCEPTANCE: Outbound connection request is validated and is not yet
	// accepted by the remote domain owner.
	//
	// * APPROVED: Outbound connection has been
	// approved by the remote domain owner for getting provisioned.
	//
	// * PROVISIONING:
	// Outbound connection request is in process.
	//
	// * ACTIVE: Outbound connection is
	// active and ready to use.
	//
	// * REJECTING: Outbound connection rejection by remote
	// domain owner is in progress.
	//
	// * REJECTED: Outbound connection request is
	// rejected by remote domain owner.
	//
	// * DELETING: Outbound connection deletion is in
	// progress.
	//
	// * DELETED: Outbound connection is deleted and can no longer be used.
	StatusCode OutboundConnectionStatusCode

	noSmithyDocumentSerde
}

// Basic information about a package.
type PackageDetails struct {
	AvailablePackageVersion *string

	// The timestamp of when the package was created.
	CreatedAt *time.Time

	// Additional information if the package is in an error state. Null otherwise.
	ErrorDetails *ErrorDetails

	LastUpdatedAt *time.Time

	// User-specified description of the package.
	PackageDescription *string

	// Internal ID of the package.
	PackageID *string

	// User-specified name of the package.
	PackageName *string

	// Current state of the package. Values are COPYING, COPY_FAILED, AVAILABLE,
	// DELETING, and DELETE_FAILED.
	PackageStatus PackageStatus

	// Currently supports only TXT-DICTIONARY.
	PackageType PackageType

	noSmithyDocumentSerde
}

// The Amazon S3 location for importing the package specified as S3BucketName and
// S3Key
type PackageSource struct {

	// The name of the Amazon S3 bucket containing the package.
	S3BucketName *string

	// Key (file name) of the package.
	S3Key *string

	noSmithyDocumentSerde
}

// Details of a package version.
type PackageVersionHistory struct {

	// A message associated with the package version.
	CommitMessage *string

	// The timestamp of when the package was created.
	CreatedAt *time.Time

	// The package version.
	PackageVersion *string

	noSmithyDocumentSerde
}

// Contains the specific price and frequency of a recurring charges for a reserved
// OpenSearch instance, or for a reserved OpenSearch instance offering.
type RecurringCharge struct {

	// The monetary amount of the recurring charge.
	RecurringChargeAmount *float64

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string

	noSmithyDocumentSerde
}

// Details of a reserved OpenSearch instance.
type ReservedInstance struct {
	BillingSubscriptionId *int64

	// The currency code for the reserved OpenSearch instance offering.
	CurrencyCode *string

	// The duration, in seconds, for which the OpenSearch instance is reserved.
	Duration int32

	// The upfront fixed charge you will paid to purchase the specific reserved
	// OpenSearch instance offering.
	FixedPrice *float64

	// The number of OpenSearch instances that have been reserved.
	InstanceCount int32

	// The OpenSearch instance type offered by the reserved instance offering.
	InstanceType OpenSearchPartitionInstanceType

	// The payment option as defined in the reserved OpenSearch instance offering.
	PaymentOption ReservedInstancePaymentOption

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []RecurringCharge

	// The customer-specified identifier to track this reservation.
	ReservationName *string

	// The unique identifier for the reservation.
	ReservedInstanceId *string

	// The offering identifier.
	ReservedInstanceOfferingId *string

	// The time the reservation started.
	StartTime *time.Time

	// The state of the reserved OpenSearch instance.
	State *string

	// The rate you are charged for each hour for the domain that is using this
	// reserved instance.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// Details of a reserved OpenSearch instance offering.
type ReservedInstanceOffering struct {

	// The currency code for the reserved OpenSearch instance offering.
	CurrencyCode *string

	// The duration, in seconds, for which the offering will reserve the OpenSearch
	// instance.
	Duration int32

	// The upfront fixed charge you will pay to purchase the specific reserved
	// OpenSearch instance offering.
	FixedPrice *float64

	// The OpenSearch instance type offered by the reserved instance offering.
	InstanceType OpenSearchPartitionInstanceType

	// Payment option for the reserved OpenSearch instance offering
	PaymentOption ReservedInstancePaymentOption

	// The charge to your account regardless of whether you are creating any domains
	// using the instance offering.
	RecurringCharges []RecurringCharge

	// The OpenSearch reserved instance offering identifier.
	ReservedInstanceOfferingId *string

	// The rate you are charged for each hour the domain that is using the offering is
	// running.
	UsagePrice *float64

	noSmithyDocumentSerde
}

// The SAML identity povider's information.
type SAMLIdp struct {

	// The unique entity ID of the application in SAML identity provider.
	//
	// This member is required.
	EntityId *string

	// The metadata of the SAML application in XML format.
	//
	// This member is required.
	MetadataContent *string

	noSmithyDocumentSerde
}

// The SAML application configuration for the domain.
type SAMLOptionsInput struct {

	// True if SAML is enabled.
	Enabled *bool

	// The SAML Identity Provider's information.
	Idp *SAMLIdp

	// The backend role that the SAML master user is mapped to.
	MasterBackendRole *string

	// The SAML master username, which is stored in the Amazon OpenSearch Service
	// domain's internal database.
	MasterUserName *string

	// Element of the SAML assertion to use for backend roles. Default is roles.
	RolesKey *string

	// The duration, in minutes, after which a user session becomes inactive.
	// Acceptable values are between 1 and 1440, and the default value is 60.
	SessionTimeoutMinutes *int32

	// Element of the SAML assertion to use for username. Default is NameID.
	SubjectKey *string

	noSmithyDocumentSerde
}

// Describes the SAML application configured for the domain.
type SAMLOptionsOutput struct {

	// True if SAML is enabled.
	Enabled *bool

	// Describes the SAML identity provider's information.
	Idp *SAMLIdp

	// The key used for matching the SAML roles attribute.
	RolesKey *string

	// The duration, in minutes, after which a user session becomes inactive.
	SessionTimeoutMinutes *int32

	// The key used for matching the SAML subject attribute.
	SubjectKey *string

	noSmithyDocumentSerde
}

// Specifies details about the scheduled Auto-Tune action. See  Auto-Tune for
// Amazon OpenSearch Service
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html)
// for more information.
type ScheduledAutoTuneDetails struct {

	// The Auto-Tune action description.
	Action *string

	// The Auto-Tune action type. Valid values are JVM_HEAP_SIZE_TUNING and
	// JVM_YOUNG_GEN_TUNING.
	ActionType ScheduledAutoTuneActionType

	// The timestamp of the Auto-Tune action scheduled for the domain.
	Date *time.Time

	// The Auto-Tune action severity. Valid values are LOW, MEDIUM, and HIGH.
	Severity ScheduledAutoTuneSeverityType

	noSmithyDocumentSerde
}

// The current options of an domain service software options.
type ServiceSoftwareOptions struct {

	// The timestamp, in Epoch time, until which you can manually request a service
	// software update. After this date, we automatically update your service software.
	AutomatedUpdateDate *time.Time

	// True if you're able to cancel your service software version update. False if you
	// can't cancel your service software update.
	Cancellable *bool

	// The current service software version present on the domain.
	CurrentVersion *string

	// The description of the UpdateStatus.
	Description *string

	// The new service software version if one is available.
	NewVersion *string

	// True if a service software is never automatically updated. False if a service
	// software is automatically updated after AutomatedUpdateDate.
	OptionalDeployment *bool

	// True if you're able to update your service software version. False if you can't
	// update your service software version.
	UpdateAvailable *bool

	// The status of your service software update. This field can take the following
	// values:  ELIGIBLE, PENDING_UPDATE, IN_PROGRESS, COMPLETED, and  NOT_ELIGIBLE.
	UpdateStatus DeploymentStatus

	noSmithyDocumentSerde
}

// The time, in UTC format, when the service takes a daily automated snapshot of
// the specified domain. Default is 0 hours.
type SnapshotOptions struct {

	// The time, in UTC format, when the service takes a daily automated snapshot of
	// the specified domain. Default is 0 hours.
	AutomatedSnapshotStartHour *int32

	noSmithyDocumentSerde
}

// Status of a daily automated snapshot.
type SnapshotOptionsStatus struct {

	// The daily snapshot options specified for the domain.
	//
	// This member is required.
	Options *SnapshotOptions

	// The status of a daily automated snapshot.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// StorageTypes represents the list of storage-related types and their attributes
// that are available for a given InstanceType.
type StorageType struct {

	// Sub-type of the given storage type. List of available sub-storage options:
	// "instance" storageType has no storageSubType. "ebs" storageType has the
	// following valid storageSubTypes:
	//
	// * standard
	//
	// * gp2
	//
	// * gp3
	//
	// * io1
	//
	// See
	// VolumeType for more information regarding each EBS storage option.
	StorageSubTypeName *string

	// Limits that are applicable for the given storage type.
	StorageTypeLimits []StorageTypeLimit

	// Type of storage. List of available storage options:
	//
	// * instance
	//  Built-in
	// storage available for the instance
	// * ebs
	//  Elastic block storage attached to the
	// instance
	StorageTypeName *string

	noSmithyDocumentSerde
}

// Limits that are applicable for the given storage type.
type StorageTypeLimit struct {

	// Name of storage limits that are applicable for the given storage type. If
	// StorageType is "ebs", the following storage options are applicable:
	//
	// *
	// MinimumVolumeSize
	//  Minimum amount of volume size that is applicable for the
	// given storage type. Can be empty if not applicable.
	// * MaximumVolumeSize
	//  Maximum
	// amount of volume size that is applicable for the given storage type. Can be
	// empty if not applicable.
	// * MaximumIops
	//  Maximum amount of Iops that is
	// applicable for given the storage type. Can be empty if not applicable.
	// *
	// MinimumIops
	//  Minimum amount of Iops that is applicable for given the storage
	// type. Can be empty if not applicable.
	// * MaximumThroughput
	//  Maximum amount of
	// Throughput that is applicable for given the storage type. Can be empty if not
	// applicable.
	// * MinimumThroughput
	//  Minimum amount of Throughput that is applicable
	// for given the storage type. Can be empty if not applicable.
	LimitName *string

	// Values for the StorageTypeLimit$LimitName .
	LimitValues []string

	noSmithyDocumentSerde
}

// A key value pair for a resource tag.
type Tag struct {

	// The TagKey, the name of the tag. Tag keys must be unique for the domain to which
	// they are attached.
	//
	// This member is required.
	Key *string

	// The TagValue, the value assigned to the corresponding tag key. Tag values can be
	// null and don't have to be unique in a tag set. For example, you can have a key
	// value pair in a tag set of project : Trinity and cost-center : Trinity
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// History of the last 10 upgrades and upgrade eligibility checks.
type UpgradeHistory struct {

	// UTC timestamp at which the upgrade API call was made in "yyyy-MM-ddTHH:mm:ssZ"
	// format.
	StartTimestamp *time.Time

	// A list of UpgradeStepItem s representing information about each step performed
	// as part of a specific upgrade or upgrade eligibility check.
	StepsList []UpgradeStepItem

	// A string that briefly describes the upgrade.
	UpgradeName *string

	// The current status of the upgrade. The status can take one of the following
	// values:
	//
	// * In Progress
	//
	// * Succeeded
	//
	// * Succeeded with Issues
	//
	// * Failed
	UpgradeStatus UpgradeStatus

	noSmithyDocumentSerde
}

// Represents a single step of the upgrade or upgrade eligibility check workflow.
type UpgradeStepItem struct {

	// A list of strings containing detailed information about the errors encountered
	// in a particular step.
	Issues []string

	// The floating point value representing the progress percentage of a particular
	// step.
	ProgressPercent *float64

	// One of three steps an upgrade or upgrade eligibility check goes through:
	//
	// *
	// PreUpgradeCheck
	//
	// * Snapshot
	//
	// * Upgrade
	UpgradeStep UpgradeStep

	// The current status of the upgrade. The status can take one of the following
	// values:
	//
	// * In Progress
	//
	// * Succeeded
	//
	// * Succeeded with Issues
	//
	// * Failed
	UpgradeStepStatus UpgradeStatus

	noSmithyDocumentSerde
}

// The status of the OpenSearch version options for the specified OpenSearch
// domain.
type VersionStatus struct {

	// The OpenSearch version for the specified OpenSearch domain.
	//
	// This member is required.
	Options *string

	// The status of the OpenSearch version options for the specified OpenSearch
	// domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Options to specify the subnets and security groups for the VPC endpoint. For
// more information, see  Launching your Amazon OpenSearch Service domains using a
// VPC
// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
type VPCDerivedInfo struct {

	// The Availability Zones for the domain. Exists only if the domain was created
	// with VPCOptions.
	AvailabilityZones []string

	// The security groups for the VPC endpoint.
	SecurityGroupIds []string

	// The subnets for the VPC endpoint.
	SubnetIds []string

	// The VPC ID for the domain. Exists only if the domain was created with
	// VPCOptions.
	VPCId *string

	noSmithyDocumentSerde
}

// Status of the VPC options for the specified domain.
type VPCDerivedInfoStatus struct {

	// The VPC options for the specified domain.
	//
	// This member is required.
	Options *VPCDerivedInfo

	// The status of the VPC options for the specified domain.
	//
	// This member is required.
	Status *OptionStatus

	noSmithyDocumentSerde
}

// Options to specify the subnets and security groups for the VPC endpoint. For
// more information, see  Launching your Amazon OpenSearch Service domains using a
// VPC
// (http://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html).
type VPCOptions struct {

	// The security groups for the VPC endpoint.
	SecurityGroupIds []string

	// The subnets for the VPC endpoint.
	SubnetIds []string

	noSmithyDocumentSerde
}

// The zone awareness configuration for the domain cluster, such as the number of
// availability zones.
type ZoneAwarenessConfig struct {

	// An integer value to indicate the number of availability zones for a domain when
	// zone awareness is enabled. This should be equal to number of subnets if VPC
	// endpoints is enabled.
	AvailabilityZoneCount *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
