// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Provides the details of the ActivityTaskCanceled event.
type ActivityTaskCanceledEventAttributes struct {

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the ActivityTaskStarted event recorded when this activity task was
	// started. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// Details of the cancellation.
	Details *string

	// If set, contains the ID of the last ActivityTaskCancelRequested event recorded
	// for this activity task. This information can be useful for diagnosing problems
	// by tracing back the chain of events leading up to this event.
	LatestCancelRequestedEventId int64

	noSmithyDocumentSerde
}

// Provides the details of the ActivityTaskCancelRequested event.
type ActivityTaskCancelRequestedEventAttributes struct {

	// The unique ID of the task.
	//
	// This member is required.
	ActivityId *string

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	noSmithyDocumentSerde
}

// Provides the details of the ActivityTaskCompleted event.
type ActivityTaskCompletedEventAttributes struct {

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the ActivityTaskStarted event recorded when this activity task was
	// started. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The results of the activity task.
	Result *string

	noSmithyDocumentSerde
}

// Provides the details of the ActivityTaskFailed event.
type ActivityTaskFailedEventAttributes struct {

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the ActivityTaskStarted event recorded when this activity task was
	// started. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The details of the failure.
	Details *string

	// The reason provided for the failure.
	Reason *string

	noSmithyDocumentSerde
}

// Provides the details of the ActivityTaskScheduled event.
type ActivityTaskScheduledEventAttributes struct {

	// The unique ID of the activity task.
	//
	// This member is required.
	ActivityId *string

	// The type of the activity task.
	//
	// This member is required.
	ActivityType *ActivityType

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be useful
	// for diagnosing problems by tracing back the chain of events leading up to this
	// event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The task list in which the activity task has been scheduled.
	//
	// This member is required.
	TaskList *TaskList

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the activity.
	Control *string

	// The maximum time before which the worker processing this task must report
	// progress by calling RecordActivityTaskHeartbeat. If the timeout is exceeded, the
	// activity task is automatically timed out. If the worker subsequently attempts to
	// record a heartbeat or return a result, it is ignored.
	HeartbeatTimeout *string

	// The input provided to the activity task.
	Input *string

	// The maximum amount of time for this activity task.
	ScheduleToCloseTimeout *string

	// The maximum amount of time the activity task can wait to be assigned to a
	// worker.
	ScheduleToStartTimeout *string

	// The maximum amount of time a worker may take to process the activity task.
	StartToCloseTimeout *string

	// The priority to assign to the scheduled activity task. If set, this overrides
	// any default priority value that was assigned when the activity type was
	// registered. Valid values are integers that range from Java's Integer.MIN_VALUE
	// (-2147483648) to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher
	// priority. For more information about setting task priority, see Setting Task
	// Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string

	noSmithyDocumentSerde
}

// Provides the details of the ActivityTaskStarted event.
type ActivityTaskStartedEventAttributes struct {

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// Identity of the worker that was assigned this task. This aids diagnostics when
	// problems arise. The form of this identity is user defined.
	Identity *string

	noSmithyDocumentSerde
}

// Provides the details of the ActivityTaskTimedOut event.
type ActivityTaskTimedOutEventAttributes struct {

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the ActivityTaskStarted event recorded when this activity task was
	// started. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The type of the timeout that caused this event.
	//
	// This member is required.
	TimeoutType ActivityTaskTimeoutType

	// Contains the content of the details parameter for the last call made by the
	// activity to RecordActivityTaskHeartbeat.
	Details *string

	noSmithyDocumentSerde
}

// Represents an activity type.
type ActivityType struct {

	// The name of this activity. The combination of activity type name and version
	// must be unique within a domain.
	//
	// This member is required.
	Name *string

	// The version of this activity. The combination of activity type name and version
	// must be unique with in a domain.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// Configuration settings registered with the activity type.
type ActivityTypeConfiguration struct {

	// The default maximum time, in seconds, before which a worker processing a task
	// must report progress by calling RecordActivityTaskHeartbeat. You can specify
	// this value only when registering an activity type. The registered default value
	// can be overridden when you schedule a task through the
	// ScheduleActivityTaskDecision. If the activity worker subsequently attempts to
	// record a heartbeat or returns a result, the activity worker receives an
	// UnknownResource fault. In this case, Amazon SWF no longer considers the activity
	// task to be valid; the activity worker should clean up the activity task. The
	// duration is specified in seconds, an integer greater than or equal to 0. You can
	// use NONE to specify unlimited duration.
	DefaultTaskHeartbeatTimeout *string

	// The default task list specified for this activity type at registration. This
	// default is used if a task list isn't provided when a task is scheduled through
	// the ScheduleActivityTaskDecision. You can override the default registered task
	// list when scheduling a task through the ScheduleActivityTaskDecision.
	DefaultTaskList *TaskList

	// The default task priority for tasks of this activity type, specified at
	// registration. If not set, then 0 is used as the default priority. This default
	// can be overridden when scheduling an activity task. Valid values are integers
	// that range from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE
	// (2147483647). Higher numbers indicate higher priority. For more information
	// about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	DefaultTaskPriority *string

	// The default maximum duration, specified when registering the activity type, for
	// tasks of this activity type. You can override this default when scheduling a
	// task through the ScheduleActivityTaskDecision. The duration is specified in
	// seconds, an integer greater than or equal to 0. You can use NONE to specify
	// unlimited duration.
	DefaultTaskScheduleToCloseTimeout *string

	// The default maximum duration, specified when registering the activity type, that
	// a task of an activity type can wait before being assigned to a worker. You can
	// override this default when scheduling a task through the
	// ScheduleActivityTaskDecision. The duration is specified in seconds, an integer
	// greater than or equal to 0. You can use NONE to specify unlimited duration.
	DefaultTaskScheduleToStartTimeout *string

	// The default maximum duration for tasks of an activity type specified when
	// registering the activity type. You can override this default when scheduling a
	// task through the ScheduleActivityTaskDecision. The duration is specified in
	// seconds, an integer greater than or equal to 0. You can use NONE to specify
	// unlimited duration.
	DefaultTaskStartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Detailed information about an activity type.
type ActivityTypeInfo struct {

	// The ActivityType type structure representing the activity type.
	//
	// This member is required.
	ActivityType *ActivityType

	// The date and time this activity type was created through RegisterActivityType.
	//
	// This member is required.
	CreationDate *time.Time

	// The current status of the activity type.
	//
	// This member is required.
	Status RegistrationStatus

	// If DEPRECATED, the date and time DeprecateActivityType was called.
	DeprecationDate *time.Time

	// The description of the activity type provided in RegisterActivityType.
	Description *string

	noSmithyDocumentSerde
}

// Provides the details of the CancelTimer decision. Access Control You can use IAM
// policies to control this decision's access to Amazon SWF resources as
// follows:
//
// * Use a Resource element with the domain name to limit the action to
// only specified domains.
//
// * Use an Action element to allow or deny permission to
// call this action.
//
// * You cannot use an IAM policy to constrain this action's
// parameters.
//
// If the caller doesn't have sufficient permissions to invoke the
// action, or the parameter values fall outside the specified constraints, the
// action fails. The associated event attribute's cause parameter is set to
// OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to
// Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CancelTimerDecisionAttributes struct {

	// The unique ID of the timer to cancel.
	//
	// This member is required.
	TimerId *string

	noSmithyDocumentSerde
}

// Provides the details of the CancelTimerFailed event.
type CancelTimerFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause CancelTimerFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The timerId provided in the CancelTimer decision that failed.
	//
	// This member is required.
	TimerId *string

	noSmithyDocumentSerde
}

// Provides the details of the CancelWorkflowExecution decision. Access Control You
// can use IAM policies to control this decision's access to Amazon SWF resources
// as follows:
//
// * Use a Resource element with the domain name to limit the action
// to only specified domains.
//
// * Use an Action element to allow or deny permission
// to call this action.
//
// * You cannot use an IAM policy to constrain this action's
// parameters.
//
// If the caller doesn't have sufficient permissions to invoke the
// action, or the parameter values fall outside the specified constraints, the
// action fails. The associated event attribute's cause parameter is set to
// OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to
// Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CancelWorkflowExecutionDecisionAttributes struct {

	// Details of the cancellation.
	Details *string

	noSmithyDocumentSerde
}

// Provides the details of the CancelWorkflowExecutionFailed event.
type CancelWorkflowExecutionFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause CancelWorkflowExecutionFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	noSmithyDocumentSerde
}

// Provide details of the ChildWorkflowExecutionCanceled event.
type ChildWorkflowExecutionCanceledEventAttributes struct {

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to the
	// StartChildWorkflowExecutionDecision to start this child workflow execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The child workflow execution that was canceled.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	// The type of the child workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// Details of the cancellation (if provided).
	Details *string

	noSmithyDocumentSerde
}

// Provides the details of the ChildWorkflowExecutionCompleted event.
type ChildWorkflowExecutionCompletedEventAttributes struct {

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to the
	// StartChildWorkflowExecutionDecision to start this child workflow execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The child workflow execution that was completed.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	// The type of the child workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// The result of the child workflow execution.
	Result *string

	noSmithyDocumentSerde
}

// Provides the details of the ChildWorkflowExecutionFailed event.
type ChildWorkflowExecutionFailedEventAttributes struct {

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to the
	// StartChildWorkflowExecutionDecision to start this child workflow execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The child workflow execution that failed.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	// The type of the child workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// The details of the failure (if provided).
	Details *string

	// The reason for the failure (if provided).
	Reason *string

	noSmithyDocumentSerde
}

// Provides the details of the ChildWorkflowExecutionStarted event.
type ChildWorkflowExecutionStartedEventAttributes struct {

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to the
	// StartChildWorkflowExecutionDecision to start this child workflow execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The child workflow execution that was started.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	// The type of the child workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	noSmithyDocumentSerde
}

// Provides the details of the ChildWorkflowExecutionTerminated event.
type ChildWorkflowExecutionTerminatedEventAttributes struct {

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to the
	// StartChildWorkflowExecutionDecision to start this child workflow execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The child workflow execution that was terminated.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	// The type of the child workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	noSmithyDocumentSerde
}

// Provides the details of the ChildWorkflowExecutionTimedOut event.
type ChildWorkflowExecutionTimedOutEventAttributes struct {

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to the
	// StartChildWorkflowExecutionDecision to start this child workflow execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The ID of the ChildWorkflowExecutionStarted event recorded when this child
	// workflow execution was started. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The type of the timeout that caused the child workflow execution to time out.
	//
	// This member is required.
	TimeoutType WorkflowExecutionTimeoutType

	// The child workflow execution that timed out.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	// The type of the child workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	noSmithyDocumentSerde
}

// Used to filter the closed workflow executions in visibility APIs by their close
// status.
type CloseStatusFilter struct {

	// The close status that must match the close status of an execution for it to meet
	// the criteria of this filter.
	//
	// This member is required.
	Status CloseStatus

	noSmithyDocumentSerde
}

// Provides the details of the CompleteWorkflowExecution decision. Access Control
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
// * Use a Resource element with the domain name to limit
// the action to only specified domains.
//
// * Use an Action element to allow or deny
// permission to call this action.
//
// * You cannot use an IAM policy to constrain
// this action's parameters.
//
// If the caller doesn't have sufficient permissions to
// invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type CompleteWorkflowExecutionDecisionAttributes struct {

	// The result of the workflow execution. The form of the result is implementation
	// defined.
	Result *string

	noSmithyDocumentSerde
}

// Provides the details of the CompleteWorkflowExecutionFailed event.
type CompleteWorkflowExecutionFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause CompleteWorkflowExecutionFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	noSmithyDocumentSerde
}

// Provides the details of the ContinueAsNewWorkflowExecution decision. Access
// Control You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
// * Use a Resource element with the domain name to limit
// the action to only specified domains.
//
// * Use an Action element to allow or deny
// permission to call this action.
//
// * Constrain the following parameters by using a
// Condition element with the appropriate keys.
//
// * tag – A tag used to identify the
// workflow execution
//
// * taskList – String constraint. The key is
// swf:taskList.name.
//
// * workflowType.version – String constraint. The key is
// swf:workflowType.version.
//
// If the caller doesn't have sufficient permissions to
// invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type ContinueAsNewWorkflowExecutionDecisionAttributes struct {

	// If set, specifies the policy to use for the child workflow executions of the new
	// execution if it is terminated by calling the TerminateWorkflowExecution action
	// explicitly or due to an expired timeout. This policy overrides the default child
	// policy specified when registering the workflow type using RegisterWorkflowType.
	// The supported child policies are:
	//
	// * TERMINATE – The child executions are
	// terminated.
	//
	// * REQUEST_CANCEL – A request to cancel is attempted for each child
	// execution by recording a WorkflowExecutionCancelRequested event in its history.
	// It is up to the decider to take appropriate actions when it receives an
	// execution history with this event.
	//
	// * ABANDON – No action is taken. The child
	// executions continue to run.
	//
	// A child policy for this workflow execution must be
	// specified either as a default for the workflow type or through this parameter.
	// If neither this parameter is set nor a default child policy was specified at
	// registration time then a fault is returned.
	ChildPolicy ChildPolicy

	// If set, specifies the total duration for this workflow execution. This overrides
	// the defaultExecutionStartToCloseTimeout specified when registering the workflow
	// type. The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration. An execution start-to-close
	// timeout for this workflow execution must be specified either as a default for
	// the workflow type or through this field. If neither this field is set nor a
	// default execution start-to-close timeout was specified at registration time then
	// a fault is returned.
	ExecutionStartToCloseTimeout *string

	// The input provided to the new workflow execution.
	Input *string

	// The IAM role to attach to the new (continued) execution.
	LambdaRole *string

	// The list of tags to associate with the new workflow execution. A maximum of 5
	// tags can be specified. You can list workflow executions with a specific tag by
	// calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and
	// specifying a TagFilter.
	TagList []string

	// The task list to use for the decisions of the new (continued) workflow
	// execution.
	TaskList *TaskList

	// The task priority that, if set, specifies the priority for the decision tasks
	// for this workflow execution. This overrides the defaultTaskPriority specified
	// when registering the workflow type. Valid values are integers that range from
	// Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher
	// numbers indicate higher priority. For more information about setting task
	// priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string

	// Specifies the maximum duration of decision tasks for the new workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType. The duration is
	// specified in seconds, an integer greater than or equal to 0. You can use NONE to
	// specify unlimited duration. A task start-to-close timeout for the new workflow
	// execution must be specified either as a default for the workflow type or through
	// this parameter. If neither this parameter is set nor a default task
	// start-to-close timeout was specified at registration time then a fault is
	// returned.
	TaskStartToCloseTimeout *string

	// The version of the workflow to start.
	WorkflowTypeVersion *string

	noSmithyDocumentSerde
}

// Provides the details of the ContinueAsNewWorkflowExecutionFailed event.
type ContinueAsNewWorkflowExecutionFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause ContinueAsNewWorkflowExecutionFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	noSmithyDocumentSerde
}

// Specifies a decision made by the decider. A decision can be one of these
// types:
//
// * CancelTimer – Cancels a previously started timer and records a
// TimerCanceled event in the history.
//
// * CancelWorkflowExecution – Closes the
// workflow execution and records a WorkflowExecutionCanceled event in the
// history.
//
// * CompleteWorkflowExecution – Closes the workflow execution and
// records a WorkflowExecutionCompleted event in the history .
//
// *
// ContinueAsNewWorkflowExecution – Closes the workflow execution and starts a new
// workflow execution of the same type using the same workflow ID and a unique run
// Id. A WorkflowExecutionContinuedAsNew event is recorded in the history.
//
// *
// FailWorkflowExecution – Closes the workflow execution and records a
// WorkflowExecutionFailed event in the history.
//
// * RecordMarker – Records a
// MarkerRecorded event in the history. Markers can be used for adding custom
// information in the history for instance to let deciders know that they don't
// need to look at the history beyond the marker event.
//
// *
// RequestCancelActivityTask – Attempts to cancel a previously scheduled activity
// task. If the activity task was scheduled but has not been assigned to a worker,
// then it is canceled. If the activity task was already assigned to a worker, then
// the worker is informed that cancellation has been requested in the response to
// RecordActivityTaskHeartbeat.
//
// * RequestCancelExternalWorkflowExecution –
// Requests that a request be made to cancel the specified external workflow
// execution and records a RequestCancelExternalWorkflowExecutionInitiated event in
// the history.
//
// * ScheduleActivityTask – Schedules an activity task.
//
// *
// SignalExternalWorkflowExecution – Requests a signal to be delivered to the
// specified external workflow execution and records a
// SignalExternalWorkflowExecutionInitiated event in the history.
//
// *
// StartChildWorkflowExecution – Requests that a child workflow execution be
// started and records a StartChildWorkflowExecutionInitiated event in the history.
// The child workflow execution is a separate workflow execution with its own
// history.
//
// * StartTimer – Starts a timer for this workflow execution and records
// a TimerStarted event in the history. This timer fires after the specified delay
// and record a TimerFired event.
//
// Access Control If you grant permission to use
// RespondDecisionTaskCompleted, you can use IAM policies to express permissions
// for the list of decisions returned by this action as if they were members of the
// API. Treating decisions as a pseudo API maintains a uniform conceptual model and
// helps keep policies readable. For details and example IAM policies, see Using
// IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide. Decision Failure Decisions can fail for
// several reasons
//
// * The ordering of decisions should follow a logical flow. Some
// decisions might not make sense in the current context of the workflow execution
// and therefore fails.
//
// * A limit on your account was reached.
//
// * The decision
// lacks sufficient permissions.
//
// One of the following events might be added to the
// history to indicate an error. The event attribute's cause parameter indicates
// the cause. If cause is set to OPERATION_NOT_PERMITTED, the decision failed
// because it lacked sufficient permissions. For details and example IAM policies,
// see Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
// * ScheduleActivityTaskFailed – A
// ScheduleActivityTask decision failed. This could happen if the activity type
// specified in the decision isn't registered, is in a deprecated state, or the
// decision isn't properly configured.
//
// * RequestCancelActivityTaskFailed – A
// RequestCancelActivityTask decision failed. This could happen if there is no open
// activity task with the specified activityId.
//
// * StartTimerFailed – A StartTimer
// decision failed. This could happen if there is another open timer with the same
// timerId.
//
// * CancelTimerFailed – A CancelTimer decision failed. This could happen
// if there is no open timer with the specified timerId.
//
// *
// StartChildWorkflowExecutionFailed – A StartChildWorkflowExecution decision
// failed. This could happen if the workflow type specified isn't registered, is
// deprecated, or the decision isn't properly configured.
//
// *
// SignalExternalWorkflowExecutionFailed – A SignalExternalWorkflowExecution
// decision failed. This could happen if the workflowID specified in the decision
// was incorrect.
//
// * RequestCancelExternalWorkflowExecutionFailed – A
// RequestCancelExternalWorkflowExecution decision failed. This could happen if the
// workflowID specified in the decision was incorrect.
//
// *
// CancelWorkflowExecutionFailed – A CancelWorkflowExecution decision failed. This
// could happen if there is an unhandled decision task pending in the workflow
// execution.
//
// * CompleteWorkflowExecutionFailed – A CompleteWorkflowExecution
// decision failed. This could happen if there is an unhandled decision task
// pending in the workflow execution.
//
// * ContinueAsNewWorkflowExecutionFailed – A
// ContinueAsNewWorkflowExecution decision failed. This could happen if there is an
// unhandled decision task pending in the workflow execution or the
// ContinueAsNewWorkflowExecution decision was not configured correctly.
//
// *
// FailWorkflowExecutionFailed – A FailWorkflowExecution decision failed. This
// could happen if there is an unhandled decision task pending in the workflow
// execution.
//
// The preceding error events might occur due to an error in the
// decider logic, which might put the workflow execution in an unstable state The
// cause field in the event structure for the error event indicates the cause of
// the error. A workflow execution may be closed by the decider by returning one of
// the following decisions when completing a decision task:
// CompleteWorkflowExecution, FailWorkflowExecution, CancelWorkflowExecution and
// ContinueAsNewWorkflowExecution. An UnhandledDecision fault is returned if a
// workflow closing decision is specified and a signal or activity event had been
// added to the history while the decision task was being performed by the decider.
// Unlike the above situations which are logic issues, this fault is always
// possible because of race conditions in a distributed system. The right action
// here is to call RespondDecisionTaskCompleted without any decisions. This would
// result in another decision task with these new events included in the history.
// The decider should handle the new events and may decide to close the workflow
// execution. How to Code a Decision You code a decision by first setting the
// decision type field to one of the above decision values, and then set the
// corresponding attributes field shown below:
//
// *
// ScheduleActivityTaskDecisionAttributes
//
// *
// RequestCancelActivityTaskDecisionAttributes
//
// *
// CompleteWorkflowExecutionDecisionAttributes
//
// *
// FailWorkflowExecutionDecisionAttributes
//
// *
// CancelWorkflowExecutionDecisionAttributes
//
// *
// ContinueAsNewWorkflowExecutionDecisionAttributes
//
// *
// RecordMarkerDecisionAttributes
//
// * StartTimerDecisionAttributes
//
// *
// CancelTimerDecisionAttributes
//
// *
// SignalExternalWorkflowExecutionDecisionAttributes
//
// *
// RequestCancelExternalWorkflowExecutionDecisionAttributes
//
// *
// StartChildWorkflowExecutionDecisionAttributes
type Decision struct {

	// Specifies the type of the decision.
	//
	// This member is required.
	DecisionType DecisionType

	// Provides the details of the CancelTimer decision. It isn't set for other
	// decision types.
	CancelTimerDecisionAttributes *CancelTimerDecisionAttributes

	// Provides the details of the CancelWorkflowExecution decision. It isn't set for
	// other decision types.
	CancelWorkflowExecutionDecisionAttributes *CancelWorkflowExecutionDecisionAttributes

	// Provides the details of the CompleteWorkflowExecution decision. It isn't set for
	// other decision types.
	CompleteWorkflowExecutionDecisionAttributes *CompleteWorkflowExecutionDecisionAttributes

	// Provides the details of the ContinueAsNewWorkflowExecution decision. It isn't
	// set for other decision types.
	ContinueAsNewWorkflowExecutionDecisionAttributes *ContinueAsNewWorkflowExecutionDecisionAttributes

	// Provides the details of the FailWorkflowExecution decision. It isn't set for
	// other decision types.
	FailWorkflowExecutionDecisionAttributes *FailWorkflowExecutionDecisionAttributes

	// Provides the details of the RecordMarker decision. It isn't set for other
	// decision types.
	RecordMarkerDecisionAttributes *RecordMarkerDecisionAttributes

	// Provides the details of the RequestCancelActivityTask decision. It isn't set for
	// other decision types.
	RequestCancelActivityTaskDecisionAttributes *RequestCancelActivityTaskDecisionAttributes

	// Provides the details of the RequestCancelExternalWorkflowExecution decision. It
	// isn't set for other decision types.
	RequestCancelExternalWorkflowExecutionDecisionAttributes *RequestCancelExternalWorkflowExecutionDecisionAttributes

	// Provides the details of the ScheduleActivityTask decision. It isn't set for
	// other decision types.
	ScheduleActivityTaskDecisionAttributes *ScheduleActivityTaskDecisionAttributes

	// Provides the details of the ScheduleLambdaFunction decision. It isn't set for
	// other decision types.
	ScheduleLambdaFunctionDecisionAttributes *ScheduleLambdaFunctionDecisionAttributes

	// Provides the details of the SignalExternalWorkflowExecution decision. It isn't
	// set for other decision types.
	SignalExternalWorkflowExecutionDecisionAttributes *SignalExternalWorkflowExecutionDecisionAttributes

	// Provides the details of the StartChildWorkflowExecution decision. It isn't set
	// for other decision types.
	StartChildWorkflowExecutionDecisionAttributes *StartChildWorkflowExecutionDecisionAttributes

	// Provides the details of the StartTimer decision. It isn't set for other decision
	// types.
	StartTimerDecisionAttributes *StartTimerDecisionAttributes

	noSmithyDocumentSerde
}

// Provides the details of the DecisionTaskCompleted event.
type DecisionTaskCompletedEventAttributes struct {

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the DecisionTaskStarted event recorded when this decision task was
	// started. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// User defined context for the workflow execution.
	ExecutionContext *string

	noSmithyDocumentSerde
}

// Provides details about the DecisionTaskScheduled event.
type DecisionTaskScheduledEventAttributes struct {

	// The name of the task list in which the decision task was scheduled.
	//
	// This member is required.
	TaskList *TaskList

	// The maximum duration for this decision task. The task is considered timed out if
	// it doesn't completed within this duration. The duration is specified in seconds,
	// an integer greater than or equal to 0. You can use NONE to specify unlimited
	// duration.
	StartToCloseTimeout *string

	// A task priority that, if set, specifies the priority for this decision task.
	// Valid values are integers that range from Java's Integer.MIN_VALUE (-2147483648)
	// to Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority. For
	// more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string

	noSmithyDocumentSerde
}

// Provides the details of the DecisionTaskStarted event.
type DecisionTaskStartedEventAttributes struct {

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// Identity of the decider making the request. This enables diagnostic tracing when
	// problems arise. The form of this identity is user defined.
	Identity *string

	noSmithyDocumentSerde
}

// Provides the details of the DecisionTaskTimedOut event.
type DecisionTaskTimedOutEventAttributes struct {

	// The ID of the DecisionTaskScheduled event that was recorded when this decision
	// task was scheduled. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the DecisionTaskStarted event recorded when this decision task was
	// started. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The type of timeout that expired before the decision task could be completed.
	//
	// This member is required.
	TimeoutType DecisionTaskTimeoutType

	noSmithyDocumentSerde
}

// Contains the configuration settings of a domain.
type DomainConfiguration struct {

	// The retention period for workflow executions in this domain.
	//
	// This member is required.
	WorkflowExecutionRetentionPeriodInDays *string

	noSmithyDocumentSerde
}

// Contains general information about a domain.
type DomainInfo struct {

	// The name of the domain. This name is unique within the account.
	//
	// This member is required.
	Name *string

	// The status of the domain:
	//
	// * REGISTERED – The domain is properly registered and
	// available. You can use this domain for registering types and creating new
	// workflow executions.
	//
	// * DEPRECATED – The domain was deprecated using
	// DeprecateDomain, but is still in use. You should not create new workflow
	// executions in this domain.
	//
	// This member is required.
	Status RegistrationStatus

	// The ARN of the domain.
	Arn *string

	// The description of the domain provided through RegisterDomain.
	Description *string

	noSmithyDocumentSerde
}

// Used to filter the workflow executions in visibility APIs by various time-based
// rules. Each parameter, if specified, defines a rule that must be satisfied by
// each returned query result. The parameter values are in the Unix Time format
// (https://en.wikipedia.org/wiki/Unix_time). For example: "oldestDate":
// 1325376070.
type ExecutionTimeFilter struct {

	// Specifies the oldest start or close date and time to return.
	//
	// This member is required.
	OldestDate *time.Time

	// Specifies the latest start or close date and time to return.
	LatestDate *time.Time

	noSmithyDocumentSerde
}

// Provides the details of the ExternalWorkflowExecutionCancelRequested event.
type ExternalWorkflowExecutionCancelRequestedEventAttributes struct {

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event
	// corresponding to the RequestCancelExternalWorkflowExecution decision to cancel
	// this external workflow execution. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The external workflow execution to which the cancellation request was delivered.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	noSmithyDocumentSerde
}

// Provides the details of the ExternalWorkflowExecutionSignaled event.
type ExternalWorkflowExecutionSignaledEventAttributes struct {

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding to
	// the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The external workflow execution that the signal was delivered to.
	//
	// This member is required.
	WorkflowExecution *WorkflowExecution

	noSmithyDocumentSerde
}

// Provides the details of the FailWorkflowExecution decision. Access Control You
// can use IAM policies to control this decision's access to Amazon SWF resources
// as follows:
//
// * Use a Resource element with the domain name to limit the action
// to only specified domains.
//
// * Use an Action element to allow or deny permission
// to call this action.
//
// * You cannot use an IAM policy to constrain this action's
// parameters.
//
// If the caller doesn't have sufficient permissions to invoke the
// action, or the parameter values fall outside the specified constraints, the
// action fails. The associated event attribute's cause parameter is set to
// OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to
// Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type FailWorkflowExecutionDecisionAttributes struct {

	// Details of the failure.
	Details *string

	// A descriptive reason for the failure that may help in diagnostics.
	Reason *string

	noSmithyDocumentSerde
}

// Provides the details of the FailWorkflowExecutionFailed event.
type FailWorkflowExecutionFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause FailWorkflowExecutionFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	noSmithyDocumentSerde
}

// Event within a workflow execution. A history event can be one of these types:
//
// *
// ActivityTaskCancelRequested – A RequestCancelActivityTask decision was received
// by the system.
//
// * ActivityTaskCanceled – The activity task was successfully
// canceled.
//
// * ActivityTaskCompleted – An activity worker successfully completed
// an activity task by calling RespondActivityTaskCompleted.
//
// * ActivityTaskFailed
// – An activity worker failed an activity task by calling
// RespondActivityTaskFailed.
//
// * ActivityTaskScheduled – An activity task was
// scheduled for execution.
//
// * ActivityTaskStarted – The scheduled activity task
// was dispatched to a worker.
//
// * ActivityTaskTimedOut – The activity task timed
// out.
//
// * CancelTimerFailed – Failed to process CancelTimer decision. This happens
// when the decision isn't configured properly, for example no timer exists with
// the specified timer Id.
//
// * CancelWorkflowExecutionFailed – A request to cancel a
// workflow execution failed.
//
// * ChildWorkflowExecutionCanceled – A child workflow
// execution, started by this workflow execution, was canceled and closed.
//
// *
// ChildWorkflowExecutionCompleted – A child workflow execution, started by this
// workflow execution, completed successfully and was closed.
//
// *
// ChildWorkflowExecutionFailed – A child workflow execution, started by this
// workflow execution, failed to complete successfully and was closed.
//
// *
// ChildWorkflowExecutionStarted – A child workflow execution was successfully
// started.
//
// * ChildWorkflowExecutionTerminated – A child workflow execution,
// started by this workflow execution, was terminated.
//
// *
// ChildWorkflowExecutionTimedOut – A child workflow execution, started by this
// workflow execution, timed out and was closed.
//
// * CompleteWorkflowExecutionFailed
// – The workflow execution failed to complete.
//
// *
// ContinueAsNewWorkflowExecutionFailed – The workflow execution failed to complete
// after being continued as a new workflow execution.
//
// * DecisionTaskCompleted –
// The decider successfully completed a decision task by calling
// RespondDecisionTaskCompleted.
//
// * DecisionTaskScheduled – A decision task was
// scheduled for the workflow execution.
//
// * DecisionTaskStarted – The decision task
// was dispatched to a decider.
//
// * DecisionTaskTimedOut – The decision task timed
// out.
//
// * ExternalWorkflowExecutionCancelRequested – Request to cancel an external
// workflow execution was successfully delivered to the target execution.
//
// *
// ExternalWorkflowExecutionSignaled – A signal, requested by this workflow
// execution, was successfully delivered to the target external workflow
// execution.
//
// * FailWorkflowExecutionFailed – A request to mark a workflow
// execution as failed, itself failed.
//
// * MarkerRecorded – A marker was recorded in
// the workflow history as the result of a RecordMarker decision.
//
// *
// RecordMarkerFailed – A RecordMarker decision was returned as failed.
//
// *
// RequestCancelActivityTaskFailed – Failed to process RequestCancelActivityTask
// decision. This happens when the decision isn't configured properly.
//
// *
// RequestCancelExternalWorkflowExecutionFailed – Request to cancel an external
// workflow execution failed.
//
// * RequestCancelExternalWorkflowExecutionInitiated –
// A request was made to request the cancellation of an external workflow
// execution.
//
// * ScheduleActivityTaskFailed – Failed to process
// ScheduleActivityTask decision. This happens when the decision isn't configured
// properly, for example the activity type specified isn't registered.
//
// *
// SignalExternalWorkflowExecutionFailed – The request to signal an external
// workflow execution failed.
//
// * SignalExternalWorkflowExecutionInitiated – A
// request to signal an external workflow was made.
//
// * StartActivityTaskFailed – A
// scheduled activity task failed to start.
//
// * StartChildWorkflowExecutionFailed –
// Failed to process StartChildWorkflowExecution decision. This happens when the
// decision isn't configured properly, for example the workflow type specified
// isn't registered.
//
// * StartChildWorkflowExecutionInitiated – A request was made
// to start a child workflow execution.
//
// * StartTimerFailed – Failed to process
// StartTimer decision. This happens when the decision isn't configured properly,
// for example a timer already exists with the specified timer Id.
//
// * TimerCanceled
// – A timer, previously started for this workflow execution, was successfully
// canceled.
//
// * TimerFired – A timer, previously started for this workflow
// execution, fired.
//
// * TimerStarted – A timer was started for the workflow
// execution due to a StartTimer decision.
//
// * WorkflowExecutionCancelRequested – A
// request to cancel this workflow execution was made.
//
// * WorkflowExecutionCanceled
// – The workflow execution was successfully canceled and closed.
//
// *
// WorkflowExecutionCompleted – The workflow execution was closed due to successful
// completion.
//
// * WorkflowExecutionContinuedAsNew – The workflow execution was
// closed and a new execution of the same type was created with the same
// workflowId.
//
// * WorkflowExecutionFailed – The workflow execution closed due to a
// failure.
//
// * WorkflowExecutionSignaled – An external signal was received for the
// workflow execution.
//
// * WorkflowExecutionStarted – The workflow execution was
// started.
//
// * WorkflowExecutionTerminated – The workflow execution was
// terminated.
//
// * WorkflowExecutionTimedOut – The workflow execution was closed
// because a time out was exceeded.
type HistoryEvent struct {

	// The system generated ID of the event. This ID uniquely identifies the event with
	// in the workflow execution history.
	//
	// This member is required.
	EventId int64

	// The date and time when the event occurred.
	//
	// This member is required.
	EventTimestamp *time.Time

	// The type of the history event.
	//
	// This member is required.
	EventType EventType

	// If the event is of type ActivityTaskcancelRequested then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskCancelRequestedEventAttributes *ActivityTaskCancelRequestedEventAttributes

	// If the event is of type ActivityTaskCanceled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskCanceledEventAttributes *ActivityTaskCanceledEventAttributes

	// If the event is of type ActivityTaskCompleted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskCompletedEventAttributes *ActivityTaskCompletedEventAttributes

	// If the event is of type ActivityTaskFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	ActivityTaskFailedEventAttributes *ActivityTaskFailedEventAttributes

	// If the event is of type ActivityTaskScheduled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskScheduledEventAttributes *ActivityTaskScheduledEventAttributes

	// If the event is of type ActivityTaskStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	ActivityTaskStartedEventAttributes *ActivityTaskStartedEventAttributes

	// If the event is of type ActivityTaskTimedOut then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ActivityTaskTimedOutEventAttributes *ActivityTaskTimedOutEventAttributes

	// If the event is of type CancelTimerFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	CancelTimerFailedEventAttributes *CancelTimerFailedEventAttributes

	// If the event is of type CancelWorkflowExecutionFailed then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	CancelWorkflowExecutionFailedEventAttributes *CancelWorkflowExecutionFailedEventAttributes

	// If the event is of type ChildWorkflowExecutionCanceled then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	ChildWorkflowExecutionCanceledEventAttributes *ChildWorkflowExecutionCanceledEventAttributes

	// If the event is of type ChildWorkflowExecutionCompleted then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	ChildWorkflowExecutionCompletedEventAttributes *ChildWorkflowExecutionCompletedEventAttributes

	// If the event is of type ChildWorkflowExecutionFailed then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ChildWorkflowExecutionFailedEventAttributes *ChildWorkflowExecutionFailedEventAttributes

	// If the event is of type ChildWorkflowExecutionStarted then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	ChildWorkflowExecutionStartedEventAttributes *ChildWorkflowExecutionStartedEventAttributes

	// If the event is of type ChildWorkflowExecutionTerminated then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	ChildWorkflowExecutionTerminatedEventAttributes *ChildWorkflowExecutionTerminatedEventAttributes

	// If the event is of type ChildWorkflowExecutionTimedOut then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	ChildWorkflowExecutionTimedOutEventAttributes *ChildWorkflowExecutionTimedOutEventAttributes

	// If the event is of type CompleteWorkflowExecutionFailed then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	CompleteWorkflowExecutionFailedEventAttributes *CompleteWorkflowExecutionFailedEventAttributes

	// If the event is of type ContinueAsNewWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ContinueAsNewWorkflowExecutionFailedEventAttributes *ContinueAsNewWorkflowExecutionFailedEventAttributes

	// If the event is of type DecisionTaskCompleted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskCompletedEventAttributes *DecisionTaskCompletedEventAttributes

	// If the event is of type DecisionTaskScheduled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskScheduledEventAttributes *DecisionTaskScheduledEventAttributes

	// If the event is of type DecisionTaskStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	DecisionTaskStartedEventAttributes *DecisionTaskStartedEventAttributes

	// If the event is of type DecisionTaskTimedOut then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	DecisionTaskTimedOutEventAttributes *DecisionTaskTimedOutEventAttributes

	// If the event is of type ExternalWorkflowExecutionCancelRequested then this
	// member is set and provides detailed information about the event. It isn't set
	// for other event types.
	ExternalWorkflowExecutionCancelRequestedEventAttributes *ExternalWorkflowExecutionCancelRequestedEventAttributes

	// If the event is of type ExternalWorkflowExecutionSignaled then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	ExternalWorkflowExecutionSignaledEventAttributes *ExternalWorkflowExecutionSignaledEventAttributes

	// If the event is of type FailWorkflowExecutionFailed then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	FailWorkflowExecutionFailedEventAttributes *FailWorkflowExecutionFailedEventAttributes

	// Provides the details of the LambdaFunctionCompleted event. It isn't set for
	// other event types.
	LambdaFunctionCompletedEventAttributes *LambdaFunctionCompletedEventAttributes

	// Provides the details of the LambdaFunctionFailed event. It isn't set for other
	// event types.
	LambdaFunctionFailedEventAttributes *LambdaFunctionFailedEventAttributes

	// Provides the details of the LambdaFunctionScheduled event. It isn't set for
	// other event types.
	LambdaFunctionScheduledEventAttributes *LambdaFunctionScheduledEventAttributes

	// Provides the details of the LambdaFunctionStarted event. It isn't set for other
	// event types.
	LambdaFunctionStartedEventAttributes *LambdaFunctionStartedEventAttributes

	// Provides the details of the LambdaFunctionTimedOut event. It isn't set for other
	// event types.
	LambdaFunctionTimedOutEventAttributes *LambdaFunctionTimedOutEventAttributes

	// If the event is of type MarkerRecorded then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	MarkerRecordedEventAttributes *MarkerRecordedEventAttributes

	// If the event is of type DecisionTaskFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	RecordMarkerFailedEventAttributes *RecordMarkerFailedEventAttributes

	// If the event is of type RequestCancelActivityTaskFailed then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	RequestCancelActivityTaskFailedEventAttributes *RequestCancelActivityTaskFailedEventAttributes

	// If the event is of type RequestCancelExternalWorkflowExecutionFailed then this
	// member is set and provides detailed information about the event. It isn't set
	// for other event types.
	RequestCancelExternalWorkflowExecutionFailedEventAttributes *RequestCancelExternalWorkflowExecutionFailedEventAttributes

	// If the event is of type RequestCancelExternalWorkflowExecutionInitiated then
	// this member is set and provides detailed information about the event. It isn't
	// set for other event types.
	RequestCancelExternalWorkflowExecutionInitiatedEventAttributes *RequestCancelExternalWorkflowExecutionInitiatedEventAttributes

	// If the event is of type ScheduleActivityTaskFailed then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	ScheduleActivityTaskFailedEventAttributes *ScheduleActivityTaskFailedEventAttributes

	// Provides the details of the ScheduleLambdaFunctionFailed event. It isn't set for
	// other event types.
	ScheduleLambdaFunctionFailedEventAttributes *ScheduleLambdaFunctionFailedEventAttributes

	// If the event is of type SignalExternalWorkflowExecutionFailed then this member
	// is set and provides detailed information about the event. It isn't set for other
	// event types.
	SignalExternalWorkflowExecutionFailedEventAttributes *SignalExternalWorkflowExecutionFailedEventAttributes

	// If the event is of type SignalExternalWorkflowExecutionInitiated then this
	// member is set and provides detailed information about the event. It isn't set
	// for other event types.
	SignalExternalWorkflowExecutionInitiatedEventAttributes *SignalExternalWorkflowExecutionInitiatedEventAttributes

	// If the event is of type StartChildWorkflowExecutionFailed then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	StartChildWorkflowExecutionFailedEventAttributes *StartChildWorkflowExecutionFailedEventAttributes

	// If the event is of type StartChildWorkflowExecutionInitiated then this member is
	// set and provides detailed information about the event. It isn't set for other
	// event types.
	StartChildWorkflowExecutionInitiatedEventAttributes *StartChildWorkflowExecutionInitiatedEventAttributes

	// Provides the details of the StartLambdaFunctionFailed event. It isn't set for
	// other event types.
	StartLambdaFunctionFailedEventAttributes *StartLambdaFunctionFailedEventAttributes

	// If the event is of type StartTimerFailed then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	StartTimerFailedEventAttributes *StartTimerFailedEventAttributes

	// If the event is of type TimerCanceled then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	TimerCanceledEventAttributes *TimerCanceledEventAttributes

	// If the event is of type TimerFired then this member is set and provides detailed
	// information about the event. It isn't set for other event types.
	TimerFiredEventAttributes *TimerFiredEventAttributes

	// If the event is of type TimerStarted then this member is set and provides
	// detailed information about the event. It isn't set for other event types.
	TimerStartedEventAttributes *TimerStartedEventAttributes

	// If the event is of type WorkflowExecutionCancelRequested then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionCancelRequestedEventAttributes *WorkflowExecutionCancelRequestedEventAttributes

	// If the event is of type WorkflowExecutionCanceled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionCanceledEventAttributes *WorkflowExecutionCanceledEventAttributes

	// If the event is of type WorkflowExecutionCompleted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionCompletedEventAttributes *WorkflowExecutionCompletedEventAttributes

	// If the event is of type WorkflowExecutionContinuedAsNew then this member is set
	// and provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionContinuedAsNewEventAttributes *WorkflowExecutionContinuedAsNewEventAttributes

	// If the event is of type WorkflowExecutionFailed then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionFailedEventAttributes *WorkflowExecutionFailedEventAttributes

	// If the event is of type WorkflowExecutionSignaled then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionSignaledEventAttributes *WorkflowExecutionSignaledEventAttributes

	// If the event is of type WorkflowExecutionStarted then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionStartedEventAttributes *WorkflowExecutionStartedEventAttributes

	// If the event is of type WorkflowExecutionTerminated then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionTerminatedEventAttributes *WorkflowExecutionTerminatedEventAttributes

	// If the event is of type WorkflowExecutionTimedOut then this member is set and
	// provides detailed information about the event. It isn't set for other event
	// types.
	WorkflowExecutionTimedOutEventAttributes *WorkflowExecutionTimedOutEventAttributes

	noSmithyDocumentSerde
}

// Provides the details of the LambdaFunctionCompleted event. It isn't set for
// other event types.
type LambdaFunctionCompletedEventAttributes struct {

	// The ID of the LambdaFunctionScheduled event that was recorded when this Lambda
	// task was scheduled. To help diagnose issues, use this information to trace back
	// the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the LambdaFunctionStarted event recorded when this activity task
	// started. To help diagnose issues, use this information to trace back the chain
	// of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The results of the Lambda task.
	Result *string

	noSmithyDocumentSerde
}

// Provides the details of the LambdaFunctionFailed event. It isn't set for other
// event types.
type LambdaFunctionFailedEventAttributes struct {

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace back
	// the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the LambdaFunctionStarted event recorded when this activity task
	// started. To help diagnose issues, use this information to trace back the chain
	// of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The details of the failure.
	Details *string

	// The reason provided for the failure.
	Reason *string

	noSmithyDocumentSerde
}

// Provides the details of the LambdaFunctionScheduled event. It isn't set for
// other event types.
type LambdaFunctionScheduledEventAttributes struct {

	// The ID of the LambdaFunctionCompleted event corresponding to the decision that
	// resulted in scheduling this activity task. To help diagnose issues, use this
	// information to trace back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The unique ID of the Lambda task.
	//
	// This member is required.
	Id *string

	// The name of the Lambda function.
	//
	// This member is required.
	Name *string

	// Data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the Lambda task.
	Control *string

	// The input provided to the Lambda task.
	Input *string

	// The maximum amount of time a worker can take to process the Lambda task.
	StartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Provides the details of the LambdaFunctionStarted event. It isn't set for other
// event types.
type LambdaFunctionStartedEventAttributes struct {

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace back
	// the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	noSmithyDocumentSerde
}

// Provides details of the LambdaFunctionTimedOut event.
type LambdaFunctionTimedOutEventAttributes struct {

	// The ID of the LambdaFunctionScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace back
	// the chain of events leading up to this event.
	//
	// This member is required.
	ScheduledEventId int64

	// The ID of the ActivityTaskStarted event that was recorded when this activity
	// task started. To help diagnose issues, use this information to trace back the
	// chain of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The type of the timeout that caused this event.
	TimeoutType LambdaFunctionTimeoutType

	noSmithyDocumentSerde
}

// Provides the details of the MarkerRecorded event.
type MarkerRecordedEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarker decision that requested this marker. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The name of the marker.
	//
	// This member is required.
	MarkerName *string

	// The details of the marker.
	Details *string

	noSmithyDocumentSerde
}

// Provides the details of the RecordMarker decision. Access Control You can use
// IAM policies to control this decision's access to Amazon SWF resources as
// follows:
//
// * Use a Resource element with the domain name to limit the action to
// only specified domains.
//
// * Use an Action element to allow or deny permission to
// call this action.
//
// * You cannot use an IAM policy to constrain this action's
// parameters.
//
// If the caller doesn't have sufficient permissions to invoke the
// action, or the parameter values fall outside the specified constraints, the
// action fails. The associated event attribute's cause parameter is set to
// OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to
// Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RecordMarkerDecisionAttributes struct {

	// The name of the marker.
	//
	// This member is required.
	MarkerName *string

	// The details of the marker.
	Details *string

	noSmithyDocumentSerde
}

// Provides the details of the RecordMarkerFailed event.
type RecordMarkerFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause RecordMarkerFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RecordMarkerFailed decision for this cancellation request.
	// This information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The marker's name.
	//
	// This member is required.
	MarkerName *string

	noSmithyDocumentSerde
}

// Provides the details of the RequestCancelActivityTask decision. Access Control
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
// * Use a Resource element with the domain name to limit
// the action to only specified domains.
//
// * Use an Action element to allow or deny
// permission to call this action.
//
// * You cannot use an IAM policy to constrain
// this action's parameters.
//
// If the caller doesn't have sufficient permissions to
// invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RequestCancelActivityTaskDecisionAttributes struct {

	// The activityId of the activity task to be canceled.
	//
	// This member is required.
	ActivityId *string

	noSmithyDocumentSerde
}

// Provides the details of the RequestCancelActivityTaskFailed event.
type RequestCancelActivityTaskFailedEventAttributes struct {

	// The activityId provided in the RequestCancelActivityTask decision that failed.
	//
	// This member is required.
	ActivityId *string

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause RequestCancelActivityTaskFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelActivityTask decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	noSmithyDocumentSerde
}

// Provides the details of the RequestCancelExternalWorkflowExecution decision.
// Access Control You can use IAM policies to control this decision's access to
// Amazon SWF resources as follows:
//
// * Use a Resource element with the domain name
// to limit the action to only specified domains.
//
// * Use an Action element to allow
// or deny permission to call this action.
//
// * You cannot use an IAM policy to
// constrain this action's parameters.
//
// If the caller doesn't have sufficient
// permissions to invoke the action, or the parameter values fall outside the
// specified constraints, the action fails. The associated event attribute's cause
// parameter is set to OPERATION_NOT_PERMITTED. For details and example IAM
// policies, see Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type RequestCancelExternalWorkflowExecutionDecisionAttributes struct {

	// The workflowId of the external workflow execution to cancel.
	//
	// This member is required.
	WorkflowId *string

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string

	// The runId of the external workflow execution to cancel.
	RunId *string

	noSmithyDocumentSerde
}

// Provides the details of the RequestCancelExternalWorkflowExecutionFailed event.
type RequestCancelExternalWorkflowExecutionFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause RequestCancelExternalWorkflowExecutionFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for this
	// cancellation request. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event
	// corresponding to the RequestCancelExternalWorkflowExecution decision to cancel
	// this external workflow execution. This information can be useful for diagnosing
	// problems by tracing back the chain of events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The workflowId of the external workflow to which the cancel request was to be
	// delivered.
	//
	// This member is required.
	WorkflowId *string

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the workflow execution.
	Control *string

	// The runId of the external workflow execution.
	RunId *string

	noSmithyDocumentSerde
}

// Provides the details of the RequestCancelExternalWorkflowExecutionInitiated
// event.
type RequestCancelExternalWorkflowExecutionInitiatedEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the RequestCancelExternalWorkflowExecution decision for this
	// cancellation request. This information can be useful for diagnosing problems by
	// tracing back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The workflowId of the external workflow execution to be canceled.
	//
	// This member is required.
	WorkflowId *string

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string

	// The runId of the external workflow execution to be canceled.
	RunId *string

	noSmithyDocumentSerde
}

// Tags are key-value pairs that can be associated with Amazon SWF state machines
// and activities. Tags may only contain unicode letters, digits, whitespace, or
// these symbols: _ . : / = + - @.
type ResourceTag struct {

	// The key of a tag.
	//
	// This member is required.
	Key *string

	// The value of a tag.
	Value *string

	noSmithyDocumentSerde
}

// Provides the details of the ScheduleActivityTask decision. Access Control You
// can use IAM policies to control this decision's access to Amazon SWF resources
// as follows:
//
// * Use a Resource element with the domain name to limit the action
// to only specified domains.
//
// * Use an Action element to allow or deny permission
// to call this action.
//
// * Constrain the following parameters by using a Condition
// element with the appropriate keys.
//
// * activityType.name – String constraint. The
// key is swf:activityType.name.
//
// * activityType.version – String constraint. The
// key is swf:activityType.version.
//
// * taskList – String constraint. The key is
// swf:taskList.name.
//
// If the caller doesn't have sufficient permissions to invoke
// the action, or the parameter values fall outside the specified constraints, the
// action fails. The associated event attribute's cause parameter is set to
// OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to
// Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type ScheduleActivityTaskDecisionAttributes struct {

	// The activityId of the activity task. The specified string must not start or end
	// with whitespace. It must not contain a : (colon), / (slash), | (vertical bar),
	// or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not
	// contain the literal string arn.
	//
	// This member is required.
	ActivityId *string

	// The type of the activity task to schedule.
	//
	// This member is required.
	ActivityType *ActivityType

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the activity.
	Control *string

	// If set, specifies the maximum time before which a worker processing a task of
	// this type must report progress by calling RecordActivityTaskHeartbeat. If the
	// timeout is exceeded, the activity task is automatically timed out. If the worker
	// subsequently attempts to record a heartbeat or returns a result, it is ignored.
	// This overrides the default heartbeat timeout specified when registering the
	// activity type using RegisterActivityType. The duration is specified in seconds,
	// an integer greater than or equal to 0. You can use NONE to specify unlimited
	// duration.
	HeartbeatTimeout *string

	// The input provided to the activity task.
	Input *string

	// The maximum duration for this activity task. The duration is specified in
	// seconds, an integer greater than or equal to 0. You can use NONE to specify
	// unlimited duration. A schedule-to-close timeout for this activity task must be
	// specified either as a default for the activity type or through this field. If
	// neither this field is set nor a default schedule-to-close timeout was specified
	// at registration time then a fault is returned.
	ScheduleToCloseTimeout *string

	// If set, specifies the maximum duration the activity task can wait to be assigned
	// to a worker. This overrides the default schedule-to-start timeout specified when
	// registering the activity type using RegisterActivityType. The duration is
	// specified in seconds, an integer greater than or equal to 0. You can use NONE to
	// specify unlimited duration. A schedule-to-start timeout for this activity task
	// must be specified either as a default for the activity type or through this
	// field. If neither this field is set nor a default schedule-to-start timeout was
	// specified at registration time then a fault is returned.
	ScheduleToStartTimeout *string

	// If set, specifies the maximum duration a worker may take to process this
	// activity task. This overrides the default start-to-close timeout specified when
	// registering the activity type using RegisterActivityType. The duration is
	// specified in seconds, an integer greater than or equal to 0. You can use NONE to
	// specify unlimited duration. A start-to-close timeout for this activity task must
	// be specified either as a default for the activity type or through this field. If
	// neither this field is set nor a default start-to-close timeout was specified at
	// registration time then a fault is returned.
	StartToCloseTimeout *string

	// If set, specifies the name of the task list in which to schedule the activity
	// task. If not specified, the defaultTaskList registered with the activity type is
	// used. A task list for this activity task must be specified either as a default
	// for the activity type or through this field. If neither this field is set nor a
	// default task list was specified at registration time then a fault is returned.
	// The specified string must not start or end with whitespace. It must not contain
	// a : (colon), / (slash), | (vertical bar), or any control characters
	// (\u0000-\u001f | \u007f-\u009f). Also, it must not contain the literal string
	// arn.
	TaskList *TaskList

	// If set, specifies the priority with which the activity task is to be assigned to
	// a worker. This overrides the defaultTaskPriority specified when registering the
	// activity type using RegisterActivityType. Valid values are integers that range
	// from Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647).
	// Higher numbers indicate higher priority. For more information about setting task
	// priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string

	noSmithyDocumentSerde
}

// Provides the details of the ScheduleActivityTaskFailed event.
type ScheduleActivityTaskFailedEventAttributes struct {

	// The activityId provided in the ScheduleActivityTask decision that failed.
	//
	// This member is required.
	ActivityId *string

	// The activity type provided in the ScheduleActivityTask decision that failed.
	//
	// This member is required.
	ActivityType *ActivityType

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause ScheduleActivityTaskFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision that
	// resulted in the scheduling of this activity task. This information can be useful
	// for diagnosing problems by tracing back the chain of events leading up to this
	// event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	noSmithyDocumentSerde
}

// Decision attributes specified in scheduleLambdaFunctionDecisionAttributes within
// the list of decisions decisions passed to RespondDecisionTaskCompleted.
type ScheduleLambdaFunctionDecisionAttributes struct {

	// A string that identifies the Lambda function execution in the event history.
	//
	// This member is required.
	Id *string

	// The name, or ARN, of the Lambda function to schedule.
	//
	// This member is required.
	Name *string

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the Lambda task.
	Control *string

	// The optional input data to be supplied to the Lambda function.
	Input *string

	// The timeout value, in seconds, after which the Lambda function is considered to
	// be failed once it has started. This can be any integer from 1-300 (1s-5m). If no
	// value is supplied, than a default value of 300s is assumed.
	StartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Provides the details of the ScheduleLambdaFunctionFailed event. It isn't set for
// other event types.
type ScheduleLambdaFunctionFailedEventAttributes struct {

	// The cause of the failure. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event. If cause is set to
	// OPERATION_NOT_PERMITTED, the decision failed because it lacked sufficient
	// permissions. For details and example IAM policies, see Using IAM to Manage
	// Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause ScheduleLambdaFunctionFailedCause

	// The ID of the LambdaFunctionCompleted event corresponding to the decision that
	// resulted in scheduling this Lambda task. To help diagnose issues, use this
	// information to trace back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The ID provided in the ScheduleLambdaFunction decision that failed.
	//
	// This member is required.
	Id *string

	// The name of the Lambda function.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Provides the details of the SignalExternalWorkflowExecution decision. Access
// Control You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
// * Use a Resource element with the domain name to limit
// the action to only specified domains.
//
// * Use an Action element to allow or deny
// permission to call this action.
//
// * You cannot use an IAM policy to constrain
// this action's parameters.
//
// If the caller doesn't have sufficient permissions to
// invoke the action, or the parameter values fall outside the specified
// constraints, the action fails. The associated event attribute's cause parameter
// is set to OPERATION_NOT_PERMITTED. For details and example IAM policies, see
// Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type SignalExternalWorkflowExecutionDecisionAttributes struct {

	// The name of the signal.The target workflow execution uses the signal name and
	// input to process the signal.
	//
	// This member is required.
	SignalName *string

	// The workflowId of the workflow execution to be signaled.
	//
	// This member is required.
	WorkflowId *string

	// The data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string

	// The input data to be provided with the signal. The target workflow execution
	// uses the signal name and input data to process the signal.
	Input *string

	// The runId of the workflow execution to be signaled.
	RunId *string

	noSmithyDocumentSerde
}

// Provides the details of the SignalExternalWorkflowExecutionFailed event.
type SignalExternalWorkflowExecutionFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause SignalExternalWorkflowExecutionFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding to
	// the SignalExternalWorkflowExecution decision to request this signal. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	InitiatedEventId int64

	// The workflowId of the external workflow execution that the signal was being
	// delivered to.
	//
	// This member is required.
	WorkflowId *string

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the workflow execution.
	Control *string

	// The runId of the external workflow execution that the signal was being delivered
	// to.
	RunId *string

	noSmithyDocumentSerde
}

// Provides the details of the SignalExternalWorkflowExecutionInitiated event.
type SignalExternalWorkflowExecutionInitiatedEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the SignalExternalWorkflowExecution decision for this signal.
	// This information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The name of the signal.
	//
	// This member is required.
	SignalName *string

	// The workflowId of the external workflow execution.
	//
	// This member is required.
	WorkflowId *string

	// Data attached to the event that can be used by the decider in subsequent
	// decision tasks.
	Control *string

	// The input provided to the signal.
	Input *string

	// The runId of the external workflow execution to send the signal to.
	RunId *string

	noSmithyDocumentSerde
}

// Provides the details of the StartChildWorkflowExecution decision. Access Control
// You can use IAM policies to control this decision's access to Amazon SWF
// resources as follows:
//
// * Use a Resource element with the domain name to limit
// the action to only specified domains.
//
// * Use an Action element to allow or deny
// permission to call this action.
//
// * Constrain the following parameters by using a
// Condition element with the appropriate keys.
//
// * tagList.member.N – The key is
// "swf:tagList.N" where N is the tag number from 0 to 4, inclusive.
//
// * taskList –
// String constraint. The key is swf:taskList.name.
//
// * workflowType.name – String
// constraint. The key is swf:workflowType.name.
//
// * workflowType.version – String
// constraint. The key is swf:workflowType.version.
//
// If the caller doesn't have
// sufficient permissions to invoke the action, or the parameter values fall
// outside the specified constraints, the action fails. The associated event
// attribute's cause parameter is set to OPERATION_NOT_PERMITTED. For details and
// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type StartChildWorkflowExecutionDecisionAttributes struct {

	// The workflowId of the workflow execution. The specified string must not start or
	// end with whitespace. It must not contain a : (colon), / (slash), | (vertical
	// bar), or any control characters (\u0000-\u001f | \u007f-\u009f). Also, it must
	// not contain the literal string arn.
	//
	// This member is required.
	WorkflowId *string

	// The type of the workflow execution to be started.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// If set, specifies the policy to use for the child workflow executions if the
	// workflow execution being started is terminated by calling the
	// TerminateWorkflowExecution action explicitly or due to an expired timeout. This
	// policy overrides the default child policy specified when registering the
	// workflow type using RegisterWorkflowType. The supported child policies are:
	//
	// *
	// TERMINATE – The child executions are terminated.
	//
	// * REQUEST_CANCEL – A request
	// to cancel is attempted for each child execution by recording a
	// WorkflowExecutionCancelRequested event in its history. It is up to the decider
	// to take appropriate actions when it receives an execution history with this
	// event.
	//
	// * ABANDON – No action is taken. The child executions continue to run.
	//
	// A
	// child policy for this workflow execution must be specified either as a default
	// for the workflow type or through this parameter. If neither this parameter is
	// set nor a default child policy was specified at registration time then a fault
	// is returned.
	ChildPolicy ChildPolicy

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks. This data isn't sent to the child workflow execution.
	Control *string

	// The total duration for this workflow execution. This overrides the
	// defaultExecutionStartToCloseTimeout specified when registering the workflow
	// type. The duration is specified in seconds, an integer greater than or equal to
	// 0. You can use NONE to specify unlimited duration. An execution start-to-close
	// timeout for this workflow execution must be specified either as a default for
	// the workflow type or through this parameter. If neither this parameter is set
	// nor a default execution start-to-close timeout was specified at registration
	// time then a fault is returned.
	ExecutionStartToCloseTimeout *string

	// The input to be provided to the workflow execution.
	Input *string

	// The IAM role attached to the child workflow execution.
	LambdaRole *string

	// The list of tags to associate with the child workflow execution. A maximum of 5
	// tags can be specified. You can list workflow executions with a specific tag by
	// calling ListOpenWorkflowExecutions or ListClosedWorkflowExecutions and
	// specifying a TagFilter.
	TagList []string

	// The name of the task list to be used for decision tasks of the child workflow
	// execution. A task list for this workflow execution must be specified either as a
	// default for the workflow type or through this parameter. If neither this
	// parameter is set nor a default task list was specified at registration time then
	// a fault is returned. The specified string must not start or end with whitespace.
	// It must not contain a : (colon), / (slash), | (vertical bar), or any control
	// characters (\u0000-\u001f | \u007f-\u009f). Also, it must not contain the
	// literal string arn.
	TaskList *TaskList

	// A task priority that, if set, specifies the priority for a decision task of this
	// workflow execution. This overrides the defaultTaskPriority specified when
	// registering the workflow type. Valid values are integers that range from Java's
	// Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher
	// numbers indicate higher priority. For more information about setting task
	// priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string

	// Specifies the maximum duration of decision tasks for this workflow execution.
	// This parameter overrides the defaultTaskStartToCloseTimout specified when
	// registering the workflow type using RegisterWorkflowType. The duration is
	// specified in seconds, an integer greater than or equal to 0. You can use NONE to
	// specify unlimited duration. A task start-to-close timeout for this workflow
	// execution must be specified either as a default for the workflow type or through
	// this parameter. If neither this parameter is set nor a default task
	// start-to-close timeout was specified at registration time then a fault is
	// returned.
	TaskStartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Provides the details of the StartChildWorkflowExecutionFailed event.
type StartChildWorkflowExecutionFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. When cause is set to OPERATION_NOT_PERMITTED,
	// the decision fails because it lacks sufficient permissions. For details and
	// example IAM policies, see  Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause StartChildWorkflowExecutionFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecutionDecision to request this child
	// workflow execution. This information can be useful for diagnosing problems by
	// tracing back the chain of events.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// When the cause is WORKFLOW_ALREADY_RUNNING, initiatedEventId is the ID of the
	// StartChildWorkflowExecutionInitiated event that corresponds to the
	// StartChildWorkflowExecutionDecision to start the workflow execution. You can use
	// this information to diagnose problems by tracing back the chain of events
	// leading up to this event. When the cause isn't WORKFLOW_ALREADY_RUNNING,
	// initiatedEventId is set to 0 because the StartChildWorkflowExecutionInitiated
	// event doesn't exist.
	//
	// This member is required.
	InitiatedEventId int64

	// The workflowId of the child workflow execution.
	//
	// This member is required.
	WorkflowId *string

	// The workflow type provided in the StartChildWorkflowExecutionDecision that
	// failed.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// The data attached to the event that the decider can use in subsequent workflow
	// tasks. This data isn't sent to the child workflow execution.
	Control *string

	noSmithyDocumentSerde
}

// Provides the details of the StartChildWorkflowExecutionInitiated event.
type StartChildWorkflowExecutionInitiatedEventAttributes struct {

	// The policy to use for the child workflow executions if this execution gets
	// terminated by explicitly calling the TerminateWorkflowExecution action or due to
	// an expired timeout. The supported child policies are:
	//
	// * TERMINATE – The child
	// executions are terminated.
	//
	// * REQUEST_CANCEL – A request to cancel is attempted
	// for each child execution by recording a WorkflowExecutionCancelRequested event
	// in its history. It is up to the decider to take appropriate actions when it
	// receives an execution history with this event.
	//
	// * ABANDON – No action is taken.
	// The child executions continue to run.
	//
	// This member is required.
	ChildPolicy ChildPolicy

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartChildWorkflowExecutionDecision to request this child
	// workflow execution. This information can be useful for diagnosing problems by
	// tracing back the cause of events.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The name of the task list used for the decision tasks of the child workflow
	// execution.
	//
	// This member is required.
	TaskList *TaskList

	// The workflowId of the child workflow execution.
	//
	// This member is required.
	WorkflowId *string

	// The type of the child workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// Data attached to the event that can be used by the decider in subsequent
	// decision tasks. This data isn't sent to the activity.
	Control *string

	// The maximum duration for the child workflow execution. If the workflow execution
	// isn't closed within this duration, it is timed out and force-terminated. The
	// duration is specified in seconds, an integer greater than or equal to 0. You can
	// use NONE to specify unlimited duration.
	ExecutionStartToCloseTimeout *string

	// The inputs provided to the child workflow execution.
	Input *string

	// The IAM role to attach to the child workflow execution.
	LambdaRole *string

	// The list of tags to associated with the child workflow execution.
	TagList []string

	// The priority assigned for the decision tasks for this workflow execution. Valid
	// values are integers that range from Java's Integer.MIN_VALUE (-2147483648) to
	// Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority. For
	// more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string

	// The maximum duration allowed for the decision tasks for this workflow execution.
	// The duration is specified in seconds, an integer greater than or equal to 0. You
	// can use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Provides the details of the StartLambdaFunctionFailed event. It isn't set for
// other event types.
type StartLambdaFunctionFailedEventAttributes struct {

	// The cause of the failure. To help diagnose issues, use this information to trace
	// back the chain of events leading up to this event. If cause is set to
	// OPERATION_NOT_PERMITTED, the decision failed because the IAM role attached to
	// the execution lacked sufficient permissions. For details and example IAM
	// policies, see Lambda Tasks
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	Cause StartLambdaFunctionFailedCause

	// A description that can help diagnose the cause of the fault.
	Message *string

	// The ID of the ActivityTaskScheduled event that was recorded when this activity
	// task was scheduled. To help diagnose issues, use this information to trace back
	// the chain of events leading up to this event.
	ScheduledEventId int64

	noSmithyDocumentSerde
}

// Provides the details of the StartTimer decision. Access Control You can use IAM
// policies to control this decision's access to Amazon SWF resources as
// follows:
//
// * Use a Resource element with the domain name to limit the action to
// only specified domains.
//
// * Use an Action element to allow or deny permission to
// call this action.
//
// * You cannot use an IAM policy to constrain this action's
// parameters.
//
// If the caller doesn't have sufficient permissions to invoke the
// action, or the parameter values fall outside the specified constraints, the
// action fails. The associated event attribute's cause parameter is set to
// OPERATION_NOT_PERMITTED. For details and example IAM policies, see Using IAM to
// Manage Access to Amazon SWF Workflows
// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
type StartTimerDecisionAttributes struct {

	// The duration to wait before firing the timer. The duration is specified in
	// seconds, an integer greater than or equal to 0.
	//
	// This member is required.
	StartToFireTimeout *string

	// The unique ID of the timer. The specified string must not start or end with
	// whitespace. It must not contain a : (colon), / (slash), | (vertical bar), or any
	// control characters (\u0000-\u001f | \u007f-\u009f). Also, it must not contain
	// the literal string arn.
	//
	// This member is required.
	TimerId *string

	// The data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string

	noSmithyDocumentSerde
}

// Provides the details of the StartTimerFailed event.
type StartTimerFailedEventAttributes struct {

	// The cause of the failure. This information is generated by the system and can be
	// useful for diagnostic purposes. If cause is set to OPERATION_NOT_PERMITTED, the
	// decision failed because it lacked sufficient permissions. For details and
	// example IAM policies, see Using IAM to Manage Access to Amazon SWF Workflows
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
	// in the Amazon SWF Developer Guide.
	//
	// This member is required.
	Cause StartTimerFailedCause

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The timerId provided in the StartTimer decision that failed.
	//
	// This member is required.
	TimerId *string

	noSmithyDocumentSerde
}

// Used to filter the workflow executions in visibility APIs based on a tag.
type TagFilter struct {

	// Specifies the tag that must be associated with the execution for it to meet the
	// filter criteria. Tags may only contain unicode letters, digits, whitespace, or
	// these symbols: _ . : / = + - @.
	//
	// This member is required.
	Tag *string

	noSmithyDocumentSerde
}

// Represents a task list.
type TaskList struct {

	// The name of the task list.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Provides the details of the TimerCanceled event.
type TimerCanceledEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelTimer decision to cancel this timer. This information
	// can be useful for diagnosing problems by tracing back the chain of events
	// leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The unique ID of the timer that was canceled.
	//
	// This member is required.
	TimerId *string

	noSmithyDocumentSerde
}

// Provides the details of the TimerFired event.
type TimerFiredEventAttributes struct {

	// The ID of the TimerStarted event that was recorded when this timer was started.
	// This information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	//
	// This member is required.
	StartedEventId int64

	// The unique ID of the timer that fired.
	//
	// This member is required.
	TimerId *string

	noSmithyDocumentSerde
}

// Provides the details of the TimerStarted event.
type TimerStartedEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the StartTimer decision for this activity task. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The duration of time after which the timer fires. The duration is specified in
	// seconds, an integer greater than or equal to 0.
	//
	// This member is required.
	StartToFireTimeout *string

	// The unique ID of the timer that was started.
	//
	// This member is required.
	TimerId *string

	// Data attached to the event that can be used by the decider in subsequent
	// workflow tasks.
	Control *string

	noSmithyDocumentSerde
}

// Represents a workflow execution.
type WorkflowExecution struct {

	// A system-generated unique identifier for the workflow execution.
	//
	// This member is required.
	RunId *string

	// The user defined identifier associated with the workflow execution.
	//
	// This member is required.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionCanceled event.
type WorkflowExecutionCanceledEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CancelWorkflowExecution decision for this cancellation
	// request. This information can be useful for diagnosing problems by tracing back
	// the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The details of the cancellation.
	Details *string

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionCancelRequested event.
type WorkflowExecutionCancelRequestedEventAttributes struct {

	// If set, indicates that the request to cancel the workflow execution was
	// automatically generated, and specifies the cause. This happens if the parent
	// workflow execution times out or is terminated, and the child policy is set to
	// cancel child executions.
	Cause WorkflowExecutionCancelRequestedCause

	// The ID of the RequestCancelExternalWorkflowExecutionInitiated event
	// corresponding to the RequestCancelExternalWorkflowExecution decision to cancel
	// this workflow execution.The source event with this ID can be found in the
	// history of the source workflow execution. This information can be useful for
	// diagnosing problems by tracing back the chain of events leading up to this
	// event.
	ExternalInitiatedEventId int64

	// The external workflow execution for which the cancellation was requested.
	ExternalWorkflowExecution *WorkflowExecution

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionCompleted event.
type WorkflowExecutionCompletedEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the CompleteWorkflowExecution decision to complete this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The result produced by the workflow execution upon successful completion.
	Result *string

	noSmithyDocumentSerde
}

// The configuration settings for a workflow execution including timeout values,
// tasklist etc. These configuration settings are determined from the defaults
// specified when registering the workflow type and those specified when starting
// the workflow execution.
type WorkflowExecutionConfiguration struct {

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly or
	// due to an expired timeout. The supported child policies are:
	//
	// * TERMINATE – The
	// child executions are terminated.
	//
	// * REQUEST_CANCEL – A request to cancel is
	// attempted for each child execution by recording a
	// WorkflowExecutionCancelRequested event in its history. It is up to the decider
	// to take appropriate actions when it receives an execution history with this
	// event.
	//
	// * ABANDON – No action is taken. The child executions continue to run.
	//
	// This member is required.
	ChildPolicy ChildPolicy

	// The total duration for this workflow execution. The duration is specified in
	// seconds, an integer greater than or equal to 0. You can use NONE to specify
	// unlimited duration.
	//
	// This member is required.
	ExecutionStartToCloseTimeout *string

	// The task list used for the decision tasks generated for this workflow execution.
	//
	// This member is required.
	TaskList *TaskList

	// The maximum duration allowed for decision tasks for this workflow execution. The
	// duration is specified in seconds, an integer greater than or equal to 0. You can
	// use NONE to specify unlimited duration.
	//
	// This member is required.
	TaskStartToCloseTimeout *string

	// The IAM role attached to the child workflow execution.
	LambdaRole *string

	// The priority assigned to decision tasks for this workflow execution. Valid
	// values are integers that range from Java's Integer.MIN_VALUE (-2147483648) to
	// Integer.MAX_VALUE (2147483647). Higher numbers indicate higher priority. For
	// more information about setting task priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	TaskPriority *string

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionContinuedAsNew event.
type WorkflowExecutionContinuedAsNewEventAttributes struct {

	// The policy to use for the child workflow executions of the new execution if it
	// is terminated by calling the TerminateWorkflowExecution action explicitly or due
	// to an expired timeout. The supported child policies are:
	//
	// * TERMINATE – The
	// child executions are terminated.
	//
	// * REQUEST_CANCEL – A request to cancel is
	// attempted for each child execution by recording a
	// WorkflowExecutionCancelRequested event in its history. It is up to the decider
	// to take appropriate actions when it receives an execution history with this
	// event.
	//
	// * ABANDON – No action is taken. The child executions continue to run.
	//
	// This member is required.
	ChildPolicy ChildPolicy

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the ContinueAsNewWorkflowExecution decision that started this
	// execution. This information can be useful for diagnosing problems by tracing
	// back the chain of events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The runId of the new workflow execution.
	//
	// This member is required.
	NewExecutionRunId *string

	// The task list to use for the decisions of the new (continued) workflow
	// execution.
	//
	// This member is required.
	TaskList *TaskList

	// The workflow type of this execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// The total duration allowed for the new workflow execution. The duration is
	// specified in seconds, an integer greater than or equal to 0. You can use NONE to
	// specify unlimited duration.
	ExecutionStartToCloseTimeout *string

	// The input provided to the new workflow execution.
	Input *string

	// The IAM role to attach to the new (continued) workflow execution.
	LambdaRole *string

	// The list of tags associated with the new workflow execution.
	TagList []string

	// The priority of the task to use for the decisions of the new (continued)
	// workflow execution.
	TaskPriority *string

	// The maximum duration of decision tasks for the new workflow execution. The
	// duration is specified in seconds, an integer greater than or equal to 0. You can
	// use NONE to specify unlimited duration.
	TaskStartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionFailed event.
type WorkflowExecutionFailedEventAttributes struct {

	// The ID of the DecisionTaskCompleted event corresponding to the decision task
	// that resulted in the FailWorkflowExecution decision to fail this execution. This
	// information can be useful for diagnosing problems by tracing back the chain of
	// events leading up to this event.
	//
	// This member is required.
	DecisionTaskCompletedEventId int64

	// The details of the failure.
	Details *string

	// The descriptive reason provided for the failure.
	Reason *string

	noSmithyDocumentSerde
}

// Used to filter the workflow executions in visibility APIs by their workflowId.
type WorkflowExecutionFilter struct {

	// The workflowId to pass of match the criteria of this filter.
	//
	// This member is required.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Contains information about a workflow execution.
type WorkflowExecutionInfo struct {

	// The workflow execution this information is about.
	//
	// This member is required.
	Execution *WorkflowExecution

	// The current status of the execution.
	//
	// This member is required.
	ExecutionStatus ExecutionStatus

	// The time when the execution was started.
	//
	// This member is required.
	StartTimestamp *time.Time

	// The type of the workflow execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// Set to true if a cancellation is requested for this workflow execution.
	CancelRequested bool

	// If the execution status is closed then this specifies how the execution was
	// closed:
	//
	// * COMPLETED – the execution was successfully completed.
	//
	// * CANCELED –
	// the execution was canceled.Cancellation allows the implementation to gracefully
	// clean up before the execution is closed.
	//
	// * TERMINATED – the execution was force
	// terminated.
	//
	// * FAILED – the execution failed to complete.
	//
	// * TIMED_OUT – the
	// execution did not complete in the alloted time and was automatically timed
	// out.
	//
	// * CONTINUED_AS_NEW – the execution is logically continued. This means the
	// current execution was completed and a new execution was started to carry on the
	// workflow.
	CloseStatus CloseStatus

	// The time when the workflow execution was closed. Set only if the execution
	// status is CLOSED.
	CloseTimestamp *time.Time

	// If this workflow execution is a child of another execution then contains the
	// workflow execution that started this execution.
	Parent *WorkflowExecution

	// The list of tags associated with the workflow execution. Tags can be used to
	// identify and list workflow executions of interest through the visibility APIs. A
	// workflow execution can have a maximum of 5 tags.
	TagList []string

	noSmithyDocumentSerde
}

// Contains the counts of open tasks, child workflow executions and timers for a
// workflow execution.
type WorkflowExecutionOpenCounts struct {

	// The count of activity tasks whose status is OPEN.
	//
	// This member is required.
	OpenActivityTasks int32

	// The count of child workflow executions whose status is OPEN.
	//
	// This member is required.
	OpenChildWorkflowExecutions int32

	// The count of decision tasks whose status is OPEN. A workflow execution can have
	// at most one open decision task.
	//
	// This member is required.
	OpenDecisionTasks int32

	// The count of timers started by this workflow execution that have not fired yet.
	//
	// This member is required.
	OpenTimers int32

	// The count of Lambda tasks whose status is OPEN.
	OpenLambdaFunctions int32

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionSignaled event.
type WorkflowExecutionSignaledEventAttributes struct {

	// The name of the signal received. The decider can use the signal name and inputs
	// to determine how to the process the signal.
	//
	// This member is required.
	SignalName *string

	// The ID of the SignalExternalWorkflowExecutionInitiated event corresponding to
	// the SignalExternalWorkflow decision to signal this workflow execution.The source
	// event with this ID can be found in the history of the source workflow execution.
	// This information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event. This field is set only if the signal was
	// initiated by another workflow execution.
	ExternalInitiatedEventId int64

	// The workflow execution that sent the signal. This is set only of the signal was
	// sent by another workflow execution.
	ExternalWorkflowExecution *WorkflowExecution

	// The inputs provided with the signal. The decider can use the signal name and
	// inputs to determine how to process the signal.
	Input *string

	noSmithyDocumentSerde
}

// Provides details of WorkflowExecutionStarted event.
type WorkflowExecutionStartedEventAttributes struct {

	// The policy to use for the child workflow executions if this workflow execution
	// is terminated, by calling the TerminateWorkflowExecution action explicitly or
	// due to an expired timeout. The supported child policies are:
	//
	// * TERMINATE – The
	// child executions are terminated.
	//
	// * REQUEST_CANCEL – A request to cancel is
	// attempted for each child execution by recording a
	// WorkflowExecutionCancelRequested event in its history. It is up to the decider
	// to take appropriate actions when it receives an execution history with this
	// event.
	//
	// * ABANDON – No action is taken. The child executions continue to run.
	//
	// This member is required.
	ChildPolicy ChildPolicy

	// The name of the task list for scheduling the decision tasks for this workflow
	// execution.
	//
	// This member is required.
	TaskList *TaskList

	// The workflow type of this execution.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// If this workflow execution was started due to a ContinueAsNewWorkflowExecution
	// decision, then it contains the runId of the previous workflow execution that was
	// closed and continued as this execution.
	ContinuedExecutionRunId *string

	// The maximum duration for this workflow execution. The duration is specified in
	// seconds, an integer greater than or equal to 0. You can use NONE to specify
	// unlimited duration.
	ExecutionStartToCloseTimeout *string

	// The input provided to the workflow execution.
	Input *string

	// The IAM role attached to the workflow execution.
	LambdaRole *string

	// The ID of the StartChildWorkflowExecutionInitiated event corresponding to the
	// StartChildWorkflowExecutionDecision to start this workflow execution. The source
	// event with this ID can be found in the history of the source workflow execution.
	// This information can be useful for diagnosing problems by tracing back the chain
	// of events leading up to this event.
	ParentInitiatedEventId int64

	// The source workflow execution that started this workflow execution. The member
	// isn't set if the workflow execution was not started by a workflow.
	ParentWorkflowExecution *WorkflowExecution

	// The list of tags associated with this workflow execution. An execution can have
	// up to 5 tags.
	TagList []string

	// The priority of the decision tasks in the workflow execution.
	TaskPriority *string

	// The maximum duration of decision tasks for this workflow type. The duration is
	// specified in seconds, an integer greater than or equal to 0. You can use NONE to
	// specify unlimited duration.
	TaskStartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionTerminated event.
type WorkflowExecutionTerminatedEventAttributes struct {

	// The policy used for the child workflow executions of this workflow execution.
	// The supported child policies are:
	//
	// * TERMINATE – The child executions are
	// terminated.
	//
	// * REQUEST_CANCEL – A request to cancel is attempted for each child
	// execution by recording a WorkflowExecutionCancelRequested event in its history.
	// It is up to the decider to take appropriate actions when it receives an
	// execution history with this event.
	//
	// * ABANDON – No action is taken. The child
	// executions continue to run.
	//
	// This member is required.
	ChildPolicy ChildPolicy

	// If set, indicates that the workflow execution was automatically terminated, and
	// specifies the cause. This happens if the parent workflow execution times out or
	// is terminated and the child policy is set to terminate child executions.
	Cause WorkflowExecutionTerminatedCause

	// The details provided for the termination.
	Details *string

	// The reason provided for the termination.
	Reason *string

	noSmithyDocumentSerde
}

// Provides the details of the WorkflowExecutionTimedOut event.
type WorkflowExecutionTimedOutEventAttributes struct {

	// The policy used for the child workflow executions of this workflow execution.
	// The supported child policies are:
	//
	// * TERMINATE – The child executions are
	// terminated.
	//
	// * REQUEST_CANCEL – A request to cancel is attempted for each child
	// execution by recording a WorkflowExecutionCancelRequested event in its history.
	// It is up to the decider to take appropriate actions when it receives an
	// execution history with this event.
	//
	// * ABANDON – No action is taken. The child
	// executions continue to run.
	//
	// This member is required.
	ChildPolicy ChildPolicy

	// The type of timeout that caused this event.
	//
	// This member is required.
	TimeoutType WorkflowExecutionTimeoutType

	noSmithyDocumentSerde
}

// Represents a workflow type.
type WorkflowType struct {

	// The name of the workflow type. The combination of workflow type name and version
	// must be unique with in a domain.
	//
	// This member is required.
	Name *string

	// The version of the workflow type. The combination of workflow type name and
	// version must be unique with in a domain.
	//
	// This member is required.
	Version *string

	noSmithyDocumentSerde
}

// The configuration settings of a workflow type.
type WorkflowTypeConfiguration struct {

	// The default policy to use for the child workflow executions when a workflow
	// execution of this type is terminated, by calling the TerminateWorkflowExecution
	// action explicitly or due to an expired timeout. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action or
	// the StartChildWorkflowExecutionDecision. The supported child policies are:
	//
	// *
	// TERMINATE – The child executions are terminated.
	//
	// * REQUEST_CANCEL – A request
	// to cancel is attempted for each child execution by recording a
	// WorkflowExecutionCancelRequested event in its history. It is up to the decider
	// to take appropriate actions when it receives an execution history with this
	// event.
	//
	// * ABANDON – No action is taken. The child executions continue to run.
	DefaultChildPolicy ChildPolicy

	// The default maximum duration, specified when registering the workflow type, for
	// executions of this workflow type. This default can be overridden when starting a
	// workflow execution using the StartWorkflowExecution action or the
	// StartChildWorkflowExecutionDecision. The duration is specified in seconds, an
	// integer greater than or equal to 0. You can use NONE to specify unlimited
	// duration.
	DefaultExecutionStartToCloseTimeout *string

	// The default IAM role attached to this workflow type. Executions of this workflow
	// type need IAM roles to invoke Lambda functions. If you don't specify an IAM role
	// when starting this workflow type, the default Lambda role is attached to the
	// execution. For more information, see
	// https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/lambda-task.html)
	// in the Amazon SWF Developer Guide.
	DefaultLambdaRole *string

	// The default task list, specified when registering the workflow type, for
	// decisions tasks scheduled for workflow executions of this type. This default can
	// be overridden when starting a workflow execution using the
	// StartWorkflowExecution action or the StartChildWorkflowExecutionDecision.
	DefaultTaskList *TaskList

	// The default task priority, specified when registering the workflow type, for all
	// decision tasks of this workflow type. This default can be overridden when
	// starting a workflow execution using the StartWorkflowExecution action or the
	// StartChildWorkflowExecution decision. Valid values are integers that range from
	// Java's Integer.MIN_VALUE (-2147483648) to Integer.MAX_VALUE (2147483647). Higher
	// numbers indicate higher priority. For more information about setting task
	// priority, see Setting Task Priority
	// (https://docs.aws.amazon.com/amazonswf/latest/developerguide/programming-priority.html)
	// in the Amazon SWF Developer Guide.
	DefaultTaskPriority *string

	// The default maximum duration, specified when registering the workflow type, that
	// a decision task for executions of this workflow type might take before returning
	// completion or failure. If the task doesn'tdo close in the specified time then
	// the task is automatically timed out and rescheduled. If the decider eventually
	// reports a completion or failure, it is ignored. This default can be overridden
	// when starting a workflow execution using the StartWorkflowExecution action or
	// the StartChildWorkflowExecutionDecision. The duration is specified in seconds,
	// an integer greater than or equal to 0. You can use NONE to specify unlimited
	// duration.
	DefaultTaskStartToCloseTimeout *string

	noSmithyDocumentSerde
}

// Used to filter workflow execution query results by type. Each parameter, if
// specified, defines a rule that must be satisfied by each returned result.
type WorkflowTypeFilter struct {

	// Name of the workflow type.
	//
	// This member is required.
	Name *string

	// Version of the workflow type.
	Version *string

	noSmithyDocumentSerde
}

// Contains information about a workflow type.
type WorkflowTypeInfo struct {

	// The date when this type was registered.
	//
	// This member is required.
	CreationDate *time.Time

	// The current status of the workflow type.
	//
	// This member is required.
	Status RegistrationStatus

	// The workflow type this information is about.
	//
	// This member is required.
	WorkflowType *WorkflowType

	// If the type is in deprecated state, then it is set to the date when the type was
	// deprecated.
	DeprecationDate *time.Time

	// The description of the type registered through RegisterWorkflowType.
	Description *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
