/*
 *
 *  Copyright (C) 2000 Silicon Graphics, Inc.  All Rights Reserved. 
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  Further, this software is distributed without any warranty that it is
 *  free of the rightful claim of any third person regarding infringement
 *  or the like.  Any license provided herein, whether implied or
 *  otherwise, applies only to this software file.  Patent licenses, if
 *  any, provided herein do not apply to combinations of this program with
 *  other software, or any other product whatsoever.
 * 
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  Contact information: Silicon Graphics, Inc., 1600 Amphitheatre Pkwy,
 *  Mountain View, CA  94043, or:
 * 
 *  http://www.sgi.com 
 * 
 *  For further information regarding this notice, see: 
 * 
 *  http://oss.sgi.com/projects/GenInfo/NoticeExplan/
 *
 */

/*
 * Copyright (C) 1990,91,92   Silicon Graphics, Inc.
 *
 _______________________________________________________________________
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 |
 |   $Revision: 1.1.1.1 $
 |
 |   Classes:
 |	SoXtMouse
 |
 |   Author(s): David Mott
 |
 ______________  S I L I C O N   G R A P H I C S   I N C .  ____________
 _______________________________________________________________________
 */

#include <X11/X.h>
#include <Inventor/SbTime.h>
#include <Inventor/Xt/devices/SoXtMouse.h>

////////////////////////////////////////////////////////////////////////
//
// Description:
//   Constructor.
//
// public
//
SoXtMouse::SoXtMouse(EventMask whichEvents)
//
////////////////////////////////////////////////////////////////////////
{
//??? for DEBUG, need to make sure the passed event mask is valid 
//??? for this device
    eventMask = whichEvents;
    
    // allocate the SoEvents we support here
    loc2Event = new SoLocation2Event;
    buttonEvent = new SoMouseButtonEvent;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//   Destructor.
//
// public
//
SoXtMouse::~SoXtMouse()
//
////////////////////////////////////////////////////////////////////////
{
    delete loc2Event;
    delete buttonEvent;
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//   This selects input for all mouse device events which occur in w.
// The callback routine is proc, and the callback data is clientData.
//
// virtual public
//
void
SoXtMouse::enable(
    Widget w,
    XtEventHandler proc, 
    XtPointer clientData,
    Window)
//
////////////////////////////////////////////////////////////////////////
{
    XtAddEventHandler(w, eventMask, FALSE, proc, clientData);
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//   This unselects input for all mouse device events which occur in w,
// i.e. mouse events will no longer be recognized.
//
// virtual public
//
void
SoXtMouse::disable(
    Widget w,
    XtEventHandler proc, 
    XtPointer clientData)
//
////////////////////////////////////////////////////////////////////////
{
    XtRemoveEventHandler(w, eventMask, FALSE, proc, clientData);
}

////////////////////////////////////////////////////////////////////////
//
// Description:
//   This returns an SoEvent for the passed X event, if the event
// was generated by the mouse device.
//
// static public
//
const SoEvent *
SoXtMouse::translateEvent(XAnyEvent *xe)
//
////////////////////////////////////////////////////////////////////////
{
    SoEvent *event = NULL;
    
    // switch on event type
    switch (xe->type) {
	case ButtonPress:
	    event = translateButtonEvent((XButtonEvent *) xe, SoButtonEvent::DOWN);
	    break;
	    
	case ButtonRelease:
	    event = translateButtonEvent((XButtonEvent *) xe, SoButtonEvent::UP);
	    break;
	    
	case MotionNotify:
	    event = translateMotionEvent((XMotionEvent *) xe);
	    break;
	    
	default:
	    break;
    }
    
    return event;
}

SoMouseButtonEvent *
SoXtMouse::translateButtonEvent(XButtonEvent *be,
				SoButtonEvent::State whichState)
{
    SoMouseButtonEvent::Button whichButton;
    
    if (be->button == Button1)
	whichButton = SoMouseButtonEvent::BUTTON1;
    else if (be->button == Button2)
	whichButton = SoMouseButtonEvent::BUTTON2;
    else if (be->button == Button3)
	whichButton = SoMouseButtonEvent::BUTTON3;
    else 
	whichButton = SoMouseButtonEvent::ANY;
    
    setEventPosition(buttonEvent, be->x, be->y);
    int32_t secs = be->time / 1000;
    buttonEvent->setTime(SbTime(secs, 1000 * (be->time - 1000 * secs)));
    buttonEvent->setShiftDown(be->state & ShiftMask);
    buttonEvent->setCtrlDown(be->state & ControlMask);
    buttonEvent->setAltDown(be->state & Mod1Mask);
    
    buttonEvent->setState(whichState);
    buttonEvent->setButton(whichButton);
    
    return buttonEvent;
}

SoLocation2Event *
SoXtMouse::translateMotionEvent(XMotionEvent *me)
{
    setEventPosition(loc2Event, me->x, me->y);
    int32_t secs = me->time / 1000;
    loc2Event->setTime(SbTime(secs, 1000 * (me->time - 1000 * secs)));
    loc2Event->setShiftDown(me->state & ShiftMask);
    loc2Event->setCtrlDown(me->state & ControlMask);
    loc2Event->setAltDown(me->state & Mod1Mask);

    return loc2Event;
}



