#region License
//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2009 the Open Toolkit library.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
#endregion

using System;

namespace OpenTK.Graphics
{
    #pragma warning disable 1591

    public enum AccumOp
    {
        Accum = ((int)0X0100),
        Load = ((int)0X0101),
        Return = ((int)0X0102),
        Mult = ((int)0X0103),
        Add = ((int)0X0104),
    }

    public enum ActiveAttribType
    {
        Float = ((int)0X1406),
        FloatVec2 = ((int)0X8b50),
        FloatVec3 = ((int)0X8b51),
        FloatVec4 = ((int)0X8b52),
        FloatMat2 = ((int)0X8b5a),
        FloatMat3 = ((int)0X8b5b),
        FloatMat4 = ((int)0X8b5c),
    }

    public enum ActiveUniformType
    {
        Int = ((int)0X1404),
        Float = ((int)0X1406),
        FloatVec2 = ((int)0X8b50),
        FloatVec3 = ((int)0X8b51),
        FloatVec4 = ((int)0X8b52),
        IntVec2 = ((int)0X8b53),
        IntVec3 = ((int)0X8b54),
        IntVec4 = ((int)0X8b55),
        Bool = ((int)0X8b56),
        BoolVec2 = ((int)0X8b57),
        BoolVec3 = ((int)0X8b58),
        BoolVec4 = ((int)0X8b59),
        FloatMat2 = ((int)0X8b5a),
        FloatMat3 = ((int)0X8b5b),
        FloatMat4 = ((int)0X8b5c),
        Sampler1D = ((int)0X8b5d),
        Sampler2D = ((int)0X8b5e),
        Sampler3D = ((int)0X8b5f),
        SamplerCube = ((int)0X8b60),
        Sampler1DShadow = ((int)0X8b61),
        Sampler2DShadow = ((int)0X8b62),
        FloatMat2x3 = ((int)0X8b65),
        FloatMat2x4 = ((int)0X8b66),
        FloatMat3x2 = ((int)0X8b67),
        FloatMat3x4 = ((int)0X8b68),
        FloatMat4x2 = ((int)0X8b69),
        FloatMat4x3 = ((int)0X8b6a),
        Sampler1DArray = ((int)0X8dc0),
        Sampler2DArray = ((int)0X8dc1),
        Sampler1DArrayShadow = ((int)0X8dc3),
        Sampler2DArrayShadow = ((int)0X8dc4),
        SamplerCubeShadow = ((int)0X8dc5),
        UnsignedIntVec2 = ((int)0X8dc6),
        UnsignedIntVec3 = ((int)0X8dc7),
        UnsignedIntVec4 = ((int)0X8dc8),
        IntSampler1D = ((int)0X8dc9),
        IntSampler2D = ((int)0X8dca),
        IntSampler3D = ((int)0X8dcb),
        IntSamplerCube = ((int)0X8dcc),
        IntSampler1DArray = ((int)0X8dce),
        IntSampler2DArray = ((int)0X8dcf),
        UnsignedIntSampler1D = ((int)0X8dd1),
        UnsignedIntSampler2D = ((int)0X8dd2),
        UnsignedIntSampler3D = ((int)0X8dd3),
        UnsignedIntSamplerCube = ((int)0X8dd4),
        UnsignedIntSampler1DArray = ((int)0X8dd6),
        UnsignedIntSampler2DArray = ((int)0X8dd7),
    }

    public enum All
    {
        False = ((int)0),
        NoError = ((int)0),
        None = ((int)0),
        Zero = ((int)0),
        Points = ((int)0X0000),
        ClientPixelStoreBit = ((int)0X00000001),
        ContextCoreProfileBit = ((int)0X00000001),
        CurrentBit = ((int)0X00000001),
        Gl2XBitAti = ((int)0X00000001),
        RedBitAti = ((int)0X00000001),
        SyncFlushCommandsBit = ((int)0X00000001),
        TextureDeformationBitSgix = ((int)0X00000001),
        ClientVertexArrayBit = ((int)0X00000002),
        CompBitAti = ((int)0X00000002),
        ContextCompatibilityProfileBit = ((int)0X00000002),
        GeometryDeformationBitSgix = ((int)0X00000002),
        Gl4XBitAti = ((int)0X00000002),
        GreenBitAti = ((int)0X00000002),
        PointBit = ((int)0X00000002),
        BlueBitAti = ((int)0X00000004),
        Gl8XBitAti = ((int)0X00000004),
        LineBit = ((int)0X00000004),
        NegateBitAti = ((int)0X00000004),
        Vertex23BitPgi = ((int)0X00000004),
        BiasBitAti = ((int)0X00000008),
        HalfBitAti = ((int)0X00000008),
        PolygonBit = ((int)0X00000008),
        Vertex4BitPgi = ((int)0X00000008),
        PolygonStippleBit = ((int)0X00000010),
        QuarterBitAti = ((int)0X00000010),
        EighthBitAti = ((int)0X00000020),
        PixelModeBit = ((int)0X00000020),
        LightingBit = ((int)0X00000040),
        SaturateBitAti = ((int)0X00000040),
        FogBit = ((int)0X00000080),
        DepthBufferBit = ((int)0X00000100),
        AccumBufferBit = ((int)0X00000200),
        StencilBufferBit = ((int)0X00000400),
        ViewportBit = ((int)0X00000800),
        TransformBit = ((int)0X00001000),
        EnableBit = ((int)0X00002000),
        ColorBufferBit = ((int)0X00004000),
        HintBit = ((int)0X00008000),
        ContextFlagForwardCompatibleBit = ((int)0X0001),
        Lines = ((int)0X0001),
        MapReadBit = ((int)0X0001),
        RestartSun = ((int)0X0001),
        Color3BitPgi = ((int)0X00010000),
        EvalBit = ((int)0X00010000),
        LineLoop = ((int)0X0002),
        MapWriteBit = ((int)0X0002),
        ReplaceMiddleSun = ((int)0X0002),
        Color4BitPgi = ((int)0X00020000),
        ListBit = ((int)0X00020000),
        LineStrip = ((int)0X0003),
        ReplaceOldestSun = ((int)0X0003),
        MapInvalidateRangeBit = ((int)0X0004),
        Triangles = ((int)0X0004),
        EdgeflagBitPgi = ((int)0X00040000),
        TextureBit = ((int)0X00040000),
        TriangleStrip = ((int)0X0005),
        TriangleFan = ((int)0X0006),
        Quads = ((int)0X0007),
        MapInvalidateBufferBit = ((int)0X0008),
        QuadStrip = ((int)0X0008),
        IndexBitPgi = ((int)0X00080000),
        ScissorBit = ((int)0X00080000),
        Polygon = ((int)0X0009),
        LinesAdjacency = ((int)0X000a),
        LinesAdjacencyArb = ((int)0X000a),
        LinesAdjacencyExt = ((int)0X000a),
        LineStripAdjacency = ((int)0X000b),
        LineStripAdjacencyArb = ((int)0X000b),
        LineStripAdjacencyExt = ((int)0X000b),
        TrianglesAdjacency = ((int)0X000c),
        TrianglesAdjacencyArb = ((int)0X000c),
        TrianglesAdjacencyExt = ((int)0X000c),
        TriangleStripAdjacency = ((int)0X000d),
        TriangleStripAdjacencyArb = ((int)0X000d),
        TriangleStripAdjacencyExt = ((int)0X000d),
        MapFlushExplicitBit = ((int)0X0010),
        MatAmbientBitPgi = ((int)0X00100000),
        MapUnsynchronizedBit = ((int)0X0020),
        MatAmbientAndDiffuseBitPgi = ((int)0X00200000),
        MatDiffuseBitPgi = ((int)0X00400000),
        MatEmissionBitPgi = ((int)0X00800000),
        Accum = ((int)0X0100),
        MatColorIndexesBitPgi = ((int)0X01000000),
        Load = ((int)0X0101),
        Return = ((int)0X0102),
        Mult = ((int)0X0103),
        Add = ((int)0X0104),
        Never = ((int)0X0200),
        MatShininessBitPgi = ((int)0X02000000),
        Less = ((int)0X0201),
        Equal = ((int)0X0202),
        Lequal = ((int)0X0203),
        Greater = ((int)0X0204),
        Notequal = ((int)0X0205),
        Gequal = ((int)0X0206),
        Always = ((int)0X0207),
        SrcColor = ((int)0X0300),
        OneMinusSrcColor = ((int)0X0301),
        SrcAlpha = ((int)0X0302),
        OneMinusSrcAlpha = ((int)0X0303),
        DstAlpha = ((int)0X0304),
        OneMinusDstAlpha = ((int)0X0305),
        DstColor = ((int)0X0306),
        OneMinusDstColor = ((int)0X0307),
        SrcAlphaSaturate = ((int)0X0308),
        FrontLeft = ((int)0X0400),
        MatSpecularBitPgi = ((int)0X04000000),
        FrontRight = ((int)0X0401),
        BackLeft = ((int)0X0402),
        BackRight = ((int)0X0403),
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        Left = ((int)0X0406),
        Right = ((int)0X0407),
        FrontAndBack = ((int)0X0408),
        Aux0 = ((int)0X0409),
        Aux1 = ((int)0X040a),
        Aux2 = ((int)0X040b),
        Aux3 = ((int)0X040c),
        InvalidEnum = ((int)0X0500),
        InvalidValue = ((int)0X0501),
        InvalidOperation = ((int)0X0502),
        StackOverflow = ((int)0X0503),
        StackUnderflow = ((int)0X0504),
        OutOfMemory = ((int)0X0505),
        InvalidFramebufferOperation = ((int)0X0506),
        InvalidFramebufferOperationExt = ((int)0X0506),
        Gl2D = ((int)0X0600),
        Gl3D = ((int)0X0601),
        Gl3DColor = ((int)0X0602),
        Gl3DColorTexture = ((int)0X0603),
        Gl4DColorTexture = ((int)0X0604),
        PassThroughToken = ((int)0X0700),
        PointToken = ((int)0X0701),
        LineToken = ((int)0X0702),
        PolygonToken = ((int)0X0703),
        BitmapToken = ((int)0X0704),
        DrawPixelToken = ((int)0X0705),
        CopyPixelToken = ((int)0X0706),
        LineResetToken = ((int)0X0707),
        Exp = ((int)0X0800),
        NormalBitPgi = ((int)0X08000000),
        Exp2 = ((int)0X0801),
        Cw = ((int)0X0900),
        Ccw = ((int)0X0901),
        Coeff = ((int)0X0a00),
        Order = ((int)0X0a01),
        Domain = ((int)0X0a02),
        CurrentColor = ((int)0X0b00),
        CurrentIndex = ((int)0X0b01),
        CurrentNormal = ((int)0X0b02),
        CurrentTextureCoords = ((int)0X0b03),
        CurrentRasterColor = ((int)0X0b04),
        CurrentRasterIndex = ((int)0X0b05),
        CurrentRasterTextureCoords = ((int)0X0b06),
        CurrentRasterPosition = ((int)0X0b07),
        CurrentRasterPositionValid = ((int)0X0b08),
        CurrentRasterDistance = ((int)0X0b09),
        PointSmooth = ((int)0X0b10),
        PointSize = ((int)0X0b11),
        PointSizeRange = ((int)0X0b12),
        SmoothPointSizeRange = ((int)0X0b12),
        PointSizeGranularity = ((int)0X0b13),
        SmoothPointSizeGranularity = ((int)0X0b13),
        LineSmooth = ((int)0X0b20),
        LineWidth = ((int)0X0b21),
        LineWidthRange = ((int)0X0b22),
        SmoothLineWidthRange = ((int)0X0b22),
        LineWidthGranularity = ((int)0X0b23),
        SmoothLineWidthGranularity = ((int)0X0b23),
        LineStipple = ((int)0X0b24),
        LineStipplePattern = ((int)0X0b25),
        LineStippleRepeat = ((int)0X0b26),
        ListMode = ((int)0X0b30),
        MaxListNesting = ((int)0X0b31),
        ListBase = ((int)0X0b32),
        ListIndex = ((int)0X0b33),
        PolygonMode = ((int)0X0b40),
        PolygonSmooth = ((int)0X0b41),
        PolygonStipple = ((int)0X0b42),
        EdgeFlag = ((int)0X0b43),
        CullFace = ((int)0X0b44),
        CullFaceMode = ((int)0X0b45),
        FrontFace = ((int)0X0b46),
        Lighting = ((int)0X0b50),
        LightModelLocalViewer = ((int)0X0b51),
        LightModelTwoSide = ((int)0X0b52),
        LightModelAmbient = ((int)0X0b53),
        ShadeModel = ((int)0X0b54),
        ColorMaterialFace = ((int)0X0b55),
        ColorMaterialParameter = ((int)0X0b56),
        ColorMaterial = ((int)0X0b57),
        Fog = ((int)0X0b60),
        FogIndex = ((int)0X0b61),
        FogDensity = ((int)0X0b62),
        FogStart = ((int)0X0b63),
        FogEnd = ((int)0X0b64),
        FogMode = ((int)0X0b65),
        FogColor = ((int)0X0b66),
        DepthRange = ((int)0X0b70),
        DepthTest = ((int)0X0b71),
        DepthWritemask = ((int)0X0b72),
        DepthClearValue = ((int)0X0b73),
        DepthFunc = ((int)0X0b74),
        AccumClearValue = ((int)0X0b80),
        StencilTest = ((int)0X0b90),
        StencilClearValue = ((int)0X0b91),
        StencilFunc = ((int)0X0b92),
        StencilValueMask = ((int)0X0b93),
        StencilFail = ((int)0X0b94),
        StencilPassDepthFail = ((int)0X0b95),
        StencilPassDepthPass = ((int)0X0b96),
        StencilRef = ((int)0X0b97),
        StencilWritemask = ((int)0X0b98),
        MatrixMode = ((int)0X0ba0),
        Normalize = ((int)0X0ba1),
        Viewport = ((int)0X0ba2),
        Modelview0StackDepthExt = ((int)0X0ba3),
        ModelviewStackDepth = ((int)0X0ba3),
        ProjectionStackDepth = ((int)0X0ba4),
        TextureStackDepth = ((int)0X0ba5),
        Modelview0MatrixExt = ((int)0X0ba6),
        ModelviewMatrix = ((int)0X0ba6),
        ProjectionMatrix = ((int)0X0ba7),
        TextureMatrix = ((int)0X0ba8),
        AttribStackDepth = ((int)0X0bb0),
        ClientAttribStackDepth = ((int)0X0bb1),
        AlphaTest = ((int)0X0bc0),
        AlphaTestFunc = ((int)0X0bc1),
        AlphaTestRef = ((int)0X0bc2),
        Dither = ((int)0X0bd0),
        BlendDst = ((int)0X0be0),
        BlendSrc = ((int)0X0be1),
        Blend = ((int)0X0be2),
        LogicOpMode = ((int)0X0bf0),
        IndexLogicOp = ((int)0X0bf1),
        LogicOp = ((int)0X0bf1),
        ColorLogicOp = ((int)0X0bf2),
        AuxBuffers = ((int)0X0c00),
        DrawBuffer = ((int)0X0c01),
        ReadBuffer = ((int)0X0c02),
        ScissorBox = ((int)0X0c10),
        ScissorTest = ((int)0X0c11),
        IndexClearValue = ((int)0X0c20),
        IndexWritemask = ((int)0X0c21),
        ColorClearValue = ((int)0X0c22),
        ColorWritemask = ((int)0X0c23),
        IndexMode = ((int)0X0c30),
        RgbaMode = ((int)0X0c31),
        Doublebuffer = ((int)0X0c32),
        Stereo = ((int)0X0c33),
        RenderMode = ((int)0X0c40),
        PerspectiveCorrectionHint = ((int)0X0c50),
        PointSmoothHint = ((int)0X0c51),
        LineSmoothHint = ((int)0X0c52),
        PolygonSmoothHint = ((int)0X0c53),
        FogHint = ((int)0X0c54),
        TextureGenS = ((int)0X0c60),
        TextureGenT = ((int)0X0c61),
        TextureGenR = ((int)0X0c62),
        TextureGenQ = ((int)0X0c63),
        PixelMapIToI = ((int)0X0c70),
        PixelMapSToS = ((int)0X0c71),
        PixelMapIToR = ((int)0X0c72),
        PixelMapIToG = ((int)0X0c73),
        PixelMapIToB = ((int)0X0c74),
        PixelMapIToA = ((int)0X0c75),
        PixelMapRToR = ((int)0X0c76),
        PixelMapGToG = ((int)0X0c77),
        PixelMapBToB = ((int)0X0c78),
        PixelMapAToA = ((int)0X0c79),
        PixelMapIToISize = ((int)0X0cb0),
        PixelMapSToSSize = ((int)0X0cb1),
        PixelMapIToRSize = ((int)0X0cb2),
        PixelMapIToGSize = ((int)0X0cb3),
        PixelMapIToBSize = ((int)0X0cb4),
        PixelMapIToASize = ((int)0X0cb5),
        PixelMapRToRSize = ((int)0X0cb6),
        PixelMapGToGSize = ((int)0X0cb7),
        PixelMapBToBSize = ((int)0X0cb8),
        PixelMapAToASize = ((int)0X0cb9),
        UnpackSwapBytes = ((int)0X0cf0),
        UnpackLsbFirst = ((int)0X0cf1),
        UnpackRowLength = ((int)0X0cf2),
        UnpackSkipRows = ((int)0X0cf3),
        UnpackSkipPixels = ((int)0X0cf4),
        UnpackAlignment = ((int)0X0cf5),
        PackSwapBytes = ((int)0X0d00),
        PackLsbFirst = ((int)0X0d01),
        PackRowLength = ((int)0X0d02),
        PackSkipRows = ((int)0X0d03),
        PackSkipPixels = ((int)0X0d04),
        PackAlignment = ((int)0X0d05),
        MapColor = ((int)0X0d10),
        MapStencil = ((int)0X0d11),
        IndexShift = ((int)0X0d12),
        IndexOffset = ((int)0X0d13),
        RedScale = ((int)0X0d14),
        RedBias = ((int)0X0d15),
        ZoomX = ((int)0X0d16),
        ZoomY = ((int)0X0d17),
        GreenScale = ((int)0X0d18),
        GreenBias = ((int)0X0d19),
        BlueScale = ((int)0X0d1a),
        BlueBias = ((int)0X0d1b),
        AlphaScale = ((int)0X0d1c),
        AlphaBias = ((int)0X0d1d),
        DepthScale = ((int)0X0d1e),
        DepthBias = ((int)0X0d1f),
        MaxEvalOrder = ((int)0X0d30),
        MaxLights = ((int)0X0d31),
        MaxClipDistances = ((int)0X0d32),
        MaxClipPlanes = ((int)0X0d32),
        MaxTextureSize = ((int)0X0d33),
        MaxPixelMapTable = ((int)0X0d34),
        MaxAttribStackDepth = ((int)0X0d35),
        MaxModelviewStackDepth = ((int)0X0d36),
        MaxNameStackDepth = ((int)0X0d37),
        MaxProjectionStackDepth = ((int)0X0d38),
        MaxTextureStackDepth = ((int)0X0d39),
        MaxViewportDims = ((int)0X0d3a),
        MaxClientAttribStackDepth = ((int)0X0d3b),
        SubpixelBits = ((int)0X0d50),
        IndexBits = ((int)0X0d51),
        RedBits = ((int)0X0d52),
        GreenBits = ((int)0X0d53),
        BlueBits = ((int)0X0d54),
        AlphaBits = ((int)0X0d55),
        DepthBits = ((int)0X0d56),
        StencilBits = ((int)0X0d57),
        AccumRedBits = ((int)0X0d58),
        AccumGreenBits = ((int)0X0d59),
        AccumBlueBits = ((int)0X0d5a),
        AccumAlphaBits = ((int)0X0d5b),
        NameStackDepth = ((int)0X0d70),
        AutoNormal = ((int)0X0d80),
        Map1Color4 = ((int)0X0d90),
        Map1Index = ((int)0X0d91),
        Map1Normal = ((int)0X0d92),
        Map1TextureCoord1 = ((int)0X0d93),
        Map1TextureCoord2 = ((int)0X0d94),
        Map1TextureCoord3 = ((int)0X0d95),
        Map1TextureCoord4 = ((int)0X0d96),
        Map1Vertex3 = ((int)0X0d97),
        Map1Vertex4 = ((int)0X0d98),
        Map2Color4 = ((int)0X0db0),
        Map2Index = ((int)0X0db1),
        Map2Normal = ((int)0X0db2),
        Map2TextureCoord1 = ((int)0X0db3),
        Map2TextureCoord2 = ((int)0X0db4),
        Map2TextureCoord3 = ((int)0X0db5),
        Map2TextureCoord4 = ((int)0X0db6),
        Map2Vertex3 = ((int)0X0db7),
        Map2Vertex4 = ((int)0X0db8),
        Map1GridDomain = ((int)0X0dd0),
        Map1GridSegments = ((int)0X0dd1),
        Map2GridDomain = ((int)0X0dd2),
        Map2GridSegments = ((int)0X0dd3),
        Texture1D = ((int)0X0de0),
        Texture2D = ((int)0X0de1),
        FeedbackBufferPointer = ((int)0X0df0),
        FeedbackBufferSize = ((int)0X0df1),
        FeedbackBufferType = ((int)0X0df2),
        SelectionBufferPointer = ((int)0X0df3),
        SelectionBufferSize = ((int)0X0df4),
        TextureWidth = ((int)0X1000),
        Texcoord1BitPgi = ((int)0X10000000),
        TextureHeight = ((int)0X1001),
        TextureComponents = ((int)0X1003),
        TextureInternalFormat = ((int)0X1003),
        TextureBorderColor = ((int)0X1004),
        TextureBorder = ((int)0X1005),
        DontCare = ((int)0X1100),
        Fastest = ((int)0X1101),
        Nicest = ((int)0X1102),
        Ambient = ((int)0X1200),
        Diffuse = ((int)0X1201),
        Specular = ((int)0X1202),
        Position = ((int)0X1203),
        SpotDirection = ((int)0X1204),
        SpotExponent = ((int)0X1205),
        SpotCutoff = ((int)0X1206),
        ConstantAttenuation = ((int)0X1207),
        LinearAttenuation = ((int)0X1208),
        QuadraticAttenuation = ((int)0X1209),
        Compile = ((int)0X1300),
        CompileAndExecute = ((int)0X1301),
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        Gl2Bytes = ((int)0X1407),
        Gl3Bytes = ((int)0X1408),
        Gl4Bytes = ((int)0X1409),
        Double = ((int)0X140a),
        DoubleExt = ((int)0X140a),
        HalfApple = ((int)0X140b),
        HalfFloat = ((int)0X140b),
        HalfFloatArb = ((int)0X140b),
        HalfFloatNv = ((int)0X140b),
        Clear = ((int)0X1500),
        And = ((int)0X1501),
        AndReverse = ((int)0X1502),
        Copy = ((int)0X1503),
        AndInverted = ((int)0X1504),
        Noop = ((int)0X1505),
        Xor = ((int)0X1506),
        Or = ((int)0X1507),
        Nor = ((int)0X1508),
        Equiv = ((int)0X1509),
        Invert = ((int)0X150a),
        OrReverse = ((int)0X150b),
        CopyInverted = ((int)0X150c),
        OrInverted = ((int)0X150d),
        Nand = ((int)0X150e),
        Set = ((int)0X150f),
        Emission = ((int)0X1600),
        Shininess = ((int)0X1601),
        AmbientAndDiffuse = ((int)0X1602),
        ColorIndexes = ((int)0X1603),
        Modelview = ((int)0X1700),
        Modelview0Arb = ((int)0X1700),
        Modelview0Ext = ((int)0X1700),
        Projection = ((int)0X1701),
        Texture = ((int)0X1702),
        Color = ((int)0X1800),
        Depth = ((int)0X1801),
        Stencil = ((int)0X1802),
        ColorIndex = ((int)0X1900),
        StencilIndex = ((int)0X1901),
        DepthComponent = ((int)0X1902),
        Red = ((int)0X1903),
        Green = ((int)0X1904),
        Blue = ((int)0X1905),
        Alpha = ((int)0X1906),
        Rgb = ((int)0X1907),
        Rgba = ((int)0X1908),
        Luminance = ((int)0X1909),
        LuminanceAlpha = ((int)0X190a),
        RasterPositionUnclippedIbm = ((int)0X19262),
        Bitmap = ((int)0X1a00),
        PreferDoublebufferHintPgi = ((int)0X1a1f8),
        ConserveMemoryHintPgi = ((int)0X1a1fd),
        ReclaimMemoryHintPgi = ((int)0X1a1fe),
        NativeGraphicsHandlePgi = ((int)0X1a202),
        NativeGraphicsBeginHintPgi = ((int)0X1a203),
        NativeGraphicsEndHintPgi = ((int)0X1a204),
        AlwaysFastHintPgi = ((int)0X1a20c),
        AlwaysSoftHintPgi = ((int)0X1a20d),
        AllowDrawObjHintPgi = ((int)0X1a20e),
        AllowDrawWinHintPgi = ((int)0X1a20f),
        AllowDrawFrgHintPgi = ((int)0X1a210),
        AllowDrawMemHintPgi = ((int)0X1a211),
        StrictDepthfuncHintPgi = ((int)0X1a216),
        StrictLightingHintPgi = ((int)0X1a217),
        StrictScissorHintPgi = ((int)0X1a218),
        FullStippleHintPgi = ((int)0X1a219),
        ClipNearHintPgi = ((int)0X1a220),
        ClipFarHintPgi = ((int)0X1a221),
        WideLineHintPgi = ((int)0X1a222),
        BackNormalsHintPgi = ((int)0X1a223),
        VertexDataHintPgi = ((int)0X1a22a),
        VertexConsistentHintPgi = ((int)0X1a22b),
        MaterialSideHintPgi = ((int)0X1a22c),
        MaxVertexHintPgi = ((int)0X1a22d),
        Point = ((int)0X1b00),
        Line = ((int)0X1b01),
        Fill = ((int)0X1b02),
        Render = ((int)0X1c00),
        Feedback = ((int)0X1c01),
        Select = ((int)0X1c02),
        Flat = ((int)0X1d00),
        Smooth = ((int)0X1d01),
        Keep = ((int)0X1e00),
        Replace = ((int)0X1e01),
        Incr = ((int)0X1e02),
        Decr = ((int)0X1e03),
        Vendor = ((int)0X1f00),
        Renderer = ((int)0X1f01),
        Version = ((int)0X1f02),
        Extensions = ((int)0X1f03),
        S = ((int)0X2000),
        MultisampleBit = ((int)0X20000000),
        MultisampleBit3Dfx = ((int)0X20000000),
        MultisampleBitArb = ((int)0X20000000),
        MultisampleBitExt = ((int)0X20000000),
        Texcoord2BitPgi = ((int)0X20000000),
        T = ((int)0X2001),
        R = ((int)0X2002),
        Q = ((int)0X2003),
        Modulate = ((int)0X2100),
        Decal = ((int)0X2101),
        TextureEnvMode = ((int)0X2200),
        TextureEnvColor = ((int)0X2201),
        TextureEnv = ((int)0X2300),
        EyeLinear = ((int)0X2400),
        ObjectLinear = ((int)0X2401),
        SphereMap = ((int)0X2402),
        TextureGenMode = ((int)0X2500),
        ObjectPlane = ((int)0X2501),
        EyePlane = ((int)0X2502),
        Nearest = ((int)0X2600),
        Linear = ((int)0X2601),
        NearestMipmapNearest = ((int)0X2700),
        LinearMipmapNearest = ((int)0X2701),
        NearestMipmapLinear = ((int)0X2702),
        LinearMipmapLinear = ((int)0X2703),
        TextureMagFilter = ((int)0X2800),
        TextureMinFilter = ((int)0X2801),
        TextureWrapS = ((int)0X2802),
        TextureWrapT = ((int)0X2803),
        Clamp = ((int)0X2900),
        Repeat = ((int)0X2901),
        PolygonOffsetUnits = ((int)0X2a00),
        PolygonOffsetPoint = ((int)0X2a01),
        PolygonOffsetLine = ((int)0X2a02),
        R3G3B2 = ((int)0X2a10),
        V2f = ((int)0X2a20),
        V3f = ((int)0X2a21),
        C4ubV2f = ((int)0X2a22),
        C4ubV3f = ((int)0X2a23),
        C3fV3f = ((int)0X2a24),
        N3fV3f = ((int)0X2a25),
        C4fN3fV3f = ((int)0X2a26),
        T2fV3f = ((int)0X2a27),
        T4fV4f = ((int)0X2a28),
        T2fC4ubV3f = ((int)0X2a29),
        T2fC3fV3f = ((int)0X2a2a),
        T2fN3fV3f = ((int)0X2a2b),
        T2fC4fN3fV3f = ((int)0X2a2c),
        T4fC4fN3fV4f = ((int)0X2a2d),
        ClipDistance0 = ((int)0X3000),
        ClipPlane0 = ((int)0X3000),
        ClipDistance1 = ((int)0X3001),
        ClipPlane1 = ((int)0X3001),
        ClipDistance2 = ((int)0X3002),
        ClipPlane2 = ((int)0X3002),
        ClipDistance3 = ((int)0X3003),
        ClipPlane3 = ((int)0X3003),
        ClipDistance4 = ((int)0X3004),
        ClipPlane4 = ((int)0X3004),
        ClipDistance5 = ((int)0X3005),
        ClipPlane5 = ((int)0X3005),
        ClipDistance6 = ((int)0X3006),
        ClipDistance7 = ((int)0X3007),
        Light0 = ((int)0X4000),
        Texcoord3BitPgi = ((int)0X40000000),
        Light1 = ((int)0X4001),
        Light2 = ((int)0X4002),
        Light3 = ((int)0X4003),
        Light4 = ((int)0X4004),
        Light5 = ((int)0X4005),
        Light6 = ((int)0X4006),
        Light7 = ((int)0X4007),
        AbgrExt = ((int)0X8000),
        Texcoord4BitPgi = unchecked((int)0X80000000),
        ConstantColor = ((int)0X8001),
        ConstantColorExt = ((int)0X8001),
        OneMinusConstantColor = ((int)0X8002),
        OneMinusConstantColorExt = ((int)0X8002),
        ConstantAlpha = ((int)0X8003),
        ConstantAlphaExt = ((int)0X8003),
        OneMinusConstantAlpha = ((int)0X8004),
        OneMinusConstantAlphaExt = ((int)0X8004),
        BlendColor = ((int)0X8005),
        BlendColorExt = ((int)0X8005),
        FuncAdd = ((int)0X8006),
        FuncAddExt = ((int)0X8006),
        Min = ((int)0X8007),
        MinExt = ((int)0X8007),
        Max = ((int)0X8008),
        MaxExt = ((int)0X8008),
        BlendEquation = ((int)0X8009),
        BlendEquationExt = ((int)0X8009),
        BlendEquationRgb = ((int)0X8009),
        BlendEquationRgbExt = ((int)0X8009),
        FuncSubtract = ((int)0X800a),
        FuncSubtractExt = ((int)0X800a),
        FuncReverseSubtract = ((int)0X800b),
        FuncReverseSubtractExt = ((int)0X800b),
        CmykExt = ((int)0X800c),
        CmykaExt = ((int)0X800d),
        PackCmykHintExt = ((int)0X800e),
        UnpackCmykHintExt = ((int)0X800f),
        Convolution1D = ((int)0X8010),
        Convolution1DExt = ((int)0X8010),
        Convolution2D = ((int)0X8011),
        Convolution2DExt = ((int)0X8011),
        Separable2D = ((int)0X8012),
        Separable2DExt = ((int)0X8012),
        ConvolutionBorderMode = ((int)0X8013),
        ConvolutionBorderModeExt = ((int)0X8013),
        ConvolutionFilterScale = ((int)0X8014),
        ConvolutionFilterScaleExt = ((int)0X8014),
        ConvolutionFilterBias = ((int)0X8015),
        ConvolutionFilterBiasExt = ((int)0X8015),
        Reduce = ((int)0X8016),
        ReduceExt = ((int)0X8016),
        ConvolutionFormat = ((int)0X8017),
        ConvolutionFormatExt = ((int)0X8017),
        ConvolutionWidth = ((int)0X8018),
        ConvolutionWidthExt = ((int)0X8018),
        ConvolutionHeight = ((int)0X8019),
        ConvolutionHeightExt = ((int)0X8019),
        MaxConvolutionWidth = ((int)0X801a),
        MaxConvolutionWidthExt = ((int)0X801a),
        MaxConvolutionHeight = ((int)0X801b),
        MaxConvolutionHeightExt = ((int)0X801b),
        PostConvolutionRedScale = ((int)0X801c),
        PostConvolutionRedScaleExt = ((int)0X801c),
        PostConvolutionGreenScale = ((int)0X801d),
        PostConvolutionGreenScaleExt = ((int)0X801d),
        PostConvolutionBlueScale = ((int)0X801e),
        PostConvolutionBlueScaleExt = ((int)0X801e),
        PostConvolutionAlphaScale = ((int)0X801f),
        PostConvolutionAlphaScaleExt = ((int)0X801f),
        PostConvolutionRedBias = ((int)0X8020),
        PostConvolutionRedBiasExt = ((int)0X8020),
        PostConvolutionGreenBias = ((int)0X8021),
        PostConvolutionGreenBiasExt = ((int)0X8021),
        PostConvolutionBlueBias = ((int)0X8022),
        PostConvolutionBlueBiasExt = ((int)0X8022),
        PostConvolutionAlphaBias = ((int)0X8023),
        PostConvolutionAlphaBiasExt = ((int)0X8023),
        Histogram = ((int)0X8024),
        HistogramExt = ((int)0X8024),
        ProxyHistogram = ((int)0X8025),
        ProxyHistogramExt = ((int)0X8025),
        HistogramWidth = ((int)0X8026),
        HistogramWidthExt = ((int)0X8026),
        HistogramFormat = ((int)0X8027),
        HistogramFormatExt = ((int)0X8027),
        HistogramRedSize = ((int)0X8028),
        HistogramRedSizeExt = ((int)0X8028),
        HistogramGreenSize = ((int)0X8029),
        HistogramGreenSizeExt = ((int)0X8029),
        HistogramBlueSize = ((int)0X802a),
        HistogramBlueSizeExt = ((int)0X802a),
        HistogramAlphaSize = ((int)0X802b),
        HistogramAlphaSizeExt = ((int)0X802b),
        HistogramLuminanceSize = ((int)0X802c),
        HistogramLuminanceSizeExt = ((int)0X802c),
        HistogramSink = ((int)0X802d),
        HistogramSinkExt = ((int)0X802d),
        Minmax = ((int)0X802e),
        MinmaxExt = ((int)0X802e),
        MinmaxFormat = ((int)0X802f),
        MinmaxFormatExt = ((int)0X802f),
        MinmaxSink = ((int)0X8030),
        MinmaxSinkExt = ((int)0X8030),
        TableTooLarge = ((int)0X8031),
        TableTooLargeExt = ((int)0X8031),
        UnsignedByte332 = ((int)0X8032),
        UnsignedByte332Ext = ((int)0X8032),
        UnsignedShort4444 = ((int)0X8033),
        UnsignedShort4444Ext = ((int)0X8033),
        UnsignedShort5551 = ((int)0X8034),
        UnsignedShort5551Ext = ((int)0X8034),
        UnsignedInt8888 = ((int)0X8035),
        UnsignedInt8888Ext = ((int)0X8035),
        UnsignedInt1010102 = ((int)0X8036),
        UnsignedInt1010102Ext = ((int)0X8036),
        PolygonOffsetExt = ((int)0X8037),
        PolygonOffsetFill = ((int)0X8037),
        PolygonOffsetFactor = ((int)0X8038),
        PolygonOffsetFactorExt = ((int)0X8038),
        PolygonOffsetBiasExt = ((int)0X8039),
        RescaleNormal = ((int)0X803a),
        RescaleNormalExt = ((int)0X803a),
        Alpha4 = ((int)0X803b),
        Alpha4Ext = ((int)0X803b),
        Alpha8 = ((int)0X803c),
        Alpha8Ext = ((int)0X803c),
        Alpha12 = ((int)0X803d),
        Alpha12Ext = ((int)0X803d),
        Alpha16 = ((int)0X803e),
        Alpha16Ext = ((int)0X803e),
        Luminance4 = ((int)0X803f),
        Luminance4Ext = ((int)0X803f),
        Luminance8 = ((int)0X8040),
        Luminance8Ext = ((int)0X8040),
        Luminance12 = ((int)0X8041),
        Luminance12Ext = ((int)0X8041),
        Luminance16 = ((int)0X8042),
        Luminance16Ext = ((int)0X8042),
        Luminance4Alpha4 = ((int)0X8043),
        Luminance4Alpha4Ext = ((int)0X8043),
        Luminance6Alpha2 = ((int)0X8044),
        Luminance6Alpha2Ext = ((int)0X8044),
        Luminance8Alpha8 = ((int)0X8045),
        Luminance8Alpha8Ext = ((int)0X8045),
        Luminance12Alpha4 = ((int)0X8046),
        Luminance12Alpha4Ext = ((int)0X8046),
        Luminance12Alpha12 = ((int)0X8047),
        Luminance12Alpha12Ext = ((int)0X8047),
        Luminance16Alpha16 = ((int)0X8048),
        Luminance16Alpha16Ext = ((int)0X8048),
        Intensity = ((int)0X8049),
        IntensityExt = ((int)0X8049),
        Intensity4 = ((int)0X804a),
        Intensity4Ext = ((int)0X804a),
        Intensity8 = ((int)0X804b),
        Intensity8Ext = ((int)0X804b),
        Intensity12 = ((int)0X804c),
        Intensity12Ext = ((int)0X804c),
        Intensity16 = ((int)0X804d),
        Intensity16Ext = ((int)0X804d),
        Rgb2Ext = ((int)0X804e),
        Rgb4 = ((int)0X804f),
        Rgb4Ext = ((int)0X804f),
        Rgb5 = ((int)0X8050),
        Rgb5Ext = ((int)0X8050),
        Rgb8 = ((int)0X8051),
        Rgb8Ext = ((int)0X8051),
        Rgb10 = ((int)0X8052),
        Rgb10Ext = ((int)0X8052),
        Rgb12 = ((int)0X8053),
        Rgb12Ext = ((int)0X8053),
        Rgb16 = ((int)0X8054),
        Rgb16Ext = ((int)0X8054),
        Rgba2 = ((int)0X8055),
        Rgba2Ext = ((int)0X8055),
        Rgba4 = ((int)0X8056),
        Rgba4Ext = ((int)0X8056),
        Rgb5A1 = ((int)0X8057),
        Rgb5A1Ext = ((int)0X8057),
        Rgba8 = ((int)0X8058),
        Rgba8Ext = ((int)0X8058),
        Rgb10A2 = ((int)0X8059),
        Rgb10A2Ext = ((int)0X8059),
        Rgba12 = ((int)0X805a),
        Rgba12Ext = ((int)0X805a),
        Rgba16 = ((int)0X805b),
        Rgba16Ext = ((int)0X805b),
        TextureRedSize = ((int)0X805c),
        TextureRedSizeExt = ((int)0X805c),
        TextureGreenSize = ((int)0X805d),
        TextureGreenSizeExt = ((int)0X805d),
        TextureBlueSize = ((int)0X805e),
        TextureBlueSizeExt = ((int)0X805e),
        TextureAlphaSize = ((int)0X805f),
        TextureAlphaSizeExt = ((int)0X805f),
        TextureLuminanceSize = ((int)0X8060),
        TextureLuminanceSizeExt = ((int)0X8060),
        TextureIntensitySize = ((int)0X8061),
        TextureIntensitySizeExt = ((int)0X8061),
        ReplaceExt = ((int)0X8062),
        ProxyTexture1D = ((int)0X8063),
        ProxyTexture1DExt = ((int)0X8063),
        ProxyTexture2D = ((int)0X8064),
        ProxyTexture2DExt = ((int)0X8064),
        TextureTooLargeExt = ((int)0X8065),
        TexturePriority = ((int)0X8066),
        TexturePriorityExt = ((int)0X8066),
        TextureResident = ((int)0X8067),
        TextureResidentExt = ((int)0X8067),
        Texture1DBindingExt = ((int)0X8068),
        TextureBinding1D = ((int)0X8068),
        Texture2DBindingExt = ((int)0X8069),
        TextureBinding2D = ((int)0X8069),
        Texture3DBindingExt = ((int)0X806a),
        TextureBinding3D = ((int)0X806a),
        PackSkipImages = ((int)0X806b),
        PackSkipImagesExt = ((int)0X806b),
        PackImageHeight = ((int)0X806c),
        PackImageHeightExt = ((int)0X806c),
        UnpackSkipImages = ((int)0X806d),
        UnpackSkipImagesExt = ((int)0X806d),
        UnpackImageHeight = ((int)0X806e),
        UnpackImageHeightExt = ((int)0X806e),
        Texture3D = ((int)0X806f),
        Texture3DExt = ((int)0X806f),
        ProxyTexture3D = ((int)0X8070),
        ProxyTexture3DExt = ((int)0X8070),
        TextureDepth = ((int)0X8071),
        TextureDepthExt = ((int)0X8071),
        TextureWrapR = ((int)0X8072),
        TextureWrapRExt = ((int)0X8072),
        Max3DTextureSize = ((int)0X8073),
        Max3DTextureSizeExt = ((int)0X8073),
        VertexArray = ((int)0X8074),
        VertexArrayExt = ((int)0X8074),
        NormalArray = ((int)0X8075),
        NormalArrayExt = ((int)0X8075),
        ColorArray = ((int)0X8076),
        ColorArrayExt = ((int)0X8076),
        IndexArray = ((int)0X8077),
        IndexArrayExt = ((int)0X8077),
        TextureCoordArray = ((int)0X8078),
        TextureCoordArrayExt = ((int)0X8078),
        EdgeFlagArray = ((int)0X8079),
        EdgeFlagArrayExt = ((int)0X8079),
        VertexArraySize = ((int)0X807a),
        VertexArraySizeExt = ((int)0X807a),
        VertexArrayType = ((int)0X807b),
        VertexArrayTypeExt = ((int)0X807b),
        VertexArrayStride = ((int)0X807c),
        VertexArrayStrideExt = ((int)0X807c),
        VertexArrayCountExt = ((int)0X807d),
        NormalArrayType = ((int)0X807e),
        NormalArrayTypeExt = ((int)0X807e),
        NormalArrayStride = ((int)0X807f),
        NormalArrayStrideExt = ((int)0X807f),
        NormalArrayCountExt = ((int)0X8080),
        ColorArraySize = ((int)0X8081),
        ColorArraySizeExt = ((int)0X8081),
        ColorArrayType = ((int)0X8082),
        ColorArrayTypeExt = ((int)0X8082),
        ColorArrayStride = ((int)0X8083),
        ColorArrayStrideExt = ((int)0X8083),
        ColorArrayCountExt = ((int)0X8084),
        IndexArrayType = ((int)0X8085),
        IndexArrayTypeExt = ((int)0X8085),
        IndexArrayStride = ((int)0X8086),
        IndexArrayStrideExt = ((int)0X8086),
        IndexArrayCountExt = ((int)0X8087),
        TextureCoordArraySize = ((int)0X8088),
        TextureCoordArraySizeExt = ((int)0X8088),
        TextureCoordArrayType = ((int)0X8089),
        TextureCoordArrayTypeExt = ((int)0X8089),
        TextureCoordArrayStride = ((int)0X808a),
        TextureCoordArrayStrideExt = ((int)0X808a),
        TextureCoordArrayCountExt = ((int)0X808b),
        EdgeFlagArrayStride = ((int)0X808c),
        EdgeFlagArrayStrideExt = ((int)0X808c),
        EdgeFlagArrayCountExt = ((int)0X808d),
        VertexArrayPointer = ((int)0X808e),
        VertexArrayPointerExt = ((int)0X808e),
        NormalArrayPointer = ((int)0X808f),
        NormalArrayPointerExt = ((int)0X808f),
        ColorArrayPointer = ((int)0X8090),
        ColorArrayPointerExt = ((int)0X8090),
        IndexArrayPointer = ((int)0X8091),
        IndexArrayPointerExt = ((int)0X8091),
        TextureCoordArrayPointer = ((int)0X8092),
        TextureCoordArrayPointerExt = ((int)0X8092),
        EdgeFlagArrayPointer = ((int)0X8093),
        EdgeFlagArrayPointerExt = ((int)0X8093),
        InterlaceSgix = ((int)0X8094),
        DetailTexture2DSgis = ((int)0X8095),
        DetailTexture2DBindingSgis = ((int)0X8096),
        LinearDetailSgis = ((int)0X8097),
        LinearDetailAlphaSgis = ((int)0X8098),
        LinearDetailColorSgis = ((int)0X8099),
        DetailTextureLevelSgis = ((int)0X809a),
        DetailTextureModeSgis = ((int)0X809b),
        DetailTextureFuncPointsSgis = ((int)0X809c),
        Multisample = ((int)0X809d),
        MultisampleArb = ((int)0X809d),
        MultisampleExt = ((int)0X809d),
        MultisampleSgis = ((int)0X809d),
        SampleAlphaToCoverage = ((int)0X809e),
        SampleAlphaToCoverageArb = ((int)0X809e),
        SampleAlphaToMaskExt = ((int)0X809e),
        SampleAlphaToMaskSgis = ((int)0X809e),
        SampleAlphaToOne = ((int)0X809f),
        SampleAlphaToOneArb = ((int)0X809f),
        SampleAlphaToOneExt = ((int)0X809f),
        SampleAlphaToOneSgis = ((int)0X809f),
        SampleCoverage = ((int)0X80a0),
        SampleCoverageArb = ((int)0X80a0),
        SampleMaskExt = ((int)0X80a0),
        SampleMaskSgis = ((int)0X80a0),
        Gl1PassExt = ((int)0X80a1),
        Gl1PassSgis = ((int)0X80a1),
        Gl2Pass0Ext = ((int)0X80a2),
        Gl2Pass0Sgis = ((int)0X80a2),
        Gl2Pass1Ext = ((int)0X80a3),
        Gl2Pass1Sgis = ((int)0X80a3),
        Gl4Pass0Ext = ((int)0X80a4),
        Gl4Pass0Sgis = ((int)0X80a4),
        Gl4Pass1Ext = ((int)0X80a5),
        Gl4Pass1Sgis = ((int)0X80a5),
        Gl4Pass2Ext = ((int)0X80a6),
        Gl4Pass2Sgis = ((int)0X80a6),
        Gl4Pass3Ext = ((int)0X80a7),
        Gl4Pass3Sgis = ((int)0X80a7),
        SampleBuffers = ((int)0X80a8),
        SampleBuffersArb = ((int)0X80a8),
        SampleBuffersExt = ((int)0X80a8),
        SampleBuffersSgis = ((int)0X80a8),
        Samples = ((int)0X80a9),
        SamplesArb = ((int)0X80a9),
        SamplesExt = ((int)0X80a9),
        SamplesSgis = ((int)0X80a9),
        SampleCoverageValue = ((int)0X80aa),
        SampleCoverageValueArb = ((int)0X80aa),
        SampleMaskValueExt = ((int)0X80aa),
        SampleMaskValueSgis = ((int)0X80aa),
        SampleCoverageInvert = ((int)0X80ab),
        SampleCoverageInvertArb = ((int)0X80ab),
        SampleMaskInvertExt = ((int)0X80ab),
        SampleMaskInvertSgis = ((int)0X80ab),
        SamplePatternExt = ((int)0X80ac),
        SamplePatternSgis = ((int)0X80ac),
        LinearSharpenSgis = ((int)0X80ad),
        LinearSharpenAlphaSgis = ((int)0X80ae),
        LinearSharpenColorSgis = ((int)0X80af),
        SharpenTextureFuncPointsSgis = ((int)0X80b0),
        ColorMatrix = ((int)0X80b1),
        ColorMatrixSgi = ((int)0X80b1),
        ColorMatrixStackDepth = ((int)0X80b2),
        ColorMatrixStackDepthSgi = ((int)0X80b2),
        MaxColorMatrixStackDepth = ((int)0X80b3),
        MaxColorMatrixStackDepthSgi = ((int)0X80b3),
        PostColorMatrixRedScale = ((int)0X80b4),
        PostColorMatrixRedScaleSgi = ((int)0X80b4),
        PostColorMatrixGreenScale = ((int)0X80b5),
        PostColorMatrixGreenScaleSgi = ((int)0X80b5),
        PostColorMatrixBlueScale = ((int)0X80b6),
        PostColorMatrixBlueScaleSgi = ((int)0X80b6),
        PostColorMatrixAlphaScale = ((int)0X80b7),
        PostColorMatrixAlphaScaleSgi = ((int)0X80b7),
        PostColorMatrixRedBias = ((int)0X80b8),
        PostColorMatrixRedBiasSgi = ((int)0X80b8),
        PostColorMatrixGreenBias = ((int)0X80b9),
        PostColorMatrixGreenBiasSgi = ((int)0X80b9),
        PostColorMatrixBlueBias = ((int)0X80ba),
        PostColorMatrixBlueBiasSgi = ((int)0X80ba),
        PostColorMatrixAlphaBias = ((int)0X80bb),
        PostColorMatrixAlphaBiasSgi = ((int)0X80bb),
        TextureColorTableSgi = ((int)0X80bc),
        ProxyTextureColorTableSgi = ((int)0X80bd),
        TextureEnvBiasSgix = ((int)0X80be),
        ShadowAmbientSgix = ((int)0X80bf),
        TextureCompareFailValue = ((int)0X80bf),
        TextureCompareFailValueArb = ((int)0X80bf),
        BlendDstRgb = ((int)0X80c8),
        BlendDstRgbExt = ((int)0X80c8),
        BlendSrcRgb = ((int)0X80c9),
        BlendSrcRgbExt = ((int)0X80c9),
        BlendDstAlpha = ((int)0X80ca),
        BlendDstAlphaExt = ((int)0X80ca),
        BlendSrcAlpha = ((int)0X80cb),
        BlendSrcAlphaExt = ((int)0X80cb),
        Gl422Ext = ((int)0X80cc),
        Gl422RevExt = ((int)0X80cd),
        Gl422AverageExt = ((int)0X80ce),
        Gl422RevAverageExt = ((int)0X80cf),
        ColorTable = ((int)0X80d0),
        ColorTableSgi = ((int)0X80d0),
        PostConvolutionColorTable = ((int)0X80d1),
        PostConvolutionColorTableSgi = ((int)0X80d1),
        PostColorMatrixColorTable = ((int)0X80d2),
        PostColorMatrixColorTableSgi = ((int)0X80d2),
        ProxyColorTable = ((int)0X80d3),
        ProxyColorTableSgi = ((int)0X80d3),
        ProxyPostConvolutionColorTable = ((int)0X80d4),
        ProxyPostConvolutionColorTableSgi = ((int)0X80d4),
        ProxyPostColorMatrixColorTable = ((int)0X80d5),
        ProxyPostColorMatrixColorTableSgi = ((int)0X80d5),
        ColorTableScale = ((int)0X80d6),
        ColorTableScaleSgi = ((int)0X80d6),
        ColorTableBias = ((int)0X80d7),
        ColorTableBiasSgi = ((int)0X80d7),
        ColorTableFormat = ((int)0X80d8),
        ColorTableFormatSgi = ((int)0X80d8),
        ColorTableWidth = ((int)0X80d9),
        ColorTableWidthSgi = ((int)0X80d9),
        ColorTableRedSize = ((int)0X80da),
        ColorTableRedSizeSgi = ((int)0X80da),
        ColorTableGreenSize = ((int)0X80db),
        ColorTableGreenSizeSgi = ((int)0X80db),
        ColorTableBlueSize = ((int)0X80dc),
        ColorTableBlueSizeSgi = ((int)0X80dc),
        ColorTableAlphaSize = ((int)0X80dd),
        ColorTableAlphaSizeSgi = ((int)0X80dd),
        ColorTableLuminanceSize = ((int)0X80de),
        ColorTableLuminanceSizeSgi = ((int)0X80de),
        ColorTableIntensitySize = ((int)0X80df),
        ColorTableIntensitySizeSgi = ((int)0X80df),
        Bgr = ((int)0X80e0),
        BgrExt = ((int)0X80e0),
        Bgra = ((int)0X80e1),
        BgraExt = ((int)0X80e1),
        ColorIndex1Ext = ((int)0X80e2),
        ColorIndex2Ext = ((int)0X80e3),
        ColorIndex4Ext = ((int)0X80e4),
        ColorIndex8Ext = ((int)0X80e5),
        ColorIndex12Ext = ((int)0X80e6),
        ColorIndex16Ext = ((int)0X80e7),
        MaxElementsVertices = ((int)0X80e8),
        MaxElementsVerticesExt = ((int)0X80e8),
        MaxElementsIndices = ((int)0X80e9),
        MaxElementsIndicesExt = ((int)0X80e9),
        PhongWin = ((int)0X80ea),
        PhongHintWin = ((int)0X80eb),
        FogSpecularTextureWin = ((int)0X80ec),
        TextureIndexSizeExt = ((int)0X80ed),
        ClipVolumeClippingHintExt = ((int)0X80f0),
        DualAlpha4Sgis = ((int)0X8110),
        DualAlpha8Sgis = ((int)0X8111),
        DualAlpha12Sgis = ((int)0X8112),
        DualAlpha16Sgis = ((int)0X8113),
        DualLuminance4Sgis = ((int)0X8114),
        DualLuminance8Sgis = ((int)0X8115),
        DualLuminance12Sgis = ((int)0X8116),
        DualLuminance16Sgis = ((int)0X8117),
        DualIntensity4Sgis = ((int)0X8118),
        DualIntensity8Sgis = ((int)0X8119),
        DualIntensity12Sgis = ((int)0X811a),
        DualIntensity16Sgis = ((int)0X811b),
        DualLuminanceAlpha4Sgis = ((int)0X811c),
        DualLuminanceAlpha8Sgis = ((int)0X811d),
        QuadAlpha4Sgis = ((int)0X811e),
        QuadAlpha8Sgis = ((int)0X811f),
        QuadLuminance4Sgis = ((int)0X8120),
        QuadLuminance8Sgis = ((int)0X8121),
        QuadIntensity4Sgis = ((int)0X8122),
        QuadIntensity8Sgis = ((int)0X8123),
        DualTextureSelectSgis = ((int)0X8124),
        QuadTextureSelectSgis = ((int)0X8125),
        PointSizeMin = ((int)0X8126),
        PointSizeMinArb = ((int)0X8126),
        PointSizeMinExt = ((int)0X8126),
        PointSizeMinSgis = ((int)0X8126),
        PointSizeMax = ((int)0X8127),
        PointSizeMaxArb = ((int)0X8127),
        PointSizeMaxExt = ((int)0X8127),
        PointSizeMaxSgis = ((int)0X8127),
        PointFadeThresholdSize = ((int)0X8128),
        PointFadeThresholdSizeArb = ((int)0X8128),
        PointFadeThresholdSizeExt = ((int)0X8128),
        PointFadeThresholdSizeSgis = ((int)0X8128),
        DistanceAttenuationExt = ((int)0X8129),
        DistanceAttenuationSgis = ((int)0X8129),
        PointDistanceAttenuation = ((int)0X8129),
        PointDistanceAttenuationArb = ((int)0X8129),
        FogFuncSgis = ((int)0X812a),
        FogFuncPointsSgis = ((int)0X812b),
        MaxFogFuncPointsSgis = ((int)0X812c),
        ClampToBorder = ((int)0X812d),
        ClampToBorderArb = ((int)0X812d),
        ClampToBorderSgis = ((int)0X812d),
        TextureMultiBufferHintSgix = ((int)0X812e),
        ClampToEdge = ((int)0X812f),
        ClampToEdgeSgis = ((int)0X812f),
        PackSkipVolumesSgis = ((int)0X8130),
        PackImageDepthSgis = ((int)0X8131),
        UnpackSkipVolumesSgis = ((int)0X8132),
        UnpackImageDepthSgis = ((int)0X8133),
        Texture4DSgis = ((int)0X8134),
        ProxyTexture4DSgis = ((int)0X8135),
        Texture4DsizeSgis = ((int)0X8136),
        TextureWrapQSgis = ((int)0X8137),
        Max4DTextureSizeSgis = ((int)0X8138),
        PixelTexGenSgix = ((int)0X8139),
        TextureMinLod = ((int)0X813a),
        TextureMinLodSgis = ((int)0X813a),
        TextureMaxLod = ((int)0X813b),
        TextureMaxLodSgis = ((int)0X813b),
        TextureBaseLevel = ((int)0X813c),
        TextureBaseLevelSgis = ((int)0X813c),
        TextureMaxLevel = ((int)0X813d),
        TextureMaxLevelSgis = ((int)0X813d),
        PixelTileBestAlignmentSgix = ((int)0X813e),
        PixelTileCacheIncrementSgix = ((int)0X813f),
        PixelTileWidthSgix = ((int)0X8140),
        PixelTileHeightSgix = ((int)0X8141),
        PixelTileGridWidthSgix = ((int)0X8142),
        PixelTileGridHeightSgix = ((int)0X8143),
        PixelTileGridDepthSgix = ((int)0X8144),
        PixelTileCacheSizeSgix = ((int)0X8145),
        Filter4Sgis = ((int)0X8146),
        TextureFilter4SizeSgis = ((int)0X8147),
        SpriteSgix = ((int)0X8148),
        SpriteModeSgix = ((int)0X8149),
        SpriteAxisSgix = ((int)0X814a),
        SpriteTranslationSgix = ((int)0X814b),
        SpriteAxialSgix = ((int)0X814c),
        SpriteObjectAlignedSgix = ((int)0X814d),
        SpriteEyeAlignedSgix = ((int)0X814e),
        Texture4DBindingSgis = ((int)0X814f),
        IgnoreBorderHp = ((int)0X8150),
        ConstantBorder = ((int)0X8151),
        ConstantBorderHp = ((int)0X8151),
        ReplicateBorder = ((int)0X8153),
        ReplicateBorderHp = ((int)0X8153),
        ConvolutionBorderColor = ((int)0X8154),
        ConvolutionBorderColorHp = ((int)0X8154),
        ImageScaleXHp = ((int)0X8155),
        ImageScaleYHp = ((int)0X8156),
        ImageTranslateXHp = ((int)0X8157),
        ImageTranslateYHp = ((int)0X8158),
        ImageRotateAngleHp = ((int)0X8159),
        ImageRotateOriginXHp = ((int)0X815a),
        ImageRotateOriginYHp = ((int)0X815b),
        ImageMagFilterHp = ((int)0X815c),
        ImageMinFilterHp = ((int)0X815d),
        ImageCubicWeightHp = ((int)0X815e),
        CubicHp = ((int)0X815f),
        AverageHp = ((int)0X8160),
        ImageTransform2DHp = ((int)0X8161),
        PostImageTransformColorTableHp = ((int)0X8162),
        ProxyPostImageTransformColorTableHp = ((int)0X8163),
        OcclusionTestHp = ((int)0X8165),
        OcclusionTestResultHp = ((int)0X8166),
        TextureLightingModeHp = ((int)0X8167),
        TexturePostSpecularHp = ((int)0X8168),
        TexturePreSpecularHp = ((int)0X8169),
        LinearClipmapLinearSgix = ((int)0X8170),
        TextureClipmapCenterSgix = ((int)0X8171),
        TextureClipmapFrameSgix = ((int)0X8172),
        TextureClipmapOffsetSgix = ((int)0X8173),
        TextureClipmapVirtualDepthSgix = ((int)0X8174),
        TextureClipmapLodOffsetSgix = ((int)0X8175),
        TextureClipmapDepthSgix = ((int)0X8176),
        MaxClipmapDepthSgix = ((int)0X8177),
        MaxClipmapVirtualDepthSgix = ((int)0X8178),
        PostTextureFilterBiasSgix = ((int)0X8179),
        PostTextureFilterScaleSgix = ((int)0X817a),
        PostTextureFilterBiasRangeSgix = ((int)0X817b),
        PostTextureFilterScaleRangeSgix = ((int)0X817c),
        ReferencePlaneSgix = ((int)0X817d),
        ReferencePlaneEquationSgix = ((int)0X817e),
        IrInstrument1Sgix = ((int)0X817f),
        InstrumentBufferPointerSgix = ((int)0X8180),
        InstrumentMeasurementsSgix = ((int)0X8181),
        ListPrioritySgix = ((int)0X8182),
        CalligraphicFragmentSgix = ((int)0X8183),
        PixelTexGenQCeilingSgix = ((int)0X8184),
        PixelTexGenQRoundSgix = ((int)0X8185),
        PixelTexGenQFloorSgix = ((int)0X8186),
        PixelTexGenAlphaReplaceSgix = ((int)0X8187),
        PixelTexGenAlphaNoReplaceSgix = ((int)0X8188),
        PixelTexGenAlphaLsSgix = ((int)0X8189),
        PixelTexGenAlphaMsSgix = ((int)0X818a),
        FramezoomSgix = ((int)0X818b),
        FramezoomFactorSgix = ((int)0X818c),
        MaxFramezoomFactorSgix = ((int)0X818d),
        TextureLodBiasSSgix = ((int)0X818e),
        TextureLodBiasTSgix = ((int)0X818f),
        TextureLodBiasRSgix = ((int)0X8190),
        GenerateMipmap = ((int)0X8191),
        GenerateMipmapSgis = ((int)0X8191),
        GenerateMipmapHint = ((int)0X8192),
        GenerateMipmapHintSgis = ((int)0X8192),
        GeometryDeformationSgix = ((int)0X8194),
        TextureDeformationSgix = ((int)0X8195),
        DeformationsMaskSgix = ((int)0X8196),
        MaxDeformationOrderSgix = ((int)0X8197),
        FogOffsetSgix = ((int)0X8198),
        FogOffsetValueSgix = ((int)0X8199),
        TextureCompareSgix = ((int)0X819a),
        TextureCompareOperatorSgix = ((int)0X819b),
        TextureLequalRSgix = ((int)0X819c),
        TextureGequalRSgix = ((int)0X819d),
        DepthComponent16 = ((int)0X81a5),
        DepthComponent16Arb = ((int)0X81a5),
        DepthComponent16Sgix = ((int)0X81a5),
        DepthComponent24 = ((int)0X81a6),
        DepthComponent24Arb = ((int)0X81a6),
        DepthComponent24Sgix = ((int)0X81a6),
        DepthComponent32 = ((int)0X81a7),
        DepthComponent32Arb = ((int)0X81a7),
        DepthComponent32Sgix = ((int)0X81a7),
        ArrayElementLockFirstExt = ((int)0X81a8),
        ArrayElementLockCountExt = ((int)0X81a9),
        CullVertexExt = ((int)0X81aa),
        CullVertexEyePositionExt = ((int)0X81ab),
        CullVertexObjectPositionExt = ((int)0X81ac),
        IuiV2fExt = ((int)0X81ad),
        IuiV3fExt = ((int)0X81ae),
        IuiN3fV2fExt = ((int)0X81af),
        IuiN3fV3fExt = ((int)0X81b0),
        T2fIuiV2fExt = ((int)0X81b1),
        T2fIuiV3fExt = ((int)0X81b2),
        T2fIuiN3fV2fExt = ((int)0X81b3),
        T2fIuiN3fV3fExt = ((int)0X81b4),
        IndexTestExt = ((int)0X81b5),
        IndexTestFuncExt = ((int)0X81b6),
        IndexTestRefExt = ((int)0X81b7),
        IndexMaterialExt = ((int)0X81b8),
        IndexMaterialParameterExt = ((int)0X81b9),
        IndexMaterialFaceExt = ((int)0X81ba),
        Ycrcb422Sgix = ((int)0X81bb),
        Ycrcb444Sgix = ((int)0X81bc),
        WrapBorderSun = ((int)0X81d4),
        UnpackConstantDataSunx = ((int)0X81d5),
        TextureConstantDataSunx = ((int)0X81d6),
        TriangleListSun = ((int)0X81d7),
        ReplacementCodeSun = ((int)0X81d8),
        GlobalAlphaSun = ((int)0X81d9),
        GlobalAlphaFactorSun = ((int)0X81da),
        TextureColorWritemaskSgis = ((int)0X81ef),
        EyeDistanceToPointSgis = ((int)0X81f0),
        ObjectDistanceToPointSgis = ((int)0X81f1),
        EyeDistanceToLineSgis = ((int)0X81f2),
        ObjectDistanceToLineSgis = ((int)0X81f3),
        EyePointSgis = ((int)0X81f4),
        ObjectPointSgis = ((int)0X81f5),
        EyeLineSgis = ((int)0X81f6),
        ObjectLineSgis = ((int)0X81f7),
        LightModelColorControl = ((int)0X81f8),
        LightModelColorControlExt = ((int)0X81f8),
        SingleColor = ((int)0X81f9),
        SingleColorExt = ((int)0X81f9),
        SeparateSpecularColor = ((int)0X81fa),
        SeparateSpecularColorExt = ((int)0X81fa),
        SharedTexturePaletteExt = ((int)0X81fb),
        FogScaleSgix = ((int)0X81fc),
        FogScaleValueSgix = ((int)0X81fd),
        TextFragmentShaderAti = ((int)0X8200),
        FramebufferAttachmentColorEncoding = ((int)0X8210),
        FramebufferAttachmentComponentType = ((int)0X8211),
        FramebufferAttachmentRedSize = ((int)0X8212),
        FramebufferAttachmentGreenSize = ((int)0X8213),
        FramebufferAttachmentBlueSize = ((int)0X8214),
        FramebufferAttachmentAlphaSize = ((int)0X8215),
        FramebufferAttachmentDepthSize = ((int)0X8216),
        FramebufferAttachmentStencilSize = ((int)0X8217),
        FramebufferDefault = ((int)0X8218),
        FramebufferUndefined = ((int)0X8219),
        DepthStencilAttachment = ((int)0X821a),
        MajorVersion = ((int)0X821b),
        MinorVersion = ((int)0X821c),
        NumExtensions = ((int)0X821d),
        ContextFlags = ((int)0X821e),
        Index = ((int)0X8222),
        DepthBuffer = ((int)0X8223),
        StencilBuffer = ((int)0X8224),
        CompressedRed = ((int)0X8225),
        CompressedRg = ((int)0X8226),
        Rg = ((int)0X8227),
        RgInteger = ((int)0X8228),
        R8 = ((int)0X8229),
        R16 = ((int)0X822a),
        Rg8 = ((int)0X822b),
        Rg16 = ((int)0X822c),
        R16f = ((int)0X822d),
        R32f = ((int)0X822e),
        Rg16f = ((int)0X822f),
        Rg32f = ((int)0X8230),
        R8i = ((int)0X8231),
        R8ui = ((int)0X8232),
        R16i = ((int)0X8233),
        R16ui = ((int)0X8234),
        R32i = ((int)0X8235),
        R32ui = ((int)0X8236),
        Rg8i = ((int)0X8237),
        Rg8ui = ((int)0X8238),
        Rg16i = ((int)0X8239),
        Rg16ui = ((int)0X823a),
        Rg32i = ((int)0X823b),
        Rg32ui = ((int)0X823c),
        DepthPassInstrumentSgix = ((int)0X8310),
        DepthPassInstrumentCountersSgix = ((int)0X8311),
        DepthPassInstrumentMaxSgix = ((int)0X8312),
        ConvolutionHintSgix = ((int)0X8316),
        YcrcbSgix = ((int)0X8318),
        YcrcbaSgix = ((int)0X8319),
        AlphaMinSgix = ((int)0X8320),
        AlphaMaxSgix = ((int)0X8321),
        ScalebiasHintSgix = ((int)0X8322),
        AsyncMarkerSgix = ((int)0X8329),
        PixelTexGenModeSgix = ((int)0X832b),
        AsyncHistogramSgix = ((int)0X832c),
        MaxAsyncHistogramSgix = ((int)0X832d),
        PixelTransform2DExt = ((int)0X8330),
        PixelMagFilterExt = ((int)0X8331),
        PixelMinFilterExt = ((int)0X8332),
        PixelCubicWeightExt = ((int)0X8333),
        CubicExt = ((int)0X8334),
        AverageExt = ((int)0X8335),
        PixelTransform2DStackDepthExt = ((int)0X8336),
        MaxPixelTransform2DStackDepthExt = ((int)0X8337),
        PixelTransform2DMatrixExt = ((int)0X8338),
        FragmentMaterialExt = ((int)0X8349),
        FragmentNormalExt = ((int)0X834a),
        FragmentColorExt = ((int)0X834c),
        AttenuationExt = ((int)0X834d),
        ShadowAttenuationExt = ((int)0X834e),
        TextureApplicationModeExt = ((int)0X834f),
        TextureLightExt = ((int)0X8350),
        TextureMaterialFaceExt = ((int)0X8351),
        TextureMaterialParameterExt = ((int)0X8352),
        PixelTextureSgis = ((int)0X8353),
        PixelFragmentRgbSourceSgis = ((int)0X8354),
        PixelFragmentAlphaSourceSgis = ((int)0X8355),
        PixelGroupColorSgis = ((int)0X8356),
        AsyncTexImageSgix = ((int)0X835c),
        AsyncDrawPixelsSgix = ((int)0X835d),
        AsyncReadPixelsSgix = ((int)0X835e),
        MaxAsyncTexImageSgix = ((int)0X835f),
        MaxAsyncDrawPixelsSgix = ((int)0X8360),
        MaxAsyncReadPixelsSgix = ((int)0X8361),
        UnsignedByte233Rev = ((int)0X8362),
        UnsignedByte233Reversed = ((int)0X8362),
        UnsignedByte233RevExt = ((int)0X8362),
        UnsignedShort565 = ((int)0X8363),
        UnsignedShort565Ext = ((int)0X8363),
        UnsignedShort565Rev = ((int)0X8364),
        UnsignedShort565Reversed = ((int)0X8364),
        UnsignedShort565RevExt = ((int)0X8364),
        UnsignedShort4444Rev = ((int)0X8365),
        UnsignedShort4444Reversed = ((int)0X8365),
        UnsignedShort4444RevExt = ((int)0X8365),
        UnsignedShort1555Rev = ((int)0X8366),
        UnsignedShort1555Reversed = ((int)0X8366),
        UnsignedShort1555RevExt = ((int)0X8366),
        UnsignedInt8888Rev = ((int)0X8367),
        UnsignedInt8888Reversed = ((int)0X8367),
        UnsignedInt8888RevExt = ((int)0X8367),
        UnsignedInt2101010Rev = ((int)0X8368),
        UnsignedInt2101010Reversed = ((int)0X8368),
        UnsignedInt2101010RevExt = ((int)0X8368),
        TextureMaxClampSSgix = ((int)0X8369),
        TextureMaxClampTSgix = ((int)0X836a),
        TextureMaxClampRSgix = ((int)0X836b),
        FogFactorToAlphaSgix = ((int)0X836f),
        MirroredRepeat = ((int)0X8370),
        MirroredRepeatArb = ((int)0X8370),
        MirroredRepeatIbm = ((int)0X8370),
        RgbS3tc = ((int)0X83a0),
        Rgb4S3tc = ((int)0X83a1),
        RgbaS3tc = ((int)0X83a2),
        Rgba4S3tc = ((int)0X83a3),
        VertexPreclipSgix = ((int)0X83ee),
        VertexPreclipHintSgix = ((int)0X83ef),
        CompressedRgbS3tcDxt1Ext = ((int)0X83f0),
        CompressedRgbaS3tcDxt1Ext = ((int)0X83f1),
        CompressedRgbaS3tcDxt3Ext = ((int)0X83f2),
        CompressedRgbaS3tcDxt5Ext = ((int)0X83f3),
        ParallelArraysIntel = ((int)0X83f4),
        VertexArrayParallelPointersIntel = ((int)0X83f5),
        NormalArrayParallelPointersIntel = ((int)0X83f6),
        ColorArrayParallelPointersIntel = ((int)0X83f7),
        TextureCoordArrayParallelPointersIntel = ((int)0X83f8),
        FragmentLightingSgix = ((int)0X8400),
        FragmentColorMaterialSgix = ((int)0X8401),
        FragmentColorMaterialFaceSgix = ((int)0X8402),
        FragmentColorMaterialParameterSgix = ((int)0X8403),
        MaxFragmentLightsSgix = ((int)0X8404),
        MaxActiveLightsSgix = ((int)0X8405),
        CurrentRasterNormalSgix = ((int)0X8406),
        LightEnvModeSgix = ((int)0X8407),
        FragmentLightModelLocalViewerSgix = ((int)0X8408),
        FragmentLightModelTwoSideSgix = ((int)0X8409),
        FragmentLightModelAmbientSgix = ((int)0X840a),
        FragmentLightModelNormalInterpolationSgix = ((int)0X840b),
        FragmentLight0Sgix = ((int)0X840c),
        FragmentLight1Sgix = ((int)0X840d),
        FragmentLight2Sgix = ((int)0X840e),
        FragmentLight3Sgix = ((int)0X840f),
        FragmentLight4Sgix = ((int)0X8410),
        FragmentLight5Sgix = ((int)0X8411),
        FragmentLight6Sgix = ((int)0X8412),
        FragmentLight7Sgix = ((int)0X8413),
        PackResampleSgix = ((int)0X842c),
        UnpackResampleSgix = ((int)0X842d),
        ResampleReplicateSgix = ((int)0X842e),
        ResampleZeroFillSgix = ((int)0X842f),
        ResampleDecimateSgix = ((int)0X8430),
        TangentArrayExt = ((int)0X8439),
        BinormalArrayExt = ((int)0X843a),
        CurrentTangentExt = ((int)0X843b),
        CurrentBinormalExt = ((int)0X843c),
        TangentArrayTypeExt = ((int)0X843e),
        TangentArrayStrideExt = ((int)0X843f),
        BinormalArrayTypeExt = ((int)0X8440),
        BinormalArrayStrideExt = ((int)0X8441),
        TangentArrayPointerExt = ((int)0X8442),
        BinormalArrayPointerExt = ((int)0X8443),
        Map1TangentExt = ((int)0X8444),
        Map2TangentExt = ((int)0X8445),
        Map1BinormalExt = ((int)0X8446),
        Map2BinormalExt = ((int)0X8447),
        NearestClipmapNearestSgix = ((int)0X844d),
        NearestClipmapLinearSgix = ((int)0X844e),
        LinearClipmapNearestSgix = ((int)0X844f),
        FogCoordinateSource = ((int)0X8450),
        FogCoordinateSourceExt = ((int)0X8450),
        FogCoordSrc = ((int)0X8450),
        FogCoord = ((int)0X8451),
        FogCoordinate = ((int)0X8451),
        FogCoordinateExt = ((int)0X8451),
        FragmentDepth = ((int)0X8452),
        FragmentDepthExt = ((int)0X8452),
        CurrentFogCoord = ((int)0X8453),
        CurrentFogCoordinate = ((int)0X8453),
        CurrentFogCoordinateExt = ((int)0X8453),
        FogCoordArrayType = ((int)0X8454),
        FogCoordinateArrayType = ((int)0X8454),
        FogCoordinateArrayTypeExt = ((int)0X8454),
        FogCoordArrayStride = ((int)0X8455),
        FogCoordinateArrayStride = ((int)0X8455),
        FogCoordinateArrayStrideExt = ((int)0X8455),
        FogCoordArrayPointer = ((int)0X8456),
        FogCoordinateArrayPointer = ((int)0X8456),
        FogCoordinateArrayPointerExt = ((int)0X8456),
        FogCoordArray = ((int)0X8457),
        FogCoordinateArray = ((int)0X8457),
        FogCoordinateArrayExt = ((int)0X8457),
        ColorSum = ((int)0X8458),
        ColorSumArb = ((int)0X8458),
        ColorSumExt = ((int)0X8458),
        CurrentSecondaryColor = ((int)0X8459),
        CurrentSecondaryColorExt = ((int)0X8459),
        SecondaryColorArraySize = ((int)0X845a),
        SecondaryColorArraySizeExt = ((int)0X845a),
        SecondaryColorArrayType = ((int)0X845b),
        SecondaryColorArrayTypeExt = ((int)0X845b),
        SecondaryColorArrayStride = ((int)0X845c),
        SecondaryColorArrayStrideExt = ((int)0X845c),
        SecondaryColorArrayPointer = ((int)0X845d),
        SecondaryColorArrayPointerExt = ((int)0X845d),
        SecondaryColorArray = ((int)0X845e),
        SecondaryColorArrayExt = ((int)0X845e),
        CurrentRasterSecondaryColor = ((int)0X845f),
        AliasedPointSizeRange = ((int)0X846d),
        AliasedLineWidthRange = ((int)0X846e),
        ScreenCoordinatesRend = ((int)0X8490),
        InvertedScreenWRend = ((int)0X8491),
        Texture0 = ((int)0X84c0),
        Texture0Arb = ((int)0X84c0),
        Texture1 = ((int)0X84c1),
        Texture1Arb = ((int)0X84c1),
        Texture2 = ((int)0X84c2),
        Texture2Arb = ((int)0X84c2),
        Texture3 = ((int)0X84c3),
        Texture3Arb = ((int)0X84c3),
        Texture4 = ((int)0X84c4),
        Texture4Arb = ((int)0X84c4),
        Texture5 = ((int)0X84c5),
        Texture5Arb = ((int)0X84c5),
        Texture6 = ((int)0X84c6),
        Texture6Arb = ((int)0X84c6),
        Texture7 = ((int)0X84c7),
        Texture7Arb = ((int)0X84c7),
        Texture8 = ((int)0X84c8),
        Texture8Arb = ((int)0X84c8),
        Texture9 = ((int)0X84c9),
        Texture9Arb = ((int)0X84c9),
        Texture10 = ((int)0X84ca),
        Texture10Arb = ((int)0X84ca),
        Texture11 = ((int)0X84cb),
        Texture11Arb = ((int)0X84cb),
        Texture12 = ((int)0X84cc),
        Texture12Arb = ((int)0X84cc),
        Texture13 = ((int)0X84cd),
        Texture13Arb = ((int)0X84cd),
        Texture14 = ((int)0X84ce),
        Texture14Arb = ((int)0X84ce),
        Texture15 = ((int)0X84cf),
        Texture15Arb = ((int)0X84cf),
        Texture16 = ((int)0X84d0),
        Texture16Arb = ((int)0X84d0),
        Texture17 = ((int)0X84d1),
        Texture17Arb = ((int)0X84d1),
        Texture18 = ((int)0X84d2),
        Texture18Arb = ((int)0X84d2),
        Texture19 = ((int)0X84d3),
        Texture19Arb = ((int)0X84d3),
        Texture20 = ((int)0X84d4),
        Texture20Arb = ((int)0X84d4),
        Texture21 = ((int)0X84d5),
        Texture21Arb = ((int)0X84d5),
        Texture22 = ((int)0X84d6),
        Texture22Arb = ((int)0X84d6),
        Texture23 = ((int)0X84d7),
        Texture23Arb = ((int)0X84d7),
        Texture24 = ((int)0X84d8),
        Texture24Arb = ((int)0X84d8),
        Texture25 = ((int)0X84d9),
        Texture25Arb = ((int)0X84d9),
        Texture26 = ((int)0X84da),
        Texture26Arb = ((int)0X84da),
        Texture27 = ((int)0X84db),
        Texture27Arb = ((int)0X84db),
        Texture28 = ((int)0X84dc),
        Texture28Arb = ((int)0X84dc),
        Texture29 = ((int)0X84dd),
        Texture29Arb = ((int)0X84dd),
        Texture30 = ((int)0X84de),
        Texture30Arb = ((int)0X84de),
        Texture31 = ((int)0X84df),
        Texture31Arb = ((int)0X84df),
        ActiveTexture = ((int)0X84e0),
        ActiveTextureArb = ((int)0X84e0),
        ClientActiveTexture = ((int)0X84e1),
        ClientActiveTextureArb = ((int)0X84e1),
        MaxTextureUnits = ((int)0X84e2),
        MaxTextureUnitsArb = ((int)0X84e2),
        TransposeModelviewMatrix = ((int)0X84e3),
        TransposeModelviewMatrixArb = ((int)0X84e3),
        TransposeProjectionMatrix = ((int)0X84e4),
        TransposeProjectionMatrixArb = ((int)0X84e4),
        TransposeTextureMatrix = ((int)0X84e5),
        TransposeTextureMatrixArb = ((int)0X84e5),
        TransposeColorMatrix = ((int)0X84e6),
        TransposeColorMatrixArb = ((int)0X84e6),
        Subtract = ((int)0X84e7),
        SubtractArb = ((int)0X84e7),
        MaxRenderbufferSize = ((int)0X84e8),
        MaxRenderbufferSizeExt = ((int)0X84e8),
        CompressedAlpha = ((int)0X84e9),
        CompressedAlphaArb = ((int)0X84e9),
        CompressedLuminance = ((int)0X84ea),
        CompressedLuminanceArb = ((int)0X84ea),
        CompressedLuminanceAlpha = ((int)0X84eb),
        CompressedLuminanceAlphaArb = ((int)0X84eb),
        CompressedIntensity = ((int)0X84ec),
        CompressedIntensityArb = ((int)0X84ec),
        CompressedRgb = ((int)0X84ed),
        CompressedRgbArb = ((int)0X84ed),
        CompressedRgba = ((int)0X84ee),
        CompressedRgbaArb = ((int)0X84ee),
        TextureCompressionHint = ((int)0X84ef),
        TextureCompressionHintArb = ((int)0X84ef),
        AllCompletedNv = ((int)0X84f2),
        FenceStatusNv = ((int)0X84f3),
        FenceConditionNv = ((int)0X84f4),
        TextureRectangle = ((int)0X84f5),
        TextureRectangleArb = ((int)0X84f5),
        TextureRectangleNv = ((int)0X84f5),
        TextureBindingRectangle = ((int)0X84f6),
        TextureBindingRectangleArb = ((int)0X84f6),
        TextureBindingRectangleNv = ((int)0X84f6),
        ProxyTextureRectangle = ((int)0X84f7),
        ProxyTextureRectangleArb = ((int)0X84f7),
        ProxyTextureRectangleNv = ((int)0X84f7),
        MaxRectangleTextureSize = ((int)0X84f8),
        MaxRectangleTextureSizeArb = ((int)0X84f8),
        MaxRectangleTextureSizeNv = ((int)0X84f8),
        DepthStencil = ((int)0X84f9),
        DepthStencilExt = ((int)0X84f9),
        DepthStencilNv = ((int)0X84f9),
        UnsignedInt248 = ((int)0X84fa),
        UnsignedInt248Ext = ((int)0X84fa),
        UnsignedInt248Nv = ((int)0X84fa),
        MaxTextureLodBias = ((int)0X84fd),
        MaxTextureLodBiasExt = ((int)0X84fd),
        TextureMaxAnisotropyExt = ((int)0X84fe),
        MaxTextureMaxAnisotropyExt = ((int)0X84ff),
        TextureFilterControl = ((int)0X8500),
        TextureFilterControlExt = ((int)0X8500),
        TextureLodBias = ((int)0X8501),
        TextureLodBiasExt = ((int)0X8501),
        Modelview1StackDepthExt = ((int)0X8502),
        Combine4Nv = ((int)0X8503),
        MaxShininessNv = ((int)0X8504),
        MaxSpotExponentNv = ((int)0X8505),
        Modelview1MatrixExt = ((int)0X8506),
        IncrWrap = ((int)0X8507),
        IncrWrapExt = ((int)0X8507),
        DecrWrap = ((int)0X8508),
        DecrWrapExt = ((int)0X8508),
        VertexWeightingExt = ((int)0X8509),
        Modelview1Arb = ((int)0X850a),
        Modelview1Ext = ((int)0X850a),
        CurrentVertexWeightExt = ((int)0X850b),
        VertexWeightArrayExt = ((int)0X850c),
        VertexWeightArraySizeExt = ((int)0X850d),
        VertexWeightArrayTypeExt = ((int)0X850e),
        VertexWeightArrayStrideExt = ((int)0X850f),
        VertexWeightArrayPointerExt = ((int)0X8510),
        NormalMap = ((int)0X8511),
        NormalMapArb = ((int)0X8511),
        NormalMapExt = ((int)0X8511),
        NormalMapNv = ((int)0X8511),
        ReflectionMap = ((int)0X8512),
        ReflectionMapArb = ((int)0X8512),
        ReflectionMapExt = ((int)0X8512),
        ReflectionMapNv = ((int)0X8512),
        TextureCubeMap = ((int)0X8513),
        TextureCubeMapArb = ((int)0X8513),
        TextureCubeMapExt = ((int)0X8513),
        TextureBindingCubeMap = ((int)0X8514),
        TextureBindingCubeMapArb = ((int)0X8514),
        TextureBindingCubeMapExt = ((int)0X8514),
        TextureCubeMapPositiveX = ((int)0X8515),
        TextureCubeMapPositiveXArb = ((int)0X8515),
        TextureCubeMapPositiveXExt = ((int)0X8515),
        TextureCubeMapNegativeX = ((int)0X8516),
        TextureCubeMapNegativeXArb = ((int)0X8516),
        TextureCubeMapNegativeXExt = ((int)0X8516),
        TextureCubeMapPositiveY = ((int)0X8517),
        TextureCubeMapPositiveYArb = ((int)0X8517),
        TextureCubeMapPositiveYExt = ((int)0X8517),
        TextureCubeMapNegativeY = ((int)0X8518),
        TextureCubeMapNegativeYArb = ((int)0X8518),
        TextureCubeMapNegativeYExt = ((int)0X8518),
        TextureCubeMapPositiveZ = ((int)0X8519),
        TextureCubeMapPositiveZArb = ((int)0X8519),
        TextureCubeMapPositiveZExt = ((int)0X8519),
        TextureCubeMapNegativeZ = ((int)0X851a),
        TextureCubeMapNegativeZArb = ((int)0X851a),
        TextureCubeMapNegativeZExt = ((int)0X851a),
        ProxyTextureCubeMap = ((int)0X851b),
        ProxyTextureCubeMapArb = ((int)0X851b),
        ProxyTextureCubeMapExt = ((int)0X851b),
        MaxCubeMapTextureSize = ((int)0X851c),
        MaxCubeMapTextureSizeArb = ((int)0X851c),
        MaxCubeMapTextureSizeExt = ((int)0X851c),
        VertexArrayRangeApple = ((int)0X851d),
        VertexArrayRangeNv = ((int)0X851d),
        VertexArrayRangeLengthApple = ((int)0X851e),
        VertexArrayRangeLengthNv = ((int)0X851e),
        VertexArrayRangeValidNv = ((int)0X851f),
        VertexArrayStorageHintApple = ((int)0X851f),
        MaxVertexArrayRangeElementNv = ((int)0X8520),
        VertexArrayRangePointerApple = ((int)0X8521),
        VertexArrayRangePointerNv = ((int)0X8521),
        RegisterCombinersNv = ((int)0X8522),
        VariableANv = ((int)0X8523),
        VariableBNv = ((int)0X8524),
        VariableCNv = ((int)0X8525),
        VariableDNv = ((int)0X8526),
        VariableENv = ((int)0X8527),
        VariableFNv = ((int)0X8528),
        VariableGNv = ((int)0X8529),
        ConstantColor0Nv = ((int)0X852a),
        ConstantColor1Nv = ((int)0X852b),
        PrimaryColorNv = ((int)0X852c),
        SecondaryColorNv = ((int)0X852d),
        Spare0Nv = ((int)0X852e),
        Spare1Nv = ((int)0X852f),
        DiscardNv = ((int)0X8530),
        ETimesFNv = ((int)0X8531),
        Spare0PlusSecondaryColorNv = ((int)0X8532),
        VertexArrayRangeWithoutFlushNv = ((int)0X8533),
        MultisampleFilterHintNv = ((int)0X8534),
        PerStageConstantsNv = ((int)0X8535),
        UnsignedIdentityNv = ((int)0X8536),
        UnsignedInvertNv = ((int)0X8537),
        ExpandNormalNv = ((int)0X8538),
        ExpandNegateNv = ((int)0X8539),
        HalfBiasNormalNv = ((int)0X853a),
        HalfBiasNegateNv = ((int)0X853b),
        SignedIdentityNv = ((int)0X853c),
        SignedNegateNv = ((int)0X853d),
        ScaleByTwoNv = ((int)0X853e),
        ScaleByFourNv = ((int)0X853f),
        ScaleByOneHalfNv = ((int)0X8540),
        BiasByNegativeOneHalfNv = ((int)0X8541),
        CombinerInputNv = ((int)0X8542),
        CombinerMappingNv = ((int)0X8543),
        CombinerComponentUsageNv = ((int)0X8544),
        CombinerAbDotProductNv = ((int)0X8545),
        CombinerCdDotProductNv = ((int)0X8546),
        CombinerMuxSumNv = ((int)0X8547),
        CombinerScaleNv = ((int)0X8548),
        CombinerBiasNv = ((int)0X8549),
        CombinerAbOutputNv = ((int)0X854a),
        CombinerCdOutputNv = ((int)0X854b),
        CombinerSumOutputNv = ((int)0X854c),
        MaxGeneralCombinersNv = ((int)0X854d),
        NumGeneralCombinersNv = ((int)0X854e),
        ColorSumClampNv = ((int)0X854f),
        Combiner0Nv = ((int)0X8550),
        Combiner1Nv = ((int)0X8551),
        Combiner2Nv = ((int)0X8552),
        Combiner3Nv = ((int)0X8553),
        Combiner4Nv = ((int)0X8554),
        Combiner5Nv = ((int)0X8555),
        Combiner6Nv = ((int)0X8556),
        Combiner7Nv = ((int)0X8557),
        PrimitiveRestartNv = ((int)0X8558),
        PrimitiveRestartIndexNv = ((int)0X8559),
        FogDistanceModeNv = ((int)0X855a),
        EyeRadialNv = ((int)0X855b),
        EyePlaneAbsoluteNv = ((int)0X855c),
        EmbossLightNv = ((int)0X855d),
        EmbossConstantNv = ((int)0X855e),
        EmbossMapNv = ((int)0X855f),
        RedMinClampIngr = ((int)0X8560),
        GreenMinClampIngr = ((int)0X8561),
        BlueMinClampIngr = ((int)0X8562),
        AlphaMinClampIngr = ((int)0X8563),
        RedMaxClampIngr = ((int)0X8564),
        GreenMaxClampIngr = ((int)0X8565),
        BlueMaxClampIngr = ((int)0X8566),
        AlphaMaxClampIngr = ((int)0X8567),
        InterlaceReadIngr = ((int)0X8568),
        Combine = ((int)0X8570),
        CombineArb = ((int)0X8570),
        CombineExt = ((int)0X8570),
        CombineRgb = ((int)0X8571),
        CombineRgbArb = ((int)0X8571),
        CombineRgbExt = ((int)0X8571),
        CombineAlpha = ((int)0X8572),
        CombineAlphaArb = ((int)0X8572),
        CombineAlphaExt = ((int)0X8572),
        RgbScale = ((int)0X8573),
        RgbScaleArb = ((int)0X8573),
        RgbScaleExt = ((int)0X8573),
        AddSigned = ((int)0X8574),
        AddSignedArb = ((int)0X8574),
        AddSignedExt = ((int)0X8574),
        Interpolate = ((int)0X8575),
        InterpolateArb = ((int)0X8575),
        InterpolateExt = ((int)0X8575),
        Constant = ((int)0X8576),
        ConstantArb = ((int)0X8576),
        ConstantExt = ((int)0X8576),
        PrimaryColor = ((int)0X8577),
        PrimaryColorArb = ((int)0X8577),
        PrimaryColorExt = ((int)0X8577),
        Previous = ((int)0X8578),
        PreviousArb = ((int)0X8578),
        PreviousExt = ((int)0X8578),
        Source0Rgb = ((int)0X8580),
        Source0RgbArb = ((int)0X8580),
        Source0RgbExt = ((int)0X8580),
        Src0Rgb = ((int)0X8580),
        Source1Rgb = ((int)0X8581),
        Source1RgbArb = ((int)0X8581),
        Source1RgbExt = ((int)0X8581),
        Src1Rgb = ((int)0X8581),
        Source2Rgb = ((int)0X8582),
        Source2RgbArb = ((int)0X8582),
        Source2RgbExt = ((int)0X8582),
        Src2Rgb = ((int)0X8582),
        Source3RgbNv = ((int)0X8583),
        Source0Alpha = ((int)0X8588),
        Source0AlphaArb = ((int)0X8588),
        Source0AlphaExt = ((int)0X8588),
        Src0Alpha = ((int)0X8588),
        Source1Alpha = ((int)0X8589),
        Source1AlphaArb = ((int)0X8589),
        Source1AlphaExt = ((int)0X8589),
        Src1Alpha = ((int)0X8589),
        Source2Alpha = ((int)0X858a),
        Source2AlphaArb = ((int)0X858a),
        Source2AlphaExt = ((int)0X858a),
        Src2Alpha = ((int)0X858a),
        Source3AlphaNv = ((int)0X858b),
        Operand0Rgb = ((int)0X8590),
        Operand0RgbArb = ((int)0X8590),
        Operand0RgbExt = ((int)0X8590),
        Operand1Rgb = ((int)0X8591),
        Operand1RgbArb = ((int)0X8591),
        Operand1RgbExt = ((int)0X8591),
        Operand2Rgb = ((int)0X8592),
        Operand2RgbArb = ((int)0X8592),
        Operand2RgbExt = ((int)0X8592),
        Operand3RgbNv = ((int)0X8593),
        Operand0Alpha = ((int)0X8598),
        Operand0AlphaArb = ((int)0X8598),
        Operand0AlphaExt = ((int)0X8598),
        Operand1Alpha = ((int)0X8599),
        Operand1AlphaArb = ((int)0X8599),
        Operand1AlphaExt = ((int)0X8599),
        Operand2Alpha = ((int)0X859a),
        Operand2AlphaArb = ((int)0X859a),
        Operand2AlphaExt = ((int)0X859a),
        Operand3AlphaNv = ((int)0X859b),
        PackSubsampleRateSgix = ((int)0X85a0),
        UnpackSubsampleRateSgix = ((int)0X85a1),
        PixelSubsample4444Sgix = ((int)0X85a2),
        PixelSubsample2424Sgix = ((int)0X85a3),
        PixelSubsample4242Sgix = ((int)0X85a4),
        PerturbExt = ((int)0X85ae),
        TextureNormalExt = ((int)0X85af),
        LightModelSpecularVectorApple = ((int)0X85b0),
        TransformHintApple = ((int)0X85b1),
        UnpackClientStorageApple = ((int)0X85b2),
        BufferObjectApple = ((int)0X85b3),
        VertexArrayBinding = ((int)0X85b5),
        VertexArrayBindingApple = ((int)0X85b5),
        TextureRangeLengthApple = ((int)0X85b7),
        TextureRangePointerApple = ((int)0X85b8),
        Ycbcr422Apple = ((int)0X85b9),
        UnsignedShort88Apple = ((int)0X85ba),
        UnsignedShort88Mesa = ((int)0X85ba),
        UnsignedShort88RevApple = ((int)0X85bb),
        UnsignedShort88RevMesa = ((int)0X85bb),
        TextureStorageHintApple = ((int)0X85bc),
        StoragePrivateApple = ((int)0X85bd),
        StorageCachedApple = ((int)0X85be),
        StorageSharedApple = ((int)0X85bf),
        ReplacementCodeArraySun = ((int)0X85c0),
        ReplacementCodeArrayTypeSun = ((int)0X85c1),
        ReplacementCodeArrayStrideSun = ((int)0X85c2),
        ReplacementCodeArrayPointerSun = ((int)0X85c3),
        R1uiV3fSun = ((int)0X85c4),
        R1uiC4ubV3fSun = ((int)0X85c5),
        R1uiC3fV3fSun = ((int)0X85c6),
        R1uiN3fV3fSun = ((int)0X85c7),
        R1uiC4fN3fV3fSun = ((int)0X85c8),
        R1uiT2fV3fSun = ((int)0X85c9),
        R1uiT2fN3fV3fSun = ((int)0X85ca),
        R1uiT2fC4fN3fV3fSun = ((int)0X85cb),
        SliceAccumSun = ((int)0X85cc),
        QuadMeshSun = ((int)0X8614),
        TriangleMeshSun = ((int)0X8615),
        VertexProgram = ((int)0X8620),
        VertexProgramArb = ((int)0X8620),
        VertexProgramNv = ((int)0X8620),
        VertexStateProgramNv = ((int)0X8621),
        ArrayEnabled = ((int)0X8622),
        VertexAttribArrayEnabled = ((int)0X8622),
        VertexAttribArrayEnabledArb = ((int)0X8622),
        ArraySize = ((int)0X8623),
        AttribArraySizeNv = ((int)0X8623),
        VertexAttribArraySize = ((int)0X8623),
        VertexAttribArraySizeArb = ((int)0X8623),
        ArrayStride = ((int)0X8624),
        AttribArrayStrideNv = ((int)0X8624),
        VertexAttribArrayStride = ((int)0X8624),
        VertexAttribArrayStrideArb = ((int)0X8624),
        ArrayType = ((int)0X8625),
        AttribArrayTypeNv = ((int)0X8625),
        VertexAttribArrayType = ((int)0X8625),
        VertexAttribArrayTypeArb = ((int)0X8625),
        CurrentAttribNv = ((int)0X8626),
        CurrentVertexAttrib = ((int)0X8626),
        CurrentVertexAttribArb = ((int)0X8626),
        ProgramLength = ((int)0X8627),
        ProgramLengthArb = ((int)0X8627),
        ProgramLengthNv = ((int)0X8627),
        ProgramString = ((int)0X8628),
        ProgramStringArb = ((int)0X8628),
        ProgramStringNv = ((int)0X8628),
        ModelviewProjectionNv = ((int)0X8629),
        IdentityNv = ((int)0X862a),
        InverseNv = ((int)0X862b),
        TransposeNv = ((int)0X862c),
        InverseTransposeNv = ((int)0X862d),
        MaxProgramMatrixStackDepthArb = ((int)0X862e),
        MaxTrackMatrixStackDepthNv = ((int)0X862e),
        MaxProgramMatricesArb = ((int)0X862f),
        MaxTrackMatricesNv = ((int)0X862f),
        Matrix0Nv = ((int)0X8630),
        Matrix1Nv = ((int)0X8631),
        Matrix2Nv = ((int)0X8632),
        Matrix3Nv = ((int)0X8633),
        Matrix4Nv = ((int)0X8634),
        Matrix5Nv = ((int)0X8635),
        Matrix6Nv = ((int)0X8636),
        Matrix7Nv = ((int)0X8637),
        CurrentMatrixStackDepthArb = ((int)0X8640),
        CurrentMatrixStackDepthNv = ((int)0X8640),
        CurrentMatrixArb = ((int)0X8641),
        CurrentMatrixNv = ((int)0X8641),
        ProgramPointSize = ((int)0X8642),
        ProgramPointSizeArb = ((int)0X8642),
        ProgramPointSizeExt = ((int)0X8642),
        VertexProgramPointSize = ((int)0X8642),
        VertexProgramPointSizeArb = ((int)0X8642),
        VertexProgramPointSizeNv = ((int)0X8642),
        VertexProgramTwoSide = ((int)0X8643),
        VertexProgramTwoSideArb = ((int)0X8643),
        VertexProgramTwoSideNv = ((int)0X8643),
        ProgramParameterNv = ((int)0X8644),
        ArrayPointer = ((int)0X8645),
        AttribArrayPointerNv = ((int)0X8645),
        VertexAttribArrayPointer = ((int)0X8645),
        VertexAttribArrayPointerArb = ((int)0X8645),
        ProgramTargetNv = ((int)0X8646),
        ProgramResidentNv = ((int)0X8647),
        TrackMatrixNv = ((int)0X8648),
        TrackMatrixTransformNv = ((int)0X8649),
        VertexProgramBindingNv = ((int)0X864a),
        ProgramErrorPositionArb = ((int)0X864b),
        ProgramErrorPositionNv = ((int)0X864b),
        OffsetTextureRectangleNv = ((int)0X864c),
        OffsetTextureRectangleScaleNv = ((int)0X864d),
        DotProductTextureRectangleNv = ((int)0X864e),
        DepthClamp = ((int)0X864f),
        DepthClampNv = ((int)0X864f),
        VertexAttribArray0Nv = ((int)0X8650),
        VertexAttribArray1Nv = ((int)0X8651),
        VertexAttribArray2Nv = ((int)0X8652),
        VertexAttribArray3Nv = ((int)0X8653),
        VertexAttribArray4Nv = ((int)0X8654),
        VertexAttribArray5Nv = ((int)0X8655),
        VertexAttribArray6Nv = ((int)0X8656),
        VertexAttribArray7Nv = ((int)0X8657),
        VertexAttribArray8Nv = ((int)0X8658),
        VertexAttribArray9Nv = ((int)0X8659),
        VertexAttribArray10Nv = ((int)0X865a),
        VertexAttribArray11Nv = ((int)0X865b),
        VertexAttribArray12Nv = ((int)0X865c),
        VertexAttribArray13Nv = ((int)0X865d),
        VertexAttribArray14Nv = ((int)0X865e),
        VertexAttribArray15Nv = ((int)0X865f),
        Map1VertexAttrib04Nv = ((int)0X8660),
        Map1VertexAttrib14Nv = ((int)0X8661),
        Map1VertexAttrib24Nv = ((int)0X8662),
        Map1VertexAttrib34Nv = ((int)0X8663),
        Map1VertexAttrib44Nv = ((int)0X8664),
        Map1VertexAttrib54Nv = ((int)0X8665),
        Map1VertexAttrib64Nv = ((int)0X8666),
        Map1VertexAttrib74Nv = ((int)0X8667),
        Map1VertexAttrib84Nv = ((int)0X8668),
        Map1VertexAttrib94Nv = ((int)0X8669),
        Map1VertexAttrib104Nv = ((int)0X866a),
        Map1VertexAttrib114Nv = ((int)0X866b),
        Map1VertexAttrib124Nv = ((int)0X866c),
        Map1VertexAttrib134Nv = ((int)0X866d),
        Map1VertexAttrib144Nv = ((int)0X866e),
        Map1VertexAttrib154Nv = ((int)0X866f),
        Map2VertexAttrib04Nv = ((int)0X8670),
        Map2VertexAttrib14Nv = ((int)0X8671),
        Map2VertexAttrib24Nv = ((int)0X8672),
        Map2VertexAttrib34Nv = ((int)0X8673),
        Map2VertexAttrib44Nv = ((int)0X8674),
        Map2VertexAttrib54Nv = ((int)0X8675),
        Map2VertexAttrib64Nv = ((int)0X8676),
        Map2VertexAttrib74Nv = ((int)0X8677),
        ProgramBinding = ((int)0X8677),
        ProgramBindingArb = ((int)0X8677),
        Map2VertexAttrib84Nv = ((int)0X8678),
        Map2VertexAttrib94Nv = ((int)0X8679),
        Map2VertexAttrib104Nv = ((int)0X867a),
        Map2VertexAttrib114Nv = ((int)0X867b),
        Map2VertexAttrib124Nv = ((int)0X867c),
        Map2VertexAttrib134Nv = ((int)0X867d),
        Map2VertexAttrib144Nv = ((int)0X867e),
        Map2VertexAttrib154Nv = ((int)0X867f),
        TextureCompressedImageSize = ((int)0X86a0),
        TextureCompressedImageSizeArb = ((int)0X86a0),
        TextureCompressed = ((int)0X86a1),
        TextureCompressedArb = ((int)0X86a1),
        NumCompressedTextureFormats = ((int)0X86a2),
        NumCompressedTextureFormatsArb = ((int)0X86a2),
        CompressedTextureFormats = ((int)0X86a3),
        CompressedTextureFormatsArb = ((int)0X86a3),
        MaxVertexUnitsArb = ((int)0X86a4),
        ActiveVertexUnitsArb = ((int)0X86a5),
        WeightSumUnityArb = ((int)0X86a6),
        VertexBlendArb = ((int)0X86a7),
        CurrentWeightArb = ((int)0X86a8),
        WeightArrayTypeArb = ((int)0X86a9),
        WeightArrayStrideArb = ((int)0X86aa),
        WeightArraySizeArb = ((int)0X86ab),
        WeightArrayPointerArb = ((int)0X86ac),
        WeightArrayArb = ((int)0X86ad),
        Dot3Rgb = ((int)0X86ae),
        Dot3RgbArb = ((int)0X86ae),
        Dot3Rgba = ((int)0X86af),
        Dot3RgbaArb = ((int)0X86af),
        CompressedRgbFxt13Dfx = ((int)0X86b0),
        CompressedRgbaFxt13Dfx = ((int)0X86b1),
        Multisample3Dfx = ((int)0X86b2),
        SampleBuffers3Dfx = ((int)0X86b3),
        Samples3Dfx = ((int)0X86b4),
        Eval2DNv = ((int)0X86c0),
        EvalTriangular2DNv = ((int)0X86c1),
        MapTessellationNv = ((int)0X86c2),
        MapAttribUOrderNv = ((int)0X86c3),
        MapAttribVOrderNv = ((int)0X86c4),
        EvalFractionalTessellationNv = ((int)0X86c5),
        EvalVertexAttrib0Nv = ((int)0X86c6),
        EvalVertexAttrib1Nv = ((int)0X86c7),
        EvalVertexAttrib2Nv = ((int)0X86c8),
        EvalVertexAttrib3Nv = ((int)0X86c9),
        EvalVertexAttrib4Nv = ((int)0X86ca),
        EvalVertexAttrib5Nv = ((int)0X86cb),
        EvalVertexAttrib6Nv = ((int)0X86cc),
        EvalVertexAttrib7Nv = ((int)0X86cd),
        EvalVertexAttrib8Nv = ((int)0X86ce),
        EvalVertexAttrib9Nv = ((int)0X86cf),
        EvalVertexAttrib10Nv = ((int)0X86d0),
        EvalVertexAttrib11Nv = ((int)0X86d1),
        EvalVertexAttrib12Nv = ((int)0X86d2),
        EvalVertexAttrib13Nv = ((int)0X86d3),
        EvalVertexAttrib14Nv = ((int)0X86d4),
        EvalVertexAttrib15Nv = ((int)0X86d5),
        MaxMapTessellationNv = ((int)0X86d6),
        MaxRationalEvalOrderNv = ((int)0X86d7),
        RgbaUnsignedDotProductMappingNv = ((int)0X86d9),
        UnsignedIntS8S888Nv = ((int)0X86da),
        UnsignedInt88S8S8RevNv = ((int)0X86db),
        DsdtMagIntensityNv = ((int)0X86dc),
        ShaderConsistentNv = ((int)0X86dd),
        TextureShaderNv = ((int)0X86de),
        ShaderOperationNv = ((int)0X86df),
        CullModesNv = ((int)0X86e0),
        OffsetTexture2DMatrixNv = ((int)0X86e1),
        OffsetTextureMatrixNv = ((int)0X86e1),
        OffsetTexture2DScaleNv = ((int)0X86e2),
        OffsetTextureScaleNv = ((int)0X86e2),
        OffsetTexture2DBiasNv = ((int)0X86e3),
        OffsetTextureBiasNv = ((int)0X86e3),
        PreviousTextureInputNv = ((int)0X86e4),
        ConstEyeNv = ((int)0X86e5),
        PassThroughNv = ((int)0X86e6),
        CullFragmentNv = ((int)0X86e7),
        OffsetTexture2DNv = ((int)0X86e8),
        DependentArTexture2DNv = ((int)0X86e9),
        DependentGbTexture2DNv = ((int)0X86ea),
        DotProductNv = ((int)0X86ec),
        DotProductDepthReplaceNv = ((int)0X86ed),
        DotProductTexture2DNv = ((int)0X86ee),
        DotProductTexture3DNv = ((int)0X86ef),
        DotProductTextureCubeMapNv = ((int)0X86f0),
        DotProductDiffuseCubeMapNv = ((int)0X86f1),
        DotProductReflectCubeMapNv = ((int)0X86f2),
        DotProductConstEyeReflectCubeMapNv = ((int)0X86f3),
        HiloNv = ((int)0X86f4),
        DsdtNv = ((int)0X86f5),
        DsdtMagNv = ((int)0X86f6),
        DsdtMagVibNv = ((int)0X86f7),
        Hilo16Nv = ((int)0X86f8),
        SignedHiloNv = ((int)0X86f9),
        SignedHilo16Nv = ((int)0X86fa),
        SignedRgbaNv = ((int)0X86fb),
        SignedRgba8Nv = ((int)0X86fc),
        SignedRgbNv = ((int)0X86fe),
        SignedRgb8Nv = ((int)0X86ff),
        SignedLuminanceNv = ((int)0X8701),
        SignedLuminance8Nv = ((int)0X8702),
        SignedLuminanceAlphaNv = ((int)0X8703),
        SignedLuminance8Alpha8Nv = ((int)0X8704),
        SignedAlphaNv = ((int)0X8705),
        SignedAlpha8Nv = ((int)0X8706),
        SignedIntensityNv = ((int)0X8707),
        SignedIntensity8Nv = ((int)0X8708),
        Dsdt8Nv = ((int)0X8709),
        Dsdt8Mag8Nv = ((int)0X870a),
        Dsdt8Mag8Intensity8Nv = ((int)0X870b),
        SignedRgbUnsignedAlphaNv = ((int)0X870c),
        SignedRgb8UnsignedAlpha8Nv = ((int)0X870d),
        HiScaleNv = ((int)0X870e),
        LoScaleNv = ((int)0X870f),
        DsScaleNv = ((int)0X8710),
        DtScaleNv = ((int)0X8711),
        MagnitudeScaleNv = ((int)0X8712),
        VibranceScaleNv = ((int)0X8713),
        HiBiasNv = ((int)0X8714),
        LoBiasNv = ((int)0X8715),
        DsBiasNv = ((int)0X8716),
        DtBiasNv = ((int)0X8717),
        MagnitudeBiasNv = ((int)0X8718),
        VibranceBiasNv = ((int)0X8719),
        TextureBorderValuesNv = ((int)0X871a),
        TextureHiSizeNv = ((int)0X871b),
        TextureLoSizeNv = ((int)0X871c),
        TextureDsSizeNv = ((int)0X871d),
        TextureDtSizeNv = ((int)0X871e),
        TextureMagSizeNv = ((int)0X871f),
        Modelview2Arb = ((int)0X8722),
        Modelview3Arb = ((int)0X8723),
        Modelview4Arb = ((int)0X8724),
        Modelview5Arb = ((int)0X8725),
        Modelview6Arb = ((int)0X8726),
        Modelview7Arb = ((int)0X8727),
        Modelview8Arb = ((int)0X8728),
        Modelview9Arb = ((int)0X8729),
        Modelview10Arb = ((int)0X872a),
        Modelview11Arb = ((int)0X872b),
        Modelview12Arb = ((int)0X872c),
        Modelview13Arb = ((int)0X872d),
        Modelview14Arb = ((int)0X872e),
        Modelview15Arb = ((int)0X872f),
        Modelview16Arb = ((int)0X8730),
        Modelview17Arb = ((int)0X8731),
        Modelview18Arb = ((int)0X8732),
        Modelview19Arb = ((int)0X8733),
        Modelview20Arb = ((int)0X8734),
        Modelview21Arb = ((int)0X8735),
        Modelview22Arb = ((int)0X8736),
        Modelview23Arb = ((int)0X8737),
        Modelview24Arb = ((int)0X8738),
        Modelview25Arb = ((int)0X8739),
        Modelview26Arb = ((int)0X873a),
        Modelview27Arb = ((int)0X873b),
        Modelview28Arb = ((int)0X873c),
        Modelview29Arb = ((int)0X873d),
        Modelview30Arb = ((int)0X873e),
        Modelview31Arb = ((int)0X873f),
        Dot3RgbExt = ((int)0X8740),
        Dot3RgbaExt = ((int)0X8741),
        MirrorClampAti = ((int)0X8742),
        MirrorClampExt = ((int)0X8742),
        MirrorClampToEdgeAti = ((int)0X8743),
        MirrorClampToEdgeExt = ((int)0X8743),
        ModulateAddAti = ((int)0X8744),
        ModulateSignedAddAti = ((int)0X8745),
        ModulateSubtractAti = ((int)0X8746),
        YcbcrMesa = ((int)0X8757),
        PackInvertMesa = ((int)0X8758),
        Texture1DStackMesax = ((int)0X8759),
        Texture2DStackMesax = ((int)0X875a),
        ProxyTexture1DStackMesax = ((int)0X875b),
        ProxyTexture2DStackMesax = ((int)0X875c),
        Texture1DStackBindingMesax = ((int)0X875d),
        Texture2DStackBindingMesax = ((int)0X875e),
        StaticAti = ((int)0X8760),
        DynamicAti = ((int)0X8761),
        PreserveAti = ((int)0X8762),
        DiscardAti = ((int)0X8763),
        BufferSize = ((int)0X8764),
        BufferSizeArb = ((int)0X8764),
        ObjectBufferSizeAti = ((int)0X8764),
        BufferUsage = ((int)0X8765),
        BufferUsageArb = ((int)0X8765),
        ObjectBufferUsageAti = ((int)0X8765),
        ArrayObjectBufferAti = ((int)0X8766),
        ArrayObjectOffsetAti = ((int)0X8767),
        ElementArrayApple = ((int)0X8768),
        ElementArrayAti = ((int)0X8768),
        ElementArrayTypeApple = ((int)0X8769),
        ElementArrayTypeAti = ((int)0X8769),
        ElementArrayPointerApple = ((int)0X876a),
        ElementArrayPointerAti = ((int)0X876a),
        MaxVertexStreamsAti = ((int)0X876b),
        VertexStream0Ati = ((int)0X876c),
        VertexStream1Ati = ((int)0X876d),
        VertexStream2Ati = ((int)0X876e),
        VertexStream3Ati = ((int)0X876f),
        VertexStream4Ati = ((int)0X8770),
        VertexStream5Ati = ((int)0X8771),
        VertexStream6Ati = ((int)0X8772),
        VertexStream7Ati = ((int)0X8773),
        VertexSourceAti = ((int)0X8774),
        BumpRotMatrixAti = ((int)0X8775),
        BumpRotMatrixSizeAti = ((int)0X8776),
        BumpNumTexUnitsAti = ((int)0X8777),
        BumpTexUnitsAti = ((int)0X8778),
        DudvAti = ((int)0X8779),
        Du8dv8Ati = ((int)0X877a),
        BumpEnvmapAti = ((int)0X877b),
        BumpTargetAti = ((int)0X877c),
        VertexShaderExt = ((int)0X8780),
        VertexShaderBindingExt = ((int)0X8781),
        OpIndexExt = ((int)0X8782),
        OpNegateExt = ((int)0X8783),
        OpDot3Ext = ((int)0X8784),
        OpDot4Ext = ((int)0X8785),
        OpMulExt = ((int)0X8786),
        OpAddExt = ((int)0X8787),
        OpMaddExt = ((int)0X8788),
        OpFracExt = ((int)0X8789),
        OpMaxExt = ((int)0X878a),
        OpMinExt = ((int)0X878b),
        OpSetGeExt = ((int)0X878c),
        OpSetLtExt = ((int)0X878d),
        OpClampExt = ((int)0X878e),
        OpFloorExt = ((int)0X878f),
        OpRoundExt = ((int)0X8790),
        OpExpBase2Ext = ((int)0X8791),
        OpLogBase2Ext = ((int)0X8792),
        OpPowerExt = ((int)0X8793),
        OpRecipExt = ((int)0X8794),
        OpRecipSqrtExt = ((int)0X8795),
        OpSubExt = ((int)0X8796),
        OpCrossProductExt = ((int)0X8797),
        OpMultiplyMatrixExt = ((int)0X8798),
        OpMovExt = ((int)0X8799),
        OutputVertexExt = ((int)0X879a),
        OutputColor0Ext = ((int)0X879b),
        OutputColor1Ext = ((int)0X879c),
        OutputTextureCoord0Ext = ((int)0X879d),
        OutputTextureCoord1Ext = ((int)0X879e),
        OutputTextureCoord2Ext = ((int)0X879f),
        OutputTextureCoord3Ext = ((int)0X87a0),
        OutputTextureCoord4Ext = ((int)0X87a1),
        OutputTextureCoord5Ext = ((int)0X87a2),
        OutputTextureCoord6Ext = ((int)0X87a3),
        OutputTextureCoord7Ext = ((int)0X87a4),
        OutputTextureCoord8Ext = ((int)0X87a5),
        OutputTextureCoord9Ext = ((int)0X87a6),
        OutputTextureCoord10Ext = ((int)0X87a7),
        OutputTextureCoord11Ext = ((int)0X87a8),
        OutputTextureCoord12Ext = ((int)0X87a9),
        OutputTextureCoord13Ext = ((int)0X87aa),
        OutputTextureCoord14Ext = ((int)0X87ab),
        OutputTextureCoord15Ext = ((int)0X87ac),
        OutputTextureCoord16Ext = ((int)0X87ad),
        OutputTextureCoord17Ext = ((int)0X87ae),
        OutputTextureCoord18Ext = ((int)0X87af),
        OutputTextureCoord19Ext = ((int)0X87b0),
        OutputTextureCoord20Ext = ((int)0X87b1),
        OutputTextureCoord21Ext = ((int)0X87b2),
        OutputTextureCoord22Ext = ((int)0X87b3),
        OutputTextureCoord23Ext = ((int)0X87b4),
        OutputTextureCoord24Ext = ((int)0X87b5),
        OutputTextureCoord25Ext = ((int)0X87b6),
        OutputTextureCoord26Ext = ((int)0X87b7),
        OutputTextureCoord27Ext = ((int)0X87b8),
        OutputTextureCoord28Ext = ((int)0X87b9),
        OutputTextureCoord29Ext = ((int)0X87ba),
        OutputTextureCoord30Ext = ((int)0X87bb),
        OutputTextureCoord31Ext = ((int)0X87bc),
        OutputFogExt = ((int)0X87bd),
        ScalarExt = ((int)0X87be),
        VectorExt = ((int)0X87bf),
        MatrixExt = ((int)0X87c0),
        VariantExt = ((int)0X87c1),
        InvariantExt = ((int)0X87c2),
        LocalConstantExt = ((int)0X87c3),
        LocalExt = ((int)0X87c4),
        MaxVertexShaderInstructionsExt = ((int)0X87c5),
        MaxVertexShaderVariantsExt = ((int)0X87c6),
        MaxVertexShaderInvariantsExt = ((int)0X87c7),
        MaxVertexShaderLocalConstantsExt = ((int)0X87c8),
        MaxVertexShaderLocalsExt = ((int)0X87c9),
        MaxOptimizedVertexShaderInstructionsExt = ((int)0X87ca),
        MaxOptimizedVertexShaderVariantsExt = ((int)0X87cb),
        MaxOptimizedVertexShaderLocalConstantsExt = ((int)0X87cc),
        MaxOptimizedVertexShaderInvariantsExt = ((int)0X87cd),
        MaxOptimizedVertexShaderLocalsExt = ((int)0X87ce),
        VertexShaderInstructionsExt = ((int)0X87cf),
        VertexShaderVariantsExt = ((int)0X87d0),
        VertexShaderInvariantsExt = ((int)0X87d1),
        VertexShaderLocalConstantsExt = ((int)0X87d2),
        VertexShaderLocalsExt = ((int)0X87d3),
        VertexShaderOptimizedExt = ((int)0X87d4),
        XExt = ((int)0X87d5),
        YExt = ((int)0X87d6),
        ZExt = ((int)0X87d7),
        WExt = ((int)0X87d8),
        NegativeXExt = ((int)0X87d9),
        NegativeYExt = ((int)0X87da),
        NegativeZExt = ((int)0X87db),
        NegativeWExt = ((int)0X87dc),
        ZeroExt = ((int)0X87dd),
        OneExt = ((int)0X87de),
        NegativeOneExt = ((int)0X87df),
        NormalizedRangeExt = ((int)0X87e0),
        FullRangeExt = ((int)0X87e1),
        CurrentVertexExt = ((int)0X87e2),
        MvpMatrixExt = ((int)0X87e3),
        VariantValueExt = ((int)0X87e4),
        VariantDatatypeExt = ((int)0X87e5),
        VariantArrayStrideExt = ((int)0X87e6),
        VariantArrayTypeExt = ((int)0X87e7),
        VariantArrayExt = ((int)0X87e8),
        VariantArrayPointerExt = ((int)0X87e9),
        InvariantValueExt = ((int)0X87ea),
        InvariantDatatypeExt = ((int)0X87eb),
        LocalConstantValueExt = ((int)0X87ec),
        LocalConstantDatatypeExt = ((int)0X87ed),
        PnTrianglesAti = ((int)0X87f0),
        MaxPnTrianglesTesselationLevelAti = ((int)0X87f1),
        PnTrianglesPointModeAti = ((int)0X87f2),
        PnTrianglesNormalModeAti = ((int)0X87f3),
        PnTrianglesTesselationLevelAti = ((int)0X87f4),
        PnTrianglesPointModeLinearAti = ((int)0X87f5),
        PnTrianglesPointModeCubicAti = ((int)0X87f6),
        PnTrianglesNormalModeLinearAti = ((int)0X87f7),
        PnTrianglesNormalModeQuadraticAti = ((int)0X87f8),
        VboFreeMemoryAti = ((int)0X87fb),
        TextureFreeMemoryAti = ((int)0X87fc),
        RenderbufferFreeMemoryAti = ((int)0X87fd),
        StencilBackFunc = ((int)0X8800),
        StencilBackFuncAti = ((int)0X8800),
        StencilBackFail = ((int)0X8801),
        StencilBackFailAti = ((int)0X8801),
        StencilBackPassDepthFail = ((int)0X8802),
        StencilBackPassDepthFailAti = ((int)0X8802),
        StencilBackPassDepthPass = ((int)0X8803),
        StencilBackPassDepthPassAti = ((int)0X8803),
        FragmentProgram = ((int)0X8804),
        FragmentProgramArb = ((int)0X8804),
        ProgramAluInstructionsArb = ((int)0X8805),
        ProgramTexInstructionsArb = ((int)0X8806),
        ProgramTexIndirectionsArb = ((int)0X8807),
        ProgramNativeAluInstructionsArb = ((int)0X8808),
        ProgramNativeTexInstructionsArb = ((int)0X8809),
        ProgramNativeTexIndirectionsArb = ((int)0X880a),
        MaxProgramAluInstructionsArb = ((int)0X880b),
        MaxProgramTexInstructionsArb = ((int)0X880c),
        MaxProgramTexIndirectionsArb = ((int)0X880d),
        MaxProgramNativeAluInstructionsArb = ((int)0X880e),
        MaxProgramNativeTexInstructionsArb = ((int)0X880f),
        MaxProgramNativeTexIndirectionsArb = ((int)0X8810),
        Rgba32f = ((int)0X8814),
        Rgba32fArb = ((int)0X8814),
        RgbaFloat32Apple = ((int)0X8814),
        RgbaFloat32Ati = ((int)0X8814),
        Rgb32f = ((int)0X8815),
        Rgb32fArb = ((int)0X8815),
        RgbFloat32Apple = ((int)0X8815),
        RgbFloat32Ati = ((int)0X8815),
        Alpha32fArb = ((int)0X8816),
        AlphaFloat32Apple = ((int)0X8816),
        AlphaFloat32Ati = ((int)0X8816),
        Intensity32fArb = ((int)0X8817),
        IntensityFloat32Apple = ((int)0X8817),
        IntensityFloat32Ati = ((int)0X8817),
        Luminance32fArb = ((int)0X8818),
        LuminanceFloat32Apple = ((int)0X8818),
        LuminanceFloat32Ati = ((int)0X8818),
        LuminanceAlpha32fArb = ((int)0X8819),
        LuminanceAlphaFloat32Apple = ((int)0X8819),
        LuminanceAlphaFloat32Ati = ((int)0X8819),
        Rgba16f = ((int)0X881a),
        Rgba16fArb = ((int)0X881a),
        RgbaFloat16Apple = ((int)0X881a),
        RgbaFloat16Ati = ((int)0X881a),
        Rgb16f = ((int)0X881b),
        Rgb16fArb = ((int)0X881b),
        RgbFloat16Apple = ((int)0X881b),
        RgbFloat16Ati = ((int)0X881b),
        Alpha16fArb = ((int)0X881c),
        AlphaFloat16Apple = ((int)0X881c),
        AlphaFloat16Ati = ((int)0X881c),
        Intensity16fArb = ((int)0X881d),
        IntensityFloat16Apple = ((int)0X881d),
        IntensityFloat16Ati = ((int)0X881d),
        Luminance16fArb = ((int)0X881e),
        LuminanceFloat16Apple = ((int)0X881e),
        LuminanceFloat16Ati = ((int)0X881e),
        LuminanceAlpha16fArb = ((int)0X881f),
        LuminanceAlphaFloat16Apple = ((int)0X881f),
        LuminanceAlphaFloat16Ati = ((int)0X881f),
        RgbaFloatMode = ((int)0X8820),
        RgbaFloatModeArb = ((int)0X8820),
        TypeRgbaFloatAti = ((int)0X8820),
        MaxDrawBuffers = ((int)0X8824),
        MaxDrawBuffersArb = ((int)0X8824),
        MaxDrawBuffersAti = ((int)0X8824),
        DrawBuffer0 = ((int)0X8825),
        DrawBuffer0Arb = ((int)0X8825),
        DrawBuffer0Ati = ((int)0X8825),
        DrawBuffer1 = ((int)0X8826),
        DrawBuffer1Arb = ((int)0X8826),
        DrawBuffer1Ati = ((int)0X8826),
        DrawBuffer2 = ((int)0X8827),
        DrawBuffer2Arb = ((int)0X8827),
        DrawBuffer2Ati = ((int)0X8827),
        DrawBuffer3 = ((int)0X8828),
        DrawBuffer3Arb = ((int)0X8828),
        DrawBuffer3Ati = ((int)0X8828),
        DrawBuffer4 = ((int)0X8829),
        DrawBuffer4Arb = ((int)0X8829),
        DrawBuffer4Ati = ((int)0X8829),
        DrawBuffer5 = ((int)0X882a),
        DrawBuffer5Arb = ((int)0X882a),
        DrawBuffer5Ati = ((int)0X882a),
        DrawBuffer6 = ((int)0X882b),
        DrawBuffer6Arb = ((int)0X882b),
        DrawBuffer6Ati = ((int)0X882b),
        DrawBuffer7 = ((int)0X882c),
        DrawBuffer7Arb = ((int)0X882c),
        DrawBuffer7Ati = ((int)0X882c),
        DrawBuffer8 = ((int)0X882d),
        DrawBuffer8Arb = ((int)0X882d),
        DrawBuffer8Ati = ((int)0X882d),
        DrawBuffer9 = ((int)0X882e),
        DrawBuffer9Arb = ((int)0X882e),
        DrawBuffer9Ati = ((int)0X882e),
        DrawBuffer10 = ((int)0X882f),
        DrawBuffer10Arb = ((int)0X882f),
        DrawBuffer10Ati = ((int)0X882f),
        DrawBuffer11 = ((int)0X8830),
        DrawBuffer11Arb = ((int)0X8830),
        DrawBuffer11Ati = ((int)0X8830),
        DrawBuffer12 = ((int)0X8831),
        DrawBuffer12Arb = ((int)0X8831),
        DrawBuffer12Ati = ((int)0X8831),
        DrawBuffer13 = ((int)0X8832),
        DrawBuffer13Arb = ((int)0X8832),
        DrawBuffer13Ati = ((int)0X8832),
        DrawBuffer14 = ((int)0X8833),
        DrawBuffer14Arb = ((int)0X8833),
        DrawBuffer14Ati = ((int)0X8833),
        DrawBuffer15 = ((int)0X8834),
        DrawBuffer15Arb = ((int)0X8834),
        DrawBuffer15Ati = ((int)0X8834),
        ColorClearUnclampedValueAti = ((int)0X8835),
        BlendEquationAlpha = ((int)0X883d),
        BlendEquationAlphaExt = ((int)0X883d),
        MatrixPaletteArb = ((int)0X8840),
        MaxMatrixPaletteStackDepthArb = ((int)0X8841),
        MaxPaletteMatricesArb = ((int)0X8842),
        CurrentPaletteMatrixArb = ((int)0X8843),
        MatrixIndexArrayArb = ((int)0X8844),
        CurrentMatrixIndexArb = ((int)0X8845),
        MatrixIndexArraySizeArb = ((int)0X8846),
        MatrixIndexArrayTypeArb = ((int)0X8847),
        MatrixIndexArrayStrideArb = ((int)0X8848),
        MatrixIndexArrayPointerArb = ((int)0X8849),
        TextureDepthSize = ((int)0X884a),
        TextureDepthSizeArb = ((int)0X884a),
        DepthTextureMode = ((int)0X884b),
        DepthTextureModeArb = ((int)0X884b),
        TextureCompareMode = ((int)0X884c),
        TextureCompareModeArb = ((int)0X884c),
        TextureCompareFunc = ((int)0X884d),
        TextureCompareFuncArb = ((int)0X884d),
        CompareRefDepthToTextureExt = ((int)0X884e),
        CompareRefToTexture = ((int)0X884e),
        CompareRToTexture = ((int)0X884e),
        CompareRToTextureArb = ((int)0X884e),
        TextureCubeMapSeamless = ((int)0X884f),
        OffsetProjectiveTexture2DNv = ((int)0X8850),
        OffsetProjectiveTexture2DScaleNv = ((int)0X8851),
        OffsetProjectiveTextureRectangleNv = ((int)0X8852),
        OffsetProjectiveTextureRectangleScaleNv = ((int)0X8853),
        OffsetHiloTexture2DNv = ((int)0X8854),
        OffsetHiloTextureRectangleNv = ((int)0X8855),
        OffsetHiloProjectiveTexture2DNv = ((int)0X8856),
        OffsetHiloProjectiveTextureRectangleNv = ((int)0X8857),
        DependentHiloTexture2DNv = ((int)0X8858),
        DependentRgbTexture3DNv = ((int)0X8859),
        DependentRgbTextureCubeMapNv = ((int)0X885a),
        DotProductPassThroughNv = ((int)0X885b),
        DotProductTexture1DNv = ((int)0X885c),
        DotProductAffineDepthReplaceNv = ((int)0X885d),
        Hilo8Nv = ((int)0X885e),
        SignedHilo8Nv = ((int)0X885f),
        ForceBlueToOneNv = ((int)0X8860),
        PointSprite = ((int)0X8861),
        PointSpriteArb = ((int)0X8861),
        PointSpriteNv = ((int)0X8861),
        CoordReplace = ((int)0X8862),
        CoordReplaceArb = ((int)0X8862),
        CoordReplaceNv = ((int)0X8862),
        PointSpriteRModeNv = ((int)0X8863),
        PixelCounterBitsNv = ((int)0X8864),
        QueryCounterBits = ((int)0X8864),
        QueryCounterBitsArb = ((int)0X8864),
        CurrentOcclusionQueryIdNv = ((int)0X8865),
        CurrentQuery = ((int)0X8865),
        CurrentQueryArb = ((int)0X8865),
        PixelCountNv = ((int)0X8866),
        QueryResult = ((int)0X8866),
        QueryResultArb = ((int)0X8866),
        PixelCountAvailableNv = ((int)0X8867),
        QueryResultAvailable = ((int)0X8867),
        QueryResultAvailableArb = ((int)0X8867),
        MaxFragmentProgramLocalParametersNv = ((int)0X8868),
        MaxVertexAttribs = ((int)0X8869),
        MaxVertexAttribsArb = ((int)0X8869),
        ArrayNormalized = ((int)0X886a),
        VertexAttribArrayNormalized = ((int)0X886a),
        VertexAttribArrayNormalizedArb = ((int)0X886a),
        DepthStencilToRgbaNv = ((int)0X886e),
        DepthStencilToBgraNv = ((int)0X886f),
        FragmentProgramNv = ((int)0X8870),
        MaxTextureCoords = ((int)0X8871),
        MaxTextureCoordsArb = ((int)0X8871),
        MaxTextureCoordsNv = ((int)0X8871),
        MaxTextureImageUnits = ((int)0X8872),
        MaxTextureImageUnitsArb = ((int)0X8872),
        MaxTextureImageUnitsNv = ((int)0X8872),
        FragmentProgramBindingNv = ((int)0X8873),
        ProgramErrorStringArb = ((int)0X8874),
        ProgramErrorStringNv = ((int)0X8874),
        ProgramFormatAsciiArb = ((int)0X8875),
        ProgramFormat = ((int)0X8876),
        ProgramFormatArb = ((int)0X8876),
        WritePixelDataRangeNv = ((int)0X8878),
        ReadPixelDataRangeNv = ((int)0X8879),
        WritePixelDataRangeLengthNv = ((int)0X887a),
        ReadPixelDataRangeLengthNv = ((int)0X887b),
        WritePixelDataRangePointerNv = ((int)0X887c),
        ReadPixelDataRangePointerNv = ((int)0X887d),
        FloatRNv = ((int)0X8880),
        FloatRgNv = ((int)0X8881),
        FloatRgbNv = ((int)0X8882),
        FloatRgbaNv = ((int)0X8883),
        FloatR16Nv = ((int)0X8884),
        FloatR32Nv = ((int)0X8885),
        FloatRg16Nv = ((int)0X8886),
        FloatRg32Nv = ((int)0X8887),
        FloatRgb16Nv = ((int)0X8888),
        FloatRgb32Nv = ((int)0X8889),
        FloatRgba16Nv = ((int)0X888a),
        FloatRgba32Nv = ((int)0X888b),
        TextureFloatComponentsNv = ((int)0X888c),
        FloatClearColorValueNv = ((int)0X888d),
        FloatRgbaModeNv = ((int)0X888e),
        TextureUnsignedRemapModeNv = ((int)0X888f),
        DepthBoundsTestExt = ((int)0X8890),
        DepthBoundsExt = ((int)0X8891),
        ArrayBuffer = ((int)0X8892),
        ArrayBufferArb = ((int)0X8892),
        ElementArrayBuffer = ((int)0X8893),
        ElementArrayBufferArb = ((int)0X8893),
        ArrayBufferBinding = ((int)0X8894),
        ArrayBufferBindingArb = ((int)0X8894),
        ElementArrayBufferBinding = ((int)0X8895),
        ElementArrayBufferBindingArb = ((int)0X8895),
        VertexArrayBufferBinding = ((int)0X8896),
        VertexArrayBufferBindingArb = ((int)0X8896),
        NormalArrayBufferBinding = ((int)0X8897),
        NormalArrayBufferBindingArb = ((int)0X8897),
        ColorArrayBufferBinding = ((int)0X8898),
        ColorArrayBufferBindingArb = ((int)0X8898),
        IndexArrayBufferBinding = ((int)0X8899),
        IndexArrayBufferBindingArb = ((int)0X8899),
        TextureCoordArrayBufferBinding = ((int)0X889a),
        TextureCoordArrayBufferBindingArb = ((int)0X889a),
        EdgeFlagArrayBufferBinding = ((int)0X889b),
        EdgeFlagArrayBufferBindingArb = ((int)0X889b),
        SecondaryColorArrayBufferBinding = ((int)0X889c),
        SecondaryColorArrayBufferBindingArb = ((int)0X889c),
        FogCoordArrayBufferBinding = ((int)0X889d),
        FogCoordinateArrayBufferBinding = ((int)0X889d),
        FogCoordinateArrayBufferBindingArb = ((int)0X889d),
        WeightArrayBufferBinding = ((int)0X889e),
        WeightArrayBufferBindingArb = ((int)0X889e),
        VertexAttribArrayBufferBinding = ((int)0X889f),
        VertexAttribArrayBufferBindingArb = ((int)0X889f),
        ProgramInstruction = ((int)0X88a0),
        ProgramInstructionsArb = ((int)0X88a0),
        MaxProgramInstructions = ((int)0X88a1),
        MaxProgramInstructionsArb = ((int)0X88a1),
        ProgramNativeInstructions = ((int)0X88a2),
        ProgramNativeInstructionsArb = ((int)0X88a2),
        MaxProgramNativeInstructions = ((int)0X88a3),
        MaxProgramNativeInstructionsArb = ((int)0X88a3),
        ProgramTemporaries = ((int)0X88a4),
        ProgramTemporariesArb = ((int)0X88a4),
        MaxProgramTemporaries = ((int)0X88a5),
        MaxProgramTemporariesArb = ((int)0X88a5),
        ProgramNativeTemporaries = ((int)0X88a6),
        ProgramNativeTemporariesArb = ((int)0X88a6),
        MaxProgramNativeTemporaries = ((int)0X88a7),
        MaxProgramNativeTemporariesArb = ((int)0X88a7),
        ProgramParameters = ((int)0X88a8),
        ProgramParametersArb = ((int)0X88a8),
        MaxProgramParameters = ((int)0X88a9),
        MaxProgramParametersArb = ((int)0X88a9),
        ProgramNativeParameters = ((int)0X88aa),
        ProgramNativeParametersArb = ((int)0X88aa),
        MaxProgramNativeParameters = ((int)0X88ab),
        MaxProgramNativeParametersArb = ((int)0X88ab),
        ProgramAttribs = ((int)0X88ac),
        ProgramAttribsArb = ((int)0X88ac),
        MaxProgramAttribs = ((int)0X88ad),
        MaxProgramAttribsArb = ((int)0X88ad),
        ProgramNativeAttribs = ((int)0X88ae),
        ProgramNativeAttribsArb = ((int)0X88ae),
        MaxProgramNativeAttribs = ((int)0X88af),
        MaxProgramNativeAttribsArb = ((int)0X88af),
        ProgramAddressRegisters = ((int)0X88b0),
        ProgramAddressRegistersArb = ((int)0X88b0),
        MaxProgramAddressRegisters = ((int)0X88b1),
        MaxProgramAddressRegistersArb = ((int)0X88b1),
        ProgramNativeAddressRegisters = ((int)0X88b2),
        ProgramNativeAddressRegistersArb = ((int)0X88b2),
        MaxProgramNativeAddressRegisters = ((int)0X88b3),
        MaxProgramNativeAddressRegistersArb = ((int)0X88b3),
        MaxProgramLocalParameters = ((int)0X88b4),
        MaxProgramLocalParametersArb = ((int)0X88b4),
        MaxProgramEnvParameters = ((int)0X88b5),
        MaxProgramEnvParametersArb = ((int)0X88b5),
        ProgramUnderNativeLimits = ((int)0X88b6),
        ProgramUnderNativeLimitsArb = ((int)0X88b6),
        TransposeCurrentMatrixArb = ((int)0X88b7),
        ReadOnly = ((int)0X88b8),
        ReadOnlyArb = ((int)0X88b8),
        WriteOnly = ((int)0X88b9),
        WriteOnlyArb = ((int)0X88b9),
        ReadWrite = ((int)0X88ba),
        ReadWriteArb = ((int)0X88ba),
        BufferAccess = ((int)0X88bb),
        BufferAccessArb = ((int)0X88bb),
        BufferMapped = ((int)0X88bc),
        BufferMappedArb = ((int)0X88bc),
        BufferMapPointer = ((int)0X88bd),
        BufferMapPointerArb = ((int)0X88bd),
        TimeElapsedExt = ((int)0X88bf),
        Matrix0 = ((int)0X88c0),
        Matrix0Arb = ((int)0X88c0),
        Matrix1 = ((int)0X88c1),
        Matrix1Arb = ((int)0X88c1),
        Matrix2 = ((int)0X88c2),
        Matrix2Arb = ((int)0X88c2),
        Matrix3 = ((int)0X88c3),
        Matrix3Arb = ((int)0X88c3),
        Matrix4 = ((int)0X88c4),
        Matrix4Arb = ((int)0X88c4),
        Matrix5 = ((int)0X88c5),
        Matrix5Arb = ((int)0X88c5),
        Matrix6 = ((int)0X88c6),
        Matrix6Arb = ((int)0X88c6),
        Matrix7 = ((int)0X88c7),
        Matrix7Arb = ((int)0X88c7),
        Matrix8 = ((int)0X88c8),
        Matrix8Arb = ((int)0X88c8),
        Matrix9 = ((int)0X88c9),
        Matrix9Arb = ((int)0X88c9),
        Matrix10 = ((int)0X88ca),
        Matrix10Arb = ((int)0X88ca),
        Matrix11 = ((int)0X88cb),
        Matrix11Arb = ((int)0X88cb),
        Matrix12 = ((int)0X88cc),
        Matrix12Arb = ((int)0X88cc),
        Matrix13 = ((int)0X88cd),
        Matrix13Arb = ((int)0X88cd),
        Matrix14 = ((int)0X88ce),
        Matrix14Arb = ((int)0X88ce),
        Matrix15 = ((int)0X88cf),
        Matrix15Arb = ((int)0X88cf),
        Matrix16 = ((int)0X88d0),
        Matrix16Arb = ((int)0X88d0),
        Matrix17 = ((int)0X88d1),
        Matrix17Arb = ((int)0X88d1),
        Matrix18 = ((int)0X88d2),
        Matrix18Arb = ((int)0X88d2),
        Matrix19 = ((int)0X88d3),
        Matrix19Arb = ((int)0X88d3),
        Matrix20 = ((int)0X88d4),
        Matrix20Arb = ((int)0X88d4),
        Matrix21 = ((int)0X88d5),
        Matrix21Arb = ((int)0X88d5),
        Matrix22 = ((int)0X88d6),
        Matrix22Arb = ((int)0X88d6),
        Matrix23 = ((int)0X88d7),
        Matrix23Arb = ((int)0X88d7),
        Matrix24 = ((int)0X88d8),
        Matrix24Arb = ((int)0X88d8),
        Matrix25 = ((int)0X88d9),
        Matrix25Arb = ((int)0X88d9),
        Matrix26 = ((int)0X88da),
        Matrix26Arb = ((int)0X88da),
        Matrix27 = ((int)0X88db),
        Matrix27Arb = ((int)0X88db),
        Matrix28 = ((int)0X88dc),
        Matrix28Arb = ((int)0X88dc),
        Matrix29 = ((int)0X88dd),
        Matrix29Arb = ((int)0X88dd),
        Matrix30 = ((int)0X88de),
        Matrix30Arb = ((int)0X88de),
        Matrix31 = ((int)0X88df),
        Matrix31Arb = ((int)0X88df),
        StreamDraw = ((int)0X88e0),
        StreamDrawArb = ((int)0X88e0),
        StreamRead = ((int)0X88e1),
        StreamReadArb = ((int)0X88e1),
        StreamCopy = ((int)0X88e2),
        StreamCopyArb = ((int)0X88e2),
        StaticDraw = ((int)0X88e4),
        StaticDrawArb = ((int)0X88e4),
        StaticRead = ((int)0X88e5),
        StaticReadArb = ((int)0X88e5),
        StaticCopy = ((int)0X88e6),
        StaticCopyArb = ((int)0X88e6),
        DynamicDraw = ((int)0X88e8),
        DynamicDrawArb = ((int)0X88e8),
        DynamicRead = ((int)0X88e9),
        DynamicReadArb = ((int)0X88e9),
        DynamicCopy = ((int)0X88ea),
        DynamicCopyArb = ((int)0X88ea),
        PixelPackBuffer = ((int)0X88eb),
        PixelPackBufferArb = ((int)0X88eb),
        PixelPackBufferExt = ((int)0X88eb),
        PixelUnpackBuffer = ((int)0X88ec),
        PixelUnpackBufferArb = ((int)0X88ec),
        PixelUnpackBufferExt = ((int)0X88ec),
        PixelPackBufferBinding = ((int)0X88ed),
        PixelPackBufferBindingArb = ((int)0X88ed),
        PixelPackBufferBindingExt = ((int)0X88ed),
        PixelUnpackBufferBinding = ((int)0X88ef),
        PixelUnpackBufferBindingArb = ((int)0X88ef),
        PixelUnpackBufferBindingExt = ((int)0X88ef),
        Depth24Stencil8 = ((int)0X88f0),
        Depth24Stencil8Ext = ((int)0X88f0),
        TextureStencilSize = ((int)0X88f1),
        TextureStencilSizeExt = ((int)0X88f1),
        StencilTagBitsExt = ((int)0X88f2),
        StencilClearTagValueExt = ((int)0X88f3),
        MaxProgramExecInstructionsNv = ((int)0X88f4),
        MaxProgramCallDepthNv = ((int)0X88f5),
        MaxProgramIfDepthNv = ((int)0X88f6),
        MaxProgramLoopDepthNv = ((int)0X88f7),
        MaxProgramLoopCountNv = ((int)0X88f8),
        VertexAttribArrayInteger = ((int)0X88fd),
        VertexAttribArrayIntegerNv = ((int)0X88fd),
        ArrayDivisor = ((int)0X88fe),
        VertexAttribArrayDivisorArb = ((int)0X88fe),
        MaxArrayTextureLayers = ((int)0X88ff),
        MaxArrayTextureLayersExt = ((int)0X88ff),
        MinProgramTexelOffset = ((int)0X8904),
        MinProgramTexelOffsetNv = ((int)0X8904),
        MaxProgramTexelOffset = ((int)0X8905),
        MaxProgramTexelOffsetNv = ((int)0X8905),
        ProgramAttribComponentsNv = ((int)0X8906),
        ProgramResultComponentsNv = ((int)0X8907),
        MaxProgramAttribComponentsNv = ((int)0X8908),
        MaxProgramResultComponentsNv = ((int)0X8909),
        StencilTestTwoSideExt = ((int)0X8910),
        ActiveStencilFaceExt = ((int)0X8911),
        MirrorClampToBorderExt = ((int)0X8912),
        SamplesPassed = ((int)0X8914),
        SamplesPassedArb = ((int)0X8914),
        GeometryVerticesOut = ((int)0X8916),
        GeometryInputType = ((int)0X8917),
        GeometryOutputType = ((int)0X8918),
        ClampVertexColor = ((int)0X891a),
        ClampVertexColorArb = ((int)0X891a),
        ClampFragmentColor = ((int)0X891b),
        ClampFragmentColorArb = ((int)0X891b),
        ClampReadColor = ((int)0X891c),
        ClampReadColorArb = ((int)0X891c),
        FixedOnly = ((int)0X891d),
        FixedOnlyArb = ((int)0X891d),
        FragmentShaderAti = ((int)0X8920),
        Reg0Ati = ((int)0X8921),
        Reg1Ati = ((int)0X8922),
        Reg2Ati = ((int)0X8923),
        Reg3Ati = ((int)0X8924),
        Reg4Ati = ((int)0X8925),
        Reg5Ati = ((int)0X8926),
        Reg6Ati = ((int)0X8927),
        Reg7Ati = ((int)0X8928),
        Reg8Ati = ((int)0X8929),
        Reg9Ati = ((int)0X892a),
        Reg10Ati = ((int)0X892b),
        Reg11Ati = ((int)0X892c),
        Reg12Ati = ((int)0X892d),
        Reg13Ati = ((int)0X892e),
        Reg14Ati = ((int)0X892f),
        Reg15Ati = ((int)0X8930),
        Reg16Ati = ((int)0X8931),
        Reg17Ati = ((int)0X8932),
        Reg18Ati = ((int)0X8933),
        Reg19Ati = ((int)0X8934),
        Reg20Ati = ((int)0X8935),
        Reg21Ati = ((int)0X8936),
        Reg22Ati = ((int)0X8937),
        Reg23Ati = ((int)0X8938),
        Reg24Ati = ((int)0X8939),
        Reg25Ati = ((int)0X893a),
        Reg26Ati = ((int)0X893b),
        Reg27Ati = ((int)0X893c),
        Reg28Ati = ((int)0X893d),
        Reg29Ati = ((int)0X893e),
        Reg30Ati = ((int)0X893f),
        Reg31Ati = ((int)0X8940),
        Con0Ati = ((int)0X8941),
        Con1Ati = ((int)0X8942),
        Con2Ati = ((int)0X8943),
        Con3Ati = ((int)0X8944),
        Con4Ati = ((int)0X8945),
        Con5Ati = ((int)0X8946),
        Con6Ati = ((int)0X8947),
        Con7Ati = ((int)0X8948),
        Con8Ati = ((int)0X8949),
        Con9Ati = ((int)0X894a),
        Con10Ati = ((int)0X894b),
        Con11Ati = ((int)0X894c),
        Con12Ati = ((int)0X894d),
        Con13Ati = ((int)0X894e),
        Con14Ati = ((int)0X894f),
        Con15Ati = ((int)0X8950),
        Con16Ati = ((int)0X8951),
        Con17Ati = ((int)0X8952),
        Con18Ati = ((int)0X8953),
        Con19Ati = ((int)0X8954),
        Con20Ati = ((int)0X8955),
        Con21Ati = ((int)0X8956),
        Con22Ati = ((int)0X8957),
        Con23Ati = ((int)0X8958),
        Con24Ati = ((int)0X8959),
        Con25Ati = ((int)0X895a),
        Con26Ati = ((int)0X895b),
        Con27Ati = ((int)0X895c),
        Con28Ati = ((int)0X895d),
        Con29Ati = ((int)0X895e),
        Con30Ati = ((int)0X895f),
        Con31Ati = ((int)0X8960),
        MovAti = ((int)0X8961),
        AddAti = ((int)0X8963),
        MulAti = ((int)0X8964),
        SubAti = ((int)0X8965),
        Dot3Ati = ((int)0X8966),
        Dot4Ati = ((int)0X8967),
        MadAti = ((int)0X8968),
        LerpAti = ((int)0X8969),
        CndAti = ((int)0X896a),
        Cnd0Ati = ((int)0X896b),
        Dot2AddAti = ((int)0X896c),
        SecondaryInterpolatorAti = ((int)0X896d),
        NumFragmentRegistersAti = ((int)0X896e),
        NumFragmentConstantsAti = ((int)0X896f),
        NumPassesAti = ((int)0X8970),
        NumInstructionsPerPassAti = ((int)0X8971),
        NumInstructionsTotalAti = ((int)0X8972),
        NumInputInterpolatorComponentsAti = ((int)0X8973),
        NumLoopbackComponentsAti = ((int)0X8974),
        ColorAlphaPairingAti = ((int)0X8975),
        SwizzleStrAti = ((int)0X8976),
        SwizzleStqAti = ((int)0X8977),
        SwizzleStrDrAti = ((int)0X8978),
        SwizzleStqDqAti = ((int)0X8979),
        SwizzleStrqAti = ((int)0X897a),
        SwizzleStrqDqAti = ((int)0X897b),
        InterlaceOml = ((int)0X8980),
        InterlaceReadOml = ((int)0X8981),
        FormatSubsample2424Oml = ((int)0X8982),
        FormatSubsample244244Oml = ((int)0X8983),
        PackResampleOml = ((int)0X8984),
        UnpackResampleOml = ((int)0X8985),
        ResampleReplicateOml = ((int)0X8986),
        ResampleZeroFillOml = ((int)0X8987),
        ResampleAverageOml = ((int)0X8988),
        ResampleDecimateOml = ((int)0X8989),
        VertexAttribMap1Apple = ((int)0X8a00),
        VertexAttribMap2Apple = ((int)0X8a01),
        VertexAttribMap1SizeApple = ((int)0X8a02),
        VertexAttribMap1CoeffApple = ((int)0X8a03),
        VertexAttribMap1OrderApple = ((int)0X8a04),
        VertexAttribMap1DomainApple = ((int)0X8a05),
        VertexAttribMap2SizeApple = ((int)0X8a06),
        VertexAttribMap2CoeffApple = ((int)0X8a07),
        VertexAttribMap2OrderApple = ((int)0X8a08),
        VertexAttribMap2DomainApple = ((int)0X8a09),
        DrawPixelsApple = ((int)0X8a0a),
        FenceApple = ((int)0X8a0b),
        ColorFloatApple = ((int)0X8a0f),
        UniformBuffer = ((int)0X8a11),
        BufferSerializedModifyApple = ((int)0X8a12),
        BufferFlushingUnmapApple = ((int)0X8a13),
        AuxDepthStencilApple = ((int)0X8a14),
        PackRowBytesApple = ((int)0X8a15),
        UnpackRowBytesApple = ((int)0X8a16),
        ReleasedApple = ((int)0X8a19),
        VolatileApple = ((int)0X8a1a),
        RetainedApple = ((int)0X8a1b),
        UndefinedApple = ((int)0X8a1c),
        PurgeableApple = ((int)0X8a1d),
        UniformBufferBinding = ((int)0X8a28),
        UniformBufferStart = ((int)0X8a29),
        UniformBufferSize = ((int)0X8a2a),
        MaxVertexUniformBlocks = ((int)0X8a2b),
        MaxGeometryUniformBlocks = ((int)0X8a2c),
        MaxFragmentUniformBlocks = ((int)0X8a2d),
        MaxCombinedUniformBlocks = ((int)0X8a2e),
        MaxUniformBufferBindings = ((int)0X8a2f),
        MaxUniformBlockSize = ((int)0X8a30),
        MaxCombinedVertexUniformComponents = ((int)0X8a31),
        MaxCombinedGeometryUniformComponents = ((int)0X8a32),
        MaxCombinedFragmentUniformComponents = ((int)0X8a33),
        UniformBufferOffsetAlignment = ((int)0X8a34),
        ActiveUniformBlockMaxNameLength = ((int)0X8a35),
        ActiveUniformBlocks = ((int)0X8a36),
        UniformType = ((int)0X8a37),
        UniformSize = ((int)0X8a38),
        UniformNameLength = ((int)0X8a39),
        UniformBlockIndex = ((int)0X8a3a),
        UniformOffset = ((int)0X8a3b),
        UniformArrayStride = ((int)0X8a3c),
        UniformMatrixStride = ((int)0X8a3d),
        UniformIsRowMajor = ((int)0X8a3e),
        UniformBlockBinding = ((int)0X8a3f),
        UniformBlockDataSize = ((int)0X8a40),
        UniformBlockNameLength = ((int)0X8a41),
        UniformBlockActiveUniforms = ((int)0X8a42),
        UniformBlockActiveUniformIndices = ((int)0X8a43),
        UniformBlockReferencedByVertexShader = ((int)0X8a44),
        UniformBlockReferencedByGeometryShader = ((int)0X8a45),
        UniformBlockReferencedByFragmentShader = ((int)0X8a46),
        FragmentShader = ((int)0X8b30),
        FragmentShaderArb = ((int)0X8b30),
        VertexShader = ((int)0X8b31),
        VertexShaderArb = ((int)0X8b31),
        ProgramObjectArb = ((int)0X8b40),
        ShaderObjectArb = ((int)0X8b48),
        MaxFragmentUniformComponents = ((int)0X8b49),
        MaxFragmentUniformComponentsArb = ((int)0X8b49),
        MaxVertexUniformComponents = ((int)0X8b4a),
        MaxVertexUniformComponentsArb = ((int)0X8b4a),
        MaxVaryingComponents = ((int)0X8b4b),
        MaxVaryingComponentsExt = ((int)0X8b4b),
        MaxVaryingFloats = ((int)0X8b4b),
        MaxVaryingFloatsArb = ((int)0X8b4b),
        MaxVertexTextureImageUnits = ((int)0X8b4c),
        MaxVertexTextureImageUnitsArb = ((int)0X8b4c),
        MaxCombinedTextureImageUnits = ((int)0X8b4d),
        MaxCombinedTextureImageUnitsArb = ((int)0X8b4d),
        ObjectTypeArb = ((int)0X8b4e),
        ObjectSubtypeArb = ((int)0X8b4f),
        ShaderType = ((int)0X8b4f),
        FloatVec2 = ((int)0X8b50),
        FloatVec2Arb = ((int)0X8b50),
        FloatVec3 = ((int)0X8b51),
        FloatVec3Arb = ((int)0X8b51),
        FloatVec4 = ((int)0X8b52),
        FloatVec4Arb = ((int)0X8b52),
        IntVec2 = ((int)0X8b53),
        IntVec2Arb = ((int)0X8b53),
        IntVec3 = ((int)0X8b54),
        IntVec3Arb = ((int)0X8b54),
        IntVec4 = ((int)0X8b55),
        IntVec4Arb = ((int)0X8b55),
        Bool = ((int)0X8b56),
        BoolArb = ((int)0X8b56),
        BoolVec2 = ((int)0X8b57),
        BoolVec2Arb = ((int)0X8b57),
        BoolVec3 = ((int)0X8b58),
        BoolVec3Arb = ((int)0X8b58),
        BoolVec4 = ((int)0X8b59),
        BoolVec4Arb = ((int)0X8b59),
        FloatMat2 = ((int)0X8b5a),
        FloatMat2Arb = ((int)0X8b5a),
        FloatMat3 = ((int)0X8b5b),
        FloatMat3Arb = ((int)0X8b5b),
        FloatMat4 = ((int)0X8b5c),
        FloatMat4Arb = ((int)0X8b5c),
        Sampler1D = ((int)0X8b5d),
        Sampler1DArb = ((int)0X8b5d),
        Sampler2D = ((int)0X8b5e),
        Sampler2DArb = ((int)0X8b5e),
        Sampler3D = ((int)0X8b5f),
        Sampler3DArb = ((int)0X8b5f),
        SamplerCube = ((int)0X8b60),
        SamplerCubeArb = ((int)0X8b60),
        Sampler1DShadow = ((int)0X8b61),
        Sampler1DShadowArb = ((int)0X8b61),
        Sampler2DShadow = ((int)0X8b62),
        Sampler2DShadowArb = ((int)0X8b62),
        Sampler2DRect = ((int)0X8b63),
        Sampler2DRectArb = ((int)0X8b63),
        Sampler2DRectShadow = ((int)0X8b64),
        Sampler2DRectShadowArb = ((int)0X8b64),
        FloatMat2x3 = ((int)0X8b65),
        FloatMat2x4 = ((int)0X8b66),
        FloatMat3x2 = ((int)0X8b67),
        FloatMat3x4 = ((int)0X8b68),
        FloatMat4x2 = ((int)0X8b69),
        FloatMat4x3 = ((int)0X8b6a),
        DeleteStatus = ((int)0X8b80),
        ObjectDeleteStatusArb = ((int)0X8b80),
        CompileStatus = ((int)0X8b81),
        ObjectCompileStatusArb = ((int)0X8b81),
        LinkStatus = ((int)0X8b82),
        ObjectLinkStatusArb = ((int)0X8b82),
        ObjectValidateStatusArb = ((int)0X8b83),
        ValidateStatus = ((int)0X8b83),
        InfoLogLength = ((int)0X8b84),
        ObjectInfoLogLengthArb = ((int)0X8b84),
        AttachedShaders = ((int)0X8b85),
        ObjectAttachedObjectsArb = ((int)0X8b85),
        ActiveUniforms = ((int)0X8b86),
        ObjectActiveUniformsArb = ((int)0X8b86),
        ActiveUniformMaxLength = ((int)0X8b87),
        ObjectActiveUniformMaxLengthArb = ((int)0X8b87),
        ObjectShaderSourceLengthArb = ((int)0X8b88),
        ShaderSourceLength = ((int)0X8b88),
        ActiveAttributes = ((int)0X8b89),
        ObjectActiveAttributesArb = ((int)0X8b89),
        ActiveAttributeMaxLength = ((int)0X8b8a),
        ObjectActiveAttributeMaxLengthArb = ((int)0X8b8a),
        FragmentShaderDerivativeHint = ((int)0X8b8b),
        FragmentShaderDerivativeHintArb = ((int)0X8b8b),
        ShadingLanguageVersion = ((int)0X8b8c),
        ShadingLanguageVersionArb = ((int)0X8b8c),
        CurrentProgram = ((int)0X8b8d),
        ImplementationColorReadTypeOes = ((int)0X8b9a),
        ImplementationColorReadFormatOes = ((int)0X8b9b),
        CounterTypeAmd = ((int)0X8bc0),
        CounterRangeAmd = ((int)0X8bc1),
        UnsignedInt64Amd = ((int)0X8bc2),
        PercentageAmd = ((int)0X8bc3),
        PerfmonResultAvailableAmd = ((int)0X8bc4),
        PerfmonResultSizeAmd = ((int)0X8bc5),
        PerfmonResultAmd = ((int)0X8bc6),
        TextureRedType = ((int)0X8c10),
        TextureRedTypeArb = ((int)0X8c10),
        TextureGreenType = ((int)0X8c11),
        TextureGreenTypeArb = ((int)0X8c11),
        TextureBlueType = ((int)0X8c12),
        TextureBlueTypeArb = ((int)0X8c12),
        TextureAlphaType = ((int)0X8c13),
        TextureAlphaTypeArb = ((int)0X8c13),
        TextureLuminanceType = ((int)0X8c14),
        TextureLuminanceTypeArb = ((int)0X8c14),
        TextureIntensityType = ((int)0X8c15),
        TextureIntensityTypeArb = ((int)0X8c15),
        TextureDepthType = ((int)0X8c16),
        TextureDepthTypeArb = ((int)0X8c16),
        UnsignedNormalized = ((int)0X8c17),
        UnsignedNormalizedArb = ((int)0X8c17),
        Texture1DArray = ((int)0X8c18),
        Texture1DArrayExt = ((int)0X8c18),
        ProxyTexture1DArray = ((int)0X8c19),
        ProxyTexture1DArrayExt = ((int)0X8c19),
        Texture2DArray = ((int)0X8c1a),
        Texture2DArrayExt = ((int)0X8c1a),
        ProxyTexture2DArray = ((int)0X8c1b),
        ProxyTexture2DArrayExt = ((int)0X8c1b),
        TextureBinding1DArray = ((int)0X8c1c),
        TextureBinding1DArrayExt = ((int)0X8c1c),
        TextureBinding2DArray = ((int)0X8c1d),
        TextureBinding2DArrayExt = ((int)0X8c1d),
        GeometryProgramNv = ((int)0X8c26),
        MaxProgramOutputVerticesNv = ((int)0X8c27),
        MaxProgramTotalOutputComponentsNv = ((int)0X8c28),
        MaxGeometryTextureImageUnits = ((int)0X8c29),
        MaxGeometryTextureImageUnitsArb = ((int)0X8c29),
        MaxGeometryTextureImageUnitsExt = ((int)0X8c29),
        TextureBuffer = ((int)0X8c2a),
        TextureBufferArb = ((int)0X8c2a),
        TextureBufferExt = ((int)0X8c2a),
        MaxTextureBufferSize = ((int)0X8c2b),
        MaxTextureBufferSizeArb = ((int)0X8c2b),
        MaxTextureBufferSizeExt = ((int)0X8c2b),
        TextureBindingBuffer = ((int)0X8c2c),
        TextureBindingBufferArb = ((int)0X8c2c),
        TextureBindingBufferExt = ((int)0X8c2c),
        TextureBufferDataStoreBinding = ((int)0X8c2d),
        TextureBufferDataStoreBindingArb = ((int)0X8c2d),
        TextureBufferDataStoreBindingExt = ((int)0X8c2d),
        TextureBufferFormat = ((int)0X8c2e),
        TextureBufferFormatArb = ((int)0X8c2e),
        TextureBufferFormatExt = ((int)0X8c2e),
        SampleShading = ((int)0X8c36),
        MinSampleShadingValue = ((int)0X8c37),
        R11fG11fB10f = ((int)0X8c3a),
        R11fG11fB10fExt = ((int)0X8c3a),
        UnsignedInt10F11F11FRev = ((int)0X8c3b),
        UnsignedInt10F11F11FRevExt = ((int)0X8c3b),
        RgbaSignedComponentsExt = ((int)0X8c3c),
        Rgb9E5 = ((int)0X8c3d),
        Rgb9E5Ext = ((int)0X8c3d),
        UnsignedInt5999Rev = ((int)0X8c3e),
        UnsignedInt5999RevExt = ((int)0X8c3e),
        TextureSharedSize = ((int)0X8c3f),
        TextureSharedSizeExt = ((int)0X8c3f),
        Srgb = ((int)0X8c40),
        SrgbExt = ((int)0X8c40),
        Srgb8 = ((int)0X8c41),
        Srgb8Ext = ((int)0X8c41),
        SrgbAlpha = ((int)0X8c42),
        SrgbAlphaExt = ((int)0X8c42),
        Srgb8Alpha8 = ((int)0X8c43),
        Srgb8Alpha8Ext = ((int)0X8c43),
        SluminanceAlpha = ((int)0X8c44),
        SluminanceAlphaExt = ((int)0X8c44),
        Sluminance8Alpha8 = ((int)0X8c45),
        Sluminance8Alpha8Ext = ((int)0X8c45),
        Sluminance = ((int)0X8c46),
        SluminanceExt = ((int)0X8c46),
        Sluminance8 = ((int)0X8c47),
        Sluminance8Ext = ((int)0X8c47),
        CompressedSrgb = ((int)0X8c48),
        CompressedSrgbExt = ((int)0X8c48),
        CompressedSrgbAlpha = ((int)0X8c49),
        CompressedSrgbAlphaExt = ((int)0X8c49),
        CompressedSluminance = ((int)0X8c4a),
        CompressedSluminanceExt = ((int)0X8c4a),
        CompressedSluminanceAlpha = ((int)0X8c4b),
        CompressedSluminanceAlphaExt = ((int)0X8c4b),
        CompressedSrgbS3tcDxt1Ext = ((int)0X8c4c),
        CompressedSrgbAlphaS3tcDxt1Ext = ((int)0X8c4d),
        CompressedSrgbAlphaS3tcDxt3Ext = ((int)0X8c4e),
        CompressedSrgbAlphaS3tcDxt5Ext = ((int)0X8c4f),
        CompressedLuminanceLatc1Ext = ((int)0X8c70),
        CompressedSignedLuminanceLatc1Ext = ((int)0X8c71),
        CompressedLuminanceAlphaLatc2Ext = ((int)0X8c72),
        CompressedSignedLuminanceAlphaLatc2Ext = ((int)0X8c73),
        TransformFeedbackVaryingMaxLength = ((int)0X8c76),
        TransformFeedbackVaryingMaxLengthExt = ((int)0X8c76),
        BackPrimaryColorNv = ((int)0X8c77),
        BackSecondaryColorNv = ((int)0X8c78),
        TextureCoordNv = ((int)0X8c79),
        ClipDistanceNv = ((int)0X8c7a),
        VertexIdNv = ((int)0X8c7b),
        PrimitiveIdNv = ((int)0X8c7c),
        GenericAttribNv = ((int)0X8c7d),
        TransformFeedbackAttribsNv = ((int)0X8c7e),
        TransformFeedbackBufferMode = ((int)0X8c7f),
        TransformFeedbackBufferModeExt = ((int)0X8c7f),
        TransformFeedbackBufferModeNv = ((int)0X8c7f),
        MaxTransformFeedbackSeparateComponents = ((int)0X8c80),
        MaxTransformFeedbackSeparateComponentsExt = ((int)0X8c80),
        MaxTransformFeedbackSeparateComponentsNv = ((int)0X8c80),
        ActiveVaryingsNv = ((int)0X8c81),
        ActiveVaryingMaxLengthNv = ((int)0X8c82),
        TransformFeedbackVaryings = ((int)0X8c83),
        TransformFeedbackVaryingsExt = ((int)0X8c83),
        TransformFeedbackVaryingsNv = ((int)0X8c83),
        TransformFeedbackBufferStart = ((int)0X8c84),
        TransformFeedbackBufferStartExt = ((int)0X8c84),
        TransformFeedbackBufferStartNv = ((int)0X8c84),
        TransformFeedbackBufferSize = ((int)0X8c85),
        TransformFeedbackBufferSizeExt = ((int)0X8c85),
        TransformFeedbackBufferSizeNv = ((int)0X8c85),
        TransformFeedbackRecordNv = ((int)0X8c86),
        PrimitivesGenerated = ((int)0X8c87),
        PrimitivesGeneratedExt = ((int)0X8c87),
        PrimitivesGeneratedNv = ((int)0X8c87),
        TransformFeedbackPrimitivesWritten = ((int)0X8c88),
        TransformFeedbackPrimitivesWrittenExt = ((int)0X8c88),
        TransformFeedbackPrimitivesWrittenNv = ((int)0X8c88),
        RasterizerDiscard = ((int)0X8c89),
        RasterizerDiscardExt = ((int)0X8c89),
        RasterizerDiscardNv = ((int)0X8c89),
        MaxTransformFeedbackInterleavedAttribsNv = ((int)0X8c8a),
        MaxTransformFeedbackInterleavedComponents = ((int)0X8c8a),
        MaxTransformFeedbackInterleavedComponentsExt = ((int)0X8c8a),
        MaxTransformFeedbackSeparateAttribs = ((int)0X8c8b),
        MaxTransformFeedbackSeparateAttribsExt = ((int)0X8c8b),
        MaxTransformFeedbackSeparateAttribsNv = ((int)0X8c8b),
        InterleavedAttribs = ((int)0X8c8c),
        InterleavedAttribsExt = ((int)0X8c8c),
        InterleavedAttribsNv = ((int)0X8c8c),
        SeparateAttribs = ((int)0X8c8d),
        SeparateAttribsExt = ((int)0X8c8d),
        SeparateAttribsNv = ((int)0X8c8d),
        TransformFeedbackBuffer = ((int)0X8c8e),
        TransformFeedbackBufferExt = ((int)0X8c8e),
        TransformFeedbackBufferNv = ((int)0X8c8e),
        TransformFeedbackBufferBinding = ((int)0X8c8f),
        TransformFeedbackBufferBindingExt = ((int)0X8c8f),
        TransformFeedbackBufferBindingNv = ((int)0X8c8f),
        PointSpriteCoordOrigin = ((int)0X8ca0),
        LowerLeft = ((int)0X8ca1),
        UpperLeft = ((int)0X8ca2),
        StencilBackRef = ((int)0X8ca3),
        StencilBackValueMask = ((int)0X8ca4),
        StencilBackWritemask = ((int)0X8ca5),
        DrawFramebufferBinding = ((int)0X8ca6),
        DrawFramebufferBindingExt = ((int)0X8ca6),
        FramebufferBinding = ((int)0X8ca6),
        FramebufferBindingExt = ((int)0X8ca6),
        RenderbufferBinding = ((int)0X8ca7),
        RenderbufferBindingExt = ((int)0X8ca7),
        ReadFramebuffer = ((int)0X8ca8),
        ReadFramebufferExt = ((int)0X8ca8),
        DrawFramebuffer = ((int)0X8ca9),
        DrawFramebufferExt = ((int)0X8ca9),
        ReadFramebufferBinding = ((int)0X8caa),
        ReadFramebufferBindingExt = ((int)0X8caa),
        RenderbufferCoverageSamplesNv = ((int)0X8cab),
        RenderbufferSamples = ((int)0X8cab),
        RenderbufferSamplesExt = ((int)0X8cab),
        DepthComponent32f = ((int)0X8cac),
        Depth32fStencil8 = ((int)0X8cad),
        FramebufferAttachmentObjectType = ((int)0X8cd0),
        FramebufferAttachmentObjectTypeExt = ((int)0X8cd0),
        FramebufferAttachmentObjectName = ((int)0X8cd1),
        FramebufferAttachmentObjectNameExt = ((int)0X8cd1),
        FramebufferAttachmentTextureLevel = ((int)0X8cd2),
        FramebufferAttachmentTextureLevelExt = ((int)0X8cd2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0X8cd3),
        FramebufferAttachmentTextureCubeMapFaceExt = ((int)0X8cd3),
        FramebufferAttachmentTexture3DZoffsetExt = ((int)0X8cd4),
        FramebufferAttachmentTextureLayer = ((int)0X8cd4),
        FramebufferAttachmentTextureLayerExt = ((int)0X8cd4),
        FramebufferComplete = ((int)0X8cd5),
        FramebufferCompleteExt = ((int)0X8cd5),
        FramebufferIncompleteAttachment = ((int)0X8cd6),
        FramebufferIncompleteAttachmentExt = ((int)0X8cd6),
        FramebufferIncompleteMissingAttachment = ((int)0X8cd7),
        FramebufferIncompleteMissingAttachmentExt = ((int)0X8cd7),
        FramebufferIncompleteDimensionsExt = ((int)0X8cd9),
        FramebufferIncompleteFormatsExt = ((int)0X8cda),
        FramebufferIncompleteDrawBuffer = ((int)0X8cdb),
        FramebufferIncompleteDrawBufferExt = ((int)0X8cdb),
        FramebufferIncompleteReadBuffer = ((int)0X8cdc),
        FramebufferIncompleteReadBufferExt = ((int)0X8cdc),
        FramebufferUnsupported = ((int)0X8cdd),
        FramebufferUnsupportedExt = ((int)0X8cdd),
        MaxColorAttachments = ((int)0X8cdf),
        MaxColorAttachmentsExt = ((int)0X8cdf),
        ColorAttachment0 = ((int)0X8ce0),
        ColorAttachment0Ext = ((int)0X8ce0),
        ColorAttachment1 = ((int)0X8ce1),
        ColorAttachment1Ext = ((int)0X8ce1),
        ColorAttachment2 = ((int)0X8ce2),
        ColorAttachment2Ext = ((int)0X8ce2),
        ColorAttachment3 = ((int)0X8ce3),
        ColorAttachment3Ext = ((int)0X8ce3),
        ColorAttachment4 = ((int)0X8ce4),
        ColorAttachment4Ext = ((int)0X8ce4),
        ColorAttachment5 = ((int)0X8ce5),
        ColorAttachment5Ext = ((int)0X8ce5),
        ColorAttachment6 = ((int)0X8ce6),
        ColorAttachment6Ext = ((int)0X8ce6),
        ColorAttachment7 = ((int)0X8ce7),
        ColorAttachment7Ext = ((int)0X8ce7),
        ColorAttachment8 = ((int)0X8ce8),
        ColorAttachment8Ext = ((int)0X8ce8),
        ColorAttachment9 = ((int)0X8ce9),
        ColorAttachment9Ext = ((int)0X8ce9),
        ColorAttachment10 = ((int)0X8cea),
        ColorAttachment10Ext = ((int)0X8cea),
        ColorAttachment11 = ((int)0X8ceb),
        ColorAttachment11Ext = ((int)0X8ceb),
        ColorAttachment12 = ((int)0X8cec),
        ColorAttachment12Ext = ((int)0X8cec),
        ColorAttachment13 = ((int)0X8ced),
        ColorAttachment13Ext = ((int)0X8ced),
        ColorAttachment14 = ((int)0X8cee),
        ColorAttachment14Ext = ((int)0X8cee),
        ColorAttachment15 = ((int)0X8cef),
        ColorAttachment15Ext = ((int)0X8cef),
        DepthAttachment = ((int)0X8d00),
        DepthAttachmentExt = ((int)0X8d00),
        StencilAttachment = ((int)0X8d20),
        StencilAttachmentExt = ((int)0X8d20),
        Framebuffer = ((int)0X8d40),
        FramebufferExt = ((int)0X8d40),
        Renderbuffer = ((int)0X8d41),
        RenderbufferExt = ((int)0X8d41),
        RenderbufferWidth = ((int)0X8d42),
        RenderbufferWidthExt = ((int)0X8d42),
        RenderbufferHeight = ((int)0X8d43),
        RenderbufferHeightExt = ((int)0X8d43),
        RenderbufferInternalFormat = ((int)0X8d44),
        RenderbufferInternalFormatExt = ((int)0X8d44),
        StencilIndex1 = ((int)0X8d46),
        StencilIndex1Ext = ((int)0X8d46),
        StencilIndex4 = ((int)0X8d47),
        StencilIndex4Ext = ((int)0X8d47),
        StencilIndex8 = ((int)0X8d48),
        StencilIndex8Ext = ((int)0X8d48),
        StencilIndex16 = ((int)0X8d49),
        StencilIndex16Ext = ((int)0X8d49),
        RenderbufferRedSize = ((int)0X8d50),
        RenderbufferRedSizeExt = ((int)0X8d50),
        RenderbufferGreenSize = ((int)0X8d51),
        RenderbufferGreenSizeExt = ((int)0X8d51),
        RenderbufferBlueSize = ((int)0X8d52),
        RenderbufferBlueSizeExt = ((int)0X8d52),
        RenderbufferAlphaSize = ((int)0X8d53),
        RenderbufferAlphaSizeExt = ((int)0X8d53),
        RenderbufferDepthSize = ((int)0X8d54),
        RenderbufferDepthSizeExt = ((int)0X8d54),
        RenderbufferStencilSize = ((int)0X8d55),
        RenderbufferStencilSizeExt = ((int)0X8d55),
        FramebufferIncompleteMultisample = ((int)0X8d56),
        FramebufferIncompleteMultisampleExt = ((int)0X8d56),
        MaxSamples = ((int)0X8d57),
        MaxSamplesExt = ((int)0X8d57),
        Rgba32ui = ((int)0X8d70),
        Rgba32uiExt = ((int)0X8d70),
        Rgb32ui = ((int)0X8d71),
        Rgb32uiExt = ((int)0X8d71),
        Alpha32uiExt = ((int)0X8d72),
        Intensity32uiExt = ((int)0X8d73),
        Luminance32uiExt = ((int)0X8d74),
        LuminanceAlpha32uiExt = ((int)0X8d75),
        Rgba16ui = ((int)0X8d76),
        Rgba16uiExt = ((int)0X8d76),
        Rgb16ui = ((int)0X8d77),
        Rgb16uiExt = ((int)0X8d77),
        Alpha16uiExt = ((int)0X8d78),
        Intensity16uiExt = ((int)0X8d79),
        Luminance16uiExt = ((int)0X8d7a),
        LuminanceAlpha16uiExt = ((int)0X8d7b),
        Rgba8ui = ((int)0X8d7c),
        Rgba8uiExt = ((int)0X8d7c),
        Rgb8ui = ((int)0X8d7d),
        Rgb8uiExt = ((int)0X8d7d),
        Alpha8uiExt = ((int)0X8d7e),
        Intensity8uiExt = ((int)0X8d7f),
        Luminance8uiExt = ((int)0X8d80),
        LuminanceAlpha8uiExt = ((int)0X8d81),
        Rgba32i = ((int)0X8d82),
        Rgba32iExt = ((int)0X8d82),
        Rgb32i = ((int)0X8d83),
        Rgb32iExt = ((int)0X8d83),
        Alpha32iExt = ((int)0X8d84),
        Intensity32iExt = ((int)0X8d85),
        Luminance32iExt = ((int)0X8d86),
        LuminanceAlpha32iExt = ((int)0X8d87),
        Rgba16i = ((int)0X8d88),
        Rgba16iExt = ((int)0X8d88),
        Rgb16i = ((int)0X8d89),
        Rgb16iExt = ((int)0X8d89),
        Alpha16iExt = ((int)0X8d8a),
        Intensity16iExt = ((int)0X8d8b),
        Luminance16iExt = ((int)0X8d8c),
        LuminanceAlpha16iExt = ((int)0X8d8d),
        Rgba8i = ((int)0X8d8e),
        Rgba8iExt = ((int)0X8d8e),
        Rgb8i = ((int)0X8d8f),
        Rgb8iExt = ((int)0X8d8f),
        Alpha8iExt = ((int)0X8d90),
        Intensity8iExt = ((int)0X8d91),
        Luminance8iExt = ((int)0X8d92),
        LuminanceAlpha8iExt = ((int)0X8d93),
        RedInteger = ((int)0X8d94),
        RedIntegerExt = ((int)0X8d94),
        GreenInteger = ((int)0X8d95),
        GreenIntegerExt = ((int)0X8d95),
        BlueInteger = ((int)0X8d96),
        BlueIntegerExt = ((int)0X8d96),
        AlphaInteger = ((int)0X8d97),
        AlphaIntegerExt = ((int)0X8d97),
        RgbInteger = ((int)0X8d98),
        RgbIntegerExt = ((int)0X8d98),
        RgbaInteger = ((int)0X8d99),
        RgbaIntegerExt = ((int)0X8d99),
        BgrInteger = ((int)0X8d9a),
        BgrIntegerExt = ((int)0X8d9a),
        BgraInteger = ((int)0X8d9b),
        BgraIntegerExt = ((int)0X8d9b),
        LuminanceIntegerExt = ((int)0X8d9c),
        LuminanceAlphaIntegerExt = ((int)0X8d9d),
        RgbaIntegerModeExt = ((int)0X8d9e),
        MaxProgramParameterBufferBindingsNv = ((int)0X8da0),
        MaxProgramParameterBufferSizeNv = ((int)0X8da1),
        VertexProgramParameterBufferNv = ((int)0X8da2),
        GeometryProgramParameterBufferNv = ((int)0X8da3),
        FragmentProgramParameterBufferNv = ((int)0X8da4),
        MaxProgramGenericAttribsNv = ((int)0X8da5),
        MaxProgramGenericResultsNv = ((int)0X8da6),
        FramebufferAttachmentLayered = ((int)0X8da7),
        FramebufferAttachmentLayeredArb = ((int)0X8da7),
        FramebufferAttachmentLayeredExt = ((int)0X8da7),
        FramebufferIncompleteLayerTargets = ((int)0X8da8),
        FramebufferIncompleteLayerTargetsArb = ((int)0X8da8),
        FramebufferIncompleteLayerTargetsExt = ((int)0X8da8),
        FramebufferIncompleteLayerCountArb = ((int)0X8da9),
        FramebufferIncompleteLayerCountExt = ((int)0X8da9),
        DepthComponent32fNv = ((int)0X8dab),
        Depth32fStencil8Nv = ((int)0X8dac),
        Float32UnsignedInt248Rev = ((int)0X8dad),
        Float32UnsignedInt248RevNv = ((int)0X8dad),
        DepthBufferFloatModeNv = ((int)0X8daf),
        FramebufferSrgb = ((int)0X8db9),
        FramebufferSrgbExt = ((int)0X8db9),
        FramebufferSrgbCapableExt = ((int)0X8dba),
        CompressedRedRgtc1 = ((int)0X8dbb),
        CompressedRedRgtc1Ext = ((int)0X8dbb),
        CompressedSignedRedRgtc1 = ((int)0X8dbc),
        CompressedSignedRedRgtc1Ext = ((int)0X8dbc),
        CompressedRedGreenRgtc2Ext = ((int)0X8dbd),
        CompressedRgRgtc2 = ((int)0X8dbd),
        CompressedSignedRedGreenRgtc2Ext = ((int)0X8dbe),
        CompressedSignedRgRgtc2 = ((int)0X8dbe),
        Sampler1DArray = ((int)0X8dc0),
        Sampler1DArrayExt = ((int)0X8dc0),
        Sampler2DArray = ((int)0X8dc1),
        Sampler2DArrayExt = ((int)0X8dc1),
        SamplerBuffer = ((int)0X8dc2),
        SamplerBufferExt = ((int)0X8dc2),
        Sampler1DArrayShadow = ((int)0X8dc3),
        Sampler1DArrayShadowExt = ((int)0X8dc3),
        Sampler2DArrayShadow = ((int)0X8dc4),
        Sampler2DArrayShadowExt = ((int)0X8dc4),
        SamplerCubeShadow = ((int)0X8dc5),
        SamplerCubeShadowExt = ((int)0X8dc5),
        UnsignedIntVec2 = ((int)0X8dc6),
        UnsignedIntVec2Ext = ((int)0X8dc6),
        UnsignedIntVec3 = ((int)0X8dc7),
        UnsignedIntVec3Ext = ((int)0X8dc7),
        UnsignedIntVec4 = ((int)0X8dc8),
        UnsignedIntVec4Ext = ((int)0X8dc8),
        IntSampler1D = ((int)0X8dc9),
        IntSampler1DExt = ((int)0X8dc9),
        IntSampler2D = ((int)0X8dca),
        IntSampler2DExt = ((int)0X8dca),
        IntSampler3D = ((int)0X8dcb),
        IntSampler3DExt = ((int)0X8dcb),
        IntSamplerCube = ((int)0X8dcc),
        IntSamplerCubeExt = ((int)0X8dcc),
        IntSampler2DRect = ((int)0X8dcd),
        IntSampler2DRectExt = ((int)0X8dcd),
        IntSampler1DArray = ((int)0X8dce),
        IntSampler1DArrayExt = ((int)0X8dce),
        IntSampler2DArray = ((int)0X8dcf),
        IntSampler2DArrayExt = ((int)0X8dcf),
        IntSamplerBuffer = ((int)0X8dd0),
        IntSamplerBufferExt = ((int)0X8dd0),
        UnsignedIntSampler1D = ((int)0X8dd1),
        UnsignedIntSampler1DExt = ((int)0X8dd1),
        UnsignedIntSampler2D = ((int)0X8dd2),
        UnsignedIntSampler2DExt = ((int)0X8dd2),
        UnsignedIntSampler3D = ((int)0X8dd3),
        UnsignedIntSampler3DExt = ((int)0X8dd3),
        UnsignedIntSamplerCube = ((int)0X8dd4),
        UnsignedIntSamplerCubeExt = ((int)0X8dd4),
        UnsignedIntSampler2DRect = ((int)0X8dd5),
        UnsignedIntSampler2DRectExt = ((int)0X8dd5),
        UnsignedIntSampler1DArray = ((int)0X8dd6),
        UnsignedIntSampler1DArrayExt = ((int)0X8dd6),
        UnsignedIntSampler2DArray = ((int)0X8dd7),
        UnsignedIntSampler2DArrayExt = ((int)0X8dd7),
        UnsignedIntSamplerBuffer = ((int)0X8dd8),
        UnsignedIntSamplerBufferExt = ((int)0X8dd8),
        GeometryShader = ((int)0X8dd9),
        GeometryShaderArb = ((int)0X8dd9),
        GeometryShaderExt = ((int)0X8dd9),
        GeometryVerticesOutArb = ((int)0X8dda),
        GeometryVerticesOutExt = ((int)0X8dda),
        GeometryInputTypeArb = ((int)0X8ddb),
        GeometryInputTypeExt = ((int)0X8ddb),
        GeometryOutputTypeArb = ((int)0X8ddc),
        GeometryOutputTypeExt = ((int)0X8ddc),
        MaxGeometryVaryingComponentsArb = ((int)0X8ddd),
        MaxGeometryVaryingComponentsExt = ((int)0X8ddd),
        MaxVertexVaryingComponentsArb = ((int)0X8dde),
        MaxVertexVaryingComponentsExt = ((int)0X8dde),
        MaxGeometryUniformComponents = ((int)0X8ddf),
        MaxGeometryUniformComponentsArb = ((int)0X8ddf),
        MaxGeometryUniformComponentsExt = ((int)0X8ddf),
        MaxGeometryOutputVertices = ((int)0X8de0),
        MaxGeometryOutputVerticesArb = ((int)0X8de0),
        MaxGeometryOutputVerticesExt = ((int)0X8de0),
        MaxGeometryTotalOutputComponents = ((int)0X8de1),
        MaxGeometryTotalOutputComponentsArb = ((int)0X8de1),
        MaxGeometryTotalOutputComponentsExt = ((int)0X8de1),
        MaxVertexBindableUniformsExt = ((int)0X8de2),
        MaxFragmentBindableUniformsExt = ((int)0X8de3),
        MaxGeometryBindableUniformsExt = ((int)0X8de4),
        MaxBindableUniformSizeExt = ((int)0X8ded),
        UniformBufferExt = ((int)0X8dee),
        UniformBufferBindingExt = ((int)0X8def),
        RenderbufferColorSamplesNv = ((int)0X8e10),
        MaxMultisampleCoverageModesNv = ((int)0X8e11),
        MultisampleCoverageModesNv = ((int)0X8e12),
        QueryWait = ((int)0X8e13),
        QueryWaitNv = ((int)0X8e13),
        QueryNoWait = ((int)0X8e14),
        QueryNoWaitNv = ((int)0X8e14),
        QueryByRegionWait = ((int)0X8e15),
        QueryByRegionWaitNv = ((int)0X8e15),
        QueryByRegionNoWait = ((int)0X8e16),
        QueryByRegionNoWaitNv = ((int)0X8e16),
        TransformFeedbackNv = ((int)0X8e22),
        TransformFeedbackBufferPausedNv = ((int)0X8e23),
        TransformFeedbackBufferActiveNv = ((int)0X8e24),
        TransformFeedbackBindingNv = ((int)0X8e25),
        FrameNv = ((int)0X8e26),
        FieldsNv = ((int)0X8e27),
        CurrentTimeNv = ((int)0X8e28),
        NumFillStreamsNv = ((int)0X8e29),
        PresentTimeNv = ((int)0X8e2a),
        PresentDurationNv = ((int)0X8e2b),
        ProgramMatrixExt = ((int)0X8e2d),
        TransposeProgramMatrixExt = ((int)0X8e2e),
        ProgramMatrixStackDepthExt = ((int)0X8e2f),
        TextureSwizzleRExt = ((int)0X8e42),
        TextureSwizzleGExt = ((int)0X8e43),
        TextureSwizzleBExt = ((int)0X8e44),
        TextureSwizzleAExt = ((int)0X8e45),
        TextureSwizzleRgbaExt = ((int)0X8e46),
        QuadsFollowProvokingVertexConvention = ((int)0X8e4c),
        QuadsFollowProvokingVertexConventionExt = ((int)0X8e4c),
        FirstVertexConvention = ((int)0X8e4d),
        FirstVertexConventionExt = ((int)0X8e4d),
        LastVertexConvention = ((int)0X8e4e),
        LastVertexConventionExt = ((int)0X8e4e),
        ProvokingVertex = ((int)0X8e4f),
        ProvokingVertexExt = ((int)0X8e4f),
        SamplePosition = ((int)0X8e50),
        SamplePositionNv = ((int)0X8e50),
        SampleMask = ((int)0X8e51),
        SampleMaskNv = ((int)0X8e51),
        SampleMaskValue = ((int)0X8e52),
        SampleMaskValueNv = ((int)0X8e52),
        TextureBindingRenderbufferNv = ((int)0X8e53),
        TextureRenderbufferDataStoreBindingNv = ((int)0X8e54),
        TextureRenderbufferNv = ((int)0X8e55),
        SamplerRenderbufferNv = ((int)0X8e56),
        IntSamplerRenderbufferNv = ((int)0X8e57),
        UnsignedIntSamplerRenderbufferNv = ((int)0X8e58),
        MaxSampleMaskWords = ((int)0X8e59),
        MaxSampleMaskWordsNv = ((int)0X8e59),
        MinProgramTextureGatherOffset = ((int)0X8e5e),
        MaxProgramTextureGatherOffset = ((int)0X8e5f),
        CopyReadBuffer = ((int)0X8f36),
        CopyWriteBuffer = ((int)0X8f37),
        RedSnorm = ((int)0X8f90),
        RgSnorm = ((int)0X8f91),
        RgbSnorm = ((int)0X8f92),
        RgbaSnorm = ((int)0X8f93),
        R8Snorm = ((int)0X8f94),
        Rg8Snorm = ((int)0X8f95),
        Rgb8Snorm = ((int)0X8f96),
        Rgba8Snorm = ((int)0X8f97),
        R16Snorm = ((int)0X8f98),
        Rg16Snorm = ((int)0X8f99),
        Rgb16Snorm = ((int)0X8f9a),
        Rgba16Snorm = ((int)0X8f9b),
        SignedNormalized = ((int)0X8f9c),
        PrimitiveRestart = ((int)0X8f9d),
        PrimitiveRestartIndex = ((int)0X8f9e),
        MaxProgramTextureGatherComponents = ((int)0X8f9f),
        SamplerBufferAmd = ((int)0X9001),
        IntSamplerBufferAmd = ((int)0X9002),
        UnsignedIntSamplerBufferAmd = ((int)0X9003),
        TessellationModeAmd = ((int)0X9004),
        TessellationFactorAmd = ((int)0X9005),
        DiscreteAmd = ((int)0X9006),
        ContinuousAmd = ((int)0X9007),
        TextureCubeMapArray = ((int)0X9009),
        TextureBindingCubeMapArray = ((int)0X900a),
        ProxyTextureCubeMapArray = ((int)0X900b),
        SamplerCubeMapArray = ((int)0X900c),
        SamplerCubeMapArrayShadow = ((int)0X900d),
        IntSamplerCubeMapArray = ((int)0X900e),
        UnsignedIntSamplerCubeMapArray = ((int)0X900f),
        AlphaSnorm = ((int)0X9010),
        LuminanceSnorm = ((int)0X9011),
        LuminanceAlphaSnorm = ((int)0X9012),
        IntensitySnorm = ((int)0X9013),
        Alpha8Snorm = ((int)0X9014),
        Luminance8Snorm = ((int)0X9015),
        Luminance8Alpha8Snorm = ((int)0X9016),
        Intensity8Snorm = ((int)0X9017),
        Alpha16Snorm = ((int)0X9018),
        Luminance16Snorm = ((int)0X9019),
        Luminance16Alpha16Snorm = ((int)0X901a),
        Intensity16Snorm = ((int)0X901b),
        Texture2DMultisample = ((int)0X9100),
        ProxyTexture2DMultisample = ((int)0X9101),
        Texture2DMultisampleArray = ((int)0X9102),
        ProxyTexture2DMultisampleArray = ((int)0X9103),
        TextureBinding2DMultisample = ((int)0X9104),
        TextureBinding2DMultisampleArray = ((int)0X9105),
        TextureSamples = ((int)0X9106),
        TextureFixedSampleLocations = ((int)0X9107),
        Sampler2DMultisample = ((int)0X9108),
        IntSampler2DMultisample = ((int)0X9109),
        UnsignedIntSampler2DMultisample = ((int)0X910a),
        Sampler2DMultisampleArray = ((int)0X910b),
        IntSampler2DMultisampleArray = ((int)0X910c),
        UnsignedIntSampler2DMultisampleArray = ((int)0X910d),
        MaxColorTextureSamples = ((int)0X910e),
        MaxDepthTextureSamples = ((int)0X910f),
        MaxIntegerSamples = ((int)0X9110),
        MaxServerWaitTimeout = ((int)0X9111),
        ObjectType = ((int)0X9112),
        SyncCondition = ((int)0X9113),
        SyncStatus = ((int)0X9114),
        SyncFlags = ((int)0X9115),
        SyncFence = ((int)0X9116),
        SyncGpuCommandsComplete = ((int)0X9117),
        Unsignaled = ((int)0X9118),
        Signaled = ((int)0X9119),
        AlreadySignaled = ((int)0X911a),
        TimeoutExpired = ((int)0X911b),
        ConditionSatisfied = ((int)0X911c),
        WaitFailed = ((int)0X911d),
        BufferAccessFlags = ((int)0X911f),
        BufferMapLength = ((int)0X9120),
        BufferMapOffset = ((int)0X9121),
        MaxVertexOutputComponents = ((int)0X9122),
        MaxGeometryInputComponents = ((int)0X9123),
        MaxGeometryOutputComponents = ((int)0X9124),
        MaxFragmentInputComponents = ((int)0X9125),
        ContextProfileMask = ((int)0X9126),
        AllAttribBits = unchecked((int)0Xffffffff),
        ClientAllAttribBits = unchecked((int)0Xffffffff),
        InvalidIndex = unchecked((int)0Xffffffff),
        TimeoutIgnored = unchecked((int)0Xffffffffffffffff),
        One = ((int)1),
        True = ((int)1),
        CullVertexIbm = ((int)103050),
        VertexArrayListIbm = ((int)103070),
        NormalArrayListIbm = ((int)103071),
        ColorArrayListIbm = ((int)103072),
        IndexArrayListIbm = ((int)103073),
        TextureCoordArrayListIbm = ((int)103074),
        EdgeFlagArrayListIbm = ((int)103075),
        FogCoordinateArrayListIbm = ((int)103076),
        SecondaryColorArrayListIbm = ((int)103077),
        VertexArrayListStrideIbm = ((int)103080),
        NormalArrayListStrideIbm = ((int)103081),
        ColorArrayListStrideIbm = ((int)103082),
        IndexArrayListStrideIbm = ((int)103083),
        TextureCoordArrayListStrideIbm = ((int)103084),
        EdgeFlagArrayListStrideIbm = ((int)103085),
        FogCoordinateArrayListStrideIbm = ((int)103086),
        SecondaryColorArrayListStrideIbm = ((int)103087),
        Two = ((int)2),
        Three = ((int)3),
        Four = ((int)4),
    }

    public enum AlphaFunction
    {
        Never = ((int)0X0200),
        Less = ((int)0X0201),
        Equal = ((int)0X0202),
        Lequal = ((int)0X0203),
        Greater = ((int)0X0204),
        Notequal = ((int)0X0205),
        Gequal = ((int)0X0206),
        Always = ((int)0X0207),
    }

    public enum AmdDrawBuffersBlend
    {
    }

    public enum AmdPerformanceMonitor
    {
        CounterTypeAmd = ((int)0X8bc0),
        CounterRangeAmd = ((int)0X8bc1),
        UnsignedInt64Amd = ((int)0X8bc2),
        PercentageAmd = ((int)0X8bc3),
        PerfmonResultAvailableAmd = ((int)0X8bc4),
        PerfmonResultSizeAmd = ((int)0X8bc5),
        PerfmonResultAmd = ((int)0X8bc6),
    }

    public enum AmdTextureTexture4
    {
    }

    public enum AmdVertexShaderTesselator
    {
        SamplerBufferAmd = ((int)0X9001),
        IntSamplerBufferAmd = ((int)0X9002),
        UnsignedIntSamplerBufferAmd = ((int)0X9003),
        TessellationModeAmd = ((int)0X9004),
        TessellationFactorAmd = ((int)0X9005),
        DiscreteAmd = ((int)0X9006),
        ContinuousAmd = ((int)0X9007),
    }

    public enum AppleAuxDepthStencil
    {
        AuxDepthStencilApple = ((int)0X8a14),
    }

    public enum AppleClientStorage
    {
        UnpackClientStorageApple = ((int)0X85b2),
    }

    public enum AppleElementArray
    {
        ElementArrayApple = ((int)0X8768),
        ElementArrayTypeApple = ((int)0X8769),
        ElementArrayPointerApple = ((int)0X876a),
    }

    public enum AppleFence
    {
        DrawPixelsApple = ((int)0X8a0a),
        FenceApple = ((int)0X8a0b),
    }

    public enum AppleFloatPixels
    {
        HalfApple = ((int)0X140b),
        RgbaFloat32Apple = ((int)0X8814),
        RgbFloat32Apple = ((int)0X8815),
        AlphaFloat32Apple = ((int)0X8816),
        IntensityFloat32Apple = ((int)0X8817),
        LuminanceFloat32Apple = ((int)0X8818),
        LuminanceAlphaFloat32Apple = ((int)0X8819),
        RgbaFloat16Apple = ((int)0X881a),
        RgbFloat16Apple = ((int)0X881b),
        AlphaFloat16Apple = ((int)0X881c),
        IntensityFloat16Apple = ((int)0X881d),
        LuminanceFloat16Apple = ((int)0X881e),
        LuminanceAlphaFloat16Apple = ((int)0X881f),
        ColorFloatApple = ((int)0X8a0f),
    }

    public enum AppleFlushBufferRange
    {
        BufferSerializedModifyApple = ((int)0X8a12),
        BufferFlushingUnmapApple = ((int)0X8a13),
    }

    public enum AppleObjectPurgeable
    {
        BufferObjectApple = ((int)0X85b3),
        ReleasedApple = ((int)0X8a19),
        VolatileApple = ((int)0X8a1a),
        RetainedApple = ((int)0X8a1b),
        UndefinedApple = ((int)0X8a1c),
        PurgeableApple = ((int)0X8a1d),
    }

    public enum AppleRowBytes
    {
        PackRowBytesApple = ((int)0X8a15),
        UnpackRowBytesApple = ((int)0X8a16),
    }

    public enum AppleSpecularVector
    {
        LightModelSpecularVectorApple = ((int)0X85b0),
    }

    public enum AppleTextureRange
    {
        TextureRangeLengthApple = ((int)0X85b7),
        TextureRangePointerApple = ((int)0X85b8),
        TextureStorageHintApple = ((int)0X85bc),
        StoragePrivateApple = ((int)0X85bd),
        StorageCachedApple = ((int)0X85be),
        StorageSharedApple = ((int)0X85bf),
    }

    public enum AppleTransformHint
    {
        TransformHintApple = ((int)0X85b1),
    }

    public enum AppleVertexArrayObject
    {
        VertexArrayBindingApple = ((int)0X85b5),
    }

    public enum AppleVertexArrayRange
    {
        VertexArrayRangeApple = ((int)0X851d),
        VertexArrayRangeLengthApple = ((int)0X851e),
        VertexArrayStorageHintApple = ((int)0X851f),
        VertexArrayRangePointerApple = ((int)0X8521),
        StorageCachedApple = ((int)0X85be),
        StorageSharedApple = ((int)0X85bf),
    }

    public enum AppleVertexProgramEvaluators
    {
        VertexAttribMap1Apple = ((int)0X8a00),
        VertexAttribMap2Apple = ((int)0X8a01),
        VertexAttribMap1SizeApple = ((int)0X8a02),
        VertexAttribMap1CoeffApple = ((int)0X8a03),
        VertexAttribMap1OrderApple = ((int)0X8a04),
        VertexAttribMap1DomainApple = ((int)0X8a05),
        VertexAttribMap2SizeApple = ((int)0X8a06),
        VertexAttribMap2CoeffApple = ((int)0X8a07),
        VertexAttribMap2OrderApple = ((int)0X8a08),
        VertexAttribMap2DomainApple = ((int)0X8a09),
    }

    public enum AppleYcbcr422
    {
        Ycbcr422Apple = ((int)0X85b9),
        UnsignedShort88Apple = ((int)0X85ba),
        UnsignedShort88RevApple = ((int)0X85bb),
    }

    public enum ArbColorBufferFloat
    {
        RgbaFloatModeArb = ((int)0X8820),
        ClampVertexColorArb = ((int)0X891a),
        ClampFragmentColorArb = ((int)0X891b),
        ClampReadColorArb = ((int)0X891c),
        FixedOnlyArb = ((int)0X891d),
    }

    public enum ArbCompatibility
    {
    }

    public enum ArbCopyBuffer
    {
        CopyReadBuffer = ((int)0X8f36),
        CopyWriteBuffer = ((int)0X8f37),
    }

    public enum ArbDepthBufferFloat
    {
        DepthComponent32f = ((int)0X8cac),
        Depth32fStencil8 = ((int)0X8cad),
        Float32UnsignedInt248Rev = ((int)0X8dad),
    }

    public enum ArbDepthClamp
    {
        DepthClamp = ((int)0X864f),
    }

    public enum ArbDepthTexture
    {
        DepthComponent16Arb = ((int)0X81a5),
        DepthComponent24Arb = ((int)0X81a6),
        DepthComponent32Arb = ((int)0X81a7),
        TextureDepthSizeArb = ((int)0X884a),
        DepthTextureModeArb = ((int)0X884b),
    }

    public enum ArbDrawBuffers
    {
        MaxDrawBuffersArb = ((int)0X8824),
        DrawBuffer0Arb = ((int)0X8825),
        DrawBuffer1Arb = ((int)0X8826),
        DrawBuffer2Arb = ((int)0X8827),
        DrawBuffer3Arb = ((int)0X8828),
        DrawBuffer4Arb = ((int)0X8829),
        DrawBuffer5Arb = ((int)0X882a),
        DrawBuffer6Arb = ((int)0X882b),
        DrawBuffer7Arb = ((int)0X882c),
        DrawBuffer8Arb = ((int)0X882d),
        DrawBuffer9Arb = ((int)0X882e),
        DrawBuffer10Arb = ((int)0X882f),
        DrawBuffer11Arb = ((int)0X8830),
        DrawBuffer12Arb = ((int)0X8831),
        DrawBuffer13Arb = ((int)0X8832),
        DrawBuffer14Arb = ((int)0X8833),
        DrawBuffer15Arb = ((int)0X8834),
    }

    public enum ArbDrawBuffersBlend
    {
    }

    public enum ArbDrawElementsBaseVertex
    {
    }

    public enum ArbDrawInstanced
    {
    }

    public enum ArbFragmentCoordConventions
    {
    }

    public enum ArbFragmentProgram
    {
        FragmentProgramArb = ((int)0X8804),
        ProgramAluInstructionsArb = ((int)0X8805),
        ProgramTexInstructionsArb = ((int)0X8806),
        ProgramTexIndirectionsArb = ((int)0X8807),
        ProgramNativeAluInstructionsArb = ((int)0X8808),
        ProgramNativeTexInstructionsArb = ((int)0X8809),
        ProgramNativeTexIndirectionsArb = ((int)0X880a),
        MaxProgramAluInstructionsArb = ((int)0X880b),
        MaxProgramTexInstructionsArb = ((int)0X880c),
        MaxProgramTexIndirectionsArb = ((int)0X880d),
        MaxProgramNativeAluInstructionsArb = ((int)0X880e),
        MaxProgramNativeTexInstructionsArb = ((int)0X880f),
        MaxProgramNativeTexIndirectionsArb = ((int)0X8810),
        MaxTextureCoordsArb = ((int)0X8871),
        MaxTextureImageUnitsArb = ((int)0X8872),
    }

    public enum ArbFragmentProgramShadow
    {
    }

    public enum ArbFragmentShader
    {
        FragmentShaderArb = ((int)0X8b30),
        MaxFragmentUniformComponentsArb = ((int)0X8b49),
        FragmentShaderDerivativeHintArb = ((int)0X8b8b),
    }

    public enum ArbFramebufferObject
    {
        InvalidFramebufferOperation = ((int)0X0506),
        FramebufferAttachmentColorEncoding = ((int)0X8210),
        FramebufferAttachmentComponentType = ((int)0X8211),
        FramebufferAttachmentRedSize = ((int)0X8212),
        FramebufferAttachmentGreenSize = ((int)0X8213),
        FramebufferAttachmentBlueSize = ((int)0X8214),
        FramebufferAttachmentAlphaSize = ((int)0X8215),
        FramebufferAttachmentDepthSize = ((int)0X8216),
        FramebufferAttachmentStencilSize = ((int)0X8217),
        FramebufferDefault = ((int)0X8218),
        FramebufferUndefined = ((int)0X8219),
        DepthStencilAttachment = ((int)0X821a),
        MaxRenderbufferSize = ((int)0X84e8),
        DepthStencil = ((int)0X84f9),
        UnsignedInt248 = ((int)0X84fa),
        Depth24Stencil8 = ((int)0X88f0),
        TextureStencilSize = ((int)0X88f1),
        TextureRedType = ((int)0X8c10),
        TextureGreenType = ((int)0X8c11),
        TextureBlueType = ((int)0X8c12),
        TextureAlphaType = ((int)0X8c13),
        TextureDepthType = ((int)0X8c16),
        UnsignedNormalized = ((int)0X8c17),
        DrawFramebufferBinding = ((int)0X8ca6),
        FramebufferBinding = ((int)0X8ca6),
        RenderbufferBinding = ((int)0X8ca7),
        ReadFramebuffer = ((int)0X8ca8),
        DrawFramebuffer = ((int)0X8ca9),
        ReadFramebufferBinding = ((int)0X8caa),
        RenderbufferSamples = ((int)0X8cab),
        FramebufferAttachmentObjectType = ((int)0X8cd0),
        FramebufferAttachmentObjectName = ((int)0X8cd1),
        FramebufferAttachmentTextureLevel = ((int)0X8cd2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0X8cd3),
        FramebufferAttachmentTextureLayer = ((int)0X8cd4),
        FramebufferComplete = ((int)0X8cd5),
        FramebufferIncompleteAttachment = ((int)0X8cd6),
        FramebufferIncompleteMissingAttachment = ((int)0X8cd7),
        FramebufferIncompleteDrawBuffer = ((int)0X8cdb),
        FramebufferIncompleteReadBuffer = ((int)0X8cdc),
        FramebufferUnsupported = ((int)0X8cdd),
        MaxColorAttachments = ((int)0X8cdf),
        ColorAttachment0 = ((int)0X8ce0),
        ColorAttachment1 = ((int)0X8ce1),
        ColorAttachment2 = ((int)0X8ce2),
        ColorAttachment3 = ((int)0X8ce3),
        ColorAttachment4 = ((int)0X8ce4),
        ColorAttachment5 = ((int)0X8ce5),
        ColorAttachment6 = ((int)0X8ce6),
        ColorAttachment7 = ((int)0X8ce7),
        ColorAttachment8 = ((int)0X8ce8),
        ColorAttachment9 = ((int)0X8ce9),
        ColorAttachment10 = ((int)0X8cea),
        ColorAttachment11 = ((int)0X8ceb),
        ColorAttachment12 = ((int)0X8cec),
        ColorAttachment13 = ((int)0X8ced),
        ColorAttachment14 = ((int)0X8cee),
        ColorAttachment15 = ((int)0X8cef),
        DepthAttachment = ((int)0X8d00),
        StencilAttachment = ((int)0X8d20),
        Framebuffer = ((int)0X8d40),
        Renderbuffer = ((int)0X8d41),
        RenderbufferWidth = ((int)0X8d42),
        RenderbufferHeight = ((int)0X8d43),
        RenderbufferInternalFormat = ((int)0X8d44),
        StencilIndex1 = ((int)0X8d46),
        StencilIndex4 = ((int)0X8d47),
        StencilIndex8 = ((int)0X8d48),
        StencilIndex16 = ((int)0X8d49),
        RenderbufferRedSize = ((int)0X8d50),
        RenderbufferGreenSize = ((int)0X8d51),
        RenderbufferBlueSize = ((int)0X8d52),
        RenderbufferAlphaSize = ((int)0X8d53),
        RenderbufferDepthSize = ((int)0X8d54),
        RenderbufferStencilSize = ((int)0X8d55),
        FramebufferIncompleteMultisample = ((int)0X8d56),
        MaxSamples = ((int)0X8d57),
    }

    public enum ArbFramebufferObjectDeprecated
    {
        Index = ((int)0X8222),
        TextureLuminanceType = ((int)0X8c14),
        TextureIntensityType = ((int)0X8c15),
    }

    public enum ArbFramebufferSrgb
    {
        FramebufferSrgb = ((int)0X8db9),
    }

    public enum ArbGeometryShader4
    {
        LinesAdjacencyArb = ((int)0X000a),
        LineStripAdjacencyArb = ((int)0X000b),
        TrianglesAdjacencyArb = ((int)0X000c),
        TriangleStripAdjacencyArb = ((int)0X000d),
        ProgramPointSizeArb = ((int)0X8642),
        MaxVaryingComponents = ((int)0X8b4b),
        MaxGeometryTextureImageUnitsArb = ((int)0X8c29),
        FramebufferAttachmentTextureLayer = ((int)0X8cd4),
        FramebufferAttachmentLayeredArb = ((int)0X8da7),
        FramebufferIncompleteLayerTargetsArb = ((int)0X8da8),
        FramebufferIncompleteLayerCountArb = ((int)0X8da9),
        GeometryShaderArb = ((int)0X8dd9),
        GeometryVerticesOutArb = ((int)0X8dda),
        GeometryInputTypeArb = ((int)0X8ddb),
        GeometryOutputTypeArb = ((int)0X8ddc),
        MaxGeometryVaryingComponentsArb = ((int)0X8ddd),
        MaxVertexVaryingComponentsArb = ((int)0X8dde),
        MaxGeometryUniformComponentsArb = ((int)0X8ddf),
        MaxGeometryOutputVerticesArb = ((int)0X8de0),
        MaxGeometryTotalOutputComponentsArb = ((int)0X8de1),
    }

    public enum ArbHalfFloatPixel
    {
        HalfFloatArb = ((int)0X140b),
    }

    public enum ArbHalfFloatVertex
    {
        HalfFloat = ((int)0X140b),
    }

    public enum ArbImaging
    {
        ConstantColor = ((int)0X8001),
        OneMinusConstantColor = ((int)0X8002),
        ConstantAlpha = ((int)0X8003),
        OneMinusConstantAlpha = ((int)0X8004),
        BlendColor = ((int)0X8005),
        FuncAdd = ((int)0X8006),
        Min = ((int)0X8007),
        Max = ((int)0X8008),
        BlendEquation = ((int)0X8009),
        FuncSubtract = ((int)0X800a),
        FuncReverseSubtract = ((int)0X800b),
    }

    public enum ArbImagingDeprecated
    {
        Convolution1D = ((int)0X8010),
        Convolution2D = ((int)0X8011),
        Separable2D = ((int)0X8012),
        ConvolutionBorderMode = ((int)0X8013),
        ConvolutionFilterScale = ((int)0X8014),
        ConvolutionFilterBias = ((int)0X8015),
        Reduce = ((int)0X8016),
        ConvolutionFormat = ((int)0X8017),
        ConvolutionWidth = ((int)0X8018),
        ConvolutionHeight = ((int)0X8019),
        MaxConvolutionWidth = ((int)0X801a),
        MaxConvolutionHeight = ((int)0X801b),
        PostConvolutionRedScale = ((int)0X801c),
        PostConvolutionGreenScale = ((int)0X801d),
        PostConvolutionBlueScale = ((int)0X801e),
        PostConvolutionAlphaScale = ((int)0X801f),
        PostConvolutionRedBias = ((int)0X8020),
        PostConvolutionGreenBias = ((int)0X8021),
        PostConvolutionBlueBias = ((int)0X8022),
        PostConvolutionAlphaBias = ((int)0X8023),
        Histogram = ((int)0X8024),
        ProxyHistogram = ((int)0X8025),
        HistogramWidth = ((int)0X8026),
        HistogramFormat = ((int)0X8027),
        HistogramRedSize = ((int)0X8028),
        HistogramGreenSize = ((int)0X8029),
        HistogramBlueSize = ((int)0X802a),
        HistogramAlphaSize = ((int)0X802b),
        HistogramLuminanceSize = ((int)0X802c),
        HistogramSink = ((int)0X802d),
        Minmax = ((int)0X802e),
        MinmaxFormat = ((int)0X802f),
        MinmaxSink = ((int)0X8030),
        TableTooLarge = ((int)0X8031),
        ColorMatrix = ((int)0X80b1),
        ColorMatrixStackDepth = ((int)0X80b2),
        MaxColorMatrixStackDepth = ((int)0X80b3),
        PostColorMatrixRedScale = ((int)0X80b4),
        PostColorMatrixGreenScale = ((int)0X80b5),
        PostColorMatrixBlueScale = ((int)0X80b6),
        PostColorMatrixAlphaScale = ((int)0X80b7),
        PostColorMatrixRedBias = ((int)0X80b8),
        PostColorMatrixGreenBias = ((int)0X80b9),
        PostColorMatrixBlueBias = ((int)0X80ba),
        PostColorMatrixAlphaBias = ((int)0X80bb),
        ColorTable = ((int)0X80d0),
        PostConvolutionColorTable = ((int)0X80d1),
        PostColorMatrixColorTable = ((int)0X80d2),
        ProxyColorTable = ((int)0X80d3),
        ProxyPostConvolutionColorTable = ((int)0X80d4),
        ProxyPostColorMatrixColorTable = ((int)0X80d5),
        ColorTableScale = ((int)0X80d6),
        ColorTableBias = ((int)0X80d7),
        ColorTableFormat = ((int)0X80d8),
        ColorTableWidth = ((int)0X80d9),
        ColorTableRedSize = ((int)0X80da),
        ColorTableGreenSize = ((int)0X80db),
        ColorTableBlueSize = ((int)0X80dc),
        ColorTableAlphaSize = ((int)0X80dd),
        ColorTableLuminanceSize = ((int)0X80de),
        ColorTableIntensitySize = ((int)0X80df),
        ConstantBorder = ((int)0X8151),
        ReplicateBorder = ((int)0X8153),
        ConvolutionBorderColor = ((int)0X8154),
    }

    public enum ArbInstancedArrays
    {
        VertexAttribArrayDivisorArb = ((int)0X88fe),
    }

    public enum ArbMapBufferRange
    {
        MapReadBit = ((int)0X0001),
        MapWriteBit = ((int)0X0002),
        MapInvalidateRangeBit = ((int)0X0004),
        MapInvalidateBufferBit = ((int)0X0008),
        MapFlushExplicitBit = ((int)0X0010),
        MapUnsynchronizedBit = ((int)0X0020),
    }

    public enum ArbMatrixPalette
    {
        MatrixPaletteArb = ((int)0X8840),
        MaxMatrixPaletteStackDepthArb = ((int)0X8841),
        MaxPaletteMatricesArb = ((int)0X8842),
        CurrentPaletteMatrixArb = ((int)0X8843),
        MatrixIndexArrayArb = ((int)0X8844),
        CurrentMatrixIndexArb = ((int)0X8845),
        MatrixIndexArraySizeArb = ((int)0X8846),
        MatrixIndexArrayTypeArb = ((int)0X8847),
        MatrixIndexArrayStrideArb = ((int)0X8848),
        MatrixIndexArrayPointerArb = ((int)0X8849),
    }

    public enum ArbMultisample
    {
        MultisampleBitArb = ((int)0X20000000),
        MultisampleArb = ((int)0X809d),
        SampleAlphaToCoverageArb = ((int)0X809e),
        SampleAlphaToOneArb = ((int)0X809f),
        SampleCoverageArb = ((int)0X80a0),
        SampleBuffersArb = ((int)0X80a8),
        SamplesArb = ((int)0X80a9),
        SampleCoverageValueArb = ((int)0X80aa),
        SampleCoverageInvertArb = ((int)0X80ab),
    }

    public enum ArbMultitexture
    {
        Texture0Arb = ((int)0X84c0),
        Texture1Arb = ((int)0X84c1),
        Texture2Arb = ((int)0X84c2),
        Texture3Arb = ((int)0X84c3),
        Texture4Arb = ((int)0X84c4),
        Texture5Arb = ((int)0X84c5),
        Texture6Arb = ((int)0X84c6),
        Texture7Arb = ((int)0X84c7),
        Texture8Arb = ((int)0X84c8),
        Texture9Arb = ((int)0X84c9),
        Texture10Arb = ((int)0X84ca),
        Texture11Arb = ((int)0X84cb),
        Texture12Arb = ((int)0X84cc),
        Texture13Arb = ((int)0X84cd),
        Texture14Arb = ((int)0X84ce),
        Texture15Arb = ((int)0X84cf),
        Texture16Arb = ((int)0X84d0),
        Texture17Arb = ((int)0X84d1),
        Texture18Arb = ((int)0X84d2),
        Texture19Arb = ((int)0X84d3),
        Texture20Arb = ((int)0X84d4),
        Texture21Arb = ((int)0X84d5),
        Texture22Arb = ((int)0X84d6),
        Texture23Arb = ((int)0X84d7),
        Texture24Arb = ((int)0X84d8),
        Texture25Arb = ((int)0X84d9),
        Texture26Arb = ((int)0X84da),
        Texture27Arb = ((int)0X84db),
        Texture28Arb = ((int)0X84dc),
        Texture29Arb = ((int)0X84dd),
        Texture30Arb = ((int)0X84de),
        Texture31Arb = ((int)0X84df),
        ActiveTextureArb = ((int)0X84e0),
        ClientActiveTextureArb = ((int)0X84e1),
        MaxTextureUnitsArb = ((int)0X84e2),
    }

    public enum ArbOcclusionQuery
    {
        QueryCounterBitsArb = ((int)0X8864),
        CurrentQueryArb = ((int)0X8865),
        QueryResultArb = ((int)0X8866),
        QueryResultAvailableArb = ((int)0X8867),
        SamplesPassedArb = ((int)0X8914),
    }

    public enum ArbPixelBufferObject
    {
        PixelPackBufferArb = ((int)0X88eb),
        PixelUnpackBufferArb = ((int)0X88ec),
        PixelPackBufferBindingArb = ((int)0X88ed),
        PixelUnpackBufferBindingArb = ((int)0X88ef),
    }

    public enum ArbPointParameters
    {
        PointSizeMinArb = ((int)0X8126),
        PointSizeMaxArb = ((int)0X8127),
        PointFadeThresholdSizeArb = ((int)0X8128),
        PointDistanceAttenuationArb = ((int)0X8129),
    }

    public enum ArbPointSprite
    {
        PointSpriteArb = ((int)0X8861),
        CoordReplaceArb = ((int)0X8862),
    }

    public enum ArbProvokingVertex
    {
        QuadsFollowProvokingVertexConvention = ((int)0X8e4c),
        FirstVertexConvention = ((int)0X8e4d),
        LastVertexConvention = ((int)0X8e4e),
        ProvokingVertex = ((int)0X8e4f),
    }

    public enum ArbSampleShading
    {
        SampleShading = ((int)0X8c36),
        MinSampleShadingValue = ((int)0X8c37),
    }

    public enum ArbSeamlessCubeMap
    {
        TextureCubeMapSeamless = ((int)0X884f),
    }

    public enum ArbShaderObjects
    {
        ProgramObjectArb = ((int)0X8b40),
        ShaderObjectArb = ((int)0X8b48),
        ObjectTypeArb = ((int)0X8b4e),
        ObjectSubtypeArb = ((int)0X8b4f),
        FloatVec2Arb = ((int)0X8b50),
        FloatVec3Arb = ((int)0X8b51),
        FloatVec4Arb = ((int)0X8b52),
        IntVec2Arb = ((int)0X8b53),
        IntVec3Arb = ((int)0X8b54),
        IntVec4Arb = ((int)0X8b55),
        BoolArb = ((int)0X8b56),
        BoolVec2Arb = ((int)0X8b57),
        BoolVec3Arb = ((int)0X8b58),
        BoolVec4Arb = ((int)0X8b59),
        FloatMat2Arb = ((int)0X8b5a),
        FloatMat3Arb = ((int)0X8b5b),
        FloatMat4Arb = ((int)0X8b5c),
        Sampler1DArb = ((int)0X8b5d),
        Sampler2DArb = ((int)0X8b5e),
        Sampler3DArb = ((int)0X8b5f),
        SamplerCubeArb = ((int)0X8b60),
        Sampler1DShadowArb = ((int)0X8b61),
        Sampler2DShadowArb = ((int)0X8b62),
        Sampler2DRectArb = ((int)0X8b63),
        Sampler2DRectShadowArb = ((int)0X8b64),
        ObjectDeleteStatusArb = ((int)0X8b80),
        ObjectCompileStatusArb = ((int)0X8b81),
        ObjectLinkStatusArb = ((int)0X8b82),
        ObjectValidateStatusArb = ((int)0X8b83),
        ObjectInfoLogLengthArb = ((int)0X8b84),
        ObjectAttachedObjectsArb = ((int)0X8b85),
        ObjectActiveUniformsArb = ((int)0X8b86),
        ObjectActiveUniformMaxLengthArb = ((int)0X8b87),
        ObjectShaderSourceLengthArb = ((int)0X8b88),
    }

    public enum ArbShaderTextureLod
    {
    }

    public enum ArbShadingLanguage100
    {
        ShadingLanguageVersionArb = ((int)0X8b8c),
    }

    public enum ArbShadow
    {
        TextureCompareModeArb = ((int)0X884c),
        TextureCompareFuncArb = ((int)0X884d),
        CompareRToTextureArb = ((int)0X884e),
    }

    public enum ArbShadowAmbient
    {
        TextureCompareFailValueArb = ((int)0X80bf),
    }

    public enum ArbSync
    {
        SyncFlushCommandsBit = ((int)0X00000001),
        MaxServerWaitTimeout = ((int)0X9111),
        ObjectType = ((int)0X9112),
        SyncCondition = ((int)0X9113),
        SyncStatus = ((int)0X9114),
        SyncFlags = ((int)0X9115),
        SyncFence = ((int)0X9116),
        SyncGpuCommandsComplete = ((int)0X9117),
        Unsignaled = ((int)0X9118),
        Signaled = ((int)0X9119),
        AlreadySignaled = ((int)0X911a),
        TimeoutExpired = ((int)0X911b),
        ConditionSatisfied = ((int)0X911c),
        WaitFailed = ((int)0X911d),
        TimeoutIgnored = unchecked((int)0Xffffffffffffffff),
    }

    public enum ArbTextureBorderClamp
    {
        ClampToBorderArb = ((int)0X812d),
    }

    public enum ArbTextureBufferObject
    {
        TextureBufferArb = ((int)0X8c2a),
        MaxTextureBufferSizeArb = ((int)0X8c2b),
        TextureBindingBufferArb = ((int)0X8c2c),
        TextureBufferDataStoreBindingArb = ((int)0X8c2d),
        TextureBufferFormatArb = ((int)0X8c2e),
    }

    public enum ArbTextureCompression
    {
        CompressedAlphaArb = ((int)0X84e9),
        CompressedLuminanceArb = ((int)0X84ea),
        CompressedLuminanceAlphaArb = ((int)0X84eb),
        CompressedIntensityArb = ((int)0X84ec),
        CompressedRgbArb = ((int)0X84ed),
        CompressedRgbaArb = ((int)0X84ee),
        TextureCompressionHintArb = ((int)0X84ef),
        TextureCompressedImageSizeArb = ((int)0X86a0),
        TextureCompressedArb = ((int)0X86a1),
        NumCompressedTextureFormatsArb = ((int)0X86a2),
        CompressedTextureFormatsArb = ((int)0X86a3),
    }

    public enum ArbTextureCompressionRgtc
    {
        CompressedRedRgtc1 = ((int)0X8dbb),
        CompressedSignedRedRgtc1 = ((int)0X8dbc),
        CompressedRgRgtc2 = ((int)0X8dbd),
        CompressedSignedRgRgtc2 = ((int)0X8dbe),
    }

    public enum ArbTextureCubeMap
    {
        NormalMapArb = ((int)0X8511),
        ReflectionMapArb = ((int)0X8512),
        TextureCubeMapArb = ((int)0X8513),
        TextureBindingCubeMapArb = ((int)0X8514),
        TextureCubeMapPositiveXArb = ((int)0X8515),
        TextureCubeMapNegativeXArb = ((int)0X8516),
        TextureCubeMapPositiveYArb = ((int)0X8517),
        TextureCubeMapNegativeYArb = ((int)0X8518),
        TextureCubeMapPositiveZArb = ((int)0X8519),
        TextureCubeMapNegativeZArb = ((int)0X851a),
        ProxyTextureCubeMapArb = ((int)0X851b),
        MaxCubeMapTextureSizeArb = ((int)0X851c),
    }

    public enum ArbTextureCubeMapArray
    {
        TextureCubeMapArray = ((int)0X9009),
        TextureBindingCubeMapArray = ((int)0X900a),
        ProxyTextureCubeMapArray = ((int)0X900b),
        SamplerCubeMapArray = ((int)0X900c),
        SamplerCubeMapArrayShadow = ((int)0X900d),
        IntSamplerCubeMapArray = ((int)0X900e),
        UnsignedIntSamplerCubeMapArray = ((int)0X900f),
    }

    public enum ArbTextureEnvAdd
    {
    }

    public enum ArbTextureEnvCombine
    {
        SubtractArb = ((int)0X84e7),
        CombineArb = ((int)0X8570),
        CombineRgbArb = ((int)0X8571),
        CombineAlphaArb = ((int)0X8572),
        RgbScaleArb = ((int)0X8573),
        AddSignedArb = ((int)0X8574),
        InterpolateArb = ((int)0X8575),
        ConstantArb = ((int)0X8576),
        PrimaryColorArb = ((int)0X8577),
        PreviousArb = ((int)0X8578),
        Source0RgbArb = ((int)0X8580),
        Source1RgbArb = ((int)0X8581),
        Source2RgbArb = ((int)0X8582),
        Source0AlphaArb = ((int)0X8588),
        Source1AlphaArb = ((int)0X8589),
        Source2AlphaArb = ((int)0X858a),
        Operand0RgbArb = ((int)0X8590),
        Operand1RgbArb = ((int)0X8591),
        Operand2RgbArb = ((int)0X8592),
        Operand0AlphaArb = ((int)0X8598),
        Operand1AlphaArb = ((int)0X8599),
        Operand2AlphaArb = ((int)0X859a),
    }

    public enum ArbTextureEnvCrossbar
    {
    }

    public enum ArbTextureEnvDot3
    {
        Dot3RgbArb = ((int)0X86ae),
        Dot3RgbaArb = ((int)0X86af),
    }

    public enum ArbTextureFloat
    {
        Rgba32fArb = ((int)0X8814),
        Rgb32fArb = ((int)0X8815),
        Alpha32fArb = ((int)0X8816),
        Intensity32fArb = ((int)0X8817),
        Luminance32fArb = ((int)0X8818),
        LuminanceAlpha32fArb = ((int)0X8819),
        Rgba16fArb = ((int)0X881a),
        Rgb16fArb = ((int)0X881b),
        Alpha16fArb = ((int)0X881c),
        Intensity16fArb = ((int)0X881d),
        Luminance16fArb = ((int)0X881e),
        LuminanceAlpha16fArb = ((int)0X881f),
        TextureRedTypeArb = ((int)0X8c10),
        TextureGreenTypeArb = ((int)0X8c11),
        TextureBlueTypeArb = ((int)0X8c12),
        TextureAlphaTypeArb = ((int)0X8c13),
        TextureLuminanceTypeArb = ((int)0X8c14),
        TextureIntensityTypeArb = ((int)0X8c15),
        TextureDepthTypeArb = ((int)0X8c16),
        UnsignedNormalizedArb = ((int)0X8c17),
    }

    public enum ArbTextureGather
    {
        MinProgramTextureGatherOffset = ((int)0X8e5e),
        MaxProgramTextureGatherOffset = ((int)0X8e5f),
        MaxProgramTextureGatherComponents = ((int)0X8f9f),
    }

    public enum ArbTextureMirroredRepeat
    {
        MirroredRepeatArb = ((int)0X8370),
    }

    public enum ArbTextureMultisample
    {
        SamplePosition = ((int)0X8e50),
        SampleMask = ((int)0X8e51),
        SampleMaskValue = ((int)0X8e52),
        MaxSampleMaskWords = ((int)0X8e59),
        Texture2DMultisample = ((int)0X9100),
        ProxyTexture2DMultisample = ((int)0X9101),
        Texture2DMultisampleArray = ((int)0X9102),
        ProxyTexture2DMultisampleArray = ((int)0X9103),
        TextureBinding2DMultisample = ((int)0X9104),
        TextureBinding2DMultisampleArray = ((int)0X9105),
        TextureSamples = ((int)0X9106),
        TextureFixedSampleLocations = ((int)0X9107),
        Sampler2DMultisample = ((int)0X9108),
        IntSampler2DMultisample = ((int)0X9109),
        UnsignedIntSampler2DMultisample = ((int)0X910a),
        Sampler2DMultisampleArray = ((int)0X910b),
        IntSampler2DMultisampleArray = ((int)0X910c),
        UnsignedIntSampler2DMultisampleArray = ((int)0X910d),
        MaxColorTextureSamples = ((int)0X910e),
        MaxDepthTextureSamples = ((int)0X910f),
        MaxIntegerSamples = ((int)0X9110),
    }

    public enum ArbTextureNonPowerOfTwo
    {
    }

    public enum ArbTextureQueryLod
    {
    }

    public enum ArbTextureRectangle
    {
        TextureRectangleArb = ((int)0X84f5),
        TextureBindingRectangleArb = ((int)0X84f6),
        ProxyTextureRectangleArb = ((int)0X84f7),
        MaxRectangleTextureSizeArb = ((int)0X84f8),
    }

    public enum ArbTextureRg
    {
        Rg = ((int)0X8227),
        RgInteger = ((int)0X8228),
        R8 = ((int)0X8229),
        R16 = ((int)0X822a),
        Rg8 = ((int)0X822b),
        Rg16 = ((int)0X822c),
        R16f = ((int)0X822d),
        R32f = ((int)0X822e),
        Rg16f = ((int)0X822f),
        Rg32f = ((int)0X8230),
        R8i = ((int)0X8231),
        R8ui = ((int)0X8232),
        R16i = ((int)0X8233),
        R16ui = ((int)0X8234),
        R32i = ((int)0X8235),
        R32ui = ((int)0X8236),
        Rg8i = ((int)0X8237),
        Rg8ui = ((int)0X8238),
        Rg16i = ((int)0X8239),
        Rg16ui = ((int)0X823a),
        Rg32i = ((int)0X823b),
        Rg32ui = ((int)0X823c),
    }

    public enum ArbTransposeMatrix
    {
        TransposeModelviewMatrixArb = ((int)0X84e3),
        TransposeProjectionMatrixArb = ((int)0X84e4),
        TransposeTextureMatrixArb = ((int)0X84e5),
        TransposeColorMatrixArb = ((int)0X84e6),
    }

    public enum ArbUniformBufferObject
    {
        UniformBuffer = ((int)0X8a11),
        UniformBufferBinding = ((int)0X8a28),
        UniformBufferStart = ((int)0X8a29),
        UniformBufferSize = ((int)0X8a2a),
        MaxVertexUniformBlocks = ((int)0X8a2b),
        MaxGeometryUniformBlocks = ((int)0X8a2c),
        MaxFragmentUniformBlocks = ((int)0X8a2d),
        MaxCombinedUniformBlocks = ((int)0X8a2e),
        MaxUniformBufferBindings = ((int)0X8a2f),
        MaxUniformBlockSize = ((int)0X8a30),
        MaxCombinedVertexUniformComponents = ((int)0X8a31),
        MaxCombinedGeometryUniformComponents = ((int)0X8a32),
        MaxCombinedFragmentUniformComponents = ((int)0X8a33),
        UniformBufferOffsetAlignment = ((int)0X8a34),
        ActiveUniformBlockMaxNameLength = ((int)0X8a35),
        ActiveUniformBlocks = ((int)0X8a36),
        UniformType = ((int)0X8a37),
        UniformSize = ((int)0X8a38),
        UniformNameLength = ((int)0X8a39),
        UniformBlockIndex = ((int)0X8a3a),
        UniformOffset = ((int)0X8a3b),
        UniformArrayStride = ((int)0X8a3c),
        UniformMatrixStride = ((int)0X8a3d),
        UniformIsRowMajor = ((int)0X8a3e),
        UniformBlockBinding = ((int)0X8a3f),
        UniformBlockDataSize = ((int)0X8a40),
        UniformBlockNameLength = ((int)0X8a41),
        UniformBlockActiveUniforms = ((int)0X8a42),
        UniformBlockActiveUniformIndices = ((int)0X8a43),
        UniformBlockReferencedByVertexShader = ((int)0X8a44),
        UniformBlockReferencedByGeometryShader = ((int)0X8a45),
        UniformBlockReferencedByFragmentShader = ((int)0X8a46),
        InvalidIndex = unchecked((int)0Xffffffff),
    }

    public enum ArbVertexArrayBgra
    {
        Bgra = ((int)0X80e1),
    }

    public enum ArbVertexArrayObject
    {
        VertexArrayBinding = ((int)0X85b5),
    }

    public enum ArbVertexBlend
    {
        Modelview0Arb = ((int)0X1700),
        Modelview1Arb = ((int)0X850a),
        MaxVertexUnitsArb = ((int)0X86a4),
        ActiveVertexUnitsArb = ((int)0X86a5),
        WeightSumUnityArb = ((int)0X86a6),
        VertexBlendArb = ((int)0X86a7),
        CurrentWeightArb = ((int)0X86a8),
        WeightArrayTypeArb = ((int)0X86a9),
        WeightArrayStrideArb = ((int)0X86aa),
        WeightArraySizeArb = ((int)0X86ab),
        WeightArrayPointerArb = ((int)0X86ac),
        WeightArrayArb = ((int)0X86ad),
        Modelview2Arb = ((int)0X8722),
        Modelview3Arb = ((int)0X8723),
        Modelview4Arb = ((int)0X8724),
        Modelview5Arb = ((int)0X8725),
        Modelview6Arb = ((int)0X8726),
        Modelview7Arb = ((int)0X8727),
        Modelview8Arb = ((int)0X8728),
        Modelview9Arb = ((int)0X8729),
        Modelview10Arb = ((int)0X872a),
        Modelview11Arb = ((int)0X872b),
        Modelview12Arb = ((int)0X872c),
        Modelview13Arb = ((int)0X872d),
        Modelview14Arb = ((int)0X872e),
        Modelview15Arb = ((int)0X872f),
        Modelview16Arb = ((int)0X8730),
        Modelview17Arb = ((int)0X8731),
        Modelview18Arb = ((int)0X8732),
        Modelview19Arb = ((int)0X8733),
        Modelview20Arb = ((int)0X8734),
        Modelview21Arb = ((int)0X8735),
        Modelview22Arb = ((int)0X8736),
        Modelview23Arb = ((int)0X8737),
        Modelview24Arb = ((int)0X8738),
        Modelview25Arb = ((int)0X8739),
        Modelview26Arb = ((int)0X873a),
        Modelview27Arb = ((int)0X873b),
        Modelview28Arb = ((int)0X873c),
        Modelview29Arb = ((int)0X873d),
        Modelview30Arb = ((int)0X873e),
        Modelview31Arb = ((int)0X873f),
    }

    public enum ArbVertexBufferObject
    {
        BufferSizeArb = ((int)0X8764),
        BufferUsageArb = ((int)0X8765),
        ArrayBufferArb = ((int)0X8892),
        ElementArrayBufferArb = ((int)0X8893),
        ArrayBufferBindingArb = ((int)0X8894),
        ElementArrayBufferBindingArb = ((int)0X8895),
        VertexArrayBufferBindingArb = ((int)0X8896),
        NormalArrayBufferBindingArb = ((int)0X8897),
        ColorArrayBufferBindingArb = ((int)0X8898),
        IndexArrayBufferBindingArb = ((int)0X8899),
        TextureCoordArrayBufferBindingArb = ((int)0X889a),
        EdgeFlagArrayBufferBindingArb = ((int)0X889b),
        SecondaryColorArrayBufferBindingArb = ((int)0X889c),
        FogCoordinateArrayBufferBindingArb = ((int)0X889d),
        WeightArrayBufferBindingArb = ((int)0X889e),
        VertexAttribArrayBufferBindingArb = ((int)0X889f),
        ReadOnlyArb = ((int)0X88b8),
        WriteOnlyArb = ((int)0X88b9),
        ReadWriteArb = ((int)0X88ba),
        BufferAccessArb = ((int)0X88bb),
        BufferMappedArb = ((int)0X88bc),
        BufferMapPointerArb = ((int)0X88bd),
        StreamDrawArb = ((int)0X88e0),
        StreamReadArb = ((int)0X88e1),
        StreamCopyArb = ((int)0X88e2),
        StaticDrawArb = ((int)0X88e4),
        StaticReadArb = ((int)0X88e5),
        StaticCopyArb = ((int)0X88e6),
        DynamicDrawArb = ((int)0X88e8),
        DynamicReadArb = ((int)0X88e9),
        DynamicCopyArb = ((int)0X88ea),
    }

    public enum ArbVertexProgram
    {
        ColorSumArb = ((int)0X8458),
        VertexProgramArb = ((int)0X8620),
        VertexAttribArrayEnabledArb = ((int)0X8622),
        VertexAttribArraySizeArb = ((int)0X8623),
        VertexAttribArrayStrideArb = ((int)0X8624),
        VertexAttribArrayTypeArb = ((int)0X8625),
        CurrentVertexAttribArb = ((int)0X8626),
        ProgramLengthArb = ((int)0X8627),
        ProgramStringArb = ((int)0X8628),
        MaxProgramMatrixStackDepthArb = ((int)0X862e),
        MaxProgramMatricesArb = ((int)0X862f),
        CurrentMatrixStackDepthArb = ((int)0X8640),
        CurrentMatrixArb = ((int)0X8641),
        VertexProgramPointSizeArb = ((int)0X8642),
        VertexProgramTwoSideArb = ((int)0X8643),
        VertexAttribArrayPointerArb = ((int)0X8645),
        ProgramErrorPositionArb = ((int)0X864b),
        ProgramBindingArb = ((int)0X8677),
        MaxVertexAttribsArb = ((int)0X8869),
        VertexAttribArrayNormalizedArb = ((int)0X886a),
        ProgramErrorStringArb = ((int)0X8874),
        ProgramFormatAsciiArb = ((int)0X8875),
        ProgramFormatArb = ((int)0X8876),
        ProgramInstructionsArb = ((int)0X88a0),
        MaxProgramInstructionsArb = ((int)0X88a1),
        ProgramNativeInstructionsArb = ((int)0X88a2),
        MaxProgramNativeInstructionsArb = ((int)0X88a3),
        ProgramTemporariesArb = ((int)0X88a4),
        MaxProgramTemporariesArb = ((int)0X88a5),
        ProgramNativeTemporariesArb = ((int)0X88a6),
        MaxProgramNativeTemporariesArb = ((int)0X88a7),
        ProgramParametersArb = ((int)0X88a8),
        MaxProgramParametersArb = ((int)0X88a9),
        ProgramNativeParametersArb = ((int)0X88aa),
        MaxProgramNativeParametersArb = ((int)0X88ab),
        ProgramAttribsArb = ((int)0X88ac),
        MaxProgramAttribsArb = ((int)0X88ad),
        ProgramNativeAttribsArb = ((int)0X88ae),
        MaxProgramNativeAttribsArb = ((int)0X88af),
        ProgramAddressRegistersArb = ((int)0X88b0),
        MaxProgramAddressRegistersArb = ((int)0X88b1),
        ProgramNativeAddressRegistersArb = ((int)0X88b2),
        MaxProgramNativeAddressRegistersArb = ((int)0X88b3),
        MaxProgramLocalParametersArb = ((int)0X88b4),
        MaxProgramEnvParametersArb = ((int)0X88b5),
        ProgramUnderNativeLimitsArb = ((int)0X88b6),
        TransposeCurrentMatrixArb = ((int)0X88b7),
        Matrix0Arb = ((int)0X88c0),
        Matrix1Arb = ((int)0X88c1),
        Matrix2Arb = ((int)0X88c2),
        Matrix3Arb = ((int)0X88c3),
        Matrix4Arb = ((int)0X88c4),
        Matrix5Arb = ((int)0X88c5),
        Matrix6Arb = ((int)0X88c6),
        Matrix7Arb = ((int)0X88c7),
        Matrix8Arb = ((int)0X88c8),
        Matrix9Arb = ((int)0X88c9),
        Matrix10Arb = ((int)0X88ca),
        Matrix11Arb = ((int)0X88cb),
        Matrix12Arb = ((int)0X88cc),
        Matrix13Arb = ((int)0X88cd),
        Matrix14Arb = ((int)0X88ce),
        Matrix15Arb = ((int)0X88cf),
        Matrix16Arb = ((int)0X88d0),
        Matrix17Arb = ((int)0X88d1),
        Matrix18Arb = ((int)0X88d2),
        Matrix19Arb = ((int)0X88d3),
        Matrix20Arb = ((int)0X88d4),
        Matrix21Arb = ((int)0X88d5),
        Matrix22Arb = ((int)0X88d6),
        Matrix23Arb = ((int)0X88d7),
        Matrix24Arb = ((int)0X88d8),
        Matrix25Arb = ((int)0X88d9),
        Matrix26Arb = ((int)0X88da),
        Matrix27Arb = ((int)0X88db),
        Matrix28Arb = ((int)0X88dc),
        Matrix29Arb = ((int)0X88dd),
        Matrix30Arb = ((int)0X88de),
        Matrix31Arb = ((int)0X88df),
    }

    public enum ArbVertexShader
    {
        VertexShaderArb = ((int)0X8b31),
        MaxVertexUniformComponentsArb = ((int)0X8b4a),
        MaxVaryingFloatsArb = ((int)0X8b4b),
        MaxVertexTextureImageUnitsArb = ((int)0X8b4c),
        MaxCombinedTextureImageUnitsArb = ((int)0X8b4d),
        ObjectActiveAttributesArb = ((int)0X8b89),
        ObjectActiveAttributeMaxLengthArb = ((int)0X8b8a),
    }

    public enum ArbWindowPos
    {
    }

    public enum AssemblyProgramFormatArb
    {
        ProgramFormatAsciiArb = ((int)0X8875),
    }

    public enum AssemblyProgramParameterArb
    {
        ProgramLength = ((int)0X8627),
        ProgramBinding = ((int)0X8677),
        ProgramAluInstructionsArb = ((int)0X8805),
        ProgramTexInstructionsArb = ((int)0X8806),
        ProgramTexIndirectionsArb = ((int)0X8807),
        ProgramNativeAluInstructionsArb = ((int)0X8808),
        ProgramNativeTexInstructionsArb = ((int)0X8809),
        ProgramNativeTexIndirectionsArb = ((int)0X880a),
        MaxProgramAluInstructionsArb = ((int)0X880b),
        MaxProgramTexInstructionsArb = ((int)0X880c),
        MaxProgramTexIndirectionsArb = ((int)0X880d),
        MaxProgramNativeAluInstructionsArb = ((int)0X880e),
        MaxProgramNativeTexInstructionsArb = ((int)0X880f),
        MaxProgramNativeTexIndirectionsArb = ((int)0X8810),
        ProgramFormat = ((int)0X8876),
        ProgramInstruction = ((int)0X88a0),
        MaxProgramInstructions = ((int)0X88a1),
        ProgramNativeInstructions = ((int)0X88a2),
        MaxProgramNativeInstructions = ((int)0X88a3),
        ProgramTemporaries = ((int)0X88a4),
        MaxProgramTemporaries = ((int)0X88a5),
        ProgramNativeTemporaries = ((int)0X88a6),
        MaxProgramNativeTemporaries = ((int)0X88a7),
        ProgramParameters = ((int)0X88a8),
        MaxProgramParameters = ((int)0X88a9),
        ProgramNativeParameters = ((int)0X88aa),
        MaxProgramNativeParameters = ((int)0X88ab),
        ProgramAttribs = ((int)0X88ac),
        MaxProgramAttribs = ((int)0X88ad),
        ProgramNativeAttribs = ((int)0X88ae),
        MaxProgramNativeAttribs = ((int)0X88af),
        ProgramAddressRegisters = ((int)0X88b0),
        MaxProgramAddressRegisters = ((int)0X88b1),
        ProgramNativeAddressRegisters = ((int)0X88b2),
        MaxProgramNativeAddressRegisters = ((int)0X88b3),
        MaxProgramLocalParameters = ((int)0X88b4),
        MaxProgramEnvParameters = ((int)0X88b5),
        ProgramUnderNativeLimits = ((int)0X88b6),
    }

    public enum AssemblyProgramStringParameterArb
    {
        ProgramString = ((int)0X8628),
    }

    public enum AssemblyProgramTargetArb
    {
        VertexProgram = ((int)0X8620),
        FragmentProgram = ((int)0X8804),
        GeometryProgramNv = ((int)0X8c26),
    }

    public enum AtiDrawBuffers
    {
        MaxDrawBuffersAti = ((int)0X8824),
        DrawBuffer0Ati = ((int)0X8825),
        DrawBuffer1Ati = ((int)0X8826),
        DrawBuffer2Ati = ((int)0X8827),
        DrawBuffer3Ati = ((int)0X8828),
        DrawBuffer4Ati = ((int)0X8829),
        DrawBuffer5Ati = ((int)0X882a),
        DrawBuffer6Ati = ((int)0X882b),
        DrawBuffer7Ati = ((int)0X882c),
        DrawBuffer8Ati = ((int)0X882d),
        DrawBuffer9Ati = ((int)0X882e),
        DrawBuffer10Ati = ((int)0X882f),
        DrawBuffer11Ati = ((int)0X8830),
        DrawBuffer12Ati = ((int)0X8831),
        DrawBuffer13Ati = ((int)0X8832),
        DrawBuffer14Ati = ((int)0X8833),
        DrawBuffer15Ati = ((int)0X8834),
    }

    public enum AtiElementArray
    {
        ElementArrayAti = ((int)0X8768),
        ElementArrayTypeAti = ((int)0X8769),
        ElementArrayPointerAti = ((int)0X876a),
    }

    public enum AtiEnvmapBumpmap
    {
        BumpRotMatrixAti = ((int)0X8775),
        BumpRotMatrixSizeAti = ((int)0X8776),
        BumpNumTexUnitsAti = ((int)0X8777),
        BumpTexUnitsAti = ((int)0X8778),
        DudvAti = ((int)0X8779),
        Du8dv8Ati = ((int)0X877a),
        BumpEnvmapAti = ((int)0X877b),
        BumpTargetAti = ((int)0X877c),
    }

    public enum AtiFragmentShader
    {
        Gl2XBitAti = ((int)0X00000001),
        RedBitAti = ((int)0X00000001),
        CompBitAti = ((int)0X00000002),
        Gl4XBitAti = ((int)0X00000002),
        GreenBitAti = ((int)0X00000002),
        BlueBitAti = ((int)0X00000004),
        Gl8XBitAti = ((int)0X00000004),
        NegateBitAti = ((int)0X00000004),
        BiasBitAti = ((int)0X00000008),
        HalfBitAti = ((int)0X00000008),
        QuarterBitAti = ((int)0X00000010),
        EighthBitAti = ((int)0X00000020),
        SaturateBitAti = ((int)0X00000040),
        FragmentShaderAti = ((int)0X8920),
        Reg0Ati = ((int)0X8921),
        Reg1Ati = ((int)0X8922),
        Reg2Ati = ((int)0X8923),
        Reg3Ati = ((int)0X8924),
        Reg4Ati = ((int)0X8925),
        Reg5Ati = ((int)0X8926),
        Reg6Ati = ((int)0X8927),
        Reg7Ati = ((int)0X8928),
        Reg8Ati = ((int)0X8929),
        Reg9Ati = ((int)0X892a),
        Reg10Ati = ((int)0X892b),
        Reg11Ati = ((int)0X892c),
        Reg12Ati = ((int)0X892d),
        Reg13Ati = ((int)0X892e),
        Reg14Ati = ((int)0X892f),
        Reg15Ati = ((int)0X8930),
        Reg16Ati = ((int)0X8931),
        Reg17Ati = ((int)0X8932),
        Reg18Ati = ((int)0X8933),
        Reg19Ati = ((int)0X8934),
        Reg20Ati = ((int)0X8935),
        Reg21Ati = ((int)0X8936),
        Reg22Ati = ((int)0X8937),
        Reg23Ati = ((int)0X8938),
        Reg24Ati = ((int)0X8939),
        Reg25Ati = ((int)0X893a),
        Reg26Ati = ((int)0X893b),
        Reg27Ati = ((int)0X893c),
        Reg28Ati = ((int)0X893d),
        Reg29Ati = ((int)0X893e),
        Reg30Ati = ((int)0X893f),
        Reg31Ati = ((int)0X8940),
        Con0Ati = ((int)0X8941),
        Con1Ati = ((int)0X8942),
        Con2Ati = ((int)0X8943),
        Con3Ati = ((int)0X8944),
        Con4Ati = ((int)0X8945),
        Con5Ati = ((int)0X8946),
        Con6Ati = ((int)0X8947),
        Con7Ati = ((int)0X8948),
        Con8Ati = ((int)0X8949),
        Con9Ati = ((int)0X894a),
        Con10Ati = ((int)0X894b),
        Con11Ati = ((int)0X894c),
        Con12Ati = ((int)0X894d),
        Con13Ati = ((int)0X894e),
        Con14Ati = ((int)0X894f),
        Con15Ati = ((int)0X8950),
        Con16Ati = ((int)0X8951),
        Con17Ati = ((int)0X8952),
        Con18Ati = ((int)0X8953),
        Con19Ati = ((int)0X8954),
        Con20Ati = ((int)0X8955),
        Con21Ati = ((int)0X8956),
        Con22Ati = ((int)0X8957),
        Con23Ati = ((int)0X8958),
        Con24Ati = ((int)0X8959),
        Con25Ati = ((int)0X895a),
        Con26Ati = ((int)0X895b),
        Con27Ati = ((int)0X895c),
        Con28Ati = ((int)0X895d),
        Con29Ati = ((int)0X895e),
        Con30Ati = ((int)0X895f),
        Con31Ati = ((int)0X8960),
        MovAti = ((int)0X8961),
        AddAti = ((int)0X8963),
        MulAti = ((int)0X8964),
        SubAti = ((int)0X8965),
        Dot3Ati = ((int)0X8966),
        Dot4Ati = ((int)0X8967),
        MadAti = ((int)0X8968),
        LerpAti = ((int)0X8969),
        CndAti = ((int)0X896a),
        Cnd0Ati = ((int)0X896b),
        Dot2AddAti = ((int)0X896c),
        SecondaryInterpolatorAti = ((int)0X896d),
        NumFragmentRegistersAti = ((int)0X896e),
        NumFragmentConstantsAti = ((int)0X896f),
        NumPassesAti = ((int)0X8970),
        NumInstructionsPerPassAti = ((int)0X8971),
        NumInstructionsTotalAti = ((int)0X8972),
        NumInputInterpolatorComponentsAti = ((int)0X8973),
        NumLoopbackComponentsAti = ((int)0X8974),
        ColorAlphaPairingAti = ((int)0X8975),
        SwizzleStrAti = ((int)0X8976),
        SwizzleStqAti = ((int)0X8977),
        SwizzleStrDrAti = ((int)0X8978),
        SwizzleStqDqAti = ((int)0X8979),
        SwizzleStrqAti = ((int)0X897a),
        SwizzleStrqDqAti = ((int)0X897b),
    }

    public enum AtiMapObjectBuffer
    {
    }

    public enum AtiMeminfo
    {
        VboFreeMemoryAti = ((int)0X87fb),
        TextureFreeMemoryAti = ((int)0X87fc),
        RenderbufferFreeMemoryAti = ((int)0X87fd),
    }

    public enum AtiPixelFormatFloat
    {
        TypeRgbaFloatAti = ((int)0X8820),
        ColorClearUnclampedValueAti = ((int)0X8835),
    }

    public enum AtiPnTriangles
    {
        PnTrianglesAti = ((int)0X87f0),
        MaxPnTrianglesTesselationLevelAti = ((int)0X87f1),
        PnTrianglesPointModeAti = ((int)0X87f2),
        PnTrianglesNormalModeAti = ((int)0X87f3),
        PnTrianglesTesselationLevelAti = ((int)0X87f4),
        PnTrianglesPointModeLinearAti = ((int)0X87f5),
        PnTrianglesPointModeCubicAti = ((int)0X87f6),
        PnTrianglesNormalModeLinearAti = ((int)0X87f7),
        PnTrianglesNormalModeQuadraticAti = ((int)0X87f8),
    }

    public enum AtiSeparateStencil
    {
        StencilBackFuncAti = ((int)0X8800),
        StencilBackFailAti = ((int)0X8801),
        StencilBackPassDepthFailAti = ((int)0X8802),
        StencilBackPassDepthPassAti = ((int)0X8803),
    }

    public enum AtiTextFragmentShader
    {
        TextFragmentShaderAti = ((int)0X8200),
    }

    public enum AtiTextureEnvCombine3
    {
        ModulateAddAti = ((int)0X8744),
        ModulateSignedAddAti = ((int)0X8745),
        ModulateSubtractAti = ((int)0X8746),
    }

    public enum AtiTextureFloat
    {
        RgbaFloat32Ati = ((int)0X8814),
        RgbFloat32Ati = ((int)0X8815),
        AlphaFloat32Ati = ((int)0X8816),
        IntensityFloat32Ati = ((int)0X8817),
        LuminanceFloat32Ati = ((int)0X8818),
        LuminanceAlphaFloat32Ati = ((int)0X8819),
        RgbaFloat16Ati = ((int)0X881a),
        RgbFloat16Ati = ((int)0X881b),
        AlphaFloat16Ati = ((int)0X881c),
        IntensityFloat16Ati = ((int)0X881d),
        LuminanceFloat16Ati = ((int)0X881e),
        LuminanceAlphaFloat16Ati = ((int)0X881f),
    }

    public enum AtiTextureMirrorOnce
    {
        MirrorClampAti = ((int)0X8742),
        MirrorClampToEdgeAti = ((int)0X8743),
    }

    public enum AtiVertexArrayObject
    {
        StaticAti = ((int)0X8760),
        DynamicAti = ((int)0X8761),
        PreserveAti = ((int)0X8762),
        DiscardAti = ((int)0X8763),
        ObjectBufferSizeAti = ((int)0X8764),
        ObjectBufferUsageAti = ((int)0X8765),
        ArrayObjectBufferAti = ((int)0X8766),
        ArrayObjectOffsetAti = ((int)0X8767),
    }

    public enum AtiVertexAttribArrayObject
    {
    }

    public enum AtiVertexStreams
    {
        MaxVertexStreamsAti = ((int)0X876b),
        VertexStream0Ati = ((int)0X876c),
        VertexStream1Ati = ((int)0X876d),
        VertexStream2Ati = ((int)0X876e),
        VertexStream3Ati = ((int)0X876f),
        VertexStream4Ati = ((int)0X8770),
        VertexStream5Ati = ((int)0X8771),
        VertexStream6Ati = ((int)0X8772),
        VertexStream7Ati = ((int)0X8773),
        VertexSourceAti = ((int)0X8774),
    }

    [Flags]
    public enum AttribMask
    {
        CurrentBit = ((int)0X00000001),
        PointBit = ((int)0X00000002),
        LineBit = ((int)0X00000004),
        PolygonBit = ((int)0X00000008),
        PolygonStippleBit = ((int)0X00000010),
        PixelModeBit = ((int)0X00000020),
        LightingBit = ((int)0X00000040),
        FogBit = ((int)0X00000080),
        DepthBufferBit = ((int)0X00000100),
        AccumBufferBit = ((int)0X00000200),
        StencilBufferBit = ((int)0X00000400),
        ViewportBit = ((int)0X00000800),
        TransformBit = ((int)0X00001000),
        EnableBit = ((int)0X00002000),
        ColorBufferBit = ((int)0X00004000),
        HintBit = ((int)0X00008000),
        EvalBit = ((int)0X00010000),
        ListBit = ((int)0X00020000),
        TextureBit = ((int)0X00040000),
        ScissorBit = ((int)0X00080000),
        MultisampleBit = ((int)0X20000000),
        AllAttribBits = unchecked((int)0Xffffffff),
    }

    public enum BeginFeedbackMode
    {
        Points = ((int)0X0000),
        Lines = ((int)0X0001),
        Triangles = ((int)0X0004),
    }

    public enum BeginMode
    {
        Points = ((int)0X0000),
        Lines = ((int)0X0001),
        LineLoop = ((int)0X0002),
        LineStrip = ((int)0X0003),
        Triangles = ((int)0X0004),
        TriangleStrip = ((int)0X0005),
        TriangleFan = ((int)0X0006),
        Quads = ((int)0X0007),
        QuadStrip = ((int)0X0008),
        Polygon = ((int)0X0009),
    }

    public enum BlendEquationMode
    {
        FuncAdd = ((int)0X8006),
        Min = ((int)0X8007),
        Max = ((int)0X8008),
        FuncSubtract = ((int)0X800a),
        FuncReverseSubtract = ((int)0X800b),
    }

    public enum BlendEquationModeExt
    {
        LogicOp = ((int)0X0bf1),
        FuncAddExt = ((int)0X8006),
        MinExt = ((int)0X8007),
        MaxExt = ((int)0X8008),
        FuncSubtractExt = ((int)0X800a),
        FuncReverseSubtractExt = ((int)0X800b),
        AlphaMinSgix = ((int)0X8320),
        AlphaMaxSgix = ((int)0X8321),
    }

    public enum BlendingFactorDest
    {
        Zero = ((int)0),
        SrcColor = ((int)0X0300),
        OneMinusSrcColor = ((int)0X0301),
        SrcAlpha = ((int)0X0302),
        OneMinusSrcAlpha = ((int)0X0303),
        DstAlpha = ((int)0X0304),
        OneMinusDstAlpha = ((int)0X0305),
        DstColor = ((int)0X0306),
        OneMinusDstColor = ((int)0X0307),
        ConstantColor = ((int)0X8001),
        ConstantColorExt = ((int)0X8001),
        OneMinusConstantColor = ((int)0X8002),
        OneMinusConstantColorExt = ((int)0X8002),
        ConstantAlpha = ((int)0X8003),
        ConstantAlphaExt = ((int)0X8003),
        OneMinusConstantAlpha = ((int)0X8004),
        OneMinusConstantAlphaExt = ((int)0X8004),
        One = ((int)1),
    }

    public enum BlendingFactorSrc
    {
        Zero = ((int)0),
        SrcAlpha = ((int)0X0302),
        OneMinusSrcAlpha = ((int)0X0303),
        DstAlpha = ((int)0X0304),
        OneMinusDstAlpha = ((int)0X0305),
        DstColor = ((int)0X0306),
        OneMinusDstColor = ((int)0X0307),
        SrcAlphaSaturate = ((int)0X0308),
        ConstantColor = ((int)0X8001),
        ConstantColorExt = ((int)0X8001),
        OneMinusConstantColor = ((int)0X8002),
        OneMinusConstantColorExt = ((int)0X8002),
        ConstantAlpha = ((int)0X8003),
        ConstantAlphaExt = ((int)0X8003),
        OneMinusConstantAlpha = ((int)0X8004),
        OneMinusConstantAlphaExt = ((int)0X8004),
        One = ((int)1),
    }

    public enum BlitFramebufferFilter
    {
        Nearest = ((int)0X2600),
        Linear = ((int)0X2601),
    }

    public enum Boolean
    {
        False = ((int)0),
        True = ((int)1),
    }

    public enum BufferAccess
    {
        ReadOnly = ((int)0X88b8),
        WriteOnly = ((int)0X88b9),
        ReadWrite = ((int)0X88ba),
    }

    public enum BufferAccessArb
    {
        ReadOnly = ((int)0X88b8),
        WriteOnly = ((int)0X88b9),
        ReadWrite = ((int)0X88ba),
    }

    [Flags]
    public enum BufferAccessMask
    {
        MapReadBit = ((int)0X0001),
        MapWriteBit = ((int)0X0002),
        MapInvalidateRangeBit = ((int)0X0004),
        MapInvalidateBufferBit = ((int)0X0008),
        MapFlushExplicitBit = ((int)0X0010),
        MapUnsynchronizedBit = ((int)0X0020),
    }

    public enum BufferParameterApple
    {
        BufferSerializedModifyApple = ((int)0X8a12),
        BufferFlushingUnmapApple = ((int)0X8a13),
    }

    public enum BufferParameterName
    {
        BufferSize = ((int)0X8764),
        BufferUsage = ((int)0X8765),
        BufferAccess = ((int)0X88bb),
        BufferMapped = ((int)0X88bc),
    }

    public enum BufferParameterNameArb
    {
        BufferSize = ((int)0X8764),
        BufferUsage = ((int)0X8765),
        BufferAccess = ((int)0X88bb),
        BufferMapped = ((int)0X88bc),
    }

    public enum BufferPointer
    {
        BufferMapPointer = ((int)0X88bd),
    }

    public enum BufferPointerNameArb
    {
        BufferMapPointer = ((int)0X88bd),
    }

    public enum BufferTarget
    {
        ArrayBuffer = ((int)0X8892),
        ElementArrayBuffer = ((int)0X8893),
        PixelPackBuffer = ((int)0X88eb),
        PixelUnpackBuffer = ((int)0X88ec),
        UniformBuffer = ((int)0X8a11),
        TransformFeedbackBuffer = ((int)0X8c8e),
        CopyReadBuffer = ((int)0X8f36),
        CopyWriteBuffer = ((int)0X8f37),
    }

    public enum BufferTargetArb
    {
        ArrayBuffer = ((int)0X8892),
        ElementArrayBuffer = ((int)0X8893),
    }

    public enum BufferUsageArb
    {
        StreamDraw = ((int)0X88e0),
        StreamRead = ((int)0X88e1),
        StreamCopy = ((int)0X88e2),
        StaticDraw = ((int)0X88e4),
        StaticRead = ((int)0X88e5),
        StaticCopy = ((int)0X88e6),
        DynamicDraw = ((int)0X88e8),
        DynamicRead = ((int)0X88e9),
        DynamicCopy = ((int)0X88ea),
    }

    public enum BufferUsageHint
    {
        StreamDraw = ((int)0X88e0),
        StreamRead = ((int)0X88e1),
        StreamCopy = ((int)0X88e2),
        StaticDraw = ((int)0X88e4),
        StaticRead = ((int)0X88e5),
        StaticCopy = ((int)0X88e6),
        DynamicDraw = ((int)0X88e8),
        DynamicRead = ((int)0X88e9),
        DynamicCopy = ((int)0X88ea),
    }

    public enum ClampColorMode
    {
        False = ((int)0),
        FixedOnly = ((int)0X891d),
        True = ((int)1),
    }

    public enum ClampColorTarget
    {
        ClampVertexColor = ((int)0X891a),
        ClampFragmentColor = ((int)0X891b),
        ClampReadColor = ((int)0X891c),
    }

    public enum ClearBuffer
    {
        Color = ((int)0X1800),
        Depth = ((int)0X1801),
        Stencil = ((int)0X1802),
        DepthStencil = ((int)0X84f9),
    }

    [Flags]
    public enum ClearBufferMask
    {
        DepthBufferBit = ((int)0X00000100),
        AccumBufferBit = ((int)0X00000200),
        StencilBufferBit = ((int)0X00000400),
        ColorBufferBit = ((int)0X00004000),
    }

    [Flags]
    public enum ClientAttribMask
    {
        ClientPixelStoreBit = ((int)0X00000001),
        ClientVertexArrayBit = ((int)0X00000002),
        ClientAllAttribBits = unchecked((int)0Xffffffff),
    }

    public enum ClipPlaneName
    {
        ClipPlane0 = ((int)0X3000),
        ClipPlane1 = ((int)0X3001),
        ClipPlane2 = ((int)0X3002),
        ClipPlane3 = ((int)0X3003),
        ClipPlane4 = ((int)0X3004),
        ClipPlane5 = ((int)0X3005),
    }

    public enum ColorMaterialFace
    {
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        FrontAndBack = ((int)0X0408),
    }

    public enum ColorMaterialParameter
    {
        Ambient = ((int)0X1200),
        Diffuse = ((int)0X1201),
        Specular = ((int)0X1202),
        Emission = ((int)0X1600),
        AmbientAndDiffuse = ((int)0X1602),
    }

    public enum ColorPointerType
    {
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
        HalfFloat = ((int)0X140b),
    }

    public enum ColorTableParameterPName
    {
    }

    public enum ColorTableParameterPNameSgi
    {
        ColorTableScaleSgi = ((int)0X80D6),
        ColorTableBiasSgi = ((int)0X80D7),
    }

    public enum ColorTableTarget
    {
    }

    public enum ColorTableTargetSgi
    {
        TextureColorTableSgi = ((int)0X80bc),
        ProxyTextureColorTableSgi = ((int)0X80bd),
        ColorTableSgi = ((int)0X80D0),
        PostConvolutionColorTableSgi = ((int)0X80D1),
        PostColorMatrixColorTableSgi = ((int)0X80D2),
        ProxyColorTableSgi = ((int)0X80D3),
        ProxyPostConvolutionColorTableSgi = ((int)0X80D4),
        ProxyPostColorMatrixColorTableSgi = ((int)0X80D5),
    }

    public enum ConditionalRenderType
    {
        QueryWait = ((int)0X8e13),
        QueryNoWait = ((int)0X8e14),
        QueryByRegionWait = ((int)0X8e15),
        QueryByRegionNoWait = ((int)0X8e16),
    }

    public enum ConvolutionBorderModeExt
    {
        ReduceExt = ((int)0X8016),
    }

    public enum ConvolutionParameter
    {
    }

    public enum ConvolutionParameterExt
    {
        ConvolutionBorderModeExt = ((int)0X8013),
        ConvolutionFilterScaleExt = ((int)0X8014),
        ConvolutionFilterBiasExt = ((int)0X8015),
    }

    public enum ConvolutionTarget
    {
    }

    public enum ConvolutionTargetExt
    {
        Convolution1DExt = ((int)0X8010),
        Convolution2DExt = ((int)0X8011),
    }

    public enum CullFaceMode
    {
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        FrontAndBack = ((int)0X0408),
    }

    public enum DataType
    {
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        Gl2Bytes = ((int)0X1407),
        Gl3Bytes = ((int)0X1408),
        Gl4Bytes = ((int)0X1409),
        Double = ((int)0X140a),
        DoubleExt = ((int)0X140a),
    }

    public enum DepthFunction
    {
        Never = ((int)0X0200),
        Less = ((int)0X0201),
        Equal = ((int)0X0202),
        Lequal = ((int)0X0203),
        Greater = ((int)0X0204),
        Notequal = ((int)0X0205),
        Gequal = ((int)0X0206),
        Always = ((int)0X0207),
    }

    public enum DrawBufferMode
    {
        None = ((int)0),
        FrontLeft = ((int)0X0400),
        FrontRight = ((int)0X0401),
        BackLeft = ((int)0X0402),
        BackRight = ((int)0X0403),
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        Left = ((int)0X0406),
        Right = ((int)0X0407),
        FrontAndBack = ((int)0X0408),
        Aux0 = ((int)0X0409),
        Aux1 = ((int)0X040a),
        Aux2 = ((int)0X040b),
        Aux3 = ((int)0X040c),
        ColorAttachment0 = ((int)0X8ce0),
        ColorAttachment1 = ((int)0X8ce1),
        ColorAttachment2 = ((int)0X8ce2),
        ColorAttachment3 = ((int)0X8ce3),
        ColorAttachment4 = ((int)0X8ce4),
        ColorAttachment5 = ((int)0X8ce5),
        ColorAttachment6 = ((int)0X8ce6),
        ColorAttachment7 = ((int)0X8ce7),
        ColorAttachment8 = ((int)0X8ce8),
        ColorAttachment9 = ((int)0X8ce9),
        ColorAttachment10 = ((int)0X8cea),
        ColorAttachment11 = ((int)0X8ceb),
        ColorAttachment12 = ((int)0X8cec),
        ColorAttachment13 = ((int)0X8ced),
        ColorAttachment14 = ((int)0X8cee),
        ColorAttachment15 = ((int)0X8cef),
    }

    public enum DrawBuffersEnum
    {
        None = ((int)0),
        FrontLeft = ((int)0X0400),
        FrontRight = ((int)0X0401),
        BackLeft = ((int)0X0402),
        BackRight = ((int)0X0403),
        Aux0 = ((int)0X0409),
        Aux1 = ((int)0X040a),
        Aux2 = ((int)0X040b),
        Aux3 = ((int)0X040c),
        ColorAttachment0 = ((int)0X8ce0),
        ColorAttachment1 = ((int)0X8ce1),
        ColorAttachment2 = ((int)0X8ce2),
        ColorAttachment3 = ((int)0X8ce3),
        ColorAttachment4 = ((int)0X8ce4),
        ColorAttachment5 = ((int)0X8ce5),
        ColorAttachment6 = ((int)0X8ce6),
        ColorAttachment7 = ((int)0X8ce7),
        ColorAttachment8 = ((int)0X8ce8),
        ColorAttachment9 = ((int)0X8ce9),
        ColorAttachment10 = ((int)0X8cea),
        ColorAttachment11 = ((int)0X8ceb),
        ColorAttachment12 = ((int)0X8cec),
        ColorAttachment13 = ((int)0X8ced),
        ColorAttachment14 = ((int)0X8cee),
        ColorAttachment15 = ((int)0X8cef),
    }

    public enum DrawElementsType
    {
        UnsignedByte = ((int)0X1401),
        UnsignedShort = ((int)0X1403),
        UnsignedInt = ((int)0X1405),
    }

    public enum EnableCap
    {
        PointSmooth = ((int)0X0b10),
        LineSmooth = ((int)0X0b20),
        LineStipple = ((int)0X0b24),
        PolygonSmooth = ((int)0X0b41),
        PolygonStipple = ((int)0X0b42),
        CullFace = ((int)0X0b44),
        Lighting = ((int)0X0b50),
        ColorMaterial = ((int)0X0b57),
        Fog = ((int)0X0b60),
        DepthTest = ((int)0X0b71),
        StencilTest = ((int)0X0b90),
        Normalize = ((int)0X0ba1),
        AlphaTest = ((int)0X0bc0),
        Dither = ((int)0X0bd0),
        Blend = ((int)0X0be2),
        IndexLogicOp = ((int)0X0bf1),
        ColorLogicOp = ((int)0X0bf2),
        ScissorTest = ((int)0X0c11),
        TextureGenS = ((int)0X0c60),
        TextureGenT = ((int)0X0c61),
        TextureGenR = ((int)0X0c62),
        TextureGenQ = ((int)0X0c63),
        AutoNormal = ((int)0X0D80),
        Map1Color4 = ((int)0X0D90),
        Map1Index = ((int)0X0D91),
        Map1Normal = ((int)0X0D92),
        Map1TextureCoord1 = ((int)0X0D93),
        Map1TextureCoord2 = ((int)0X0D94),
        Map1TextureCoord3 = ((int)0X0D95),
        Map1TextureCoord4 = ((int)0X0D96),
        Map1Vertex3 = ((int)0X0D97),
        Map1Vertex4 = ((int)0X0D98),
        Map2Color4 = ((int)0X0Db0),
        Map2Index = ((int)0X0Db1),
        Map2Normal = ((int)0X0Db2),
        Map2TextureCoord1 = ((int)0X0Db3),
        Map2TextureCoord2 = ((int)0X0Db4),
        Map2TextureCoord3 = ((int)0X0Db5),
        Map2TextureCoord4 = ((int)0X0Db6),
        Map2Vertex3 = ((int)0X0Db7),
        Map2Vertex4 = ((int)0X0Db8),
        Texture1D = ((int)0X0De0),
        Texture2D = ((int)0X0De1),
        PolygonOffsetPoint = ((int)0X2a01),
        PolygonOffsetLine = ((int)0X2a02),
        ClipPlane0 = ((int)0X3000),
        ClipPlane1 = ((int)0X3001),
        ClipPlane2 = ((int)0X3002),
        ClipPlane3 = ((int)0X3003),
        ClipPlane4 = ((int)0X3004),
        ClipPlane5 = ((int)0X3005),
        Light0 = ((int)0X4000),
        Light1 = ((int)0X4001),
        Light2 = ((int)0X4002),
        Light3 = ((int)0X4003),
        Light4 = ((int)0X4004),
        Light5 = ((int)0X4005),
        Light6 = ((int)0X4006),
        Light7 = ((int)0X4007),
        Convolution1DExt = ((int)0X8010),
        Convolution2DExt = ((int)0X8011),
        Separable2DExt = ((int)0X8012),
        HistogramExt = ((int)0X8024),
        MinmaxExt = ((int)0X802e),
        PolygonOffsetFill = ((int)0X8037),
        RescaleNormal = ((int)0X803a),
        RescaleNormalExt = ((int)0X803a),
        Texture3DExt = ((int)0X806f),
        VertexArray = ((int)0X8074),
        NormalArray = ((int)0X8075),
        ColorArray = ((int)0X8076),
        IndexArray = ((int)0X8077),
        TextureCoordArray = ((int)0X8078),
        EdgeFlagArray = ((int)0X8079),
        InterlaceSgix = ((int)0X8094),
        Multisample = ((int)0X809d),
        SampleAlphaToCoverage = ((int)0X809e),
        SampleAlphaToMaskSgis = ((int)0X809e),
        SampleAlphaToOne = ((int)0X809f),
        SampleAlphaToOneSgis = ((int)0X809f),
        SampleCoverage = ((int)0X80a0),
        SampleMaskSgis = ((int)0X80a0),
        TextureColorTableSgi = ((int)0X80bc),
        ColorTableSgi = ((int)0X80D0),
        PostConvolutionColorTableSgi = ((int)0X80D1),
        PostColorMatrixColorTableSgi = ((int)0X80D2),
        Texture4DSgis = ((int)0X8134),
        PixelTexGenSgix = ((int)0X8139),
        SpriteSgix = ((int)0X8148),
        ReferencePlaneSgix = ((int)0X817D),
        IrInstrument1Sgix = ((int)0X817f),
        CalligraphicFragmentSgix = ((int)0X8183),
        FramezoomSgix = ((int)0X818b),
        FogOffsetSgix = ((int)0X8198),
        SharedTexturePaletteExt = ((int)0X81fb),
        AsyncHistogramSgix = ((int)0X832c),
        PixelTextureSgis = ((int)0X8353),
        AsyncTexImageSgix = ((int)0X835c),
        AsyncDrawPixelsSgix = ((int)0X835D),
        AsyncReadPixelsSgix = ((int)0X835e),
        FragmentLightingSgix = ((int)0X8400),
        FragmentColorMaterialSgix = ((int)0X8401),
        FragmentLight0Sgix = ((int)0X840c),
        FragmentLight1Sgix = ((int)0X840D),
        FragmentLight2Sgix = ((int)0X840e),
        FragmentLight3Sgix = ((int)0X840f),
        FragmentLight4Sgix = ((int)0X8410),
        FragmentLight5Sgix = ((int)0X8411),
        FragmentLight6Sgix = ((int)0X8412),
        FragmentLight7Sgix = ((int)0X8413),
        FogCoordArray = ((int)0X8457),
        ColorSum = ((int)0X8458),
        SecondaryColorArray = ((int)0X845e),
        TextureCubeMap = ((int)0X8513),
        VertexProgramPointSize = ((int)0X8642),
        VertexProgramTwoSide = ((int)0X8643),
        PointSprite = ((int)0X8861),
        RasterizerDiscard = ((int)0X8c89),
        FramebufferSrgb = ((int)0X8Db9),
    }

    public enum ErrorCode
    {
        NoError = ((int)0),
        InvalidEnum = ((int)0X0500),
        InvalidValue = ((int)0X0501),
        InvalidOperation = ((int)0X0502),
        StackOverflow = ((int)0X0503),
        StackUnderflow = ((int)0X0504),
        OutOfMemory = ((int)0X0505),
        InvalidFramebufferOperation = ((int)0X0506),
        InvalidFramebufferOperationExt = ((int)0X0506),
        TableTooLargeExt = ((int)0X8031),
        TextureTooLargeExt = ((int)0X8065),
    }

    public enum Ext422Pixels
    {
        Gl422Ext = ((int)0X80cc),
        Gl422RevExt = ((int)0X80cd),
        Gl422AverageExt = ((int)0X80ce),
        Gl422RevAverageExt = ((int)0X80cf),
    }

    public enum ExtAbgr
    {
        AbgrExt = ((int)0X8000),
    }

    public enum ExtBgra
    {
        BgrExt = ((int)0X80e0),
        BgraExt = ((int)0X80e1),
    }

    public enum ExtBindableUniform
    {
        MaxVertexBindableUniformsExt = ((int)0X8de2),
        MaxFragmentBindableUniformsExt = ((int)0X8de3),
        MaxGeometryBindableUniformsExt = ((int)0X8de4),
        MaxBindableUniformSizeExt = ((int)0X8ded),
        UniformBufferExt = ((int)0X8dee),
        UniformBufferBindingExt = ((int)0X8def),
    }

    public enum ExtBlendColor
    {
        ConstantColor = ((int)0X8001),
        ConstantColorExt = ((int)0X8001),
        OneMinusConstantColor = ((int)0X8002),
        OneMinusConstantColorExt = ((int)0X8002),
        ConstantAlpha = ((int)0X8003),
        ConstantAlphaExt = ((int)0X8003),
        OneMinusConstantAlpha = ((int)0X8004),
        OneMinusConstantAlphaExt = ((int)0X8004),
        BlendColor = ((int)0X8005),
        BlendColorExt = ((int)0X8005),
    }

    public enum ExtBlendEquationSeparate
    {
        BlendEquationRgbExt = ((int)0X8009),
        BlendEquationAlphaExt = ((int)0X883d),
    }

    public enum ExtBlendFuncSeparate
    {
        BlendDstRgbExt = ((int)0X80c8),
        BlendSrcRgbExt = ((int)0X80c9),
        BlendDstAlphaExt = ((int)0X80ca),
        BlendSrcAlphaExt = ((int)0X80cb),
    }

    public enum ExtBlendLogicOp
    {
    }

    public enum ExtBlendMinmax
    {
        FuncAdd = ((int)0X8006),
        FuncAddExt = ((int)0X8006),
        Min = ((int)0X8007),
        MinExt = ((int)0X8007),
        Max = ((int)0X8008),
        MaxExt = ((int)0X8008),
        BlendEquation = ((int)0X8009),
        BlendEquationExt = ((int)0X8009),
    }

    public enum ExtBlendSubtract
    {
        FuncSubtract = ((int)0X800a),
        FuncSubtractExt = ((int)0X800a),
        FuncReverseSubtract = ((int)0X800b),
        FuncReverseSubtractExt = ((int)0X800b),
    }

    public enum ExtClipVolumeHint
    {
        ClipVolumeClippingHintExt = ((int)0X80f0),
    }

    public enum ExtCmyka
    {
        CmykExt = ((int)0X800c),
        CmykaExt = ((int)0X800d),
        PackCmykHintExt = ((int)0X800e),
        UnpackCmykHintExt = ((int)0X800f),
    }

    public enum ExtColorSubtable
    {
    }

    public enum ExtCompiledVertexArray
    {
        ArrayElementLockFirstExt = ((int)0X81a8),
        ArrayElementLockCountExt = ((int)0X81a9),
    }

    public enum ExtConvolution
    {
        Convolution1DExt = ((int)0X8010),
        Convolution2DExt = ((int)0X8011),
        Separable2DExt = ((int)0X8012),
        ConvolutionBorderModeExt = ((int)0X8013),
        ConvolutionFilterScaleExt = ((int)0X8014),
        ConvolutionFilterBiasExt = ((int)0X8015),
        ReduceExt = ((int)0X8016),
        ConvolutionFormatExt = ((int)0X8017),
        ConvolutionWidthExt = ((int)0X8018),
        ConvolutionHeightExt = ((int)0X8019),
        MaxConvolutionWidthExt = ((int)0X801a),
        MaxConvolutionHeightExt = ((int)0X801b),
        PostConvolutionRedScaleExt = ((int)0X801c),
        PostConvolutionGreenScaleExt = ((int)0X801d),
        PostConvolutionBlueScaleExt = ((int)0X801e),
        PostConvolutionAlphaScaleExt = ((int)0X801f),
        PostConvolutionRedBiasExt = ((int)0X8020),
        PostConvolutionGreenBiasExt = ((int)0X8021),
        PostConvolutionBlueBiasExt = ((int)0X8022),
        PostConvolutionAlphaBiasExt = ((int)0X8023),
    }

    public enum ExtCoordinateFrame
    {
        TangentArrayExt = ((int)0X8439),
        BinormalArrayExt = ((int)0X843a),
        CurrentTangentExt = ((int)0X843b),
        CurrentBinormalExt = ((int)0X843c),
        TangentArrayTypeExt = ((int)0X843e),
        TangentArrayStrideExt = ((int)0X843f),
        BinormalArrayTypeExt = ((int)0X8440),
        BinormalArrayStrideExt = ((int)0X8441),
        TangentArrayPointerExt = ((int)0X8442),
        BinormalArrayPointerExt = ((int)0X8443),
        Map1TangentExt = ((int)0X8444),
        Map2TangentExt = ((int)0X8445),
        Map1BinormalExt = ((int)0X8446),
        Map2BinormalExt = ((int)0X8447),
    }

    public enum ExtCopyTexture
    {
    }

    public enum ExtCullVertex
    {
        CullVertexExt = ((int)0X81aa),
        CullVertexEyePositionExt = ((int)0X81ab),
        CullVertexObjectPositionExt = ((int)0X81ac),
    }

    public enum ExtDepthBoundsTest
    {
        DepthBoundsTestExt = ((int)0X8890),
        DepthBoundsExt = ((int)0X8891),
    }

    public enum ExtDirectStateAccess
    {
        ProgramMatrixExt = ((int)0X8e2d),
        TransposeProgramMatrixExt = ((int)0X8e2e),
        ProgramMatrixStackDepthExt = ((int)0X8e2f),
    }

    public enum ExtDrawBuffers2
    {
    }

    public enum ExtDrawInstanced
    {
    }

    public enum ExtDrawRangeElements
    {
        MaxElementsVerticesExt = ((int)0X80e8),
        MaxElementsIndicesExt = ((int)0X80e9),
    }

    public enum ExtFogCoord
    {
        FogCoordinateSourceExt = ((int)0X8450),
        FogCoordinateExt = ((int)0X8451),
        FragmentDepthExt = ((int)0X8452),
        CurrentFogCoordinateExt = ((int)0X8453),
        FogCoordinateArrayTypeExt = ((int)0X8454),
        FogCoordinateArrayStrideExt = ((int)0X8455),
        FogCoordinateArrayPointerExt = ((int)0X8456),
        FogCoordinateArrayExt = ((int)0X8457),
    }

    public enum ExtFramebufferBlit
    {
        DrawFramebufferBindingExt = ((int)0X8ca6),
        ReadFramebufferExt = ((int)0X8ca8),
        DrawFramebufferExt = ((int)0X8ca9),
        ReadFramebufferBindingExt = ((int)0X8caa),
    }

    public enum ExtFramebufferMultisample
    {
        RenderbufferSamplesExt = ((int)0X8cab),
        FramebufferIncompleteMultisampleExt = ((int)0X8d56),
        MaxSamplesExt = ((int)0X8d57),
    }

    public enum ExtFramebufferObject
    {
        InvalidFramebufferOperationExt = ((int)0X0506),
        MaxRenderbufferSizeExt = ((int)0X84e8),
        FramebufferBindingExt = ((int)0X8ca6),
        RenderbufferBindingExt = ((int)0X8ca7),
        FramebufferAttachmentObjectTypeExt = ((int)0X8cd0),
        FramebufferAttachmentObjectNameExt = ((int)0X8cd1),
        FramebufferAttachmentTextureLevelExt = ((int)0X8cd2),
        FramebufferAttachmentTextureCubeMapFaceExt = ((int)0X8cd3),
        FramebufferAttachmentTexture3DZoffsetExt = ((int)0X8cd4),
        FramebufferCompleteExt = ((int)0X8cd5),
        FramebufferIncompleteAttachmentExt = ((int)0X8cd6),
        FramebufferIncompleteMissingAttachmentExt = ((int)0X8cd7),
        FramebufferIncompleteDimensionsExt = ((int)0X8cd9),
        FramebufferIncompleteFormatsExt = ((int)0X8cda),
        FramebufferIncompleteDrawBufferExt = ((int)0X8cdb),
        FramebufferIncompleteReadBufferExt = ((int)0X8cdc),
        FramebufferUnsupportedExt = ((int)0X8cdd),
        MaxColorAttachmentsExt = ((int)0X8cdf),
        ColorAttachment0Ext = ((int)0X8ce0),
        ColorAttachment1Ext = ((int)0X8ce1),
        ColorAttachment2Ext = ((int)0X8ce2),
        ColorAttachment3Ext = ((int)0X8ce3),
        ColorAttachment4Ext = ((int)0X8ce4),
        ColorAttachment5Ext = ((int)0X8ce5),
        ColorAttachment6Ext = ((int)0X8ce6),
        ColorAttachment7Ext = ((int)0X8ce7),
        ColorAttachment8Ext = ((int)0X8ce8),
        ColorAttachment9Ext = ((int)0X8ce9),
        ColorAttachment10Ext = ((int)0X8cea),
        ColorAttachment11Ext = ((int)0X8ceb),
        ColorAttachment12Ext = ((int)0X8cec),
        ColorAttachment13Ext = ((int)0X8ced),
        ColorAttachment14Ext = ((int)0X8cee),
        ColorAttachment15Ext = ((int)0X8cef),
        DepthAttachmentExt = ((int)0X8d00),
        StencilAttachmentExt = ((int)0X8d20),
        FramebufferExt = ((int)0X8d40),
        RenderbufferExt = ((int)0X8d41),
        RenderbufferWidthExt = ((int)0X8d42),
        RenderbufferHeightExt = ((int)0X8d43),
        RenderbufferInternalFormatExt = ((int)0X8d44),
        StencilIndex1Ext = ((int)0X8d46),
        StencilIndex4Ext = ((int)0X8d47),
        StencilIndex8Ext = ((int)0X8d48),
        StencilIndex16Ext = ((int)0X8d49),
        RenderbufferRedSizeExt = ((int)0X8d50),
        RenderbufferGreenSizeExt = ((int)0X8d51),
        RenderbufferBlueSizeExt = ((int)0X8d52),
        RenderbufferAlphaSizeExt = ((int)0X8d53),
        RenderbufferDepthSizeExt = ((int)0X8d54),
        RenderbufferStencilSizeExt = ((int)0X8d55),
    }

    public enum ExtFramebufferSrgb
    {
        FramebufferSrgbExt = ((int)0X8db9),
        FramebufferSrgbCapableExt = ((int)0X8dba),
    }

    public enum ExtGeometryShader4
    {
        LinesAdjacencyExt = ((int)0X000a),
        LineStripAdjacencyExt = ((int)0X000b),
        TrianglesAdjacencyExt = ((int)0X000c),
        TriangleStripAdjacencyExt = ((int)0X000D),
        ProgramPointSizeExt = ((int)0X8642),
        MaxVaryingComponentsExt = ((int)0X8b4b),
        MaxGeometryTextureImageUnitsExt = ((int)0X8c29),
        FramebufferAttachmentTextureLayerExt = ((int)0X8cd4),
        FramebufferAttachmentLayeredExt = ((int)0X8Da7),
        FramebufferIncompleteLayerTargetsExt = ((int)0X8Da8),
        FramebufferIncompleteLayerCountExt = ((int)0X8Da9),
        GeometryShaderExt = ((int)0X8dd9),
        GeometryVerticesOutExt = ((int)0X8Dda),
        GeometryInputTypeExt = ((int)0X8Ddb),
        GeometryOutputTypeExt = ((int)0X8Ddc),
        MaxGeometryVaryingComponentsExt = ((int)0X8ddd),
        MaxVertexVaryingComponentsExt = ((int)0X8dde),
        MaxGeometryUniformComponentsExt = ((int)0X8ddf),
        MaxGeometryOutputVerticesExt = ((int)0X8de0),
        MaxGeometryTotalOutputComponentsExt = ((int)0X8de1),
    }

    public enum ExtGpuProgramParameters
    {
    }

    public enum ExtGpuShader4
    {
        Sampler1DArrayExt = ((int)0X8dc0),
        Sampler2DArrayExt = ((int)0X8dc1),
        SamplerBufferExt = ((int)0X8dc2),
        Sampler1DArrayShadowExt = ((int)0X8dc3),
        Sampler2DArrayShadowExt = ((int)0X8dc4),
        SamplerCubeShadowExt = ((int)0X8dc5),
        UnsignedIntVec2Ext = ((int)0X8dc6),
        UnsignedIntVec3Ext = ((int)0X8dc7),
        UnsignedIntVec4Ext = ((int)0X8dc8),
        IntSampler1DExt = ((int)0X8dc9),
        IntSampler2DExt = ((int)0X8dca),
        IntSampler3DExt = ((int)0X8dcb),
        IntSamplerCubeExt = ((int)0X8dcc),
        IntSampler2DRectExt = ((int)0X8dcd),
        IntSampler1DArrayExt = ((int)0X8dce),
        IntSampler2DArrayExt = ((int)0X8dcf),
        IntSamplerBufferExt = ((int)0X8dd0),
        UnsignedIntSampler1DExt = ((int)0X8dd1),
        UnsignedIntSampler2DExt = ((int)0X8dd2),
        UnsignedIntSampler3DExt = ((int)0X8dd3),
        UnsignedIntSamplerCubeExt = ((int)0X8dd4),
        UnsignedIntSampler2DRectExt = ((int)0X8dd5),
        UnsignedIntSampler1DArrayExt = ((int)0X8dd6),
        UnsignedIntSampler2DArrayExt = ((int)0X8dd7),
        UnsignedIntSamplerBufferExt = ((int)0X8dd8),
    }

    public enum ExtHistogram
    {
        HistogramExt = ((int)0X8024),
        ProxyHistogramExt = ((int)0X8025),
        HistogramWidthExt = ((int)0X8026),
        HistogramFormatExt = ((int)0X8027),
        HistogramRedSizeExt = ((int)0X8028),
        HistogramGreenSizeExt = ((int)0X8029),
        HistogramBlueSizeExt = ((int)0X802a),
        HistogramAlphaSizeExt = ((int)0X802b),
        HistogramLuminanceSize = ((int)0X802c),
        HistogramLuminanceSizeExt = ((int)0X802c),
        HistogramSinkExt = ((int)0X802d),
        MinmaxExt = ((int)0X802e),
        MinmaxFormatExt = ((int)0X802f),
        MinmaxSinkExt = ((int)0X8030),
        TableTooLargeExt = ((int)0X8031),
    }

    public enum ExtIndexArrayFormats
    {
        IuiV2fExt = ((int)0X81ad),
        IuiV3fExt = ((int)0X81ae),
        IuiN3fV2fExt = ((int)0X81af),
        IuiN3fV3fExt = ((int)0X81b0),
        T2fIuiV2fExt = ((int)0X81b1),
        T2fIuiV3fExt = ((int)0X81b2),
        T2fIuiN3fV2fExt = ((int)0X81b3),
        T2fIuiN3fV3fExt = ((int)0X81b4),
    }

    public enum ExtIndexFunc
    {
        IndexTestExt = ((int)0X81b5),
        IndexTestFuncExt = ((int)0X81b6),
        IndexTestRefExt = ((int)0X81b7),
    }

    public enum ExtIndexMaterial
    {
        IndexMaterialExt = ((int)0X81b8),
        IndexMaterialParameterExt = ((int)0X81b9),
        IndexMaterialFaceExt = ((int)0X81ba),
    }

    public enum ExtIndexTexture
    {
    }

    public enum ExtLightTexture
    {
        FragmentMaterialExt = ((int)0X8349),
        FragmentNormalExt = ((int)0X834a),
        FragmentColorExt = ((int)0X834c),
        AttenuationExt = ((int)0X834d),
        ShadowAttenuationExt = ((int)0X834e),
        TextureApplicationModeExt = ((int)0X834f),
        TextureLightExt = ((int)0X8350),
        TextureMaterialFaceExt = ((int)0X8351),
        TextureMaterialParameterExt = ((int)0X8352),
        FragmentDepthExt = ((int)0X8452),
    }

    public enum ExtMiscAttribute
    {
    }

    public enum ExtMultiDrawArrays
    {
    }

    public enum ExtMultisample
    {
        MultisampleBitExt = ((int)0X20000000),
        MultisampleExt = ((int)0X809d),
        SampleAlphaToMaskExt = ((int)0X809e),
        SampleAlphaToOneExt = ((int)0X809f),
        SampleMaskExt = ((int)0X80a0),
        Gl1PassExt = ((int)0X80a1),
        Gl2Pass0Ext = ((int)0X80a2),
        Gl2Pass1Ext = ((int)0X80a3),
        Gl4Pass0Ext = ((int)0X80a4),
        Gl4Pass1Ext = ((int)0X80a5),
        Gl4Pass2Ext = ((int)0X80a6),
        Gl4Pass3Ext = ((int)0X80a7),
        SampleBuffersExt = ((int)0X80a8),
        SamplesExt = ((int)0X80a9),
        SampleMaskValueExt = ((int)0X80aa),
        SampleMaskInvertExt = ((int)0X80ab),
        SamplePatternExt = ((int)0X80ac),
    }

    public enum ExtPackedDepthStencil
    {
        DepthStencilExt = ((int)0X84f9),
        UnsignedInt248Ext = ((int)0X84fa),
        Depth24Stencil8Ext = ((int)0X88f0),
        TextureStencilSizeExt = ((int)0X88f1),
    }

    public enum ExtPackedFloat
    {
        R11fG11fB10fExt = ((int)0X8c3a),
        UnsignedInt10F11F11FRevExt = ((int)0X8c3b),
        RgbaSignedComponentsExt = ((int)0X8c3c),
    }

    public enum ExtPackedPixels
    {
        UnsignedByte332Ext = ((int)0X8032),
        UnsignedShort4444Ext = ((int)0X8033),
        UnsignedShort5551Ext = ((int)0X8034),
        UnsignedInt8888Ext = ((int)0X8035),
        UnsignedInt1010102Ext = ((int)0X8036),
        UnsignedByte233RevExt = ((int)0X8362),
        UnsignedShort565Ext = ((int)0X8363),
        UnsignedShort565RevExt = ((int)0X8364),
        UnsignedShort4444RevExt = ((int)0X8365),
        UnsignedShort1555RevExt = ((int)0X8366),
        UnsignedInt8888RevExt = ((int)0X8367),
        UnsignedInt2101010RevExt = ((int)0X8368),
    }

    public enum ExtPalettedTexture
    {
        ColorIndex1Ext = ((int)0X80e2),
        ColorIndex2Ext = ((int)0X80e3),
        ColorIndex4Ext = ((int)0X80e4),
        ColorIndex8Ext = ((int)0X80e5),
        ColorIndex12Ext = ((int)0X80e6),
        ColorIndex16Ext = ((int)0X80e7),
        TextureIndexSizeExt = ((int)0X80ed),
    }

    public enum ExtPixelBufferObject
    {
        PixelPackBufferExt = ((int)0X88eb),
        PixelUnpackBufferExt = ((int)0X88ec),
        PixelPackBufferBindingExt = ((int)0X88ed),
        PixelUnpackBufferBindingExt = ((int)0X88ef),
    }

    public enum ExtPixelTransform
    {
        PixelTransform2DExt = ((int)0X8330),
        PixelMagFilterExt = ((int)0X8331),
        PixelMinFilterExt = ((int)0X8332),
        PixelCubicWeightExt = ((int)0X8333),
        CubicExt = ((int)0X8334),
        AverageExt = ((int)0X8335),
        PixelTransform2DStackDepthExt = ((int)0X8336),
        MaxPixelTransform2DStackDepthExt = ((int)0X8337),
        PixelTransform2DMatrixExt = ((int)0X8338),
    }

    public enum ExtPixelTransformColorTable
    {
    }

    public enum ExtPointParameters
    {
        PointSizeMinExt = ((int)0X8126),
        PointSizeMaxExt = ((int)0X8127),
        PointFadeThresholdSizeExt = ((int)0X8128),
        DistanceAttenuationExt = ((int)0X8129),
    }

    public enum ExtPolygonOffset
    {
        PolygonOffsetExt = ((int)0X8037),
        PolygonOffsetFactorExt = ((int)0X8038),
        PolygonOffsetBiasExt = ((int)0X8039),
    }

    public enum ExtProvokingVertex
    {
        QuadsFollowProvokingVertexConventionExt = ((int)0X8e4c),
        FirstVertexConventionExt = ((int)0X8e4d),
        LastVertexConventionExt = ((int)0X8e4e),
        ProvokingVertexExt = ((int)0X8e4f),
    }

    public enum ExtRescaleNormal
    {
        RescaleNormalExt = ((int)0X803a),
    }

    public enum ExtSecondaryColor
    {
        ColorSumExt = ((int)0X8458),
        CurrentSecondaryColorExt = ((int)0X8459),
        SecondaryColorArraySizeExt = ((int)0X845a),
        SecondaryColorArrayTypeExt = ((int)0X845b),
        SecondaryColorArrayStrideExt = ((int)0X845c),
        SecondaryColorArrayPointerExt = ((int)0X845d),
        SecondaryColorArrayExt = ((int)0X845e),
    }

    public enum ExtSeparateSpecularColor
    {
        LightModelColorControlExt = ((int)0X81f8),
        SingleColorExt = ((int)0X81f9),
        SeparateSpecularColorExt = ((int)0X81fa),
    }

    public enum ExtShadowFuncs
    {
    }

    public enum ExtSharedTexturePalette
    {
        SharedTexturePaletteExt = ((int)0X81fb),
    }

    public enum ExtStencilClearTag
    {
        StencilTagBitsExt = ((int)0X88f2),
        StencilClearTagValueExt = ((int)0X88f3),
    }

    public enum ExtStencilTwoSide
    {
        StencilTestTwoSideExt = ((int)0X8910),
        ActiveStencilFaceExt = ((int)0X8911),
    }

    public enum ExtStencilWrap
    {
        IncrWrapExt = ((int)0X8507),
        DecrWrapExt = ((int)0X8508),
    }

    public enum ExtSubtexture
    {
    }

    public enum ExtTexture
    {
        Alpha4Ext = ((int)0X803b),
        Alpha8Ext = ((int)0X803c),
        Alpha12Ext = ((int)0X803d),
        Alpha16Ext = ((int)0X803e),
        Luminance4Ext = ((int)0X803f),
        Luminance8Ext = ((int)0X8040),
        Luminance12Ext = ((int)0X8041),
        Luminance16Ext = ((int)0X8042),
        Luminance4Alpha4Ext = ((int)0X8043),
        Luminance6Alpha2Ext = ((int)0X8044),
        Luminance8Alpha8Ext = ((int)0X8045),
        Luminance12Alpha4Ext = ((int)0X8046),
        Luminance12Alpha12Ext = ((int)0X8047),
        Luminance16Alpha16Ext = ((int)0X8048),
        IntensityExt = ((int)0X8049),
        Intensity4Ext = ((int)0X804a),
        Intensity8Ext = ((int)0X804b),
        Intensity12Ext = ((int)0X804c),
        Intensity16Ext = ((int)0X804d),
        Rgb2Ext = ((int)0X804e),
        Rgb4Ext = ((int)0X804f),
        Rgb5Ext = ((int)0X8050),
        Rgb8Ext = ((int)0X8051),
        Rgb10Ext = ((int)0X8052),
        Rgb12Ext = ((int)0X8053),
        Rgb16Ext = ((int)0X8054),
        Rgba2Ext = ((int)0X8055),
        Rgba4Ext = ((int)0X8056),
        Rgb5A1Ext = ((int)0X8057),
        Rgba8Ext = ((int)0X8058),
        Rgb10A2Ext = ((int)0X8059),
        Rgba12Ext = ((int)0X805a),
        Rgba16Ext = ((int)0X805b),
        TextureRedSizeExt = ((int)0X805c),
        TextureGreenSizeExt = ((int)0X805d),
        TextureBlueSizeExt = ((int)0X805e),
        TextureAlphaSizeExt = ((int)0X805f),
        TextureLuminanceSizeExt = ((int)0X8060),
        TextureIntensitySizeExt = ((int)0X8061),
        ReplaceExt = ((int)0X8062),
        ProxyTexture1DExt = ((int)0X8063),
        ProxyTexture2DExt = ((int)0X8064),
        TextureTooLargeExt = ((int)0X8065),
    }

    public enum ExtTexture3D
    {
        PackSkipImagesExt = ((int)0X806b),
        PackImageHeightExt = ((int)0X806c),
        UnpackSkipImagesExt = ((int)0X806d),
        UnpackImageHeightExt = ((int)0X806e),
        Texture3DExt = ((int)0X806f),
        ProxyTexture3DExt = ((int)0X8070),
        TextureDepthExt = ((int)0X8071),
        TextureWrapRExt = ((int)0X8072),
        Max3DTextureSizeExt = ((int)0X8073),
    }

    public enum ExtTextureArray
    {
        CompareRefDepthToTextureExt = ((int)0X884e),
        MaxArrayTextureLayersExt = ((int)0X88ff),
        Texture1DArrayExt = ((int)0X8c18),
        ProxyTexture1DArrayExt = ((int)0X8c19),
        Texture2DArrayExt = ((int)0X8c1a),
        ProxyTexture2DArrayExt = ((int)0X8c1b),
        TextureBinding1DArrayExt = ((int)0X8c1c),
        TextureBinding2DArrayExt = ((int)0X8c1d),
        FramebufferAttachmentTextureLayerExt = ((int)0X8cd4),
    }

    public enum ExtTextureBufferObject
    {
        TextureBufferExt = ((int)0X8c2a),
        MaxTextureBufferSizeExt = ((int)0X8c2b),
        TextureBindingBufferExt = ((int)0X8c2c),
        TextureBufferDataStoreBindingExt = ((int)0X8c2d),
        TextureBufferFormatExt = ((int)0X8c2e),
    }

    public enum ExtTextureCompressionLatc
    {
        CompressedLuminanceLatc1Ext = ((int)0X8c70),
        CompressedSignedLuminanceLatc1Ext = ((int)0X8c71),
        CompressedLuminanceAlphaLatc2Ext = ((int)0X8c72),
        CompressedSignedLuminanceAlphaLatc2Ext = ((int)0X8c73),
    }

    public enum ExtTextureCompressionRgtc
    {
        CompressedRedRgtc1Ext = ((int)0X8dbb),
        CompressedSignedRedRgtc1Ext = ((int)0X8dbc),
        CompressedRedGreenRgtc2Ext = ((int)0X8dbd),
        CompressedSignedRedGreenRgtc2Ext = ((int)0X8dbe),
    }

    public enum ExtTextureCompressionS3tc
    {
        CompressedRgbS3tcDxt1Ext = ((int)0X83f0),
        CompressedRgbaS3tcDxt1Ext = ((int)0X83f1),
        CompressedRgbaS3tcDxt3Ext = ((int)0X83f2),
        CompressedRgbaS3tcDxt5Ext = ((int)0X83f3),
    }

    public enum ExtTextureCubeMap
    {
        NormalMapExt = ((int)0X8511),
        ReflectionMapExt = ((int)0X8512),
        TextureCubeMapExt = ((int)0X8513),
        TextureBindingCubeMapExt = ((int)0X8514),
        TextureCubeMapPositiveXExt = ((int)0X8515),
        TextureCubeMapNegativeXExt = ((int)0X8516),
        TextureCubeMapPositiveYExt = ((int)0X8517),
        TextureCubeMapNegativeYExt = ((int)0X8518),
        TextureCubeMapPositiveZExt = ((int)0X8519),
        TextureCubeMapNegativeZExt = ((int)0X851a),
        ProxyTextureCubeMapExt = ((int)0X851b),
        MaxCubeMapTextureSizeExt = ((int)0X851c),
    }

    public enum ExtTextureEnvAdd
    {
    }

    public enum ExtTextureEnvCombine
    {
        CombineExt = ((int)0X8570),
        CombineRgbExt = ((int)0X8571),
        CombineAlphaExt = ((int)0X8572),
        RgbScaleExt = ((int)0X8573),
        AddSignedExt = ((int)0X8574),
        InterpolateExt = ((int)0X8575),
        ConstantExt = ((int)0X8576),
        PrimaryColorExt = ((int)0X8577),
        PreviousExt = ((int)0X8578),
        Source0RgbExt = ((int)0X8580),
        Source1RgbExt = ((int)0X8581),
        Source2RgbExt = ((int)0X8582),
        Source0AlphaExt = ((int)0X8588),
        Source1AlphaExt = ((int)0X8589),
        Source2AlphaExt = ((int)0X858a),
        Operand0RgbExt = ((int)0X8590),
        Operand1RgbExt = ((int)0X8591),
        Operand2RgbExt = ((int)0X8592),
        Operand0AlphaExt = ((int)0X8598),
        Operand1AlphaExt = ((int)0X8599),
        Operand2AlphaExt = ((int)0X859a),
    }

    public enum ExtTextureEnvDot3
    {
        Dot3RgbExt = ((int)0X8740),
        Dot3RgbaExt = ((int)0X8741),
    }

    public enum ExtTextureFilterAnisotropic
    {
        TextureMaxAnisotropyExt = ((int)0X84fe),
        MaxTextureMaxAnisotropyExt = ((int)0X84ff),
    }

    public enum ExtTextureInteger
    {
        Rgba32uiExt = ((int)0X8d70),
        Rgb32uiExt = ((int)0X8d71),
        Alpha32uiExt = ((int)0X8d72),
        Intensity32uiExt = ((int)0X8d73),
        Luminance32uiExt = ((int)0X8d74),
        LuminanceAlpha32uiExt = ((int)0X8d75),
        Rgba16uiExt = ((int)0X8d76),
        Rgb16uiExt = ((int)0X8d77),
        Alpha16uiExt = ((int)0X8d78),
        Intensity16uiExt = ((int)0X8d79),
        Luminance16uiExt = ((int)0X8d7a),
        LuminanceAlpha16uiExt = ((int)0X8d7b),
        Rgba8uiExt = ((int)0X8d7c),
        Rgb8uiExt = ((int)0X8d7d),
        Alpha8uiExt = ((int)0X8d7e),
        Intensity8uiExt = ((int)0X8d7f),
        Luminance8uiExt = ((int)0X8d80),
        LuminanceAlpha8uiExt = ((int)0X8d81),
        Rgba32iExt = ((int)0X8d82),
        Rgb32iExt = ((int)0X8d83),
        Alpha32iExt = ((int)0X8d84),
        Intensity32iExt = ((int)0X8d85),
        Luminance32iExt = ((int)0X8d86),
        LuminanceAlpha32iExt = ((int)0X8d87),
        Rgba16iExt = ((int)0X8d88),
        Rgb16iExt = ((int)0X8d89),
        Alpha16iExt = ((int)0X8d8a),
        Intensity16iExt = ((int)0X8d8b),
        Luminance16iExt = ((int)0X8d8c),
        LuminanceAlpha16iExt = ((int)0X8d8d),
        Rgba8iExt = ((int)0X8d8e),
        Rgb8iExt = ((int)0X8d8f),
        Alpha8iExt = ((int)0X8d90),
        Intensity8iExt = ((int)0X8d91),
        Luminance8iExt = ((int)0X8d92),
        LuminanceAlpha8iExt = ((int)0X8d93),
        RedIntegerExt = ((int)0X8d94),
        GreenIntegerExt = ((int)0X8d95),
        BlueIntegerExt = ((int)0X8d96),
        AlphaIntegerExt = ((int)0X8d97),
        RgbIntegerExt = ((int)0X8d98),
        RgbaIntegerExt = ((int)0X8d99),
        BgrIntegerExt = ((int)0X8d9a),
        BgraIntegerExt = ((int)0X8d9b),
        LuminanceIntegerExt = ((int)0X8d9c),
        LuminanceAlphaIntegerExt = ((int)0X8d9d),
        RgbaIntegerModeExt = ((int)0X8d9e),
    }

    public enum ExtTextureLodBias
    {
        MaxTextureLodBiasExt = ((int)0X84fd),
        TextureFilterControlExt = ((int)0X8500),
        TextureLodBiasExt = ((int)0X8501),
    }

    public enum ExtTextureMirrorClamp
    {
        MirrorClampExt = ((int)0X8742),
        MirrorClampToEdgeExt = ((int)0X8743),
        MirrorClampToBorderExt = ((int)0X8912),
    }

    public enum ExtTextureObject
    {
        TexturePriorityExt = ((int)0X8066),
        TextureResidentExt = ((int)0X8067),
        Texture1DBindingExt = ((int)0X8068),
        Texture2DBindingExt = ((int)0X8069),
        Texture3DBindingExt = ((int)0X806a),
    }

    public enum ExtTexturePerturbNormal
    {
        PerturbExt = ((int)0X85ae),
        TextureNormalExt = ((int)0X85af),
    }

    public enum ExtTextureSharedExponent
    {
        Rgb9E5Ext = ((int)0X8c3d),
        UnsignedInt5999RevExt = ((int)0X8c3e),
        TextureSharedSizeExt = ((int)0X8c3f),
    }

    public enum ExtTextureSnorm
    {
        RgSnorm = ((int)0X8f91),
        RgbSnorm = ((int)0X8f92),
        RgbaSnorm = ((int)0X8f93),
        R8Snorm = ((int)0X8f94),
        Rg8Snorm = ((int)0X8f95),
        Rgb8Snorm = ((int)0X8f96),
        Rgba8Snorm = ((int)0X8f97),
        R16Snorm = ((int)0X8f98),
        Rg16Snorm = ((int)0X8f99),
        Rgb16Snorm = ((int)0X8f9a),
        Rgba16Snorm = ((int)0X8f9b),
        SignedNormalized = ((int)0X8f9c),
        AlphaSnorm = ((int)0X9010),
        LuminanceSnorm = ((int)0X9011),
        LuminanceAlphaSnorm = ((int)0X9012),
        IntensitySnorm = ((int)0X9013),
        Alpha8Snorm = ((int)0X9014),
        Luminance8Snorm = ((int)0X9015),
        Luminance8Alpha8Snorm = ((int)0X9016),
        Intensity8Snorm = ((int)0X9017),
        Alpha16Snorm = ((int)0X9018),
        Luminance16Snorm = ((int)0X9019),
        Luminance16Alpha16Snorm = ((int)0X901a),
        Intensity16Snorm = ((int)0X901b),
    }

    public enum ExtTextureSrgb
    {
        SrgbExt = ((int)0X8c40),
        Srgb8Ext = ((int)0X8c41),
        SrgbAlphaExt = ((int)0X8c42),
        Srgb8Alpha8Ext = ((int)0X8c43),
        SluminanceAlphaExt = ((int)0X8c44),
        Sluminance8Alpha8Ext = ((int)0X8c45),
        SluminanceExt = ((int)0X8c46),
        Sluminance8Ext = ((int)0X8c47),
        CompressedSrgbExt = ((int)0X8c48),
        CompressedSrgbAlphaExt = ((int)0X8c49),
        CompressedSluminanceExt = ((int)0X8c4a),
        CompressedSluminanceAlphaExt = ((int)0X8c4b),
        CompressedSrgbS3tcDxt1Ext = ((int)0X8c4c),
        CompressedSrgbAlphaS3tcDxt1Ext = ((int)0X8c4d),
        CompressedSrgbAlphaS3tcDxt3Ext = ((int)0X8c4e),
        CompressedSrgbAlphaS3tcDxt5Ext = ((int)0X8c4f),
    }

    public enum ExtTextureSwizzle
    {
        TextureSwizzleRExt = ((int)0X8e42),
        TextureSwizzleGExt = ((int)0X8e43),
        TextureSwizzleBExt = ((int)0X8e44),
        TextureSwizzleAExt = ((int)0X8e45),
        TextureSwizzleRgbaExt = ((int)0X8e46),
    }

    public enum ExtTimerQuery
    {
        TimeElapsedExt = ((int)0X88bf),
    }

    public enum ExtTransformFeedback
    {
        TransformFeedbackVaryingMaxLengthExt = ((int)0X8c76),
        TransformFeedbackBufferModeExt = ((int)0X8c7f),
        MaxTransformFeedbackSeparateComponentsExt = ((int)0X8c80),
        TransformFeedbackVaryingsExt = ((int)0X8c83),
        TransformFeedbackBufferStartExt = ((int)0X8c84),
        TransformFeedbackBufferSizeExt = ((int)0X8c85),
        PrimitivesGeneratedExt = ((int)0X8c87),
        TransformFeedbackPrimitivesWrittenExt = ((int)0X8c88),
        RasterizerDiscardExt = ((int)0X8c89),
        MaxTransformFeedbackInterleavedComponentsExt = ((int)0X8c8a),
        MaxTransformFeedbackSeparateAttribsExt = ((int)0X8c8b),
        InterleavedAttribsExt = ((int)0X8c8c),
        SeparateAttribsExt = ((int)0X8c8d),
        TransformFeedbackBufferExt = ((int)0X8c8e),
        TransformFeedbackBufferBindingExt = ((int)0X8c8f),
    }

    public enum ExtVertexArray
    {
        VertexArrayExt = ((int)0X8074),
        NormalArrayExt = ((int)0X8075),
        ColorArrayExt = ((int)0X8076),
        IndexArrayExt = ((int)0X8077),
        TextureCoordArrayExt = ((int)0X8078),
        EdgeFlagArrayExt = ((int)0X8079),
        VertexArraySizeExt = ((int)0X807a),
        VertexArrayTypeExt = ((int)0X807b),
        VertexArrayStrideExt = ((int)0X807c),
        VertexArrayCountExt = ((int)0X807d),
        NormalArrayTypeExt = ((int)0X807e),
        NormalArrayStrideExt = ((int)0X807f),
        NormalArrayCountExt = ((int)0X8080),
        ColorArraySizeExt = ((int)0X8081),
        ColorArrayTypeExt = ((int)0X8082),
        ColorArrayStrideExt = ((int)0X8083),
        ColorArrayCountExt = ((int)0X8084),
        IndexArrayTypeExt = ((int)0X8085),
        IndexArrayStrideExt = ((int)0X8086),
        IndexArrayCountExt = ((int)0X8087),
        TextureCoordArraySizeExt = ((int)0X8088),
        TextureCoordArrayTypeExt = ((int)0X8089),
        TextureCoordArrayStrideExt = ((int)0X808a),
        TextureCoordArrayCountExt = ((int)0X808b),
        EdgeFlagArrayStrideExt = ((int)0X808c),
        EdgeFlagArrayCountExt = ((int)0X808d),
        VertexArrayPointerExt = ((int)0X808e),
        NormalArrayPointerExt = ((int)0X808f),
        ColorArrayPointerExt = ((int)0X8090),
        IndexArrayPointerExt = ((int)0X8091),
        TextureCoordArrayPointerExt = ((int)0X8092),
        EdgeFlagArrayPointerExt = ((int)0X8093),
    }

    public enum ExtVertexArrayBgra
    {
        Bgra = ((int)0X80e1),
    }

    public enum ExtVertexShader
    {
        VertexShaderExt = ((int)0X8780),
        VertexShaderBindingExt = ((int)0X8781),
        OpIndexExt = ((int)0X8782),
        OpNegateExt = ((int)0X8783),
        OpDot3Ext = ((int)0X8784),
        OpDot4Ext = ((int)0X8785),
        OpMulExt = ((int)0X8786),
        OpAddExt = ((int)0X8787),
        OpMaddExt = ((int)0X8788),
        OpFracExt = ((int)0X8789),
        OpMaxExt = ((int)0X878a),
        OpMinExt = ((int)0X878b),
        OpSetGeExt = ((int)0X878c),
        OpSetLtExt = ((int)0X878d),
        OpClampExt = ((int)0X878e),
        OpFloorExt = ((int)0X878f),
        OpRoundExt = ((int)0X8790),
        OpExpBase2Ext = ((int)0X8791),
        OpLogBase2Ext = ((int)0X8792),
        OpPowerExt = ((int)0X8793),
        OpRecipExt = ((int)0X8794),
        OpRecipSqrtExt = ((int)0X8795),
        OpSubExt = ((int)0X8796),
        OpCrossProductExt = ((int)0X8797),
        OpMultiplyMatrixExt = ((int)0X8798),
        OpMovExt = ((int)0X8799),
        OutputVertexExt = ((int)0X879a),
        OutputColor0Ext = ((int)0X879b),
        OutputColor1Ext = ((int)0X879c),
        OutputTextureCoord0Ext = ((int)0X879d),
        OutputTextureCoord1Ext = ((int)0X879e),
        OutputTextureCoord2Ext = ((int)0X879f),
        OutputTextureCoord3Ext = ((int)0X87a0),
        OutputTextureCoord4Ext = ((int)0X87a1),
        OutputTextureCoord5Ext = ((int)0X87a2),
        OutputTextureCoord6Ext = ((int)0X87a3),
        OutputTextureCoord7Ext = ((int)0X87a4),
        OutputTextureCoord8Ext = ((int)0X87a5),
        OutputTextureCoord9Ext = ((int)0X87a6),
        OutputTextureCoord10Ext = ((int)0X87a7),
        OutputTextureCoord11Ext = ((int)0X87a8),
        OutputTextureCoord12Ext = ((int)0X87a9),
        OutputTextureCoord13Ext = ((int)0X87aa),
        OutputTextureCoord14Ext = ((int)0X87ab),
        OutputTextureCoord15Ext = ((int)0X87ac),
        OutputTextureCoord16Ext = ((int)0X87ad),
        OutputTextureCoord17Ext = ((int)0X87ae),
        OutputTextureCoord18Ext = ((int)0X87af),
        OutputTextureCoord19Ext = ((int)0X87b0),
        OutputTextureCoord20Ext = ((int)0X87b1),
        OutputTextureCoord21Ext = ((int)0X87b2),
        OutputTextureCoord22Ext = ((int)0X87b3),
        OutputTextureCoord23Ext = ((int)0X87b4),
        OutputTextureCoord24Ext = ((int)0X87b5),
        OutputTextureCoord25Ext = ((int)0X87b6),
        OutputTextureCoord26Ext = ((int)0X87b7),
        OutputTextureCoord27Ext = ((int)0X87b8),
        OutputTextureCoord28Ext = ((int)0X87b9),
        OutputTextureCoord29Ext = ((int)0X87ba),
        OutputTextureCoord30Ext = ((int)0X87bb),
        OutputTextureCoord31Ext = ((int)0X87bc),
        OutputFogExt = ((int)0X87bd),
        ScalarExt = ((int)0X87be),
        VectorExt = ((int)0X87bf),
        MatrixExt = ((int)0X87c0),
        VariantExt = ((int)0X87c1),
        InvariantExt = ((int)0X87c2),
        LocalConstantExt = ((int)0X87c3),
        LocalExt = ((int)0X87c4),
        MaxVertexShaderInstructionsExt = ((int)0X87c5),
        MaxVertexShaderVariantsExt = ((int)0X87c6),
        MaxVertexShaderInvariantsExt = ((int)0X87c7),
        MaxVertexShaderLocalConstantsExt = ((int)0X87c8),
        MaxVertexShaderLocalsExt = ((int)0X87c9),
        MaxOptimizedVertexShaderInstructionsExt = ((int)0X87ca),
        MaxOptimizedVertexShaderVariantsExt = ((int)0X87cb),
        MaxOptimizedVertexShaderLocalConstantsExt = ((int)0X87cc),
        MaxOptimizedVertexShaderInvariantsExt = ((int)0X87cd),
        MaxOptimizedVertexShaderLocalsExt = ((int)0X87ce),
        VertexShaderInstructionsExt = ((int)0X87cf),
        VertexShaderVariantsExt = ((int)0X87d0),
        VertexShaderInvariantsExt = ((int)0X87d1),
        VertexShaderLocalConstantsExt = ((int)0X87d2),
        VertexShaderLocalsExt = ((int)0X87d3),
        VertexShaderOptimizedExt = ((int)0X87d4),
        XExt = ((int)0X87d5),
        YExt = ((int)0X87d6),
        ZExt = ((int)0X87d7),
        WExt = ((int)0X87d8),
        NegativeXExt = ((int)0X87d9),
        NegativeYExt = ((int)0X87da),
        NegativeZExt = ((int)0X87db),
        NegativeWExt = ((int)0X87dc),
        ZeroExt = ((int)0X87dd),
        OneExt = ((int)0X87de),
        NegativeOneExt = ((int)0X87df),
        NormalizedRangeExt = ((int)0X87e0),
        FullRangeExt = ((int)0X87e1),
        CurrentVertexExt = ((int)0X87e2),
        MvpMatrixExt = ((int)0X87e3),
        VariantValueExt = ((int)0X87e4),
        VariantDatatypeExt = ((int)0X87e5),
        VariantArrayStrideExt = ((int)0X87e6),
        VariantArrayTypeExt = ((int)0X87e7),
        VariantArrayExt = ((int)0X87e8),
        VariantArrayPointerExt = ((int)0X87e9),
        InvariantValueExt = ((int)0X87ea),
        InvariantDatatypeExt = ((int)0X87eb),
        LocalConstantValueExt = ((int)0X87ec),
        LocalConstantDatatypeExt = ((int)0X87ed),
    }

    public enum ExtVertexWeighting
    {
        Modelview0StackDepthExt = ((int)0X0ba3),
        Modelview0MatrixExt = ((int)0X0ba6),
        Modelview0Ext = ((int)0X1700),
        Modelview1StackDepthExt = ((int)0X8502),
        Modelview1MatrixExt = ((int)0X8506),
        VertexWeightingExt = ((int)0X8509),
        Modelview1Ext = ((int)0X850a),
        CurrentVertexWeightExt = ((int)0X850b),
        VertexWeightArrayExt = ((int)0X850c),
        VertexWeightArraySizeExt = ((int)0X850d),
        VertexWeightArrayTypeExt = ((int)0X850e),
        VertexWeightArrayStrideExt = ((int)0X850f),
        VertexWeightArrayPointerExt = ((int)0X8510),
    }

    public enum FeedBackToken
    {
        PassThroughToken = ((int)0X0700),
        PointToken = ((int)0X0701),
        LineToken = ((int)0X0702),
        PolygonToken = ((int)0X0703),
        BitmapToken = ((int)0X0704),
        DrawPixelToken = ((int)0X0705),
        CopyPixelToken = ((int)0X0706),
        LineResetToken = ((int)0X0707),
    }

    public enum FeedbackType
    {
        Gl2D = ((int)0X0600),
        Gl3D = ((int)0X0601),
        Gl3DColor = ((int)0X0602),
        Gl3DColorTexture = ((int)0X0603),
        Gl4DColorTexture = ((int)0X0604),
    }

    [Flags]
    public enum FfdMaskSgix
    {
        TextureDeformationBitSgix = ((int)0X00000001),
        GeometryDeformationBitSgix = ((int)0X00000002),
    }

    public enum FfdTargetSgix
    {
        GeometryDeformationSgix = ((int)0X8194),
        TextureDeformationSgix = ((int)0X8195),
    }

    public enum FogMode
    {
        Exp = ((int)0X0800),
        Exp2 = ((int)0X0801),
        Linear = ((int)0X2601),
        FogFuncSgis = ((int)0X812a),
        FogCoord = ((int)0X8451),
        FragmentDepth = ((int)0X8452),
    }

    public enum FogParameter
    {
        FogIndex = ((int)0X0b61),
        FogDensity = ((int)0X0b62),
        FogStart = ((int)0X0b63),
        FogEnd = ((int)0X0b64),
        FogMode = ((int)0X0b65),
        FogColor = ((int)0X0b66),
        FogOffsetValueSgix = ((int)0X8199),
        FogCoordSrc = ((int)0X8450),
    }

    public enum FogPointerType
    {
        Float = ((int)0X1406),
        Double = ((int)0X140a),
        HalfFloat = ((int)0X140b),
    }

    public enum FragmentLightModelParameterSgix
    {
        FragmentLightModelLocalViewerSgix = ((int)0X8408),
        FragmentLightModelTwoSideSgix = ((int)0X8409),
        FragmentLightModelAmbientSgix = ((int)0X840a),
        FragmentLightModelNormalInterpolationSgix = ((int)0X840b),
    }

    public enum FramebufferAttachment
    {
        DepthStencilAttachment = ((int)0X821a),
        ColorAttachment0 = ((int)0X8ce0),
        ColorAttachment0Ext = ((int)0X8ce0),
        ColorAttachment1 = ((int)0X8ce1),
        ColorAttachment1Ext = ((int)0X8ce1),
        ColorAttachment2 = ((int)0X8ce2),
        ColorAttachment2Ext = ((int)0X8ce2),
        ColorAttachment3 = ((int)0X8ce3),
        ColorAttachment3Ext = ((int)0X8ce3),
        ColorAttachment4 = ((int)0X8ce4),
        ColorAttachment4Ext = ((int)0X8ce4),
        ColorAttachment5 = ((int)0X8ce5),
        ColorAttachment5Ext = ((int)0X8ce5),
        ColorAttachment6 = ((int)0X8ce6),
        ColorAttachment6Ext = ((int)0X8ce6),
        ColorAttachment7 = ((int)0X8ce7),
        ColorAttachment7Ext = ((int)0X8ce7),
        ColorAttachment8 = ((int)0X8ce8),
        ColorAttachment8Ext = ((int)0X8ce8),
        ColorAttachment9 = ((int)0X8ce9),
        ColorAttachment9Ext = ((int)0X8ce9),
        ColorAttachment10 = ((int)0X8cea),
        ColorAttachment10Ext = ((int)0X8cea),
        ColorAttachment11 = ((int)0X8ceb),
        ColorAttachment11Ext = ((int)0X8ceb),
        ColorAttachment12 = ((int)0X8cec),
        ColorAttachment12Ext = ((int)0X8cec),
        ColorAttachment13 = ((int)0X8ced),
        ColorAttachment13Ext = ((int)0X8ced),
        ColorAttachment14 = ((int)0X8cee),
        ColorAttachment14Ext = ((int)0X8cee),
        ColorAttachment15 = ((int)0X8cef),
        ColorAttachment15Ext = ((int)0X8cef),
        DepthAttachmentExt = ((int)0X8d00),
        DepthAttachment = ((int)0X8D00),
        StencilAttachmentExt = ((int)0X8d20),
        StencilAttachment = ((int)0X8D20),
    }

    public enum FramebufferAttachmentComponentType
    {
        Int = ((int)0X1404),
        Float = ((int)0X1406),
        UnsignedNormalized = ((int)0X8c17),
    }

    public enum FramebufferAttachmentObjectType
    {
        None = ((int)0),
        Texture = ((int)0X1702),
        FramebufferDefault = ((int)0X8218),
        Renderbuffer = ((int)0X8D41),
    }

    public enum FramebufferErrorCode
    {
        FramebufferUndefined = ((int)0X8219),
        FramebufferComplete = ((int)0X8cd5),
        FramebufferCompleteExt = ((int)0X8cd5),
        FramebufferIncompleteAttachment = ((int)0X8cd6),
        FramebufferIncompleteAttachmentExt = ((int)0X8cd6),
        FramebufferIncompleteMissingAttachment = ((int)0X8cd7),
        FramebufferIncompleteMissingAttachmentExt = ((int)0X8cd7),
        FramebufferIncompleteDimensionsExt = ((int)0X8cd9),
        FramebufferIncompleteFormatsExt = ((int)0X8cda),
        FramebufferIncompleteDrawBuffer = ((int)0X8cdb),
        FramebufferIncompleteDrawBufferExt = ((int)0X8cdb),
        FramebufferIncompleteReadBuffer = ((int)0X8cdc),
        FramebufferIncompleteReadBufferExt = ((int)0X8cdc),
        FramebufferUnsupported = ((int)0X8cdd),
        FramebufferUnsupportedExt = ((int)0X8cdd),
        FramebufferIncompleteMultisample = ((int)0X8D56),
    }

    public enum FramebufferParameterName
    {
        FramebufferAttachmentColorEncoding = ((int)0X8210),
        FramebufferAttachmentComponentType = ((int)0X8211),
        FramebufferAttachmentRedSize = ((int)0X8212),
        FramebufferAttachmentGreenSize = ((int)0X8213),
        FramebufferAttachmentBlueSize = ((int)0X8214),
        FramebufferAttachmentAlphaSize = ((int)0X8215),
        FramebufferAttachmentDepthSize = ((int)0X8216),
        FramebufferAttachmentStencilSize = ((int)0X8217),
        FramebufferAttachmentObjectType = ((int)0X8cd0),
        FramebufferAttachmentObjectTypeExt = ((int)0X8cd0),
        FramebufferAttachmentObjectName = ((int)0X8cd1),
        FramebufferAttachmentObjectNameExt = ((int)0X8cd1),
        FramebufferAttachmentTextureLevel = ((int)0X8cd2),
        FramebufferAttachmentTextureLevelExt = ((int)0X8cd2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0X8cd3),
        FramebufferAttachmentTextureCubeMapFaceExt = ((int)0X8cd3),
        FramebufferAttachmentTexture3DZoffsetExt = ((int)0X8cd4),
        FramebufferAttachmentTextureLayer = ((int)0X8cd4),
    }

    public enum FramebufferTarget
    {
        ReadFramebuffer = ((int)0X8ca8),
        DrawFramebuffer = ((int)0X8ca9),
        FramebufferExt = ((int)0X8d40),
        Framebuffer = ((int)0X8D40),
    }

    public enum FrontFaceDirection
    {
        Cw = ((int)0X0900),
        Ccw = ((int)0X0901),
    }

    public enum GenerateMipmapTarget
    {
        Texture1D = ((int)0X0de0),
        Texture2D = ((int)0X0de1),
        Texture3D = ((int)0X806f),
        TextureCubeMap = ((int)0X8513),
    }

    public enum GetColorTableParameterPName
    {
    }

    public enum GetColorTableParameterPNameSgi
    {
        ColorTableScaleSgi = ((int)0X80D6),
        ColorTableBiasSgi = ((int)0X80D7),
        ColorTableFormatSgi = ((int)0X80D8),
        ColorTableWidthSgi = ((int)0X80D9),
        ColorTableRedSizeSgi = ((int)0X80Da),
        ColorTableGreenSizeSgi = ((int)0X80Db),
        ColorTableBlueSizeSgi = ((int)0X80Dc),
        ColorTableAlphaSizeSgi = ((int)0X80Dd),
        ColorTableLuminanceSizeSgi = ((int)0X80De),
        ColorTableIntensitySizeSgi = ((int)0X80Df),
    }

    public enum GetConvolutionParameter
    {
        ConvolutionBorderModeExt = ((int)0X8013),
        ConvolutionFilterScaleExt = ((int)0X8014),
        ConvolutionFilterBiasExt = ((int)0X8015),
        ConvolutionFormatExt = ((int)0X8017),
        ConvolutionWidthExt = ((int)0X8018),
        ConvolutionHeightExt = ((int)0X8019),
        MaxConvolutionWidthExt = ((int)0X801a),
        MaxConvolutionHeightExt = ((int)0X801b),
    }

    public enum GetHistogramParameterPNameExt
    {
        HistogramWidthExt = ((int)0X8026),
        HistogramFormatExt = ((int)0X8027),
        HistogramRedSizeExt = ((int)0X8028),
        HistogramGreenSizeExt = ((int)0X8029),
        HistogramBlueSizeExt = ((int)0X802a),
        HistogramAlphaSizeExt = ((int)0X802b),
        HistogramLuminanceSizeExt = ((int)0X802c),
        HistogramSinkExt = ((int)0X802D),
    }

    public enum GetIndexedPName
    {
        UniformBufferBinding = ((int)0X8a28),
        UniformBufferStart = ((int)0X8a29),
        UniformBufferSize = ((int)0X8a2a),
        TransformFeedbackBufferStart = ((int)0X8c84),
        TransformFeedbackBufferSize = ((int)0X8c85),
        TransformFeedbackBufferBinding = ((int)0X8c8f),
    }

    public enum GetMapQuery
    {
        Coeff = ((int)0X0a00),
        Order = ((int)0X0a01),
        Domain = ((int)0X0a02),
    }

    public enum GetMinmaxParameterPNameExt
    {
        MinmaxFormatExt = ((int)0X802f),
        MinmaxSinkExt = ((int)0X8030),
    }

    public enum GetPixelMap
    {
        PixelMapIToI = ((int)0X0c70),
        PixelMapSToS = ((int)0X0c71),
        PixelMapIToR = ((int)0X0c72),
        PixelMapIToG = ((int)0X0c73),
        PixelMapIToB = ((int)0X0c74),
        PixelMapIToA = ((int)0X0c75),
        PixelMapRToR = ((int)0X0c76),
        PixelMapGToG = ((int)0X0c77),
        PixelMapBToB = ((int)0X0c78),
        PixelMapAToA = ((int)0X0c79),
    }

    public enum GetPName
    {
        CurrentColor = ((int)0X0b00),
        CurrentIndex = ((int)0X0b01),
        CurrentNormal = ((int)0X0b02),
        CurrentTextureCoords = ((int)0X0b03),
        CurrentRasterColor = ((int)0X0b04),
        CurrentRasterIndex = ((int)0X0b05),
        CurrentRasterTextureCoords = ((int)0X0b06),
        CurrentRasterPosition = ((int)0X0b07),
        CurrentRasterPositionValid = ((int)0X0b08),
        CurrentRasterDistance = ((int)0X0b09),
        PointSmooth = ((int)0X0b10),
        PointSize = ((int)0X0b11),
        PointSizeRange = ((int)0X0b12),
        SmoothPointSizeRange = ((int)0X0b12),
        PointSizeGranularity = ((int)0X0b13),
        SmoothPointSizeGranularity = ((int)0X0b13),
        LineSmooth = ((int)0X0b20),
        LineWidth = ((int)0X0b21),
        LineWidthRange = ((int)0X0b22),
        SmoothLineWidthRange = ((int)0X0b22),
        LineWidthGranularity = ((int)0X0b23),
        SmoothLineWidthGranularity = ((int)0X0b23),
        LineStipple = ((int)0X0b24),
        LineStipplePattern = ((int)0X0b25),
        LineStippleRepeat = ((int)0X0b26),
        ListMode = ((int)0X0b30),
        MaxListNesting = ((int)0X0b31),
        ListBase = ((int)0X0b32),
        ListIndex = ((int)0X0b33),
        PolygonMode = ((int)0X0b40),
        PolygonSmooth = ((int)0X0b41),
        PolygonStipple = ((int)0X0b42),
        EdgeFlag = ((int)0X0b43),
        CullFace = ((int)0X0b44),
        CullFaceMode = ((int)0X0b45),
        FrontFace = ((int)0X0b46),
        Lighting = ((int)0X0b50),
        LightModelLocalViewer = ((int)0X0b51),
        LightModelTwoSide = ((int)0X0b52),
        LightModelAmbient = ((int)0X0b53),
        ShadeModel = ((int)0X0b54),
        ColorMaterialFace = ((int)0X0b55),
        ColorMaterialParameter = ((int)0X0b56),
        ColorMaterial = ((int)0X0b57),
        Fog = ((int)0X0b60),
        FogIndex = ((int)0X0b61),
        FogDensity = ((int)0X0b62),
        FogStart = ((int)0X0b63),
        FogEnd = ((int)0X0b64),
        FogMode = ((int)0X0b65),
        FogColor = ((int)0X0b66),
        DepthRange = ((int)0X0b70),
        DepthTest = ((int)0X0b71),
        DepthWritemask = ((int)0X0b72),
        DepthClearValue = ((int)0X0b73),
        DepthFunc = ((int)0X0b74),
        AccumClearValue = ((int)0X0b80),
        StencilTest = ((int)0X0b90),
        StencilClearValue = ((int)0X0b91),
        StencilFunc = ((int)0X0b92),
        StencilValueMask = ((int)0X0b93),
        StencilFail = ((int)0X0b94),
        StencilPassDepthFail = ((int)0X0b95),
        StencilPassDepthPass = ((int)0X0b96),
        StencilRef = ((int)0X0b97),
        StencilWritemask = ((int)0X0b98),
        MatrixMode = ((int)0X0ba0),
        Normalize = ((int)0X0ba1),
        Viewport = ((int)0X0ba2),
        ModelviewStackDepth = ((int)0X0ba3),
        ProjectionStackDepth = ((int)0X0ba4),
        TextureStackDepth = ((int)0X0ba5),
        ModelviewMatrix = ((int)0X0ba6),
        ProjectionMatrix = ((int)0X0ba7),
        TextureMatrix = ((int)0X0ba8),
        AttribStackDepth = ((int)0X0bb0),
        ClientAttribStackDepth = ((int)0X0bb1),
        AlphaTest = ((int)0X0bc0),
        AlphaTestFunc = ((int)0X0bc1),
        AlphaTestRef = ((int)0X0bc2),
        Dither = ((int)0X0bd0),
        BlendDst = ((int)0X0be0),
        BlendSrc = ((int)0X0be1),
        Blend = ((int)0X0be2),
        LogicOpMode = ((int)0X0bf0),
        IndexLogicOp = ((int)0X0bf1),
        LogicOp = ((int)0X0bf1),
        ColorLogicOp = ((int)0X0bf2),
        AuxBuffers = ((int)0X0c00),
        DrawBuffer = ((int)0X0c01),
        ReadBuffer = ((int)0X0c02),
        ScissorBox = ((int)0X0c10),
        ScissorTest = ((int)0X0c11),
        IndexClearValue = ((int)0X0c20),
        IndexWritemask = ((int)0X0c21),
        ColorClearValue = ((int)0X0c22),
        ColorWritemask = ((int)0X0c23),
        IndexMode = ((int)0X0c30),
        RgbaMode = ((int)0X0c31),
        Doublebuffer = ((int)0X0c32),
        Stereo = ((int)0X0c33),
        RenderMode = ((int)0X0c40),
        PerspectiveCorrectionHint = ((int)0X0c50),
        PointSmoothHint = ((int)0X0c51),
        LineSmoothHint = ((int)0X0c52),
        PolygonSmoothHint = ((int)0X0c53),
        FogHint = ((int)0X0c54),
        TextureGenS = ((int)0X0c60),
        TextureGenT = ((int)0X0c61),
        TextureGenR = ((int)0X0c62),
        TextureGenQ = ((int)0X0c63),
        PixelMapIToISize = ((int)0X0cb0),
        PixelMapSToSSize = ((int)0X0cb1),
        PixelMapIToRSize = ((int)0X0cb2),
        PixelMapIToGSize = ((int)0X0cb3),
        PixelMapIToBSize = ((int)0X0cb4),
        PixelMapIToASize = ((int)0X0cb5),
        PixelMapRToRSize = ((int)0X0cb6),
        PixelMapGToGSize = ((int)0X0cb7),
        PixelMapBToBSize = ((int)0X0cb8),
        PixelMapAToASize = ((int)0X0cb9),
        UnpackSwapBytes = ((int)0X0cf0),
        UnpackLsbFirst = ((int)0X0cf1),
        UnpackRowLength = ((int)0X0cf2),
        UnpackSkipRows = ((int)0X0cf3),
        UnpackSkipPixels = ((int)0X0cf4),
        UnpackAlignment = ((int)0X0cf5),
        PackSwapBytes = ((int)0X0d00),
        PackLsbFirst = ((int)0X0d01),
        PackRowLength = ((int)0X0d02),
        PackSkipRows = ((int)0X0d03),
        PackSkipPixels = ((int)0X0d04),
        PackAlignment = ((int)0X0d05),
        MapColor = ((int)0X0d10),
        MapStencil = ((int)0X0d11),
        IndexShift = ((int)0X0d12),
        IndexOffset = ((int)0X0d13),
        RedScale = ((int)0X0d14),
        RedBias = ((int)0X0d15),
        ZoomX = ((int)0X0d16),
        ZoomY = ((int)0X0d17),
        GreenScale = ((int)0X0d18),
        GreenBias = ((int)0X0d19),
        BlueScale = ((int)0X0d1a),
        BlueBias = ((int)0X0d1b),
        AlphaScale = ((int)0X0d1c),
        AlphaBias = ((int)0X0d1d),
        DepthScale = ((int)0X0d1e),
        DepthBias = ((int)0X0d1f),
        MaxEvalOrder = ((int)0X0d30),
        MaxLights = ((int)0X0d31),
        MaxClipPlanes = ((int)0X0d32),
        MaxTextureSize = ((int)0X0d33),
        MaxPixelMapTable = ((int)0X0d34),
        MaxAttribStackDepth = ((int)0X0d35),
        MaxModelviewStackDepth = ((int)0X0d36),
        MaxNameStackDepth = ((int)0X0d37),
        MaxProjectionStackDepth = ((int)0X0d38),
        MaxTextureStackDepth = ((int)0X0d39),
        MaxViewportDims = ((int)0X0d3a),
        MaxClientAttribStackDepth = ((int)0X0d3b),
        SubpixelBits = ((int)0X0d50),
        IndexBits = ((int)0X0d51),
        RedBits = ((int)0X0d52),
        GreenBits = ((int)0X0d53),
        BlueBits = ((int)0X0d54),
        AlphaBits = ((int)0X0d55),
        DepthBits = ((int)0X0d56),
        StencilBits = ((int)0X0d57),
        AccumRedBits = ((int)0X0d58),
        AccumGreenBits = ((int)0X0d59),
        AccumBlueBits = ((int)0X0d5a),
        AccumAlphaBits = ((int)0X0d5b),
        NameStackDepth = ((int)0X0d70),
        AutoNormal = ((int)0X0d80),
        Map1Color4 = ((int)0X0d90),
        Map1Index = ((int)0X0d91),
        Map1Normal = ((int)0X0d92),
        Map1TextureCoord1 = ((int)0X0d93),
        Map1TextureCoord2 = ((int)0X0d94),
        Map1TextureCoord3 = ((int)0X0d95),
        Map1TextureCoord4 = ((int)0X0d96),
        Map1Vertex3 = ((int)0X0d97),
        Map1Vertex4 = ((int)0X0d98),
        Map2Color4 = ((int)0X0db0),
        Map2Index = ((int)0X0db1),
        Map2Normal = ((int)0X0db2),
        Map2TextureCoord1 = ((int)0X0db3),
        Map2TextureCoord2 = ((int)0X0db4),
        Map2TextureCoord3 = ((int)0X0db5),
        Map2TextureCoord4 = ((int)0X0db6),
        Map2Vertex3 = ((int)0X0db7),
        Map2Vertex4 = ((int)0X0db8),
        Map1GridDomain = ((int)0X0dd0),
        Map1GridSegments = ((int)0X0dd1),
        Map2GridDomain = ((int)0X0dd2),
        Map2GridSegments = ((int)0X0dd3),
        Texture1D = ((int)0X0de0),
        Texture2D = ((int)0X0de1),
        FeedbackBufferSize = ((int)0X0df1),
        FeedbackBufferType = ((int)0X0df2),
        SelectionBufferSize = ((int)0X0df4),
        PolygonOffsetUnits = ((int)0X2a00),
        PolygonOffsetPoint = ((int)0X2a01),
        PolygonOffsetLine = ((int)0X2a02),
        ClipPlane0 = ((int)0X3000),
        ClipPlane1 = ((int)0X3001),
        ClipPlane2 = ((int)0X3002),
        ClipPlane3 = ((int)0X3003),
        ClipPlane4 = ((int)0X3004),
        ClipPlane5 = ((int)0X3005),
        Light0 = ((int)0X4000),
        Light1 = ((int)0X4001),
        Light2 = ((int)0X4002),
        Light3 = ((int)0X4003),
        Light4 = ((int)0X4004),
        Light5 = ((int)0X4005),
        Light6 = ((int)0X4006),
        Light7 = ((int)0X4007),
        BlendColorExt = ((int)0X8005),
        BlendEquationExt = ((int)0X8009),
        BlendEquationRgb = ((int)0X8009),
        PackCmykHintExt = ((int)0X800e),
        UnpackCmykHintExt = ((int)0X800f),
        Convolution1DExt = ((int)0X8010),
        Convolution2DExt = ((int)0X8011),
        Separable2DExt = ((int)0X8012),
        PostConvolutionRedScaleExt = ((int)0X801c),
        PostConvolutionGreenScaleExt = ((int)0X801D),
        PostConvolutionBlueScaleExt = ((int)0X801e),
        PostConvolutionAlphaScaleExt = ((int)0X801f),
        PostConvolutionRedBiasExt = ((int)0X8020),
        PostConvolutionGreenBiasExt = ((int)0X8021),
        PostConvolutionBlueBiasExt = ((int)0X8022),
        PostConvolutionAlphaBiasExt = ((int)0X8023),
        HistogramExt = ((int)0X8024),
        MinmaxExt = ((int)0X802e),
        PolygonOffsetFill = ((int)0X8037),
        PolygonOffsetFactor = ((int)0X8038),
        PolygonOffsetBiasExt = ((int)0X8039),
        RescaleNormalExt = ((int)0X803a),
        TextureBinding1D = ((int)0X8068),
        TextureBinding2D = ((int)0X8069),
        Texture3DBindingExt = ((int)0X806a),
        TextureBinding3D = ((int)0X806a),
        PackSkipImagesExt = ((int)0X806b),
        PackImageHeightExt = ((int)0X806c),
        UnpackSkipImagesExt = ((int)0X806D),
        UnpackImageHeightExt = ((int)0X806e),
        Texture3DExt = ((int)0X806f),
        Max3DTextureSize = ((int)0X8073),
        Max3DTextureSizeExt = ((int)0X8073),
        VertexArray = ((int)0X8074),
        NormalArray = ((int)0X8075),
        ColorArray = ((int)0X8076),
        IndexArray = ((int)0X8077),
        TextureCoordArray = ((int)0X8078),
        EdgeFlagArray = ((int)0X8079),
        VertexArraySize = ((int)0X807a),
        VertexArrayType = ((int)0X807b),
        VertexArrayStride = ((int)0X807c),
        VertexArrayCountExt = ((int)0X807D),
        NormalArrayType = ((int)0X807e),
        NormalArrayStride = ((int)0X807f),
        NormalArrayCountExt = ((int)0X8080),
        ColorArraySize = ((int)0X8081),
        ColorArrayType = ((int)0X8082),
        ColorArrayStride = ((int)0X8083),
        ColorArrayCountExt = ((int)0X8084),
        IndexArrayType = ((int)0X8085),
        IndexArrayStride = ((int)0X8086),
        IndexArrayCountExt = ((int)0X8087),
        TextureCoordArraySize = ((int)0X8088),
        TextureCoordArrayType = ((int)0X8089),
        TextureCoordArrayStride = ((int)0X808a),
        TextureCoordArrayCountExt = ((int)0X808b),
        EdgeFlagArrayStride = ((int)0X808c),
        EdgeFlagArrayCountExt = ((int)0X808D),
        InterlaceSgix = ((int)0X8094),
        DetailTexture2DBindingSgis = ((int)0X8096),
        Multisample = ((int)0X809d),
        MultisampleSgis = ((int)0X809D),
        SampleAlphaToCoverage = ((int)0X809e),
        SampleAlphaToMaskSgis = ((int)0X809e),
        SampleAlphaToOne = ((int)0X809f),
        SampleAlphaToOneSgis = ((int)0X809f),
        SampleCoverage = ((int)0X80a0),
        SampleMaskSgis = ((int)0X80a0),
        SampleBuffers = ((int)0X80a8),
        SampleBuffersSgis = ((int)0X80a8),
        Samples = ((int)0X80a9),
        SamplesSgis = ((int)0X80a9),
        SampleCoverageValue = ((int)0X80aa),
        SampleMaskValueSgis = ((int)0X80aa),
        SampleCoverageInvert = ((int)0X80ab),
        SampleMaskInvertSgis = ((int)0X80ab),
        SamplePatternSgis = ((int)0X80ac),
        ColorMatrixSgi = ((int)0X80b1),
        ColorMatrixStackDepthSgi = ((int)0X80b2),
        MaxColorMatrixStackDepthSgi = ((int)0X80b3),
        PostColorMatrixRedScaleSgi = ((int)0X80b4),
        PostColorMatrixGreenScaleSgi = ((int)0X80b5),
        PostColorMatrixBlueScaleSgi = ((int)0X80b6),
        PostColorMatrixAlphaScaleSgi = ((int)0X80b7),
        PostColorMatrixRedBiasSgi = ((int)0X80b8),
        PostColorMatrixGreenBiasSgi = ((int)0X80b9),
        PostColorMatrixBlueBiasSgi = ((int)0X80ba),
        PostColorMatrixAlphaBiasSgi = ((int)0X80bb),
        TextureColorTableSgi = ((int)0X80bc),
        BlendDstRgb = ((int)0X80c8),
        BlendSrcRgb = ((int)0X80c9),
        BlendDstAlpha = ((int)0X80ca),
        BlendSrcAlpha = ((int)0X80cb),
        ColorTableSgi = ((int)0X80D0),
        PostConvolutionColorTableSgi = ((int)0X80D1),
        PostColorMatrixColorTableSgi = ((int)0X80D2),
        MaxElementsVertices = ((int)0X80e8),
        MaxElementsIndices = ((int)0X80e9),
        PointSizeMin = ((int)0X8126),
        PointSizeMinSgis = ((int)0X8126),
        PointSizeMax = ((int)0X8127),
        PointSizeMaxSgis = ((int)0X8127),
        PointFadeThresholdSize = ((int)0X8128),
        PointFadeThresholdSizeSgis = ((int)0X8128),
        DistanceAttenuationSgis = ((int)0X8129),
        PointDistanceAttenuation = ((int)0X8129),
        FogFuncPointsSgis = ((int)0X812b),
        MaxFogFuncPointsSgis = ((int)0X812c),
        PackSkipVolumesSgis = ((int)0X8130),
        PackImageDepthSgis = ((int)0X8131),
        UnpackSkipVolumesSgis = ((int)0X8132),
        UnpackImageDepthSgis = ((int)0X8133),
        Texture4DSgis = ((int)0X8134),
        Max4DTextureSizeSgis = ((int)0X8138),
        PixelTexGenSgix = ((int)0X8139),
        PixelTileBestAlignmentSgix = ((int)0X813e),
        PixelTileCacheIncrementSgix = ((int)0X813f),
        PixelTileWidthSgix = ((int)0X8140),
        PixelTileHeightSgix = ((int)0X8141),
        PixelTileGridWidthSgix = ((int)0X8142),
        PixelTileGridHeightSgix = ((int)0X8143),
        PixelTileGridDepthSgix = ((int)0X8144),
        PixelTileCacheSizeSgix = ((int)0X8145),
        SpriteSgix = ((int)0X8148),
        SpriteModeSgix = ((int)0X8149),
        SpriteAxisSgix = ((int)0X814a),
        SpriteTranslationSgix = ((int)0X814b),
        Texture4DBindingSgis = ((int)0X814f),
        MaxClipmapDepthSgix = ((int)0X8177),
        MaxClipmapVirtualDepthSgix = ((int)0X8178),
        PostTextureFilterBiasRangeSgix = ((int)0X817b),
        PostTextureFilterScaleRangeSgix = ((int)0X817c),
        ReferencePlaneSgix = ((int)0X817D),
        ReferencePlaneEquationSgix = ((int)0X817e),
        IrInstrument1Sgix = ((int)0X817f),
        InstrumentMeasurementsSgix = ((int)0X8181),
        CalligraphicFragmentSgix = ((int)0X8183),
        FramezoomSgix = ((int)0X818b),
        FramezoomFactorSgix = ((int)0X818c),
        MaxFramezoomFactorSgix = ((int)0X818D),
        GenerateMipmapHint = ((int)0X8192),
        GenerateMipmapHintSgis = ((int)0X8192),
        DeformationsMaskSgix = ((int)0X8196),
        FogOffsetSgix = ((int)0X8198),
        FogOffsetValueSgix = ((int)0X8199),
        LightModelColorControl = ((int)0X81f8),
        SharedTexturePaletteExt = ((int)0X81fb),
        MajorVersion = ((int)0X821b),
        MinorVersion = ((int)0X821c),
        NumExtensions = ((int)0X821d),
        ContextFlags = ((int)0X821e),
        ConvolutionHintSgix = ((int)0X8316),
        AsyncMarkerSgix = ((int)0X8329),
        PixelTexGenModeSgix = ((int)0X832b),
        AsyncHistogramSgix = ((int)0X832c),
        MaxAsyncHistogramSgix = ((int)0X832D),
        PixelTextureSgis = ((int)0X8353),
        AsyncTexImageSgix = ((int)0X835c),
        AsyncDrawPixelsSgix = ((int)0X835D),
        AsyncReadPixelsSgix = ((int)0X835e),
        MaxAsyncTexImageSgix = ((int)0X835f),
        MaxAsyncDrawPixelsSgix = ((int)0X8360),
        MaxAsyncReadPixelsSgix = ((int)0X8361),
        VertexPreclipSgix = ((int)0X83ee),
        VertexPreclipHintSgix = ((int)0X83ef),
        FragmentLightingSgix = ((int)0X8400),
        FragmentColorMaterialSgix = ((int)0X8401),
        FragmentColorMaterialFaceSgix = ((int)0X8402),
        FragmentColorMaterialParameterSgix = ((int)0X8403),
        MaxFragmentLightsSgix = ((int)0X8404),
        MaxActiveLightsSgix = ((int)0X8405),
        LightEnvModeSgix = ((int)0X8407),
        FragmentLightModelLocalViewerSgix = ((int)0X8408),
        FragmentLightModelTwoSideSgix = ((int)0X8409),
        FragmentLightModelAmbientSgix = ((int)0X840a),
        FragmentLightModelNormalInterpolationSgix = ((int)0X840b),
        FragmentLight0Sgix = ((int)0X840c),
        PackResampleSgix = ((int)0X842c),
        UnpackResampleSgix = ((int)0X842D),
        CurrentFogCoord = ((int)0X8453),
        FogCoordArrayType = ((int)0X8454),
        FogCoordArrayStride = ((int)0X8455),
        ColorSum = ((int)0X8458),
        CurrentSecondaryColor = ((int)0X8459),
        SecondaryColorArraySize = ((int)0X845a),
        SecondaryColorArrayType = ((int)0X845b),
        SecondaryColorArrayStride = ((int)0X845c),
        CurrentRasterSecondaryColor = ((int)0X845f),
        AliasedPointSizeRange = ((int)0X846d),
        AliasedLineWidthRange = ((int)0X846e),
        ActiveTexture = ((int)0X84e0),
        ClientActiveTexture = ((int)0X84e1),
        MaxTextureUnits = ((int)0X84e2),
        TransposeModelviewMatrix = ((int)0X84e3),
        TransposeProjectionMatrix = ((int)0X84e4),
        TransposeTextureMatrix = ((int)0X84e5),
        TransposeColorMatrix = ((int)0X84e6),
        MaxRenderbufferSize = ((int)0X84e8),
        MaxRenderbufferSizeExt = ((int)0X84e8),
        TextureCompressionHint = ((int)0X84ef),
        MaxTextureLodBias = ((int)0X84fd),
        TextureCubeMap = ((int)0X8513),
        TextureBindingCubeMap = ((int)0X8514),
        MaxCubeMapTextureSize = ((int)0X851c),
        PackSubsampleRateSgix = ((int)0X85a0),
        UnpackSubsampleRateSgix = ((int)0X85a1),
        VertexArrayBinding = ((int)0X85b5),
        NumCompressedTextureFormats = ((int)0X86a2),
        CompressedTextureFormats = ((int)0X86a3),
        StencilBackFunc = ((int)0X8800),
        StencilBackFail = ((int)0X8801),
        StencilBackPassDepthFail = ((int)0X8802),
        StencilBackPassDepthPass = ((int)0X8803),
        RgbaFloatMode = ((int)0X8820),
        MaxDrawBuffers = ((int)0X8824),
        DrawBuffer0 = ((int)0X8825),
        DrawBuffer1 = ((int)0X8826),
        DrawBuffer2 = ((int)0X8827),
        DrawBuffer3 = ((int)0X8828),
        DrawBuffer4 = ((int)0X8829),
        DrawBuffer5 = ((int)0X882a),
        DrawBuffer6 = ((int)0X882b),
        DrawBuffer7 = ((int)0X882c),
        DrawBuffer8 = ((int)0X882d),
        DrawBuffer9 = ((int)0X882e),
        DrawBuffer10 = ((int)0X882f),
        DrawBuffer11 = ((int)0X8830),
        DrawBuffer12 = ((int)0X8831),
        DrawBuffer13 = ((int)0X8832),
        DrawBuffer14 = ((int)0X8833),
        DrawBuffer15 = ((int)0X8834),
        BlendEquationAlpha = ((int)0X883d),
        PointSprite = ((int)0X8861),
        MaxVertexAttribs = ((int)0X8869),
        MaxTextureCoords = ((int)0X8871),
        MaxTextureImageUnits = ((int)0X8872),
        ArrayBufferBinding = ((int)0X8894),
        ElementArrayBufferBinding = ((int)0X8895),
        VertexArrayBufferBinding = ((int)0X8896),
        NormalArrayBufferBinding = ((int)0X8897),
        ColorArrayBufferBinding = ((int)0X8898),
        IndexArrayBufferBinding = ((int)0X8899),
        TextureCoordArrayBufferBinding = ((int)0X889a),
        EdgeFlagArrayBufferBinding = ((int)0X889b),
        SecondaryColorArrayBufferBinding = ((int)0X889c),
        FogCoordArrayBufferBinding = ((int)0X889d),
        WeightArrayBufferBinding = ((int)0X889e),
        VertexAttribArrayBufferBinding = ((int)0X889f),
        PixelPackBufferBinding = ((int)0X88ed),
        PixelUnpackBufferBinding = ((int)0X88ef),
        MaxArrayTextureLayers = ((int)0X88ff),
        MinProgramTexelOffset = ((int)0X8904),
        MaxProgramTexelOffset = ((int)0X8905),
        ClampVertexColor = ((int)0X891a),
        ClampFragmentColor = ((int)0X891b),
        ClampReadColor = ((int)0X891c),
        MaxVertexUniformBlocks = ((int)0X8a2b),
        MaxGeometryUniformBlocks = ((int)0X8a2c),
        MaxFragmentUniformBlocks = ((int)0X8a2D),
        MaxCombinedUniformBlocks = ((int)0X8a2e),
        MaxUniformBufferBindings = ((int)0X8a2f),
        MaxUniformBlockSize = ((int)0X8a30),
        MaxCombinedVertexUniformComponents = ((int)0X8a31),
        MaxCombinedGeometryUniformComponents = ((int)0X8a32),
        MaxCombinedFragmentUniformComponents = ((int)0X8a33),
        UniformBufferOffsetAlignment = ((int)0X8a34),
        MaxFragmentUniformComponents = ((int)0X8b49),
        MaxVertexUniformComponents = ((int)0X8b4a),
        MaxVaryingFloats = ((int)0X8b4b),
        MaxVertexTextureImageUnits = ((int)0X8b4c),
        MaxCombinedTextureImageUnits = ((int)0X8b4d),
        FragmentShaderDerivativeHint = ((int)0X8b8b),
        CurrentProgram = ((int)0X8b8d),
        TextureBinding1DArray = ((int)0X8c1c),
        TextureBinding2DArray = ((int)0X8c1d),
        MaxTransformFeedbackSeparateComponents = ((int)0X8c80),
        MaxTransformFeedbackInterleavedComponents = ((int)0X8c8a),
        MaxTransformFeedbackSeparateAttribs = ((int)0X8c8b),
        StencilBackRef = ((int)0X8ca3),
        StencilBackValueMask = ((int)0X8ca4),
        StencilBackWritemask = ((int)0X8ca5),
        DrawFramebufferBinding = ((int)0X8ca6),
        FramebufferBinding = ((int)0X8ca6),
        FramebufferBindingExt = ((int)0X8ca6),
        RenderbufferBinding = ((int)0X8ca7),
        RenderbufferBindingExt = ((int)0X8ca7),
        ReadFramebufferBinding = ((int)0X8caa),
        MaxColorAttachments = ((int)0X8cdf),
        MaxColorAttachmentsExt = ((int)0X8cdf),
        MaxSamples = ((int)0X8D57),
        FramebufferSrgb = ((int)0X8Db9),
    }

    public enum GetPointervPName
    {
        FeedbackBufferPointer = ((int)0X0df0),
        SelectionBufferPointer = ((int)0X0df3),
        VertexArrayPointer = ((int)0X808e),
        NormalArrayPointer = ((int)0X808f),
        ColorArrayPointer = ((int)0X8090),
        IndexArrayPointer = ((int)0X8091),
        TextureCoordArrayPointer = ((int)0X8092),
        EdgeFlagArrayPointer = ((int)0X8093),
        InstrumentBufferPointerSgix = ((int)0X8180),
        FogCoordArrayPointer = ((int)0X8456),
        SecondaryColorArrayPointer = ((int)0X845d),
    }

    public enum GetQueryObjectParam
    {
        QueryResult = ((int)0X8866),
        QueryResultAvailable = ((int)0X8867),
    }

    public enum GetQueryParam
    {
        QueryCounterBits = ((int)0X8864),
        CurrentQuery = ((int)0X8865),
    }

    public enum GetTextureParameter
    {
        TextureWidth = ((int)0X1000),
        TextureHeight = ((int)0X1001),
        TextureComponents = ((int)0X1003),
        TextureInternalFormat = ((int)0X1003),
        TextureBorderColor = ((int)0X1004),
        TextureBorder = ((int)0X1005),
        TextureMagFilter = ((int)0X2800),
        TextureMinFilter = ((int)0X2801),
        TextureWrapS = ((int)0X2802),
        TextureWrapT = ((int)0X2803),
        TextureRedSize = ((int)0X805c),
        TextureGreenSize = ((int)0X805d),
        TextureBlueSize = ((int)0X805e),
        TextureAlphaSize = ((int)0X805f),
        TextureLuminanceSize = ((int)0X8060),
        TextureIntensitySize = ((int)0X8061),
        TexturePriority = ((int)0X8066),
        TextureResident = ((int)0X8067),
        TextureDepth = ((int)0X8071),
        TextureDepthExt = ((int)0X8071),
        TextureWrapR = ((int)0X8072),
        TextureWrapRExt = ((int)0X8072),
        DetailTextureLevelSgis = ((int)0X809a),
        DetailTextureModeSgis = ((int)0X809b),
        DetailTextureFuncPointsSgis = ((int)0X809c),
        SharpenTextureFuncPointsSgis = ((int)0X80b0),
        ShadowAmbientSgix = ((int)0X80bf),
        DualTextureSelectSgis = ((int)0X8124),
        QuadTextureSelectSgis = ((int)0X8125),
        Texture4DsizeSgis = ((int)0X8136),
        TextureWrapQSgis = ((int)0X8137),
        TextureMinLod = ((int)0X813a),
        TextureMinLodSgis = ((int)0X813a),
        TextureMaxLod = ((int)0X813b),
        TextureMaxLodSgis = ((int)0X813b),
        TextureBaseLevel = ((int)0X813c),
        TextureBaseLevelSgis = ((int)0X813c),
        TextureMaxLevel = ((int)0X813d),
        TextureMaxLevelSgis = ((int)0X813D),
        TextureFilter4SizeSgis = ((int)0X8147),
        TextureClipmapCenterSgix = ((int)0X8171),
        TextureClipmapFrameSgix = ((int)0X8172),
        TextureClipmapOffsetSgix = ((int)0X8173),
        TextureClipmapVirtualDepthSgix = ((int)0X8174),
        TextureClipmapLodOffsetSgix = ((int)0X8175),
        TextureClipmapDepthSgix = ((int)0X8176),
        PostTextureFilterBiasSgix = ((int)0X8179),
        PostTextureFilterScaleSgix = ((int)0X817a),
        TextureLodBiasSSgix = ((int)0X818e),
        TextureLodBiasTSgix = ((int)0X818f),
        TextureLodBiasRSgix = ((int)0X8190),
        GenerateMipmap = ((int)0X8191),
        GenerateMipmapSgis = ((int)0X8191),
        TextureCompareSgix = ((int)0X819a),
        TextureCompareOperatorSgix = ((int)0X819b),
        TextureLequalRSgix = ((int)0X819c),
        TextureGequalRSgix = ((int)0X819D),
        TextureMaxClampSSgix = ((int)0X8369),
        TextureMaxClampTSgix = ((int)0X836a),
        TextureMaxClampRSgix = ((int)0X836b),
        TextureCompressedImageSize = ((int)0X86a0),
        TextureCompressed = ((int)0X86a1),
        TextureDepthSize = ((int)0X884a),
        DepthTextureMode = ((int)0X884b),
        TextureCompareMode = ((int)0X884c),
        TextureCompareFunc = ((int)0X884d),
        TextureStencilSize = ((int)0X88f1),
        TextureRedType = ((int)0X8c10),
        TextureGreenType = ((int)0X8c11),
        TextureBlueType = ((int)0X8c12),
        TextureAlphaType = ((int)0X8c13),
        TextureLuminanceType = ((int)0X8c14),
        TextureIntensityType = ((int)0X8c15),
        TextureDepthType = ((int)0X8c16),
        TextureSharedSize = ((int)0X8c3f),
    }

    public enum Gl3DfxMultisample
    {
        MultisampleBit3Dfx = ((int)0X20000000),
        Multisample3Dfx = ((int)0X86b2),
        SampleBuffers3Dfx = ((int)0X86b3),
        Samples3Dfx = ((int)0X86b4),
    }

    public enum Gl3DfxTbuffer
    {
    }

    public enum Gl3DfxTextureCompressionFxt1
    {
        CompressedRgbFxt13Dfx = ((int)0X86b0),
        CompressedRgbaFxt13Dfx = ((int)0X86b1),
    }

    public enum GremedyFrameTerminator
    {
    }

    public enum GremedyStringMarker
    {
    }

    public enum HintMode
    {
        DontCare = ((int)0X1100),
        Fastest = ((int)0X1101),
        Nicest = ((int)0X1102),
    }

    public enum HintTarget
    {
        PerspectiveCorrectionHint = ((int)0X0c50),
        PointSmoothHint = ((int)0X0c51),
        LineSmoothHint = ((int)0X0c52),
        PolygonSmoothHint = ((int)0X0c53),
        FogHint = ((int)0X0c54),
        PackCmykHintExt = ((int)0X800e),
        UnpackCmykHintExt = ((int)0X800f),
        TextureMultiBufferHintSgix = ((int)0X812e),
        GenerateMipmapHint = ((int)0X8192),
        GenerateMipmapHintSgis = ((int)0X8192),
        ConvolutionHintSgix = ((int)0X8316),
        VertexPreclipHintSgix = ((int)0X83ef),
        TextureCompressionHint = ((int)0X84ef),
        FragmentShaderDerivativeHint = ((int)0X8b8b),
    }

    public enum HistogramTargetExt
    {
        HistogramExt = ((int)0X8024),
        ProxyHistogramExt = ((int)0X8025),
    }

    public enum HpConvolutionBorderModes
    {
        IgnoreBorderHp = ((int)0X8150),
        ConstantBorderHp = ((int)0X8151),
        ReplicateBorderHp = ((int)0X8153),
        ConvolutionBorderColorHp = ((int)0X8154),
    }

    public enum HpImageTransform
    {
        ImageScaleXHp = ((int)0X8155),
        ImageScaleYHp = ((int)0X8156),
        ImageTranslateXHp = ((int)0X8157),
        ImageTranslateYHp = ((int)0X8158),
        ImageRotateAngleHp = ((int)0X8159),
        ImageRotateOriginXHp = ((int)0X815a),
        ImageRotateOriginYHp = ((int)0X815b),
        ImageMagFilterHp = ((int)0X815c),
        ImageMinFilterHp = ((int)0X815d),
        ImageCubicWeightHp = ((int)0X815e),
        CubicHp = ((int)0X815f),
        AverageHp = ((int)0X8160),
        ImageTransform2DHp = ((int)0X8161),
        PostImageTransformColorTableHp = ((int)0X8162),
        ProxyPostImageTransformColorTableHp = ((int)0X8163),
    }

    public enum HpOcclusionTest
    {
        OcclusionTestHp = ((int)0X8165),
        OcclusionTestResultHp = ((int)0X8166),
    }

    public enum HpTextureLighting
    {
        TextureLightingModeHp = ((int)0X8167),
        TexturePostSpecularHp = ((int)0X8168),
        TexturePreSpecularHp = ((int)0X8169),
    }

    public enum IbmCullVertex
    {
        CullVertexIbm = ((int)103050),
    }

    public enum IbmMultimodeDrawArrays
    {
    }

    public enum IbmRasterposClip
    {
        RasterPositionUnclippedIbm = ((int)0X19262),
    }

    public enum IbmTextureMirroredRepeat
    {
        MirroredRepeatIbm = ((int)0X8370),
    }

    public enum IbmVertexArrayLists
    {
        VertexArrayListIbm = ((int)103070),
        NormalArrayListIbm = ((int)103071),
        ColorArrayListIbm = ((int)103072),
        IndexArrayListIbm = ((int)103073),
        TextureCoordArrayListIbm = ((int)103074),
        EdgeFlagArrayListIbm = ((int)103075),
        FogCoordinateArrayListIbm = ((int)103076),
        SecondaryColorArrayListIbm = ((int)103077),
        VertexArrayListStrideIbm = ((int)103080),
        NormalArrayListStrideIbm = ((int)103081),
        ColorArrayListStrideIbm = ((int)103082),
        IndexArrayListStrideIbm = ((int)103083),
        TextureCoordArrayListStrideIbm = ((int)103084),
        EdgeFlagArrayListStrideIbm = ((int)103085),
        FogCoordinateArrayListStrideIbm = ((int)103086),
        SecondaryColorArrayListStrideIbm = ((int)103087),
    }

    public enum IndexedEnableCap
    {
        Blend = ((int)0X0be2),
    }

    public enum IndexPointerType
    {
        Short = ((int)0X1402),
        Int = ((int)0X1404),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
    }

    public enum IngrColorClamp
    {
        RedMinClampIngr = ((int)0X8560),
        GreenMinClampIngr = ((int)0X8561),
        BlueMinClampIngr = ((int)0X8562),
        AlphaMinClampIngr = ((int)0X8563),
        RedMaxClampIngr = ((int)0X8564),
        GreenMaxClampIngr = ((int)0X8565),
        BlueMaxClampIngr = ((int)0X8566),
        AlphaMaxClampIngr = ((int)0X8567),
    }

    public enum IngrInterlaceRead
    {
        InterlaceReadIngr = ((int)0X8568),
    }

    public enum IngrPaletteBuffer
    {
    }

    public enum IntelParallelArrays
    {
        ParallelArraysIntel = ((int)0X83f4),
        VertexArrayParallelPointersIntel = ((int)0X83f5),
        NormalArrayParallelPointersIntel = ((int)0X83f6),
        ColorArrayParallelPointersIntel = ((int)0X83f7),
        TextureCoordArrayParallelPointersIntel = ((int)0X83f8),
    }

    public enum IntelTextureScissor
    {
    }

    public enum InterleavedArrayFormat
    {
        V2f = ((int)0X2a20),
        V3f = ((int)0X2a21),
        C4ubV2f = ((int)0X2a22),
        C4ubV3f = ((int)0X2a23),
        C3fV3f = ((int)0X2a24),
        N3fV3f = ((int)0X2a25),
        C4fN3fV3f = ((int)0X2a26),
        T2fV3f = ((int)0X2a27),
        T4fV4f = ((int)0X2a28),
        T2fC4ubV3f = ((int)0X2a29),
        T2fC3fV3f = ((int)0X2a2a),
        T2fN3fV3f = ((int)0X2a2b),
        T2fC4fN3fV3f = ((int)0X2a2c),
        T4fC4fN3fV4f = ((int)0X2a2d),
    }

    public enum LightEnvModeSgix
    {
        Add = ((int)0X0104),
        Replace = ((int)0X1e01),
        Modulate = ((int)0X2100),
    }

    public enum LightEnvParameterSgix
    {
        LightEnvModeSgix = ((int)0X8407),
    }

    public enum LightModelColorControl
    {
        SingleColor = ((int)0X81f9),
        SeparateSpecularColor = ((int)0X81fa),
    }

    public enum LightModelParameter
    {
        LightModelLocalViewer = ((int)0X0b51),
        LightModelTwoSide = ((int)0X0b52),
        LightModelAmbient = ((int)0X0b53),
        LightModelColorControl = ((int)0X81f8),
    }

    public enum LightName
    {
        Light0 = ((int)0X4000),
        Light1 = ((int)0X4001),
        Light2 = ((int)0X4002),
        Light3 = ((int)0X4003),
        Light4 = ((int)0X4004),
        Light5 = ((int)0X4005),
        Light6 = ((int)0X4006),
        Light7 = ((int)0X4007),
        FragmentLight0Sgix = ((int)0X840c),
        FragmentLight1Sgix = ((int)0X840D),
        FragmentLight2Sgix = ((int)0X840e),
        FragmentLight3Sgix = ((int)0X840f),
        FragmentLight4Sgix = ((int)0X8410),
        FragmentLight5Sgix = ((int)0X8411),
        FragmentLight6Sgix = ((int)0X8412),
        FragmentLight7Sgix = ((int)0X8413),
    }

    public enum LightParameter
    {
        Ambient = ((int)0X1200),
        Diffuse = ((int)0X1201),
        Specular = ((int)0X1202),
        Position = ((int)0X1203),
        SpotDirection = ((int)0X1204),
        SpotExponent = ((int)0X1205),
        SpotCutoff = ((int)0X1206),
        ConstantAttenuation = ((int)0X1207),
        LinearAttenuation = ((int)0X1208),
        QuadraticAttenuation = ((int)0X1209),
    }

    public enum ListMode
    {
        Compile = ((int)0X1300),
        CompileAndExecute = ((int)0X1301),
    }

    public enum ListNameType
    {
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        Gl2Bytes = ((int)0X1407),
        Gl3Bytes = ((int)0X1408),
        Gl4Bytes = ((int)0X1409),
    }

    public enum ListParameterName
    {
        ListPrioritySgix = ((int)0X8182),
    }

    public enum LogicOp
    {
        Clear = ((int)0X1500),
        And = ((int)0X1501),
        AndReverse = ((int)0X1502),
        Copy = ((int)0X1503),
        AndInverted = ((int)0X1504),
        Noop = ((int)0X1505),
        Xor = ((int)0X1506),
        Or = ((int)0X1507),
        Nor = ((int)0X1508),
        Equiv = ((int)0X1509),
        Invert = ((int)0X150a),
        OrReverse = ((int)0X150b),
        CopyInverted = ((int)0X150c),
        OrInverted = ((int)0X150d),
        Nand = ((int)0X150e),
        Set = ((int)0X150f),
    }

    public enum MapTarget
    {
        Map1Color4 = ((int)0X0D90),
        Map1Index = ((int)0X0D91),
        Map1Normal = ((int)0X0D92),
        Map1TextureCoord1 = ((int)0X0D93),
        Map1TextureCoord2 = ((int)0X0D94),
        Map1TextureCoord3 = ((int)0X0D95),
        Map1TextureCoord4 = ((int)0X0D96),
        Map1Vertex3 = ((int)0X0D97),
        Map1Vertex4 = ((int)0X0D98),
        Map2Color4 = ((int)0X0Db0),
        Map2Index = ((int)0X0Db1),
        Map2Normal = ((int)0X0Db2),
        Map2TextureCoord1 = ((int)0X0Db3),
        Map2TextureCoord2 = ((int)0X0Db4),
        Map2TextureCoord3 = ((int)0X0Db5),
        Map2TextureCoord4 = ((int)0X0Db6),
        Map2Vertex3 = ((int)0X0Db7),
        Map2Vertex4 = ((int)0X0Db8),
        GeometryDeformationSgix = ((int)0X8194),
        TextureDeformationSgix = ((int)0X8195),
    }

    public enum MaterialFace
    {
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        FrontAndBack = ((int)0X0408),
    }

    public enum MaterialParameter
    {
        Ambient = ((int)0X1200),
        Diffuse = ((int)0X1201),
        Specular = ((int)0X1202),
        Emission = ((int)0X1600),
        Shininess = ((int)0X1601),
        AmbientAndDiffuse = ((int)0X1602),
        ColorIndexes = ((int)0X1603),
    }

    public enum MatrixMode
    {
        Modelview = ((int)0X1700),
        Projection = ((int)0X1701),
        Texture = ((int)0X1702),
        Color = ((int)0X1800),
    }

    public enum MatrixModeArb
    {
        Modelview = ((int)0X1700),
        Projection = ((int)0X1701),
        Texture = ((int)0X1702),
        Color = ((int)0X1800),
        Matrix0 = ((int)0X88c0),
        Matrix1 = ((int)0X88c1),
        Matrix2 = ((int)0X88c2),
        Matrix3 = ((int)0X88c3),
        Matrix4 = ((int)0X88c4),
        Matrix5 = ((int)0X88c5),
        Matrix6 = ((int)0X88c6),
        Matrix7 = ((int)0X88c7),
        Matrix8 = ((int)0X88c8),
        Matrix9 = ((int)0X88c9),
        Matrix10 = ((int)0X88ca),
        Matrix11 = ((int)0X88cb),
        Matrix12 = ((int)0X88cc),
        Matrix13 = ((int)0X88cd),
        Matrix14 = ((int)0X88ce),
        Matrix15 = ((int)0X88cf),
        Matrix16 = ((int)0X88d0),
        Matrix17 = ((int)0X88d1),
        Matrix18 = ((int)0X88d2),
        Matrix19 = ((int)0X88d3),
        Matrix20 = ((int)0X88d4),
        Matrix21 = ((int)0X88d5),
        Matrix22 = ((int)0X88d6),
        Matrix23 = ((int)0X88d7),
        Matrix24 = ((int)0X88d8),
        Matrix25 = ((int)0X88d9),
        Matrix26 = ((int)0X88da),
        Matrix27 = ((int)0X88db),
        Matrix28 = ((int)0X88dc),
        Matrix29 = ((int)0X88dd),
        Matrix30 = ((int)0X88de),
        Matrix31 = ((int)0X88df),
    }

    public enum MesaPackInvert
    {
        PackInvertMesa = ((int)0X8758),
    }

    public enum MesaResizeBuffers
    {
    }

    public enum MesaWindowPos
    {
    }

    public enum MesaxTextureStack
    {
        Texture1DStackMesax = ((int)0X8759),
        Texture2DStackMesax = ((int)0X875a),
        ProxyTexture1DStackMesax = ((int)0X875b),
        ProxyTexture2DStackMesax = ((int)0X875c),
        Texture1DStackBindingMesax = ((int)0X875d),
        Texture2DStackBindingMesax = ((int)0X875e),
    }

    public enum MesaYcbcrTexture
    {
        UnsignedShort88Mesa = ((int)0X85ba),
        UnsignedShort88RevMesa = ((int)0X85bb),
        YcbcrMesa = ((int)0X8757),
    }

    public enum MeshMode1
    {
        Point = ((int)0X1b00),
        Line = ((int)0X1b01),
    }

    public enum MeshMode2
    {
        Point = ((int)0X1b00),
        Line = ((int)0X1b01),
        Fill = ((int)0X1b02),
    }

    public enum MinmaxTargetExt
    {
        MinmaxExt = ((int)0X802e),
    }

    public enum NormalPointerType
    {
        Byte = ((int)0X1400),
        Short = ((int)0X1402),
        Int = ((int)0X1404),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
        HalfFloat = ((int)0X140b),
    }

    public enum NvBlendSquare
    {
    }

    public enum NvConditionalRender
    {
        QueryWaitNv = ((int)0X8e13),
        QueryNoWaitNv = ((int)0X8e14),
        QueryByRegionWaitNv = ((int)0X8e15),
        QueryByRegionNoWaitNv = ((int)0X8e16),
    }

    public enum NvCopyDepthToColor
    {
        DepthStencilToRgbaNv = ((int)0X886e),
        DepthStencilToBgraNv = ((int)0X886f),
    }

    public enum NvDepthBufferFloat
    {
        DepthComponent32fNv = ((int)0X8dab),
        Depth32fStencil8Nv = ((int)0X8dac),
        Float32UnsignedInt248RevNv = ((int)0X8dad),
        DepthBufferFloatModeNv = ((int)0X8daf),
    }

    public enum NvDepthClamp
    {
        DepthClampNv = ((int)0X864f),
    }

    public enum NvEvaluators
    {
        Eval2DNv = ((int)0X86c0),
        EvalTriangular2DNv = ((int)0X86c1),
        MapTessellationNv = ((int)0X86c2),
        MapAttribUOrderNv = ((int)0X86c3),
        MapAttribVOrderNv = ((int)0X86c4),
        EvalFractionalTessellationNv = ((int)0X86c5),
        EvalVertexAttrib0Nv = ((int)0X86c6),
        EvalVertexAttrib1Nv = ((int)0X86c7),
        EvalVertexAttrib2Nv = ((int)0X86c8),
        EvalVertexAttrib3Nv = ((int)0X86c9),
        EvalVertexAttrib4Nv = ((int)0X86ca),
        EvalVertexAttrib5Nv = ((int)0X86cb),
        EvalVertexAttrib6Nv = ((int)0X86cc),
        EvalVertexAttrib7Nv = ((int)0X86cd),
        EvalVertexAttrib8Nv = ((int)0X86ce),
        EvalVertexAttrib9Nv = ((int)0X86cf),
        EvalVertexAttrib10Nv = ((int)0X86d0),
        EvalVertexAttrib11Nv = ((int)0X86d1),
        EvalVertexAttrib12Nv = ((int)0X86d2),
        EvalVertexAttrib13Nv = ((int)0X86d3),
        EvalVertexAttrib14Nv = ((int)0X86d4),
        EvalVertexAttrib15Nv = ((int)0X86d5),
        MaxMapTessellationNv = ((int)0X86d6),
        MaxRationalEvalOrderNv = ((int)0X86d7),
    }

    public enum NvExplicitMultisample
    {
        SamplePositionNv = ((int)0X8e50),
        SampleMaskNv = ((int)0X8e51),
        SampleMaskValueNv = ((int)0X8e52),
        TextureBindingRenderbufferNv = ((int)0X8e53),
        TextureRenderbufferDataStoreBindingNv = ((int)0X8e54),
        TextureRenderbufferNv = ((int)0X8e55),
        SamplerRenderbufferNv = ((int)0X8e56),
        IntSamplerRenderbufferNv = ((int)0X8e57),
        UnsignedIntSamplerRenderbufferNv = ((int)0X8e58),
        MaxSampleMaskWordsNv = ((int)0X8e59),
    }

    public enum NvFence
    {
        AllCompletedNv = ((int)0X84f2),
        FenceStatusNv = ((int)0X84f3),
        FenceConditionNv = ((int)0X84f4),
    }

    public enum NvFloatBuffer
    {
        FloatRNv = ((int)0X8880),
        FloatRgNv = ((int)0X8881),
        FloatRgbNv = ((int)0X8882),
        FloatRgbaNv = ((int)0X8883),
        FloatR16Nv = ((int)0X8884),
        FloatR32Nv = ((int)0X8885),
        FloatRg16Nv = ((int)0X8886),
        FloatRg32Nv = ((int)0X8887),
        FloatRgb16Nv = ((int)0X8888),
        FloatRgb32Nv = ((int)0X8889),
        FloatRgba16Nv = ((int)0X888a),
        FloatRgba32Nv = ((int)0X888b),
        TextureFloatComponentsNv = ((int)0X888c),
        FloatClearColorValueNv = ((int)0X888d),
        FloatRgbaModeNv = ((int)0X888e),
    }

    public enum NvFogDistance
    {
        EyePlane = ((int)0X2502),
        FogDistanceModeNv = ((int)0X855a),
        EyeRadialNv = ((int)0X855b),
        EyePlaneAbsoluteNv = ((int)0X855c),
    }

    public enum NvFragmentProgram
    {
        MaxFragmentProgramLocalParametersNv = ((int)0X8868),
        FragmentProgramNv = ((int)0X8870),
        MaxTextureCoordsNv = ((int)0X8871),
        MaxTextureImageUnitsNv = ((int)0X8872),
        FragmentProgramBindingNv = ((int)0X8873),
        ProgramErrorStringNv = ((int)0X8874),
    }

    public enum NvFragmentProgram2
    {
        MaxProgramExecInstructionsNv = ((int)0X88f4),
        MaxProgramCallDepthNv = ((int)0X88f5),
        MaxProgramIfDepthNv = ((int)0X88f6),
        MaxProgramLoopDepthNv = ((int)0X88f7),
        MaxProgramLoopCountNv = ((int)0X88f8),
    }

    public enum NvFragmentProgram4
    {
    }

    public enum NvFragmentProgramOption
    {
    }

    public enum NvFramebufferMultisampleCoverage
    {
        RenderbufferCoverageSamplesNv = ((int)0X8cab),
        RenderbufferColorSamplesNv = ((int)0X8e10),
        MaxMultisampleCoverageModesNv = ((int)0X8e11),
        MultisampleCoverageModesNv = ((int)0X8e12),
    }

    public enum NvGeometryProgram4
    {
        LinesAdjacencyExt = ((int)0X000a),
        LineStripAdjacencyExt = ((int)0X000b),
        TrianglesAdjacencyExt = ((int)0X000c),
        TriangleStripAdjacencyExt = ((int)0X000d),
        ProgramPointSizeExt = ((int)0X8642),
        GeometryProgramNv = ((int)0X8c26),
        MaxProgramOutputVerticesNv = ((int)0X8c27),
        MaxProgramTotalOutputComponentsNv = ((int)0X8c28),
        MaxGeometryTextureImageUnitsExt = ((int)0X8c29),
        FramebufferAttachmentTextureLayerExt = ((int)0X8cd4),
        FramebufferAttachmentLayeredExt = ((int)0X8da7),
        FramebufferIncompleteLayerTargetsExt = ((int)0X8da8),
        FramebufferIncompleteLayerCountExt = ((int)0X8da9),
        GeometryVerticesOutExt = ((int)0X8dda),
        GeometryInputTypeExt = ((int)0X8ddb),
        GeometryOutputTypeExt = ((int)0X8ddc),
    }

    public enum NvGeometryShader4
    {
    }

    public enum NvGpuProgram4
    {
        MinProgramTexelOffsetNv = ((int)0X8904),
        MaxProgramTexelOffsetNv = ((int)0X8905),
        ProgramAttribComponentsNv = ((int)0X8906),
        ProgramResultComponentsNv = ((int)0X8907),
        MaxProgramAttribComponentsNv = ((int)0X8908),
        MaxProgramResultComponentsNv = ((int)0X8909),
        MaxProgramGenericAttribsNv = ((int)0X8da5),
        MaxProgramGenericResultsNv = ((int)0X8da6),
    }

    public enum NvHalfFloat
    {
        HalfFloatNv = ((int)0X140b),
    }

    public enum NvLightMaxExponent
    {
        MaxShininessNv = ((int)0X8504),
        MaxSpotExponentNv = ((int)0X8505),
    }

    public enum NvMultisampleFilterHint
    {
        MultisampleFilterHintNv = ((int)0X8534),
    }

    public enum NvOcclusionQuery
    {
        PixelCounterBitsNv = ((int)0X8864),
        CurrentOcclusionQueryIdNv = ((int)0X8865),
        PixelCountNv = ((int)0X8866),
        PixelCountAvailableNv = ((int)0X8867),
    }

    public enum NvPackedDepthStencil
    {
        DepthStencilNv = ((int)0X84f9),
        UnsignedInt248Nv = ((int)0X84fa),
    }

    public enum NvParameterBufferObject
    {
        MaxProgramParameterBufferBindingsNv = ((int)0X8da0),
        MaxProgramParameterBufferSizeNv = ((int)0X8da1),
        VertexProgramParameterBufferNv = ((int)0X8da2),
        GeometryProgramParameterBufferNv = ((int)0X8da3),
        FragmentProgramParameterBufferNv = ((int)0X8da4),
    }

    public enum NvPixelDataRange
    {
        WritePixelDataRangeNv = ((int)0X8878),
        ReadPixelDataRangeNv = ((int)0X8879),
        WritePixelDataRangeLengthNv = ((int)0X887a),
        ReadPixelDataRangeLengthNv = ((int)0X887b),
        WritePixelDataRangePointerNv = ((int)0X887c),
        ReadPixelDataRangePointerNv = ((int)0X887d),
    }

    public enum NvPointSprite
    {
        PointSpriteNv = ((int)0X8861),
        CoordReplaceNv = ((int)0X8862),
        PointSpriteRModeNv = ((int)0X8863),
    }

    public enum NvPresentVideo
    {
        FrameNv = ((int)0X8e26),
        FieldsNv = ((int)0X8e27),
        CurrentTimeNv = ((int)0X8e28),
        NumFillStreamsNv = ((int)0X8e29),
        PresentTimeNv = ((int)0X8e2a),
        PresentDurationNv = ((int)0X8e2b),
    }

    public enum NvPrimitiveRestart
    {
        PrimitiveRestartNv = ((int)0X8558),
        PrimitiveRestartIndexNv = ((int)0X8559),
    }

    public enum NvRegisterCombiners
    {
        None = ((int)0),
        Zero = ((int)0),
        Fog = ((int)0X0b60),
        Texture0Arb = ((int)0X84c0),
        Texture1Arb = ((int)0X84c1),
        RegisterCombinersNv = ((int)0X8522),
        VariableANv = ((int)0X8523),
        VariableBNv = ((int)0X8524),
        VariableCNv = ((int)0X8525),
        VariableDNv = ((int)0X8526),
        VariableENv = ((int)0X8527),
        VariableFNv = ((int)0X8528),
        VariableGNv = ((int)0X8529),
        ConstantColor0Nv = ((int)0X852a),
        ConstantColor1Nv = ((int)0X852b),
        PrimaryColorNv = ((int)0X852c),
        SecondaryColorNv = ((int)0X852d),
        Spare0Nv = ((int)0X852e),
        Spare1Nv = ((int)0X852f),
        DiscardNv = ((int)0X8530),
        ETimesFNv = ((int)0X8531),
        Spare0PlusSecondaryColorNv = ((int)0X8532),
        UnsignedIdentityNv = ((int)0X8536),
        UnsignedInvertNv = ((int)0X8537),
        ExpandNormalNv = ((int)0X8538),
        ExpandNegateNv = ((int)0X8539),
        HalfBiasNormalNv = ((int)0X853a),
        HalfBiasNegateNv = ((int)0X853b),
        SignedIdentityNv = ((int)0X853c),
        SignedNegateNv = ((int)0X853d),
        ScaleByTwoNv = ((int)0X853e),
        ScaleByFourNv = ((int)0X853f),
        ScaleByOneHalfNv = ((int)0X8540),
        BiasByNegativeOneHalfNv = ((int)0X8541),
        CombinerInputNv = ((int)0X8542),
        CombinerMappingNv = ((int)0X8543),
        CombinerComponentUsageNv = ((int)0X8544),
        CombinerAbDotProductNv = ((int)0X8545),
        CombinerCdDotProductNv = ((int)0X8546),
        CombinerMuxSumNv = ((int)0X8547),
        CombinerScaleNv = ((int)0X8548),
        CombinerBiasNv = ((int)0X8549),
        CombinerAbOutputNv = ((int)0X854a),
        CombinerCdOutputNv = ((int)0X854b),
        CombinerSumOutputNv = ((int)0X854c),
        MaxGeneralCombinersNv = ((int)0X854d),
        NumGeneralCombinersNv = ((int)0X854e),
        ColorSumClampNv = ((int)0X854f),
        Combiner0Nv = ((int)0X8550),
        Combiner1Nv = ((int)0X8551),
        Combiner2Nv = ((int)0X8552),
        Combiner3Nv = ((int)0X8553),
        Combiner4Nv = ((int)0X8554),
        Combiner5Nv = ((int)0X8555),
        Combiner6Nv = ((int)0X8556),
        Combiner7Nv = ((int)0X8557),
    }

    public enum NvRegisterCombiners2
    {
        PerStageConstantsNv = ((int)0X8535),
    }

    public enum NvTexgenEmboss
    {
        EmbossLightNv = ((int)0X855d),
        EmbossConstantNv = ((int)0X855e),
        EmbossMapNv = ((int)0X855f),
    }

    public enum NvTexgenReflection
    {
        NormalMapNv = ((int)0X8511),
        ReflectionMapNv = ((int)0X8512),
    }

    public enum NvTextureCompressionVtc
    {
    }

    public enum NvTextureEnvCombine4
    {
        Combine4Nv = ((int)0X8503),
        Source3RgbNv = ((int)0X8583),
        Source3AlphaNv = ((int)0X858b),
        Operand3RgbNv = ((int)0X8593),
        Operand3AlphaNv = ((int)0X859b),
    }

    public enum NvTextureExpandNormal
    {
        TextureUnsignedRemapModeNv = ((int)0X888f),
    }

    public enum NvTextureRectangle
    {
        TextureRectangleNv = ((int)0X84f5),
        TextureBindingRectangleNv = ((int)0X84f6),
        ProxyTextureRectangleNv = ((int)0X84f7),
        MaxRectangleTextureSizeNv = ((int)0X84f8),
    }

    public enum NvTextureShader
    {
        OffsetTextureRectangleNv = ((int)0X864c),
        OffsetTextureRectangleScaleNv = ((int)0X864d),
        DotProductTextureRectangleNv = ((int)0X864e),
        RgbaUnsignedDotProductMappingNv = ((int)0X86d9),
        UnsignedIntS8S888Nv = ((int)0X86da),
        UnsignedInt88S8S8RevNv = ((int)0X86db),
        DsdtMagIntensityNv = ((int)0X86dc),
        ShaderConsistentNv = ((int)0X86dd),
        TextureShaderNv = ((int)0X86de),
        ShaderOperationNv = ((int)0X86df),
        CullModesNv = ((int)0X86e0),
        OffsetTexture2DMatrixNv = ((int)0X86e1),
        OffsetTextureMatrixNv = ((int)0X86e1),
        OffsetTexture2DScaleNv = ((int)0X86e2),
        OffsetTextureScaleNv = ((int)0X86e2),
        OffsetTexture2DBiasNv = ((int)0X86e3),
        OffsetTextureBiasNv = ((int)0X86e3),
        PreviousTextureInputNv = ((int)0X86e4),
        ConstEyeNv = ((int)0X86e5),
        PassThroughNv = ((int)0X86e6),
        CullFragmentNv = ((int)0X86e7),
        OffsetTexture2DNv = ((int)0X86e8),
        DependentArTexture2DNv = ((int)0X86e9),
        DependentGbTexture2DNv = ((int)0X86ea),
        DotProductNv = ((int)0X86ec),
        DotProductDepthReplaceNv = ((int)0X86ed),
        DotProductTexture2DNv = ((int)0X86ee),
        DotProductTextureCubeMapNv = ((int)0X86f0),
        DotProductDiffuseCubeMapNv = ((int)0X86f1),
        DotProductReflectCubeMapNv = ((int)0X86f2),
        DotProductConstEyeReflectCubeMapNv = ((int)0X86f3),
        HiloNv = ((int)0X86f4),
        DsdtNv = ((int)0X86f5),
        DsdtMagNv = ((int)0X86f6),
        DsdtMagVibNv = ((int)0X86f7),
        Hilo16Nv = ((int)0X86f8),
        SignedHiloNv = ((int)0X86f9),
        SignedHilo16Nv = ((int)0X86fa),
        SignedRgbaNv = ((int)0X86fb),
        SignedRgba8Nv = ((int)0X86fc),
        SignedRgbNv = ((int)0X86fe),
        SignedRgb8Nv = ((int)0X86ff),
        SignedLuminanceNv = ((int)0X8701),
        SignedLuminance8Nv = ((int)0X8702),
        SignedLuminanceAlphaNv = ((int)0X8703),
        SignedLuminance8Alpha8Nv = ((int)0X8704),
        SignedAlphaNv = ((int)0X8705),
        SignedAlpha8Nv = ((int)0X8706),
        SignedIntensityNv = ((int)0X8707),
        SignedIntensity8Nv = ((int)0X8708),
        Dsdt8Nv = ((int)0X8709),
        Dsdt8Mag8Nv = ((int)0X870a),
        Dsdt8Mag8Intensity8Nv = ((int)0X870b),
        SignedRgbUnsignedAlphaNv = ((int)0X870c),
        SignedRgb8UnsignedAlpha8Nv = ((int)0X870d),
        HiScaleNv = ((int)0X870e),
        LoScaleNv = ((int)0X870f),
        DsScaleNv = ((int)0X8710),
        DtScaleNv = ((int)0X8711),
        MagnitudeScaleNv = ((int)0X8712),
        VibranceScaleNv = ((int)0X8713),
        HiBiasNv = ((int)0X8714),
        LoBiasNv = ((int)0X8715),
        DsBiasNv = ((int)0X8716),
        DtBiasNv = ((int)0X8717),
        MagnitudeBiasNv = ((int)0X8718),
        VibranceBiasNv = ((int)0X8719),
        TextureBorderValuesNv = ((int)0X871a),
        TextureHiSizeNv = ((int)0X871b),
        TextureLoSizeNv = ((int)0X871c),
        TextureDsSizeNv = ((int)0X871d),
        TextureDtSizeNv = ((int)0X871e),
        TextureMagSizeNv = ((int)0X871f),
    }

    public enum NvTextureShader2
    {
        DotProductTexture3DNv = ((int)0X86ef),
    }

    public enum NvTextureShader3
    {
        OffsetProjectiveTexture2DNv = ((int)0X8850),
        OffsetProjectiveTexture2DScaleNv = ((int)0X8851),
        OffsetProjectiveTextureRectangleNv = ((int)0X8852),
        OffsetProjectiveTextureRectangleScaleNv = ((int)0X8853),
        OffsetHiloTexture2DNv = ((int)0X8854),
        OffsetHiloTextureRectangleNv = ((int)0X8855),
        OffsetHiloProjectiveTexture2DNv = ((int)0X8856),
        OffsetHiloProjectiveTextureRectangleNv = ((int)0X8857),
        DependentHiloTexture2DNv = ((int)0X8858),
        DependentRgbTexture3DNv = ((int)0X8859),
        DependentRgbTextureCubeMapNv = ((int)0X885a),
        DotProductPassThroughNv = ((int)0X885b),
        DotProductTexture1DNv = ((int)0X885c),
        DotProductAffineDepthReplaceNv = ((int)0X885d),
        Hilo8Nv = ((int)0X885e),
        SignedHilo8Nv = ((int)0X885f),
        ForceBlueToOneNv = ((int)0X8860),
    }

    public enum NvTransformFeedback
    {
        BackPrimaryColorNv = ((int)0X8c77),
        BackSecondaryColorNv = ((int)0X8c78),
        TextureCoordNv = ((int)0X8c79),
        ClipDistanceNv = ((int)0X8c7a),
        VertexIdNv = ((int)0X8c7b),
        PrimitiveIdNv = ((int)0X8c7c),
        GenericAttribNv = ((int)0X8c7d),
        TransformFeedbackAttribsNv = ((int)0X8c7e),
        TransformFeedbackBufferModeNv = ((int)0X8c7f),
        MaxTransformFeedbackSeparateComponentsNv = ((int)0X8c80),
        ActiveVaryingsNv = ((int)0X8c81),
        ActiveVaryingMaxLengthNv = ((int)0X8c82),
        TransformFeedbackVaryingsNv = ((int)0X8c83),
        TransformFeedbackBufferStartNv = ((int)0X8c84),
        TransformFeedbackBufferSizeNv = ((int)0X8c85),
        TransformFeedbackRecordNv = ((int)0X8c86),
        PrimitivesGeneratedNv = ((int)0X8c87),
        TransformFeedbackPrimitivesWrittenNv = ((int)0X8c88),
        RasterizerDiscardNv = ((int)0X8c89),
        MaxTransformFeedbackInterleavedAttribsNv = ((int)0X8c8a),
        MaxTransformFeedbackSeparateAttribsNv = ((int)0X8c8b),
        InterleavedAttribsNv = ((int)0X8c8c),
        SeparateAttribsNv = ((int)0X8c8d),
        TransformFeedbackBufferNv = ((int)0X8c8e),
        TransformFeedbackBufferBindingNv = ((int)0X8c8f),
    }

    public enum NvTransformFeedback2
    {
        TransformFeedbackNv = ((int)0X8e22),
        TransformFeedbackBufferPausedNv = ((int)0X8e23),
        TransformFeedbackBufferActiveNv = ((int)0X8e24),
        TransformFeedbackBindingNv = ((int)0X8e25),
    }

    public enum NvVertexArrayRange
    {
        VertexArrayRangeNv = ((int)0X851d),
        VertexArrayRangeLengthNv = ((int)0X851e),
        VertexArrayRangeValidNv = ((int)0X851f),
        MaxVertexArrayRangeElementNv = ((int)0X8520),
        VertexArrayRangePointerNv = ((int)0X8521),
    }

    public enum NvVertexArrayRange2
    {
        VertexArrayRangeWithoutFlushNv = ((int)0X8533),
    }

    public enum NvVertexProgram
    {
        VertexProgramNv = ((int)0X8620),
        VertexStateProgramNv = ((int)0X8621),
        AttribArraySizeNv = ((int)0X8623),
        AttribArrayStrideNv = ((int)0X8624),
        AttribArrayTypeNv = ((int)0X8625),
        CurrentAttribNv = ((int)0X8626),
        ProgramLengthNv = ((int)0X8627),
        ProgramStringNv = ((int)0X8628),
        ModelviewProjectionNv = ((int)0X8629),
        IdentityNv = ((int)0X862a),
        InverseNv = ((int)0X862b),
        TransposeNv = ((int)0X862c),
        InverseTransposeNv = ((int)0X862d),
        MaxTrackMatrixStackDepthNv = ((int)0X862e),
        MaxTrackMatricesNv = ((int)0X862f),
        Matrix0Nv = ((int)0X8630),
        Matrix1Nv = ((int)0X8631),
        Matrix2Nv = ((int)0X8632),
        Matrix3Nv = ((int)0X8633),
        Matrix4Nv = ((int)0X8634),
        Matrix5Nv = ((int)0X8635),
        Matrix6Nv = ((int)0X8636),
        Matrix7Nv = ((int)0X8637),
        CurrentMatrixStackDepthNv = ((int)0X8640),
        CurrentMatrixNv = ((int)0X8641),
        VertexProgramPointSizeNv = ((int)0X8642),
        VertexProgramTwoSideNv = ((int)0X8643),
        ProgramParameterNv = ((int)0X8644),
        AttribArrayPointerNv = ((int)0X8645),
        ProgramTargetNv = ((int)0X8646),
        ProgramResidentNv = ((int)0X8647),
        TrackMatrixNv = ((int)0X8648),
        TrackMatrixTransformNv = ((int)0X8649),
        VertexProgramBindingNv = ((int)0X864a),
        ProgramErrorPositionNv = ((int)0X864b),
        VertexAttribArray0Nv = ((int)0X8650),
        VertexAttribArray1Nv = ((int)0X8651),
        VertexAttribArray2Nv = ((int)0X8652),
        VertexAttribArray3Nv = ((int)0X8653),
        VertexAttribArray4Nv = ((int)0X8654),
        VertexAttribArray5Nv = ((int)0X8655),
        VertexAttribArray6Nv = ((int)0X8656),
        VertexAttribArray7Nv = ((int)0X8657),
        VertexAttribArray8Nv = ((int)0X8658),
        VertexAttribArray9Nv = ((int)0X8659),
        VertexAttribArray10Nv = ((int)0X865a),
        VertexAttribArray11Nv = ((int)0X865b),
        VertexAttribArray12Nv = ((int)0X865c),
        VertexAttribArray13Nv = ((int)0X865d),
        VertexAttribArray14Nv = ((int)0X865e),
        VertexAttribArray15Nv = ((int)0X865f),
        Map1VertexAttrib04Nv = ((int)0X8660),
        Map1VertexAttrib14Nv = ((int)0X8661),
        Map1VertexAttrib24Nv = ((int)0X8662),
        Map1VertexAttrib34Nv = ((int)0X8663),
        Map1VertexAttrib44Nv = ((int)0X8664),
        Map1VertexAttrib54Nv = ((int)0X8665),
        Map1VertexAttrib64Nv = ((int)0X8666),
        Map1VertexAttrib74Nv = ((int)0X8667),
        Map1VertexAttrib84Nv = ((int)0X8668),
        Map1VertexAttrib94Nv = ((int)0X8669),
        Map1VertexAttrib104Nv = ((int)0X866a),
        Map1VertexAttrib114Nv = ((int)0X866b),
        Map1VertexAttrib124Nv = ((int)0X866c),
        Map1VertexAttrib134Nv = ((int)0X866d),
        Map1VertexAttrib144Nv = ((int)0X866e),
        Map1VertexAttrib154Nv = ((int)0X866f),
        Map2VertexAttrib04Nv = ((int)0X8670),
        Map2VertexAttrib14Nv = ((int)0X8671),
        Map2VertexAttrib24Nv = ((int)0X8672),
        Map2VertexAttrib34Nv = ((int)0X8673),
        Map2VertexAttrib44Nv = ((int)0X8674),
        Map2VertexAttrib54Nv = ((int)0X8675),
        Map2VertexAttrib64Nv = ((int)0X8676),
        Map2VertexAttrib74Nv = ((int)0X8677),
        Map2VertexAttrib84Nv = ((int)0X8678),
        Map2VertexAttrib94Nv = ((int)0X8679),
        Map2VertexAttrib104Nv = ((int)0X867a),
        Map2VertexAttrib114Nv = ((int)0X867b),
        Map2VertexAttrib124Nv = ((int)0X867c),
        Map2VertexAttrib134Nv = ((int)0X867d),
        Map2VertexAttrib144Nv = ((int)0X867e),
        Map2VertexAttrib154Nv = ((int)0X867f),
    }

    public enum NvVertexProgram11
    {
    }

    public enum NvVertexProgram2
    {
    }

    public enum NvVertexProgram2Option
    {
        MaxProgramExecInstructionsNv = ((int)0X88f4),
        MaxProgramCallDepthNv = ((int)0X88f5),
    }

    public enum NvVertexProgram3
    {
        MaxVertexTextureImageUnitsArb = ((int)0X8b4c),
    }

    public enum NvVertexProgram4
    {
        VertexAttribArrayIntegerNv = ((int)0X88fd),
    }

    public enum OesReadFormat
    {
        ImplementationColorReadTypeOes = ((int)0X8b9a),
        ImplementationColorReadFormatOes = ((int)0X8b9b),
    }

    public enum OmlInterlace
    {
        InterlaceOml = ((int)0X8980),
        InterlaceReadOml = ((int)0X8981),
    }

    public enum OmlResample
    {
        PackResampleOml = ((int)0X8984),
        UnpackResampleOml = ((int)0X8985),
        ResampleReplicateOml = ((int)0X8986),
        ResampleZeroFillOml = ((int)0X8987),
        ResampleAverageOml = ((int)0X8988),
        ResampleDecimateOml = ((int)0X8989),
    }

    public enum OmlSubsample
    {
        FormatSubsample2424Oml = ((int)0X8982),
        FormatSubsample244244Oml = ((int)0X8983),
    }

    public enum PgiMiscHints
    {
        PreferDoublebufferHintPgi = ((int)0X1a1f8),
        ConserveMemoryHintPgi = ((int)0X1a1fd),
        ReclaimMemoryHintPgi = ((int)0X1a1fe),
        NativeGraphicsHandlePgi = ((int)0X1a202),
        NativeGraphicsBeginHintPgi = ((int)0X1a203),
        NativeGraphicsEndHintPgi = ((int)0X1a204),
        AlwaysFastHintPgi = ((int)0X1a20c),
        AlwaysSoftHintPgi = ((int)0X1a20d),
        AllowDrawObjHintPgi = ((int)0X1a20e),
        AllowDrawWinHintPgi = ((int)0X1a20f),
        AllowDrawFrgHintPgi = ((int)0X1a210),
        AllowDrawMemHintPgi = ((int)0X1a211),
        StrictDepthfuncHintPgi = ((int)0X1a216),
        StrictLightingHintPgi = ((int)0X1a217),
        StrictScissorHintPgi = ((int)0X1a218),
        FullStippleHintPgi = ((int)0X1a219),
        ClipNearHintPgi = ((int)0X1a220),
        ClipFarHintPgi = ((int)0X1a221),
        WideLineHintPgi = ((int)0X1a222),
        BackNormalsHintPgi = ((int)0X1a223),
    }

    public enum PgiVertexHints
    {
        Vertex23BitPgi = ((int)0X00000004),
        Vertex4BitPgi = ((int)0X00000008),
        Color3BitPgi = ((int)0X00010000),
        Color4BitPgi = ((int)0X00020000),
        EdgeflagBitPgi = ((int)0X00040000),
        IndexBitPgi = ((int)0X00080000),
        MatAmbientBitPgi = ((int)0X00100000),
        MatAmbientAndDiffuseBitPgi = ((int)0X00200000),
        MatDiffuseBitPgi = ((int)0X00400000),
        MatEmissionBitPgi = ((int)0X00800000),
        MatColorIndexesBitPgi = ((int)0X01000000),
        MatShininessBitPgi = ((int)0X02000000),
        MatSpecularBitPgi = ((int)0X04000000),
        NormalBitPgi = ((int)0X08000000),
        Texcoord1BitPgi = ((int)0X10000000),
        VertexDataHintPgi = ((int)0X1a22a),
        VertexConsistentHintPgi = ((int)0X1a22b),
        MaterialSideHintPgi = ((int)0X1a22c),
        MaxVertexHintPgi = ((int)0X1a22d),
        Texcoord2BitPgi = ((int)0X20000000),
        Texcoord3BitPgi = ((int)0X40000000),
        Texcoord4BitPgi = unchecked((int)0X80000000),
    }

    public enum PixelCopyType
    {
        Color = ((int)0X1800),
        Depth = ((int)0X1801),
        Stencil = ((int)0X1802),
    }

    public enum PixelFormat
    {
        ColorIndex = ((int)0X1900),
        StencilIndex = ((int)0X1901),
        DepthComponent = ((int)0X1902),
        Red = ((int)0X1903),
        Green = ((int)0X1904),
        Blue = ((int)0X1905),
        Alpha = ((int)0X1906),
        Rgb = ((int)0X1907),
        Rgba = ((int)0X1908),
        Luminance = ((int)0X1909),
        LuminanceAlpha = ((int)0X190a),
        AbgrExt = ((int)0X8000),
        CmykExt = ((int)0X800c),
        CmykaExt = ((int)0X800D),
        Bgr = ((int)0X80e0),
        Bgra = ((int)0X80e1),
        Ycrcb422Sgix = ((int)0X81bb),
        Ycrcb444Sgix = ((int)0X81bc),
        Rg = ((int)0X8227),
        RgInteger = ((int)0X8228),
        DepthStencil = ((int)0X84f9),
        RedInteger = ((int)0X8d94),
        GreenInteger = ((int)0X8d95),
        BlueInteger = ((int)0X8d96),
        AlphaInteger = ((int)0X8d97),
        RgbInteger = ((int)0X8d98),
        RgbaInteger = ((int)0X8d99),
        BgrInteger = ((int)0X8d9a),
        BgraInteger = ((int)0X8d9b),
    }

    public enum PixelInternalFormat
    {
        DepthComponent = ((int)0X1902),
        Alpha = ((int)0X1906),
        Rgb = ((int)0X1907),
        Rgba = ((int)0X1908),
        Luminance = ((int)0X1909),
        LuminanceAlpha = ((int)0X190a),
        R3G3B2 = ((int)0X2a10),
        Alpha4 = ((int)0X803b),
        Alpha8 = ((int)0X803c),
        Alpha12 = ((int)0X803d),
        Alpha16 = ((int)0X803e),
        Luminance4 = ((int)0X803f),
        Luminance8 = ((int)0X8040),
        Luminance12 = ((int)0X8041),
        Luminance16 = ((int)0X8042),
        Luminance4Alpha4 = ((int)0X8043),
        Luminance6Alpha2 = ((int)0X8044),
        Luminance8Alpha8 = ((int)0X8045),
        Luminance12Alpha4 = ((int)0X8046),
        Luminance12Alpha12 = ((int)0X8047),
        Luminance16Alpha16 = ((int)0X8048),
        Intensity = ((int)0X8049),
        Intensity4 = ((int)0X804a),
        Intensity8 = ((int)0X804b),
        Intensity12 = ((int)0X804c),
        Intensity16 = ((int)0X804d),
        Rgb2Ext = ((int)0X804e),
        Rgb4 = ((int)0X804f),
        Rgb5 = ((int)0X8050),
        Rgb8 = ((int)0X8051),
        Rgb10 = ((int)0X8052),
        Rgb12 = ((int)0X8053),
        Rgb16 = ((int)0X8054),
        Rgba2 = ((int)0X8055),
        Rgba4 = ((int)0X8056),
        Rgb5A1 = ((int)0X8057),
        Rgba8 = ((int)0X8058),
        Rgb10A2 = ((int)0X8059),
        Rgba12 = ((int)0X805a),
        Rgba16 = ((int)0X805b),
        DualAlpha4Sgis = ((int)0X8110),
        DualAlpha8Sgis = ((int)0X8111),
        DualAlpha12Sgis = ((int)0X8112),
        DualAlpha16Sgis = ((int)0X8113),
        DualLuminance4Sgis = ((int)0X8114),
        DualLuminance8Sgis = ((int)0X8115),
        DualLuminance12Sgis = ((int)0X8116),
        DualLuminance16Sgis = ((int)0X8117),
        DualIntensity4Sgis = ((int)0X8118),
        DualIntensity8Sgis = ((int)0X8119),
        DualIntensity12Sgis = ((int)0X811a),
        DualIntensity16Sgis = ((int)0X811b),
        DualLuminanceAlpha4Sgis = ((int)0X811c),
        DualLuminanceAlpha8Sgis = ((int)0X811D),
        QuadAlpha4Sgis = ((int)0X811e),
        QuadAlpha8Sgis = ((int)0X811f),
        QuadLuminance4Sgis = ((int)0X8120),
        QuadLuminance8Sgis = ((int)0X8121),
        QuadIntensity4Sgis = ((int)0X8122),
        QuadIntensity8Sgis = ((int)0X8123),
        DepthComponent16 = ((int)0X81a5),
        DepthComponent16Sgix = ((int)0X81a5),
        DepthComponent24 = ((int)0X81a6),
        DepthComponent24Sgix = ((int)0X81a6),
        DepthComponent32 = ((int)0X81a7),
        DepthComponent32Sgix = ((int)0X81a7),
        CompressedRed = ((int)0X8225),
        CompressedRg = ((int)0X8226),
        R8 = ((int)0X8229),
        R16 = ((int)0X822a),
        Rg8 = ((int)0X822b),
        Rg16 = ((int)0X822c),
        R16f = ((int)0X822D),
        R32f = ((int)0X822e),
        Rg16f = ((int)0X822f),
        Rg32f = ((int)0X8230),
        R8i = ((int)0X8231),
        R8ui = ((int)0X8232),
        R16i = ((int)0X8233),
        R16ui = ((int)0X8234),
        R32i = ((int)0X8235),
        R32ui = ((int)0X8236),
        Rg8i = ((int)0X8237),
        Rg8ui = ((int)0X8238),
        Rg16i = ((int)0X8239),
        Rg16ui = ((int)0X823a),
        Rg32i = ((int)0X823b),
        Rg32ui = ((int)0X823c),
        CompressedAlpha = ((int)0X84e9),
        CompressedLuminance = ((int)0X84ea),
        CompressedLuminanceAlpha = ((int)0X84eb),
        CompressedIntensity = ((int)0X84ec),
        CompressedRgb = ((int)0X84ed),
        CompressedRgba = ((int)0X84ee),
        DepthStencil = ((int)0X84f9),
        Rgba32f = ((int)0X8814),
        Rgb32f = ((int)0X8815),
        Rgba16f = ((int)0X881a),
        Rgb16f = ((int)0X881b),
        Depth24Stencil8 = ((int)0X88f0),
        R11fG11fB10f = ((int)0X8c3a),
        Rgb9E5 = ((int)0X8c3d),
        Srgb = ((int)0X8c40),
        Srgb8 = ((int)0X8c41),
        SrgbAlpha = ((int)0X8c42),
        Srgb8Alpha8 = ((int)0X8c43),
        SluminanceAlpha = ((int)0X8c44),
        Sluminance8Alpha8 = ((int)0X8c45),
        Sluminance = ((int)0X8c46),
        Sluminance8 = ((int)0X8c47),
        CompressedSrgb = ((int)0X8c48),
        CompressedSrgbAlpha = ((int)0X8c49),
        CompressedSluminance = ((int)0X8c4a),
        CompressedSluminanceAlpha = ((int)0X8c4b),
        CompressedSrgbS3tcDxt1Ext = ((int)0X8c4c),
        CompressedSrgbAlphaS3tcDxt1Ext = ((int)0X8c4d),
        CompressedSrgbAlphaS3tcDxt3Ext = ((int)0X8c4e),
        CompressedSrgbAlphaS3tcDxt5Ext = ((int)0X8c4f),
        DepthComponent32f = ((int)0X8cac),
        Depth32fStencil8 = ((int)0X8cad),
        Rgba32ui = ((int)0X8d70),
        Rgb32ui = ((int)0X8d71),
        Rgba16ui = ((int)0X8d76),
        Rgb16ui = ((int)0X8d77),
        Rgba8ui = ((int)0X8d7c),
        Rgb8ui = ((int)0X8d7d),
        Rgba32i = ((int)0X8d82),
        Rgb32i = ((int)0X8d83),
        Rgba16i = ((int)0X8d88),
        Rgb16i = ((int)0X8d89),
        Rgba8i = ((int)0X8d8e),
        Rgb8i = ((int)0X8d8f),
        Float32UnsignedInt248Rev = ((int)0X8Dad),
        CompressedRedRgtc1 = ((int)0X8Dbb),
        CompressedSignedRedRgtc1 = ((int)0X8Dbc),
        CompressedRgRgtc2 = ((int)0X8Dbd),
        CompressedSignedRgRgtc2 = ((int)0X8Dbe),
        One = ((int)1),
        Two = ((int)2),
        Three = ((int)3),
        Four = ((int)4),
    }

    public enum PixelMap
    {
        PixelMapIToI = ((int)0X0c70),
        PixelMapSToS = ((int)0X0c71),
        PixelMapIToR = ((int)0X0c72),
        PixelMapIToG = ((int)0X0c73),
        PixelMapIToB = ((int)0X0c74),
        PixelMapIToA = ((int)0X0c75),
        PixelMapRToR = ((int)0X0c76),
        PixelMapGToG = ((int)0X0c77),
        PixelMapBToB = ((int)0X0c78),
        PixelMapAToA = ((int)0X0c79),
    }

    public enum PixelStoreParameter
    {
        UnpackSwapBytes = ((int)0X0cf0),
        UnpackLsbFirst = ((int)0X0cf1),
        UnpackRowLength = ((int)0X0cf2),
        UnpackSkipRows = ((int)0X0cf3),
        UnpackSkipPixels = ((int)0X0cf4),
        UnpackAlignment = ((int)0X0cf5),
        PackSwapBytes = ((int)0X0D00),
        PackLsbFirst = ((int)0X0D01),
        PackRowLength = ((int)0X0D02),
        PackSkipRows = ((int)0X0D03),
        PackSkipPixels = ((int)0X0D04),
        PackAlignment = ((int)0X0D05),
        PackSkipImages = ((int)0X806b),
        PackSkipImagesExt = ((int)0X806b),
        PackImageHeight = ((int)0X806c),
        PackImageHeightExt = ((int)0X806c),
        UnpackSkipImages = ((int)0X806d),
        UnpackSkipImagesExt = ((int)0X806D),
        UnpackImageHeight = ((int)0X806e),
        UnpackImageHeightExt = ((int)0X806e),
        PackSkipVolumesSgis = ((int)0X8130),
        PackImageDepthSgis = ((int)0X8131),
        UnpackSkipVolumesSgis = ((int)0X8132),
        UnpackImageDepthSgis = ((int)0X8133),
        PixelTileWidthSgix = ((int)0X8140),
        PixelTileHeightSgix = ((int)0X8141),
        PixelTileGridWidthSgix = ((int)0X8142),
        PixelTileGridHeightSgix = ((int)0X8143),
        PixelTileGridDepthSgix = ((int)0X8144),
        PixelTileCacheSizeSgix = ((int)0X8145),
        PackResampleSgix = ((int)0X842c),
        UnpackResampleSgix = ((int)0X842D),
        PackSubsampleRateSgix = ((int)0X85a0),
        UnpackSubsampleRateSgix = ((int)0X85a1),
    }

    public enum PixelStoreResampleMode
    {
        ResampleReplicateSgix = ((int)0X842e),
        ResampleZeroFillSgix = ((int)0X842f),
        ResampleDecimateSgix = ((int)0X8430),
    }

    public enum PixelStoreSubsampleRate
    {
        PixelSubsample4444Sgix = ((int)0X85a2),
        PixelSubsample2424Sgix = ((int)0X85a3),
        PixelSubsample4242Sgix = ((int)0X85a4),
    }

    public enum PixelTexGenMode
    {
        None = ((int)0),
        Rgb = ((int)0X1907),
        Rgba = ((int)0X1908),
        Luminance = ((int)0X1909),
        LuminanceAlpha = ((int)0X190a),
        PixelTexGenAlphaReplaceSgix = ((int)0X8187),
        PixelTexGenAlphaNoReplaceSgix = ((int)0X8188),
        PixelTexGenAlphaLsSgix = ((int)0X8189),
        PixelTexGenAlphaMsSgix = ((int)0X818a),
    }

    public enum PixelTexGenParameterNameSgis
    {
        PixelFragmentRgbSourceSgis = ((int)0X8354),
        PixelFragmentAlphaSourceSgis = ((int)0X8355),
    }

    public enum PixelTransferParameter
    {
        MapColor = ((int)0X0D10),
        MapStencil = ((int)0X0D11),
        IndexShift = ((int)0X0D12),
        IndexOffset = ((int)0X0D13),
        RedScale = ((int)0X0D14),
        RedBias = ((int)0X0D15),
        GreenScale = ((int)0X0D18),
        GreenBias = ((int)0X0D19),
        BlueScale = ((int)0X0D1a),
        BlueBias = ((int)0X0D1b),
        AlphaScale = ((int)0X0D1c),
        AlphaBias = ((int)0X0D1D),
        DepthScale = ((int)0X0D1e),
        DepthBias = ((int)0X0D1f),
        PostConvolutionRedScaleExt = ((int)0X801c),
        PostConvolutionGreenScaleExt = ((int)0X801D),
        PostConvolutionBlueScaleExt = ((int)0X801e),
        PostConvolutionAlphaScaleExt = ((int)0X801f),
        PostConvolutionRedBiasExt = ((int)0X8020),
        PostConvolutionGreenBiasExt = ((int)0X8021),
        PostConvolutionBlueBiasExt = ((int)0X8022),
        PostConvolutionAlphaBiasExt = ((int)0X8023),
        PostColorMatrixRedScaleSgi = ((int)0X80b4),
        PostColorMatrixGreenScaleSgi = ((int)0X80b5),
        PostColorMatrixBlueScaleSgi = ((int)0X80b6),
        PostColorMatrixAlphaScaleSgi = ((int)0X80b7),
        PostColorMatrixRedBiasSgi = ((int)0X80b8),
        PostColorMatrixGreenBiasSgi = ((int)0X80b9),
        PostColorMatrixBlueBiasSgi = ((int)0X80ba),
        PostColorMatrixAlphaBiasSgi = ((int)0X80bb),
    }

    public enum PixelType
    {
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        HalfFloat = ((int)0X140b),
        Bitmap = ((int)0X1a00),
        UnsignedByte332 = ((int)0X8032),
        UnsignedByte332Ext = ((int)0X8032),
        UnsignedShort4444 = ((int)0X8033),
        UnsignedShort4444Ext = ((int)0X8033),
        UnsignedShort5551 = ((int)0X8034),
        UnsignedShort5551Ext = ((int)0X8034),
        UnsignedInt8888 = ((int)0X8035),
        UnsignedInt8888Ext = ((int)0X8035),
        UnsignedInt1010102 = ((int)0X8036),
        UnsignedInt1010102Ext = ((int)0X8036),
        UnsignedByte233Reversed = ((int)0X8362),
        UnsignedShort565 = ((int)0X8363),
        UnsignedShort565Reversed = ((int)0X8364),
        UnsignedShort4444Reversed = ((int)0X8365),
        UnsignedShort1555Reversed = ((int)0X8366),
        UnsignedInt8888Reversed = ((int)0X8367),
        UnsignedInt2101010Reversed = ((int)0X8368),
        UnsignedInt248 = ((int)0X84fa),
        UnsignedInt10F11F11FRev = ((int)0X8c3b),
        UnsignedInt5999Rev = ((int)0X8c3e),
        Float32UnsignedInt248Rev = ((int)0X8Dad),
    }

    public enum PointParameterName
    {
        PointSizeMin = ((int)0X8126),
        PointSizeMax = ((int)0X8127),
        PointFadeThresholdSize = ((int)0X8128),
        PointDistanceAttenuation = ((int)0X8129),
        PointSpriteCoordOrigin = ((int)0X8ca0),
    }

    public enum PointParameterNameSgis
    {
        PointSizeMinSgis = ((int)0X8126),
        PointSizeMaxSgis = ((int)0X8127),
        PointFadeThresholdSizeSgis = ((int)0X8128),
        DistanceAttenuationSgis = ((int)0X8129),
    }

    public enum PointSpriteCoordOriginParameter
    {
        LowerLeft = ((int)0X8ca1),
        UpperLeft = ((int)0X8ca2),
    }

    public enum PolygonMode
    {
        Point = ((int)0X1b00),
        Line = ((int)0X1b01),
        Fill = ((int)0X1b02),
    }

    public enum ProgramParameter
    {
        ActiveUniformBlockMaxNameLength = ((int)0X8a35),
        ActiveUniformBlocks = ((int)0X8a36),
        DeleteStatus = ((int)0X8b80),
        LinkStatus = ((int)0X8b82),
        ValidateStatus = ((int)0X8b83),
        InfoLogLength = ((int)0X8b84),
        AttachedShaders = ((int)0X8b85),
        ActiveUniforms = ((int)0X8b86),
        ActiveUniformMaxLength = ((int)0X8b87),
        ActiveAttributes = ((int)0X8b89),
        ActiveAttributeMaxLength = ((int)0X8b8a),
        TransformFeedbackVaryingMaxLength = ((int)0X8c76),
        TransformFeedbackBufferMode = ((int)0X8c7f),
        TransformFeedbackVaryings = ((int)0X8c83),
    }

    public enum QueryTarget
    {
        SamplesPassed = ((int)0X8914),
        PrimitivesGenerated = ((int)0X8c87),
        TransformFeedbackPrimitivesWritten = ((int)0X8c88),
    }

    public enum ReadBufferMode
    {
        FrontLeft = ((int)0X0400),
        FrontRight = ((int)0X0401),
        BackLeft = ((int)0X0402),
        BackRight = ((int)0X0403),
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        Left = ((int)0X0406),
        Right = ((int)0X0407),
        Aux0 = ((int)0X0409),
        Aux1 = ((int)0X040a),
        Aux2 = ((int)0X040b),
        Aux3 = ((int)0X040c),
    }

    public enum RenderbufferParameterName
    {
        RenderbufferSamples = ((int)0X8cab),
        RenderbufferWidthExt = ((int)0X8d42),
        RenderbufferWidth = ((int)0X8D42),
        RenderbufferHeightExt = ((int)0X8d43),
        RenderbufferHeight = ((int)0X8D43),
        RenderbufferInternalFormatExt = ((int)0X8d44),
        RenderbufferInternalFormat = ((int)0X8D44),
        RenderbufferRedSizeExt = ((int)0X8d50),
        RenderbufferRedSize = ((int)0X8D50),
        RenderbufferGreenSizeExt = ((int)0X8d51),
        RenderbufferGreenSize = ((int)0X8D51),
        RenderbufferBlueSizeExt = ((int)0X8d52),
        RenderbufferBlueSize = ((int)0X8D52),
        RenderbufferAlphaSizeExt = ((int)0X8d53),
        RenderbufferAlphaSize = ((int)0X8D53),
        RenderbufferDepthSizeExt = ((int)0X8d54),
        RenderbufferDepthSize = ((int)0X8D54),
        RenderbufferStencilSizeExt = ((int)0X8d55),
        RenderbufferStencilSize = ((int)0X8D55),
    }

    public enum RenderbufferStorage
    {
        R3G3B2 = ((int)0X2a10),
        Alpha4 = ((int)0X803b),
        Alpha8 = ((int)0X803c),
        Alpha12 = ((int)0X803D),
        Alpha16 = ((int)0X803e),
        Rgb4 = ((int)0X804f),
        Rgb5 = ((int)0X8050),
        Rgb8 = ((int)0X8051),
        Rgb10 = ((int)0X8052),
        Rgb12 = ((int)0X8053),
        Rgb16 = ((int)0X8054),
        Rgba2 = ((int)0X8055),
        Rgba4 = ((int)0X8056),
        Rgba8 = ((int)0X8058),
        Rgb10A2 = ((int)0X8059),
        Rgba12 = ((int)0X805a),
        Rgba16 = ((int)0X805b),
        DepthComponent16 = ((int)0X81a5),
        DepthComponent24 = ((int)0X81a6),
        DepthComponent32 = ((int)0X81a7),
        R8 = ((int)0X8229),
        R16 = ((int)0X822a),
        Rg8 = ((int)0X822b),
        Rg16 = ((int)0X822c),
        R16f = ((int)0X822d),
        R32f = ((int)0X822e),
        Rg16f = ((int)0X822f),
        Rg32f = ((int)0X8230),
        R8i = ((int)0X8231),
        R8ui = ((int)0X8232),
        R16i = ((int)0X8233),
        R16ui = ((int)0X8234),
        R32i = ((int)0X8235),
        R32ui = ((int)0X8236),
        Rg8i = ((int)0X8237),
        Rg8ui = ((int)0X8238),
        Rg16i = ((int)0X8239),
        Rg16ui = ((int)0X823a),
        Rg32i = ((int)0X823b),
        Rg32ui = ((int)0X823c),
        Rgba32f = ((int)0X8814),
        Rgb32f = ((int)0X8815),
        Rgba16f = ((int)0X881a),
        Rgb16f = ((int)0X881b),
        Depth24Stencil8 = ((int)0X88f0),
        R11fG11fB10f = ((int)0X8c3a),
        Rgb9E5 = ((int)0X8c3D),
        Srgb8 = ((int)0X8c41),
        Srgb8Alpha8 = ((int)0X8c43),
        DepthComponent32f = ((int)0X8cac),
        Depth32fStencil8 = ((int)0X8cad),
        StencilIndex1Ext = ((int)0X8d46),
        StencilIndex1 = ((int)0X8D46),
        StencilIndex4Ext = ((int)0X8d47),
        StencilIndex4 = ((int)0X8D47),
        StencilIndex8Ext = ((int)0X8d48),
        StencilIndex8 = ((int)0X8D48),
        StencilIndex16Ext = ((int)0X8d49),
        StencilIndex16 = ((int)0X8D49),
        Rgba32ui = ((int)0X8D70),
        Rgb32ui = ((int)0X8D71),
        Rgba16ui = ((int)0X8D76),
        Rgb16ui = ((int)0X8D77),
        Rgba8ui = ((int)0X8D7c),
        Rgb8ui = ((int)0X8D7D),
        Rgba32i = ((int)0X8D82),
        Rgb32i = ((int)0X8D83),
        Rgba16i = ((int)0X8D88),
        Rgb16i = ((int)0X8D89),
        Rgba8i = ((int)0X8D8e),
        Rgb8i = ((int)0X8D8f),
    }

    public enum RenderbufferTarget
    {
        RenderbufferExt = ((int)0X8d41),
        Renderbuffer = ((int)0X8D41),
    }

    public enum RenderingMode
    {
        Render = ((int)0X1c00),
        Feedback = ((int)0X1c01),
        Select = ((int)0X1c02),
    }

    public enum RendScreenCoordinates
    {
        ScreenCoordinatesRend = ((int)0X8490),
        InvertedScreenWRend = ((int)0X8491),
    }

    public enum S3S3tc
    {
        RgbS3tc = ((int)0X83a0),
        Rgb4S3tc = ((int)0X83a1),
        RgbaS3tc = ((int)0X83a2),
        Rgba4S3tc = ((int)0X83a3),
    }

    public enum SamplePatternSgis
    {
        Gl1PassSgis = ((int)0X80a1),
        Gl2Pass0Sgis = ((int)0X80a2),
        Gl2Pass1Sgis = ((int)0X80a3),
        Gl4Pass0Sgis = ((int)0X80a4),
        Gl4Pass1Sgis = ((int)0X80a5),
        Gl4Pass2Sgis = ((int)0X80a6),
        Gl4Pass3Sgis = ((int)0X80a7),
    }

    public enum SeparableTargetExt
    {
        Separable2DExt = ((int)0X8012),
    }

    public enum SgiColorMatrix
    {
        ColorMatrixSgi = ((int)0X80b1),
        ColorMatrixStackDepthSgi = ((int)0X80b2),
        MaxColorMatrixStackDepthSgi = ((int)0X80b3),
        PostColorMatrixRedScaleSgi = ((int)0X80b4),
        PostColorMatrixGreenScaleSgi = ((int)0X80b5),
        PostColorMatrixBlueScaleSgi = ((int)0X80b6),
        PostColorMatrixAlphaScaleSgi = ((int)0X80b7),
        PostColorMatrixRedBiasSgi = ((int)0X80b8),
        PostColorMatrixGreenBiasSgi = ((int)0X80b9),
        PostColorMatrixBlueBiasSgi = ((int)0X80ba),
        PostColorMatrixAlphaBiasSgi = ((int)0X80bb),
    }

    public enum SgiColorTable
    {
        ColorTableSgi = ((int)0X80d0),
        PostConvolutionColorTableSgi = ((int)0X80d1),
        PostColorMatrixColorTableSgi = ((int)0X80d2),
        ProxyColorTableSgi = ((int)0X80d3),
        ProxyPostConvolutionColorTableSgi = ((int)0X80d4),
        ProxyPostColorMatrixColorTableSgi = ((int)0X80d5),
        ColorTableScaleSgi = ((int)0X80d6),
        ColorTableBiasSgi = ((int)0X80d7),
        ColorTableFormatSgi = ((int)0X80d8),
        ColorTableWidthSgi = ((int)0X80d9),
        ColorTableRedSizeSgi = ((int)0X80da),
        ColorTableGreenSizeSgi = ((int)0X80db),
        ColorTableBlueSizeSgi = ((int)0X80dc),
        ColorTableAlphaSizeSgi = ((int)0X80dd),
        ColorTableLuminanceSizeSgi = ((int)0X80de),
        ColorTableIntensitySizeSgi = ((int)0X80df),
    }

    public enum SgiDepthPassInstrument
    {
        DepthPassInstrumentSgix = ((int)0X8310),
        DepthPassInstrumentCountersSgix = ((int)0X8311),
        DepthPassInstrumentMaxSgix = ((int)0X8312),
    }

    public enum SgisDetailTexture
    {
        DetailTexture2DSgis = ((int)0X8095),
        DetailTexture2DBindingSgis = ((int)0X8096),
        LinearDetailSgis = ((int)0X8097),
        LinearDetailAlphaSgis = ((int)0X8098),
        LinearDetailColorSgis = ((int)0X8099),
        DetailTextureLevelSgis = ((int)0X809a),
        DetailTextureModeSgis = ((int)0X809b),
        DetailTextureFuncPointsSgis = ((int)0X809c),
    }

    public enum SgisFogFunction
    {
        FogFuncSgis = ((int)0X812a),
        FogFuncPointsSgis = ((int)0X812b),
        MaxFogFuncPointsSgis = ((int)0X812c),
    }

    public enum SgisGenerateMipmap
    {
        GenerateMipmapSgis = ((int)0X8191),
        GenerateMipmapHintSgis = ((int)0X8192),
        GeometryDeformationSgix = ((int)0X8194),
        TextureDeformationSgix = ((int)0X8195),
        DeformationsMaskSgix = ((int)0X8196),
        MaxDeformationOrderSgix = ((int)0X8197),
    }

    public enum SgisMultisample
    {
        MultisampleSgis = ((int)0X809d),
        SampleAlphaToMaskSgis = ((int)0X809e),
        SampleAlphaToOneSgis = ((int)0X809f),
        SampleMaskSgis = ((int)0X80a0),
        Gl1PassSgis = ((int)0X80a1),
        Gl2Pass0Sgis = ((int)0X80a2),
        Gl2Pass1Sgis = ((int)0X80a3),
        Gl4Pass0Sgis = ((int)0X80a4),
        Gl4Pass1Sgis = ((int)0X80a5),
        Gl4Pass2Sgis = ((int)0X80a6),
        Gl4Pass3Sgis = ((int)0X80a7),
        SampleBuffersSgis = ((int)0X80a8),
        SamplesSgis = ((int)0X80a9),
        SampleMaskValueSgis = ((int)0X80aa),
        SampleMaskInvertSgis = ((int)0X80ab),
        SamplePatternSgis = ((int)0X80ac),
    }

    public enum SgisPixelTexture
    {
        PixelTextureSgis = ((int)0X8353),
        PixelFragmentRgbSourceSgis = ((int)0X8354),
        PixelFragmentAlphaSourceSgis = ((int)0X8355),
        PixelGroupColorSgis = ((int)0X8356),
    }

    public enum SgisPointLineTexgen
    {
        EyeDistanceToPointSgis = ((int)0X81f0),
        ObjectDistanceToPointSgis = ((int)0X81f1),
        EyeDistanceToLineSgis = ((int)0X81f2),
        ObjectDistanceToLineSgis = ((int)0X81f3),
        EyePointSgis = ((int)0X81f4),
        ObjectPointSgis = ((int)0X81f5),
        EyeLineSgis = ((int)0X81f6),
        ObjectLineSgis = ((int)0X81f7),
    }

    public enum SgisPointParameters
    {
        PointSizeMinSgis = ((int)0X8126),
        PointSizeMaxSgis = ((int)0X8127),
        PointFadeThresholdSizeSgis = ((int)0X8128),
        DistanceAttenuationSgis = ((int)0X8129),
    }

    public enum SgisSharpenTexture
    {
        LinearSharpenSgis = ((int)0X80ad),
        LinearSharpenAlphaSgis = ((int)0X80ae),
        LinearSharpenColorSgis = ((int)0X80af),
        SharpenTextureFuncPointsSgis = ((int)0X80b0),
    }

    public enum SgisTexture4D
    {
        PackSkipVolumesSgis = ((int)0X8130),
        PackImageDepthSgis = ((int)0X8131),
        UnpackSkipVolumesSgis = ((int)0X8132),
        UnpackImageDepthSgis = ((int)0X8133),
        Texture4DSgis = ((int)0X8134),
        ProxyTexture4DSgis = ((int)0X8135),
        Texture4DsizeSgis = ((int)0X8136),
        TextureWrapQSgis = ((int)0X8137),
        Max4DTextureSizeSgis = ((int)0X8138),
        Texture4DBindingSgis = ((int)0X814f),
    }

    public enum SgisTextureBorderClamp
    {
        ClampToBorderSgis = ((int)0X812d),
    }

    [Flags]
    public enum SgisTextureColorMask
    {
        TextureColorWritemaskSgis = ((int)0X81ef),
    }

    public enum SgisTextureEdgeClamp
    {
        ClampToEdgeSgis = ((int)0X812f),
    }

    public enum SgisTextureFilter4
    {
        Filter4Sgis = ((int)0X8146),
        TextureFilter4SizeSgis = ((int)0X8147),
    }

    public enum SgisTextureLod
    {
        TextureMinLodSgis = ((int)0X813a),
        TextureMaxLodSgis = ((int)0X813b),
        TextureBaseLevelSgis = ((int)0X813c),
        TextureMaxLevelSgis = ((int)0X813d),
    }

    public enum SgisTextureSelect
    {
        DualAlpha4Sgis = ((int)0X8110),
        DualAlpha8Sgis = ((int)0X8111),
        DualAlpha12Sgis = ((int)0X8112),
        DualAlpha16Sgis = ((int)0X8113),
        DualLuminance4Sgis = ((int)0X8114),
        DualLuminance8Sgis = ((int)0X8115),
        DualLuminance12Sgis = ((int)0X8116),
        DualLuminance16Sgis = ((int)0X8117),
        DualIntensity4Sgis = ((int)0X8118),
        DualIntensity8Sgis = ((int)0X8119),
        DualIntensity12Sgis = ((int)0X811a),
        DualIntensity16Sgis = ((int)0X811b),
        DualLuminanceAlpha4Sgis = ((int)0X811c),
        DualLuminanceAlpha8Sgis = ((int)0X811d),
        QuadAlpha4Sgis = ((int)0X811e),
        QuadAlpha8Sgis = ((int)0X811f),
        QuadLuminance4Sgis = ((int)0X8120),
        QuadLuminance8Sgis = ((int)0X8121),
        QuadIntensity4Sgis = ((int)0X8122),
        QuadIntensity8Sgis = ((int)0X8123),
        DualTextureSelectSgis = ((int)0X8124),
        QuadTextureSelectSgis = ((int)0X8125),
    }

    public enum SgiTextureColorTable
    {
        TextureColorTableSgi = ((int)0X80bc),
        ProxyTextureColorTableSgi = ((int)0X80bd),
    }

    public enum SgixAsync
    {
        AsyncMarkerSgix = ((int)0X8329),
    }

    public enum SgixAsyncHistogram
    {
        AsyncHistogramSgix = ((int)0X832c),
        MaxAsyncHistogramSgix = ((int)0X832d),
    }

    public enum SgixAsyncPixel
    {
        AsyncTexImageSgix = ((int)0X835c),
        AsyncDrawPixelsSgix = ((int)0X835d),
        AsyncReadPixelsSgix = ((int)0X835e),
        MaxAsyncTexImageSgix = ((int)0X835f),
        MaxAsyncDrawPixelsSgix = ((int)0X8360),
        MaxAsyncReadPixelsSgix = ((int)0X8361),
    }

    public enum SgixBlendAlphaMinmax
    {
        AlphaMinSgix = ((int)0X8320),
        AlphaMaxSgix = ((int)0X8321),
        AsyncMarkerSgix = ((int)0X8329),
    }

    public enum SgixCalligraphicFragment
    {
        CalligraphicFragmentSgix = ((int)0X8183),
    }

    public enum SgixClipmap
    {
        LinearClipmapLinearSgix = ((int)0X8170),
        TextureClipmapCenterSgix = ((int)0X8171),
        TextureClipmapFrameSgix = ((int)0X8172),
        TextureClipmapOffsetSgix = ((int)0X8173),
        TextureClipmapVirtualDepthSgix = ((int)0X8174),
        TextureClipmapLodOffsetSgix = ((int)0X8175),
        TextureClipmapDepthSgix = ((int)0X8176),
        MaxClipmapDepthSgix = ((int)0X8177),
        MaxClipmapVirtualDepthSgix = ((int)0X8178),
        NearestClipmapNearestSgix = ((int)0X844d),
        NearestClipmapLinearSgix = ((int)0X844e),
        LinearClipmapNearestSgix = ((int)0X844f),
    }

    public enum SgixConvolutionAccuracy
    {
        ConvolutionHintSgix = ((int)0X8316),
    }

    public enum SgixDepthTexture
    {
        DepthComponent16Sgix = ((int)0X81a5),
        DepthComponent24Sgix = ((int)0X81a6),
        DepthComponent32Sgix = ((int)0X81a7),
    }

    public enum SgixFlushRaster
    {
    }

    public enum SgixFogOffset
    {
        FogOffsetSgix = ((int)0X8198),
        FogOffsetValueSgix = ((int)0X8199),
    }

    public enum SgixFogScale
    {
        FogScaleSgix = ((int)0X81fc),
        FogScaleValueSgix = ((int)0X81fd),
    }

    public enum SgixFragmentLighting
    {
        FragmentLightingSgix = ((int)0X8400),
        FragmentColorMaterialSgix = ((int)0X8401),
        FragmentColorMaterialFaceSgix = ((int)0X8402),
        FragmentColorMaterialParameterSgix = ((int)0X8403),
        MaxFragmentLightsSgix = ((int)0X8404),
        MaxActiveLightsSgix = ((int)0X8405),
        CurrentRasterNormalSgix = ((int)0X8406),
        LightEnvModeSgix = ((int)0X8407),
        FragmentLightModelLocalViewerSgix = ((int)0X8408),
        FragmentLightModelTwoSideSgix = ((int)0X8409),
        FragmentLightModelAmbientSgix = ((int)0X840a),
        FragmentLightModelNormalInterpolationSgix = ((int)0X840b),
        FragmentLight0Sgix = ((int)0X840c),
        FragmentLight1Sgix = ((int)0X840d),
        FragmentLight2Sgix = ((int)0X840e),
        FragmentLight3Sgix = ((int)0X840f),
        FragmentLight4Sgix = ((int)0X8410),
        FragmentLight5Sgix = ((int)0X8411),
        FragmentLight6Sgix = ((int)0X8412),
        FragmentLight7Sgix = ((int)0X8413),
    }

    public enum SgixFramezoom
    {
        FramezoomSgix = ((int)0X818b),
        FramezoomFactorSgix = ((int)0X818c),
        MaxFramezoomFactorSgix = ((int)0X818d),
    }

    public enum SgixImpactPixelTexture
    {
        PixelTexGenQCeilingSgix = ((int)0X8184),
        PixelTexGenQRoundSgix = ((int)0X8185),
        PixelTexGenQFloorSgix = ((int)0X8186),
        PixelTexGenAlphaReplaceSgix = ((int)0X8187),
        PixelTexGenAlphaNoReplaceSgix = ((int)0X8188),
        PixelTexGenAlphaLsSgix = ((int)0X8189),
        PixelTexGenAlphaMsSgix = ((int)0X818a),
    }

    public enum SgixInstruments
    {
        InstrumentBufferPointerSgix = ((int)0X8180),
        InstrumentMeasurementsSgix = ((int)0X8181),
    }

    public enum SgixInterlace
    {
        InterlaceSgix = ((int)0X8094),
    }

    public enum SgixIrInstrument1
    {
        IrInstrument1Sgix = ((int)0X817f),
    }

    public enum SgixListPriority
    {
        ListPrioritySgix = ((int)0X8182),
    }

    public enum SgixPixelTexture
    {
        PixelTexGenSgix = ((int)0X8139),
        PixelTexGenModeSgix = ((int)0X832b),
    }

    public enum SgixPixelTiles
    {
        PixelTileBestAlignmentSgix = ((int)0X813e),
        PixelTileCacheIncrementSgix = ((int)0X813f),
        PixelTileWidthSgix = ((int)0X8140),
        PixelTileHeightSgix = ((int)0X8141),
        PixelTileGridWidthSgix = ((int)0X8142),
        PixelTileGridHeightSgix = ((int)0X8143),
        PixelTileGridDepthSgix = ((int)0X8144),
        PixelTileCacheSizeSgix = ((int)0X8145),
    }

    public enum SgixPolynomialFfd
    {
        GeometryDeformationSgix = ((int)0X8194),
        TextureDeformationSgix = ((int)0X8195),
        DeformationsMaskSgix = ((int)0X8196),
        MaxDeformationOrderSgix = ((int)0X8197),
    }

    public enum SgixReferencePlane
    {
        ReferencePlaneSgix = ((int)0X817d),
        ReferencePlaneEquationSgix = ((int)0X817e),
    }

    public enum SgixResample
    {
        PackResampleSgix = ((int)0X842c),
        UnpackResampleSgix = ((int)0X842d),
        ResampleReplicateSgix = ((int)0X842e),
        ResampleZeroFillSgix = ((int)0X842f),
        ResampleDecimateSgix = ((int)0X8430),
    }

    public enum SgixScalebiasHint
    {
        ScalebiasHintSgix = ((int)0X8322),
    }

    public enum SgixShadow
    {
        TextureCompareSgix = ((int)0X819a),
        TextureCompareOperatorSgix = ((int)0X819b),
        TextureLequalRSgix = ((int)0X819c),
        TextureGequalRSgix = ((int)0X819d),
    }

    public enum SgixShadowAmbient
    {
        ShadowAmbientSgix = ((int)0X80bf),
    }

    public enum SgixSprite
    {
        SpriteSgix = ((int)0X8148),
        SpriteModeSgix = ((int)0X8149),
        SpriteAxisSgix = ((int)0X814a),
        SpriteTranslationSgix = ((int)0X814b),
        SpriteAxialSgix = ((int)0X814c),
        SpriteObjectAlignedSgix = ((int)0X814d),
        SpriteEyeAlignedSgix = ((int)0X814e),
    }

    public enum SgixSubsample
    {
        PackSubsampleRateSgix = ((int)0X85a0),
        UnpackSubsampleRateSgix = ((int)0X85a1),
        PixelSubsample4444Sgix = ((int)0X85a2),
        PixelSubsample2424Sgix = ((int)0X85a3),
        PixelSubsample4242Sgix = ((int)0X85a4),
    }

    public enum SgixTagSampleBuffer
    {
    }

    public enum SgixTextureAddEnv
    {
        TextureEnvBiasSgix = ((int)0X80be),
    }

    public enum SgixTextureCoordinateClamp
    {
        TextureMaxClampSSgix = ((int)0X8369),
        TextureMaxClampTSgix = ((int)0X836a),
        TextureMaxClampRSgix = ((int)0X836b),
        FogFactorToAlphaSgix = ((int)0X836f),
    }

    public enum SgixTextureLodBias
    {
        TextureLodBiasSSgix = ((int)0X818e),
        TextureLodBiasTSgix = ((int)0X818f),
        TextureLodBiasRSgix = ((int)0X8190),
    }

    public enum SgixTextureMultiBuffer
    {
        TextureMultiBufferHintSgix = ((int)0X812e),
    }

    public enum SgixTextureScaleBias
    {
        PostTextureFilterBiasSgix = ((int)0X8179),
        PostTextureFilterScaleSgix = ((int)0X817a),
        PostTextureFilterBiasRangeSgix = ((int)0X817b),
        PostTextureFilterScaleRangeSgix = ((int)0X817c),
    }

    public enum SgixVertexPreclip
    {
        VertexPreclipSgix = ((int)0X83ee),
        VertexPreclipHintSgix = ((int)0X83ef),
    }

    public enum SgixYcrcb
    {
        Ycrcb422Sgix = ((int)0X81bb),
        Ycrcb444Sgix = ((int)0X81bc),
    }

    public enum SgixYcrcba
    {
        YcrcbSgix = ((int)0X8318),
        YcrcbaSgix = ((int)0X8319),
    }

    public enum SgixYcrcbSubsample
    {
        PackSubsampleRateSgix = ((int)0X85a0),
        UnpackSubsampleRateSgix = ((int)0X85a1),
        PixelSubsample4444Sgix = ((int)0X85a2),
        PixelSubsample2424Sgix = ((int)0X85a3),
        PixelSubsample4242Sgix = ((int)0X85a4),
    }

    public enum ShaderParameter
    {
        ShaderType = ((int)0X8b4f),
        DeleteStatus = ((int)0X8b80),
        CompileStatus = ((int)0X8b81),
        InfoLogLength = ((int)0X8b84),
        ShaderSourceLength = ((int)0X8b88),
    }

    public enum ShaderType
    {
        FragmentShader = ((int)0X8b30),
        VertexShader = ((int)0X8b31),
        GeometryShaderExt = ((int)0X8dd9),
    }

    public enum ShadingModel
    {
        Flat = ((int)0X1d00),
        Smooth = ((int)0X1d01),
    }

    public enum SizedInternalFormat
    {
        Rgba8 = ((int)0X8058),
        Rgba16 = ((int)0X805b),
        R8 = ((int)0X8229),
        R16 = ((int)0X822a),
        Rg8 = ((int)0X822b),
        Rg16 = ((int)0X822c),
        R16f = ((int)0X822d),
        R32f = ((int)0X822e),
        Rg16f = ((int)0X822f),
        Rg32f = ((int)0X8230),
        R8i = ((int)0X8231),
        R8ui = ((int)0X8232),
        R16i = ((int)0X8233),
        R16ui = ((int)0X8234),
        R32i = ((int)0X8235),
        R32ui = ((int)0X8236),
        Rg8i = ((int)0X8237),
        Rg8ui = ((int)0X8238),
        Rg16i = ((int)0X8239),
        Rg16ui = ((int)0X823a),
        Rg32i = ((int)0X823b),
        Rg32ui = ((int)0X823c),
        Rgba32f = ((int)0X8814),
        Rgba16f = ((int)0X881a),
        Rgba32ui = ((int)0X8D70),
        Rgba16ui = ((int)0X8D76),
        Rgba8ui = ((int)0X8D7c),
        Rgba32i = ((int)0X8D82),
        Rgba16i = ((int)0X8D88),
        Rgba8i = ((int)0X8D8e),
    }

    public enum StencilFace
    {
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        FrontAndBack = ((int)0X0408),
    }

    public enum StencilFunction
    {
        Never = ((int)0X0200),
        Less = ((int)0X0201),
        Equal = ((int)0X0202),
        Lequal = ((int)0X0203),
        Greater = ((int)0X0204),
        Notequal = ((int)0X0205),
        Gequal = ((int)0X0206),
        Always = ((int)0X0207),
    }

    public enum StencilOp
    {
        Zero = ((int)0),
        Invert = ((int)0X150a),
        Keep = ((int)0X1e00),
        Replace = ((int)0X1e01),
        Incr = ((int)0X1e02),
        Decr = ((int)0X1e03),
        IncrWrap = ((int)0X8507),
        DecrWrap = ((int)0X8508),
    }

    public enum StringName
    {
        Vendor = ((int)0X1f00),
        Renderer = ((int)0X1f01),
        Version = ((int)0X1f02),
        Extensions = ((int)0X1f03),
        ShadingLanguageVersion = ((int)0X8b8c),
    }

    public enum SunConvolutionBorderModes
    {
        WrapBorderSun = ((int)0X81d4),
    }

    public enum SunGlobalAlpha
    {
        GlobalAlphaSun = ((int)0X81d9),
        GlobalAlphaFactorSun = ((int)0X81da),
    }

    public enum SunMeshArray
    {
        QuadMeshSun = ((int)0X8614),
        TriangleMeshSun = ((int)0X8615),
    }

    public enum SunSliceAccum
    {
        SliceAccumSun = ((int)0X85cc),
    }

    public enum SunTriangleList
    {
        RestartSun = ((int)0X0001),
        ReplaceMiddleSun = ((int)0X0002),
        ReplaceOldestSun = ((int)0X0003),
        TriangleListSun = ((int)0X81d7),
        ReplacementCodeSun = ((int)0X81d8),
        ReplacementCodeArraySun = ((int)0X85c0),
        ReplacementCodeArrayTypeSun = ((int)0X85c1),
        ReplacementCodeArrayStrideSun = ((int)0X85c2),
        ReplacementCodeArrayPointerSun = ((int)0X85c3),
        R1uiV3fSun = ((int)0X85c4),
        R1uiC4ubV3fSun = ((int)0X85c5),
        R1uiC3fV3fSun = ((int)0X85c6),
        R1uiN3fV3fSun = ((int)0X85c7),
        R1uiC4fN3fV3fSun = ((int)0X85c8),
        R1uiT2fV3fSun = ((int)0X85c9),
        R1uiT2fN3fV3fSun = ((int)0X85ca),
        R1uiT2fC4fN3fV3fSun = ((int)0X85cb),
    }

    public enum SunVertex
    {
    }

    public enum SunxConstantData
    {
        UnpackConstantDataSunx = ((int)0X81d5),
        TextureConstantDataSunx = ((int)0X81d6),
    }

    public enum TexCoordPointerType
    {
        Short = ((int)0X1402),
        Int = ((int)0X1404),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
        HalfFloat = ((int)0X140b),
    }

    public enum TextureBufferTarget
    {
        TextureBuffer = ((int)0X8c2a),
    }

    public enum TextureCompareMode
    {
        CompareRefToTexture = ((int)0X884e),
        CompareRToTexture = ((int)0X884e),
    }

    public enum TextureCoordName
    {
        S = ((int)0X2000),
        T = ((int)0X2001),
        R = ((int)0X2002),
        Q = ((int)0X2003),
    }

    public enum TextureEnvMode
    {
        Add = ((int)0X0104),
        Blend = ((int)0X0be2),
        Replace = ((int)0X1e01),
        Modulate = ((int)0X2100),
        Decal = ((int)0X2101),
        ReplaceExt = ((int)0X8062),
        TextureEnvBiasSgix = ((int)0X80be),
        Combine = ((int)0X8570),
    }

    public enum TextureEnvModeCombine
    {
        Add = ((int)0X0104),
        Replace = ((int)0X1e01),
        Modulate = ((int)0X2100),
        Subtract = ((int)0X84e7),
        AddSigned = ((int)0X8574),
        Interpolate = ((int)0X8575),
        Dot3Rgb = ((int)0X86ae),
        Dot3Rgba = ((int)0X86af),
    }

    public enum TextureEnvModeOperandAlpha
    {
        SrcAlpha = ((int)0X0302),
        OneMinusSrcAlpha = ((int)0X0303),
    }

    public enum TextureEnvModeOperandRgb
    {
        SrcColor = ((int)0X0300),
        OneMinusSrcColor = ((int)0X0301),
        SrcAlpha = ((int)0X0302),
        OneMinusSrcAlpha = ((int)0X0303),
    }

    public enum TextureEnvModePointSprite
    {
        False = ((int)0),
        True = ((int)1),
    }

    public enum TextureEnvModeScale
    {
        One = ((int)1),
        Two = ((int)2),
        Four = ((int)4),
    }

    public enum TextureEnvModeSource
    {
        Texture = ((int)0X1702),
        Texture0 = ((int)0X84c0),
        Texture1 = ((int)0X84c1),
        Texture2 = ((int)0X84c2),
        Texture3 = ((int)0X84c3),
        Texture4 = ((int)0X84c4),
        Texture5 = ((int)0X84c5),
        Texture6 = ((int)0X84c6),
        Texture7 = ((int)0X84c7),
        Texture8 = ((int)0X84c8),
        Texture9 = ((int)0X84c9),
        Texture10 = ((int)0X84ca),
        Texture11 = ((int)0X84cb),
        Texture12 = ((int)0X84cc),
        Texture13 = ((int)0X84cd),
        Texture14 = ((int)0X84ce),
        Texture15 = ((int)0X84cf),
        Texture16 = ((int)0X84d0),
        Texture17 = ((int)0X84d1),
        Texture18 = ((int)0X84d2),
        Texture19 = ((int)0X84d3),
        Texture20 = ((int)0X84d4),
        Texture21 = ((int)0X84d5),
        Texture22 = ((int)0X84d6),
        Texture23 = ((int)0X84d7),
        Texture24 = ((int)0X84d8),
        Texture25 = ((int)0X84d9),
        Texture26 = ((int)0X84da),
        Texture27 = ((int)0X84db),
        Texture28 = ((int)0X84dc),
        Texture29 = ((int)0X84dd),
        Texture30 = ((int)0X84de),
        Texture31 = ((int)0X84df),
        Constant = ((int)0X8576),
        PrimaryColor = ((int)0X8577),
        Previous = ((int)0X8578),
    }

    public enum TextureEnvParameter
    {
        AlphaScale = ((int)0X0D1c),
        TextureEnvMode = ((int)0X2200),
        TextureEnvColor = ((int)0X2201),
        TextureLodBias = ((int)0X8501),
        CombineRgb = ((int)0X8571),
        CombineAlpha = ((int)0X8572),
        RgbScale = ((int)0X8573),
        Source0Rgb = ((int)0X8580),
        Src1Rgb = ((int)0X8581),
        Src2Rgb = ((int)0X8582),
        Src0Alpha = ((int)0X8588),
        Src1Alpha = ((int)0X8589),
        Src2Alpha = ((int)0X858a),
        Operand0Rgb = ((int)0X8590),
        Operand1Rgb = ((int)0X8591),
        Operand2Rgb = ((int)0X8592),
        Operand0Alpha = ((int)0X8598),
        Operand1Alpha = ((int)0X8599),
        Operand2Alpha = ((int)0X859a),
        CoordReplace = ((int)0X8862),
    }

    public enum TextureEnvTarget
    {
        TextureEnv = ((int)0X2300),
        TextureFilterControl = ((int)0X8500),
        PointSprite = ((int)0X8861),
    }

    public enum TextureFilterFuncSgis
    {
        Filter4Sgis = ((int)0X8146),
    }

    public enum TextureGenMode
    {
        EyeLinear = ((int)0X2400),
        ObjectLinear = ((int)0X2401),
        SphereMap = ((int)0X2402),
        EyeDistanceToPointSgis = ((int)0X81f0),
        ObjectDistanceToPointSgis = ((int)0X81f1),
        EyeDistanceToLineSgis = ((int)0X81f2),
        ObjectDistanceToLineSgis = ((int)0X81f3),
        NormalMap = ((int)0X8511),
        ReflectionMap = ((int)0X8512),
    }

    public enum TextureGenParameter
    {
        TextureGenMode = ((int)0X2500),
        ObjectPlane = ((int)0X2501),
        EyePlane = ((int)0X2502),
        EyePointSgis = ((int)0X81f4),
        ObjectPointSgis = ((int)0X81f5),
        EyeLineSgis = ((int)0X81f6),
        ObjectLineSgis = ((int)0X81f7),
    }

    public enum TextureMagFilter
    {
        Nearest = ((int)0X2600),
        Linear = ((int)0X2601),
        LinearDetailSgis = ((int)0X8097),
        LinearDetailAlphaSgis = ((int)0X8098),
        LinearDetailColorSgis = ((int)0X8099),
        LinearSharpenSgis = ((int)0X80ad),
        LinearSharpenAlphaSgis = ((int)0X80ae),
        LinearSharpenColorSgis = ((int)0X80af),
        Filter4Sgis = ((int)0X8146),
        PixelTexGenQCeilingSgix = ((int)0X8184),
        PixelTexGenQRoundSgix = ((int)0X8185),
        PixelTexGenQFloorSgix = ((int)0X8186),
    }

    public enum TextureMinFilter
    {
        Nearest = ((int)0X2600),
        Linear = ((int)0X2601),
        NearestMipmapNearest = ((int)0X2700),
        LinearMipmapNearest = ((int)0X2701),
        NearestMipmapLinear = ((int)0X2702),
        LinearMipmapLinear = ((int)0X2703),
        Filter4Sgis = ((int)0X8146),
        LinearClipmapLinearSgix = ((int)0X8170),
        PixelTexGenQCeilingSgix = ((int)0X8184),
        PixelTexGenQRoundSgix = ((int)0X8185),
        PixelTexGenQFloorSgix = ((int)0X8186),
        NearestClipmapNearestSgix = ((int)0X844D),
        NearestClipmapLinearSgix = ((int)0X844e),
        LinearClipmapNearestSgix = ((int)0X844f),
    }

    public enum TextureParameterName
    {
        TextureBorderColor = ((int)0X1004),
        Red = ((int)0X1903),
        TextureMagFilter = ((int)0X2800),
        TextureMinFilter = ((int)0X2801),
        TextureWrapS = ((int)0X2802),
        TextureWrapT = ((int)0X2803),
        TexturePriority = ((int)0X8066),
        TextureDepth = ((int)0X8071),
        TextureWrapR = ((int)0X8072),
        TextureWrapRExt = ((int)0X8072),
        DetailTextureLevelSgis = ((int)0X809a),
        DetailTextureModeSgis = ((int)0X809b),
        ShadowAmbientSgix = ((int)0X80bf),
        TextureCompareFailValue = ((int)0X80bf),
        DualTextureSelectSgis = ((int)0X8124),
        QuadTextureSelectSgis = ((int)0X8125),
        ClampToBorder = ((int)0X812d),
        ClampToEdge = ((int)0X812f),
        TextureWrapQSgis = ((int)0X8137),
        TextureMinLod = ((int)0X813a),
        TextureMaxLod = ((int)0X813b),
        TextureBaseLevel = ((int)0X813c),
        TextureMaxLevel = ((int)0X813D),
        TextureClipmapCenterSgix = ((int)0X8171),
        TextureClipmapFrameSgix = ((int)0X8172),
        TextureClipmapOffsetSgix = ((int)0X8173),
        TextureClipmapVirtualDepthSgix = ((int)0X8174),
        TextureClipmapLodOffsetSgix = ((int)0X8175),
        TextureClipmapDepthSgix = ((int)0X8176),
        PostTextureFilterBiasSgix = ((int)0X8179),
        PostTextureFilterScaleSgix = ((int)0X817a),
        TextureLodBiasSSgix = ((int)0X818e),
        TextureLodBiasTSgix = ((int)0X818f),
        TextureLodBiasRSgix = ((int)0X8190),
        GenerateMipmap = ((int)0X8191),
        GenerateMipmapSgis = ((int)0X8191),
        TextureCompareSgix = ((int)0X819a),
        TextureCompareOperatorSgix = ((int)0X819b),
        TextureMaxClampSSgix = ((int)0X8369),
        TextureMaxClampTSgix = ((int)0X836a),
        TextureMaxClampRSgix = ((int)0X836b),
        DepthTextureMode = ((int)0X884b),
        TextureCompareMode = ((int)0X884c),
        TextureCompareFunc = ((int)0X884d),
    }

    public enum TextureTarget
    {
        Texture1D = ((int)0X0De0),
        Texture2D = ((int)0X0De1),
        ProxyTexture1D = ((int)0X8063),
        ProxyTexture2D = ((int)0X8064),
        Texture3D = ((int)0X806f),
        ProxyTexture3D = ((int)0X8070),
        DetailTexture2DSgis = ((int)0X8095),
        Texture4DSgis = ((int)0X8134),
        ProxyTexture4DSgis = ((int)0X8135),
        TextureMinLod = ((int)0X813a),
        TextureMaxLod = ((int)0X813b),
        TextureBaseLevel = ((int)0X813c),
        TextureMaxLevel = ((int)0X813d),
        TextureRectangleArb = ((int)0X84f5),
        TextureRectangleNv = ((int)0X84f5),
        TextureCubeMap = ((int)0X8513),
        TextureBindingCubeMap = ((int)0X8514),
        TextureCubeMapPositiveX = ((int)0X8515),
        TextureCubeMapNegativeX = ((int)0X8516),
        TextureCubeMapPositiveY = ((int)0X8517),
        TextureCubeMapNegativeY = ((int)0X8518),
        TextureCubeMapPositiveZ = ((int)0X8519),
        TextureCubeMapNegativeZ = ((int)0X851a),
        ProxyTextureCubeMap = ((int)0X851b),
        Texture1DArray = ((int)0X8c18),
        ProxyTexture1DArray = ((int)0X8c19),
        Texture2DArray = ((int)0X8c1a),
        ProxyTexture2DArray = ((int)0X8c1b),
    }

    public enum TextureUnit
    {
        Texture0 = ((int)0X84c0),
        Texture1 = ((int)0X84c1),
        Texture2 = ((int)0X84c2),
        Texture3 = ((int)0X84c3),
        Texture4 = ((int)0X84c4),
        Texture5 = ((int)0X84c5),
        Texture6 = ((int)0X84c6),
        Texture7 = ((int)0X84c7),
        Texture8 = ((int)0X84c8),
        Texture9 = ((int)0X84c9),
        Texture10 = ((int)0X84ca),
        Texture11 = ((int)0X84cb),
        Texture12 = ((int)0X84cc),
        Texture13 = ((int)0X84cd),
        Texture14 = ((int)0X84ce),
        Texture15 = ((int)0X84cf),
        Texture16 = ((int)0X84d0),
        Texture17 = ((int)0X84d1),
        Texture18 = ((int)0X84d2),
        Texture19 = ((int)0X84d3),
        Texture20 = ((int)0X84d4),
        Texture21 = ((int)0X84d5),
        Texture22 = ((int)0X84d6),
        Texture23 = ((int)0X84d7),
        Texture24 = ((int)0X84d8),
        Texture25 = ((int)0X84d9),
        Texture26 = ((int)0X84da),
        Texture27 = ((int)0X84db),
        Texture28 = ((int)0X84dc),
        Texture29 = ((int)0X84dd),
        Texture30 = ((int)0X84de),
        Texture31 = ((int)0X84df),
    }

    public enum TextureWrapMode
    {
        Clamp = ((int)0X2900),
        Repeat = ((int)0X2901),
        ClampToBorder = ((int)0X812d),
        ClampToEdge = ((int)0X812f),
        MirroredRepeat = ((int)0X8370),
    }

    public enum TransformFeedbackMode
    {
        InterleavedAttribs = ((int)0X8c8c),
        SeparateAttribs = ((int)0X8c8d),
    }

    public enum Version11
    {
        False = ((int)0),
        NoError = ((int)0),
        None = ((int)0),
        Zero = ((int)0),
        Points = ((int)0X0000),
        DepthBufferBit = ((int)0X00000100),
        StencilBufferBit = ((int)0X00000400),
        ColorBufferBit = ((int)0X00004000),
        Lines = ((int)0X0001),
        LineLoop = ((int)0X0002),
        LineStrip = ((int)0X0003),
        Triangles = ((int)0X0004),
        TriangleStrip = ((int)0X0005),
        TriangleFan = ((int)0X0006),
        Never = ((int)0X0200),
        Less = ((int)0X0201),
        Equal = ((int)0X0202),
        Lequal = ((int)0X0203),
        Greater = ((int)0X0204),
        Notequal = ((int)0X0205),
        Gequal = ((int)0X0206),
        Always = ((int)0X0207),
        SrcColor = ((int)0X0300),
        OneMinusSrcColor = ((int)0X0301),
        SrcAlpha = ((int)0X0302),
        OneMinusSrcAlpha = ((int)0X0303),
        DstAlpha = ((int)0X0304),
        OneMinusDstAlpha = ((int)0X0305),
        DstColor = ((int)0X0306),
        OneMinusDstColor = ((int)0X0307),
        SrcAlphaSaturate = ((int)0X0308),
        FrontLeft = ((int)0X0400),
        FrontRight = ((int)0X0401),
        BackLeft = ((int)0X0402),
        BackRight = ((int)0X0403),
        Front = ((int)0X0404),
        Back = ((int)0X0405),
        Left = ((int)0X0406),
        Right = ((int)0X0407),
        FrontAndBack = ((int)0X0408),
        InvalidEnum = ((int)0X0500),
        InvalidValue = ((int)0X0501),
        InvalidOperation = ((int)0X0502),
        OutOfMemory = ((int)0X0505),
        Cw = ((int)0X0900),
        Ccw = ((int)0X0901),
        PointSize = ((int)0X0b11),
        PointSizeRange = ((int)0X0b12),
        PointSizeGranularity = ((int)0X0b13),
        LineSmooth = ((int)0X0b20),
        LineWidth = ((int)0X0b21),
        LineWidthRange = ((int)0X0b22),
        LineWidthGranularity = ((int)0X0b23),
        PolygonSmooth = ((int)0X0b41),
        CullFace = ((int)0X0b44),
        CullFaceMode = ((int)0X0b45),
        FrontFace = ((int)0X0b46),
        DepthRange = ((int)0X0b70),
        DepthTest = ((int)0X0b71),
        DepthWritemask = ((int)0X0b72),
        DepthClearValue = ((int)0X0b73),
        DepthFunc = ((int)0X0b74),
        StencilTest = ((int)0X0b90),
        StencilClearValue = ((int)0X0b91),
        StencilFunc = ((int)0X0b92),
        StencilValueMask = ((int)0X0b93),
        StencilFail = ((int)0X0b94),
        StencilPassDepthFail = ((int)0X0b95),
        StencilPassDepthPass = ((int)0X0b96),
        StencilRef = ((int)0X0b97),
        StencilWritemask = ((int)0X0b98),
        Viewport = ((int)0X0ba2),
        Dither = ((int)0X0bd0),
        BlendDst = ((int)0X0be0),
        BlendSrc = ((int)0X0be1),
        Blend = ((int)0X0be2),
        LogicOpMode = ((int)0X0bf0),
        ColorLogicOp = ((int)0X0bf2),
        DrawBuffer = ((int)0X0c01),
        ReadBuffer = ((int)0X0c02),
        ScissorBox = ((int)0X0c10),
        ScissorTest = ((int)0X0c11),
        ColorClearValue = ((int)0X0c22),
        ColorWritemask = ((int)0X0c23),
        Doublebuffer = ((int)0X0c32),
        Stereo = ((int)0X0c33),
        LineSmoothHint = ((int)0X0c52),
        PolygonSmoothHint = ((int)0X0c53),
        UnpackSwapBytes = ((int)0X0cf0),
        UnpackLsbFirst = ((int)0X0cf1),
        UnpackRowLength = ((int)0X0cf2),
        UnpackSkipRows = ((int)0X0cf3),
        UnpackSkipPixels = ((int)0X0cf4),
        UnpackAlignment = ((int)0X0cf5),
        PackSwapBytes = ((int)0X0d00),
        PackLsbFirst = ((int)0X0d01),
        PackRowLength = ((int)0X0d02),
        PackSkipRows = ((int)0X0d03),
        PackSkipPixels = ((int)0X0d04),
        PackAlignment = ((int)0X0d05),
        MaxTextureSize = ((int)0X0d33),
        MaxViewportDims = ((int)0X0d3a),
        SubpixelBits = ((int)0X0d50),
        Texture1D = ((int)0X0de0),
        Texture2D = ((int)0X0de1),
        TextureWidth = ((int)0X1000),
        TextureHeight = ((int)0X1001),
        TextureInternalFormat = ((int)0X1003),
        TextureBorderColor = ((int)0X1004),
        TextureBorder = ((int)0X1005),
        DontCare = ((int)0X1100),
        Fastest = ((int)0X1101),
        Nicest = ((int)0X1102),
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
        Clear = ((int)0X1500),
        And = ((int)0X1501),
        AndReverse = ((int)0X1502),
        Copy = ((int)0X1503),
        AndInverted = ((int)0X1504),
        Noop = ((int)0X1505),
        Xor = ((int)0X1506),
        Or = ((int)0X1507),
        Nor = ((int)0X1508),
        Equiv = ((int)0X1509),
        Invert = ((int)0X150a),
        OrReverse = ((int)0X150b),
        CopyInverted = ((int)0X150c),
        OrInverted = ((int)0X150d),
        Nand = ((int)0X150e),
        Set = ((int)0X150f),
        Texture = ((int)0X1702),
        Color = ((int)0X1800),
        Depth = ((int)0X1801),
        Stencil = ((int)0X1802),
        StencilIndex = ((int)0X1901),
        DepthComponent = ((int)0X1902),
        Red = ((int)0X1903),
        Green = ((int)0X1904),
        Blue = ((int)0X1905),
        Alpha = ((int)0X1906),
        Rgb = ((int)0X1907),
        Rgba = ((int)0X1908),
        Point = ((int)0X1b00),
        Line = ((int)0X1b01),
        Fill = ((int)0X1b02),
        Keep = ((int)0X1e00),
        Replace = ((int)0X1e01),
        Incr = ((int)0X1e02),
        Decr = ((int)0X1e03),
        Vendor = ((int)0X1f00),
        Renderer = ((int)0X1f01),
        Version = ((int)0X1f02),
        Extensions = ((int)0X1f03),
        Nearest = ((int)0X2600),
        Linear = ((int)0X2601),
        NearestMipmapNearest = ((int)0X2700),
        LinearMipmapNearest = ((int)0X2701),
        NearestMipmapLinear = ((int)0X2702),
        LinearMipmapLinear = ((int)0X2703),
        TextureMagFilter = ((int)0X2800),
        TextureMinFilter = ((int)0X2801),
        TextureWrapS = ((int)0X2802),
        TextureWrapT = ((int)0X2803),
        Repeat = ((int)0X2901),
        PolygonOffsetUnits = ((int)0X2a00),
        PolygonOffsetPoint = ((int)0X2a01),
        PolygonOffsetLine = ((int)0X2a02),
        R3G3B2 = ((int)0X2a10),
        PolygonOffsetFill = ((int)0X8037),
        PolygonOffsetFactor = ((int)0X8038),
        Rgb4 = ((int)0X804f),
        Rgb5 = ((int)0X8050),
        Rgb8 = ((int)0X8051),
        Rgb10 = ((int)0X8052),
        Rgb12 = ((int)0X8053),
        Rgb16 = ((int)0X8054),
        Rgba2 = ((int)0X8055),
        Rgba4 = ((int)0X8056),
        Rgb5A1 = ((int)0X8057),
        Rgba8 = ((int)0X8058),
        Rgb10A2 = ((int)0X8059),
        Rgba12 = ((int)0X805a),
        Rgba16 = ((int)0X805b),
        TextureRedSize = ((int)0X805c),
        TextureGreenSize = ((int)0X805d),
        TextureBlueSize = ((int)0X805e),
        TextureAlphaSize = ((int)0X805f),
        ProxyTexture1D = ((int)0X8063),
        ProxyTexture2D = ((int)0X8064),
        TextureBinding1D = ((int)0X8068),
        TextureBinding2D = ((int)0X8069),
        One = ((int)1),
        True = ((int)1),
    }

    public enum Version11Deprecated
    {
        ClientPixelStoreBit = ((int)0X00000001),
        CurrentBit = ((int)0X00000001),
        ClientVertexArrayBit = ((int)0X00000002),
        PointBit = ((int)0X00000002),
        LineBit = ((int)0X00000004),
        PolygonBit = ((int)0X00000008),
        PolygonStippleBit = ((int)0X00000010),
        PixelModeBit = ((int)0X00000020),
        LightingBit = ((int)0X00000040),
        FogBit = ((int)0X00000080),
        AccumBufferBit = ((int)0X00000200),
        ViewportBit = ((int)0X00000800),
        TransformBit = ((int)0X00001000),
        EnableBit = ((int)0X00002000),
        HintBit = ((int)0X00008000),
        EvalBit = ((int)0X00010000),
        ListBit = ((int)0X00020000),
        TextureBit = ((int)0X00040000),
        Quads = ((int)0X0007),
        QuadStrip = ((int)0X0008),
        ScissorBit = ((int)0X00080000),
        Polygon = ((int)0X0009),
        Accum = ((int)0X0100),
        Load = ((int)0X0101),
        Return = ((int)0X0102),
        Mult = ((int)0X0103),
        Add = ((int)0X0104),
        Aux0 = ((int)0X0409),
        Aux1 = ((int)0X040a),
        Aux2 = ((int)0X040b),
        Aux3 = ((int)0X040c),
        StackOverflow = ((int)0X0503),
        StackUnderflow = ((int)0X0504),
        Gl2D = ((int)0X0600),
        Gl3D = ((int)0X0601),
        Gl3DColor = ((int)0X0602),
        Gl3DColorTexture = ((int)0X0603),
        Gl4DColorTexture = ((int)0X0604),
        PassThroughToken = ((int)0X0700),
        PointToken = ((int)0X0701),
        LineToken = ((int)0X0702),
        PolygonToken = ((int)0X0703),
        BitmapToken = ((int)0X0704),
        DrawPixelToken = ((int)0X0705),
        CopyPixelToken = ((int)0X0706),
        LineResetToken = ((int)0X0707),
        Exp = ((int)0X0800),
        Exp2 = ((int)0X0801),
        Coeff = ((int)0X0a00),
        Order = ((int)0X0a01),
        Domain = ((int)0X0a02),
        CurrentColor = ((int)0X0b00),
        CurrentIndex = ((int)0X0b01),
        CurrentNormal = ((int)0X0b02),
        CurrentTextureCoords = ((int)0X0b03),
        CurrentRasterColor = ((int)0X0b04),
        CurrentRasterIndex = ((int)0X0b05),
        CurrentRasterTextureCoords = ((int)0X0b06),
        CurrentRasterPosition = ((int)0X0b07),
        CurrentRasterPositionValid = ((int)0X0b08),
        CurrentRasterDistance = ((int)0X0b09),
        PointSmooth = ((int)0X0b10),
        LineStipple = ((int)0X0b24),
        LineStipplePattern = ((int)0X0b25),
        LineStippleRepeat = ((int)0X0b26),
        ListMode = ((int)0X0b30),
        MaxListNesting = ((int)0X0b31),
        ListBase = ((int)0X0b32),
        ListIndex = ((int)0X0b33),
        PolygonMode = ((int)0X0b40),
        PolygonStipple = ((int)0X0b42),
        EdgeFlag = ((int)0X0b43),
        Lighting = ((int)0X0b50),
        LightModelLocalViewer = ((int)0X0b51),
        LightModelTwoSide = ((int)0X0b52),
        LightModelAmbient = ((int)0X0b53),
        ShadeModel = ((int)0X0b54),
        ColorMaterialFace = ((int)0X0b55),
        ColorMaterialParameter = ((int)0X0b56),
        ColorMaterial = ((int)0X0b57),
        Fog = ((int)0X0b60),
        FogIndex = ((int)0X0b61),
        FogDensity = ((int)0X0b62),
        FogStart = ((int)0X0b63),
        FogEnd = ((int)0X0b64),
        FogMode = ((int)0X0b65),
        FogColor = ((int)0X0b66),
        AccumClearValue = ((int)0X0b80),
        MatrixMode = ((int)0X0ba0),
        Normalize = ((int)0X0ba1),
        ModelviewStackDepth = ((int)0X0ba3),
        ProjectionStackDepth = ((int)0X0ba4),
        TextureStackDepth = ((int)0X0ba5),
        ModelviewMatrix = ((int)0X0ba6),
        ProjectionMatrix = ((int)0X0ba7),
        TextureMatrix = ((int)0X0ba8),
        AttribStackDepth = ((int)0X0bb0),
        ClientAttribStackDepth = ((int)0X0bb1),
        AlphaTest = ((int)0X0bc0),
        AlphaTestFunc = ((int)0X0bc1),
        AlphaTestRef = ((int)0X0bc2),
        IndexLogicOp = ((int)0X0bf1),
        LogicOp = ((int)0X0bf1),
        AuxBuffers = ((int)0X0c00),
        IndexClearValue = ((int)0X0c20),
        IndexWritemask = ((int)0X0c21),
        IndexMode = ((int)0X0c30),
        RgbaMode = ((int)0X0c31),
        RenderMode = ((int)0X0c40),
        PerspectiveCorrectionHint = ((int)0X0c50),
        PointSmoothHint = ((int)0X0c51),
        FogHint = ((int)0X0c54),
        TextureGenS = ((int)0X0c60),
        TextureGenT = ((int)0X0c61),
        TextureGenR = ((int)0X0c62),
        TextureGenQ = ((int)0X0c63),
        PixelMapIToI = ((int)0X0c70),
        PixelMapSToS = ((int)0X0c71),
        PixelMapIToR = ((int)0X0c72),
        PixelMapIToG = ((int)0X0c73),
        PixelMapIToB = ((int)0X0c74),
        PixelMapIToA = ((int)0X0c75),
        PixelMapRToR = ((int)0X0c76),
        PixelMapGToG = ((int)0X0c77),
        PixelMapBToB = ((int)0X0c78),
        PixelMapAToA = ((int)0X0c79),
        PixelMapIToISize = ((int)0X0cb0),
        PixelMapSToSSize = ((int)0X0cb1),
        PixelMapIToRSize = ((int)0X0cb2),
        PixelMapIToGSize = ((int)0X0cb3),
        PixelMapIToBSize = ((int)0X0cb4),
        PixelMapIToASize = ((int)0X0cb5),
        PixelMapRToRSize = ((int)0X0cb6),
        PixelMapGToGSize = ((int)0X0cb7),
        PixelMapBToBSize = ((int)0X0cb8),
        PixelMapAToASize = ((int)0X0cb9),
        MapColor = ((int)0X0d10),
        MapStencil = ((int)0X0d11),
        IndexShift = ((int)0X0d12),
        IndexOffset = ((int)0X0d13),
        RedScale = ((int)0X0d14),
        RedBias = ((int)0X0d15),
        ZoomX = ((int)0X0d16),
        ZoomY = ((int)0X0d17),
        GreenScale = ((int)0X0d18),
        GreenBias = ((int)0X0d19),
        BlueScale = ((int)0X0d1a),
        BlueBias = ((int)0X0d1b),
        AlphaScale = ((int)0X0d1c),
        AlphaBias = ((int)0X0d1d),
        DepthScale = ((int)0X0d1e),
        DepthBias = ((int)0X0d1f),
        MaxEvalOrder = ((int)0X0d30),
        MaxLights = ((int)0X0d31),
        MaxClipPlanes = ((int)0X0d32),
        MaxPixelMapTable = ((int)0X0d34),
        MaxAttribStackDepth = ((int)0X0d35),
        MaxModelviewStackDepth = ((int)0X0d36),
        MaxNameStackDepth = ((int)0X0d37),
        MaxProjectionStackDepth = ((int)0X0d38),
        MaxTextureStackDepth = ((int)0X0d39),
        MaxClientAttribStackDepth = ((int)0X0d3b),
        IndexBits = ((int)0X0d51),
        RedBits = ((int)0X0d52),
        GreenBits = ((int)0X0d53),
        BlueBits = ((int)0X0d54),
        AlphaBits = ((int)0X0d55),
        DepthBits = ((int)0X0d56),
        StencilBits = ((int)0X0d57),
        AccumRedBits = ((int)0X0d58),
        AccumGreenBits = ((int)0X0d59),
        AccumBlueBits = ((int)0X0d5a),
        AccumAlphaBits = ((int)0X0d5b),
        NameStackDepth = ((int)0X0d70),
        AutoNormal = ((int)0X0d80),
        Map1Color4 = ((int)0X0d90),
        Map1Index = ((int)0X0d91),
        Map1Normal = ((int)0X0d92),
        Map1TextureCoord1 = ((int)0X0d93),
        Map1TextureCoord2 = ((int)0X0d94),
        Map1TextureCoord3 = ((int)0X0d95),
        Map1TextureCoord4 = ((int)0X0d96),
        Map1Vertex3 = ((int)0X0d97),
        Map1Vertex4 = ((int)0X0d98),
        Map2Color4 = ((int)0X0db0),
        Map2Index = ((int)0X0db1),
        Map2Normal = ((int)0X0db2),
        Map2TextureCoord1 = ((int)0X0db3),
        Map2TextureCoord2 = ((int)0X0db4),
        Map2TextureCoord3 = ((int)0X0db5),
        Map2TextureCoord4 = ((int)0X0db6),
        Map2Vertex3 = ((int)0X0db7),
        Map2Vertex4 = ((int)0X0db8),
        Map1GridDomain = ((int)0X0dd0),
        Map1GridSegments = ((int)0X0dd1),
        Map2GridDomain = ((int)0X0dd2),
        Map2GridSegments = ((int)0X0dd3),
        FeedbackBufferPointer = ((int)0X0df0),
        FeedbackBufferSize = ((int)0X0df1),
        FeedbackBufferType = ((int)0X0df2),
        SelectionBufferPointer = ((int)0X0df3),
        SelectionBufferSize = ((int)0X0df4),
        TextureComponents = ((int)0X1003),
        Ambient = ((int)0X1200),
        Diffuse = ((int)0X1201),
        Specular = ((int)0X1202),
        Position = ((int)0X1203),
        SpotDirection = ((int)0X1204),
        SpotExponent = ((int)0X1205),
        SpotCutoff = ((int)0X1206),
        ConstantAttenuation = ((int)0X1207),
        LinearAttenuation = ((int)0X1208),
        QuadraticAttenuation = ((int)0X1209),
        Compile = ((int)0X1300),
        CompileAndExecute = ((int)0X1301),
        Gl2Bytes = ((int)0X1407),
        Gl3Bytes = ((int)0X1408),
        Gl4Bytes = ((int)0X1409),
        Emission = ((int)0X1600),
        Shininess = ((int)0X1601),
        AmbientAndDiffuse = ((int)0X1602),
        ColorIndexes = ((int)0X1603),
        Modelview = ((int)0X1700),
        Projection = ((int)0X1701),
        ColorIndex = ((int)0X1900),
        Luminance = ((int)0X1909),
        LuminanceAlpha = ((int)0X190a),
        Bitmap = ((int)0X1a00),
        Render = ((int)0X1c00),
        Feedback = ((int)0X1c01),
        Select = ((int)0X1c02),
        Flat = ((int)0X1d00),
        Smooth = ((int)0X1d01),
        S = ((int)0X2000),
        T = ((int)0X2001),
        R = ((int)0X2002),
        Q = ((int)0X2003),
        Modulate = ((int)0X2100),
        Decal = ((int)0X2101),
        TextureEnvMode = ((int)0X2200),
        TextureEnvColor = ((int)0X2201),
        TextureEnv = ((int)0X2300),
        EyeLinear = ((int)0X2400),
        ObjectLinear = ((int)0X2401),
        SphereMap = ((int)0X2402),
        TextureGenMode = ((int)0X2500),
        ObjectPlane = ((int)0X2501),
        EyePlane = ((int)0X2502),
        Clamp = ((int)0X2900),
        V2f = ((int)0X2a20),
        V3f = ((int)0X2a21),
        C4ubV2f = ((int)0X2a22),
        C4ubV3f = ((int)0X2a23),
        C3fV3f = ((int)0X2a24),
        N3fV3f = ((int)0X2a25),
        C4fN3fV3f = ((int)0X2a26),
        T2fV3f = ((int)0X2a27),
        T4fV4f = ((int)0X2a28),
        T2fC4ubV3f = ((int)0X2a29),
        T2fC3fV3f = ((int)0X2a2a),
        T2fN3fV3f = ((int)0X2a2b),
        T2fC4fN3fV3f = ((int)0X2a2c),
        T4fC4fN3fV4f = ((int)0X2a2d),
        ClipPlane0 = ((int)0X3000),
        ClipPlane1 = ((int)0X3001),
        ClipPlane2 = ((int)0X3002),
        ClipPlane3 = ((int)0X3003),
        ClipPlane4 = ((int)0X3004),
        ClipPlane5 = ((int)0X3005),
        Light0 = ((int)0X4000),
        Light1 = ((int)0X4001),
        Light2 = ((int)0X4002),
        Light3 = ((int)0X4003),
        Light4 = ((int)0X4004),
        Light5 = ((int)0X4005),
        Light6 = ((int)0X4006),
        Light7 = ((int)0X4007),
        Alpha4 = ((int)0X803b),
        Alpha8 = ((int)0X803c),
        Alpha12 = ((int)0X803d),
        Alpha16 = ((int)0X803e),
        Luminance4 = ((int)0X803f),
        Luminance8 = ((int)0X8040),
        Luminance12 = ((int)0X8041),
        Luminance16 = ((int)0X8042),
        Luminance4Alpha4 = ((int)0X8043),
        Luminance6Alpha2 = ((int)0X8044),
        Luminance8Alpha8 = ((int)0X8045),
        Luminance12Alpha4 = ((int)0X8046),
        Luminance12Alpha12 = ((int)0X8047),
        Luminance16Alpha16 = ((int)0X8048),
        Intensity = ((int)0X8049),
        Intensity4 = ((int)0X804a),
        Intensity8 = ((int)0X804b),
        Intensity12 = ((int)0X804c),
        Intensity16 = ((int)0X804d),
        TextureLuminanceSize = ((int)0X8060),
        TextureIntensitySize = ((int)0X8061),
        TexturePriority = ((int)0X8066),
        TextureResident = ((int)0X8067),
        VertexArray = ((int)0X8074),
        NormalArray = ((int)0X8075),
        ColorArray = ((int)0X8076),
        IndexArray = ((int)0X8077),
        TextureCoordArray = ((int)0X8078),
        EdgeFlagArray = ((int)0X8079),
        VertexArraySize = ((int)0X807a),
        VertexArrayType = ((int)0X807b),
        VertexArrayStride = ((int)0X807c),
        NormalArrayType = ((int)0X807e),
        NormalArrayStride = ((int)0X807f),
        ColorArraySize = ((int)0X8081),
        ColorArrayType = ((int)0X8082),
        ColorArrayStride = ((int)0X8083),
        IndexArrayType = ((int)0X8085),
        IndexArrayStride = ((int)0X8086),
        TextureCoordArraySize = ((int)0X8088),
        TextureCoordArrayType = ((int)0X8089),
        TextureCoordArrayStride = ((int)0X808a),
        EdgeFlagArrayStride = ((int)0X808c),
        VertexArrayPointer = ((int)0X808e),
        NormalArrayPointer = ((int)0X808f),
        ColorArrayPointer = ((int)0X8090),
        IndexArrayPointer = ((int)0X8091),
        TextureCoordArrayPointer = ((int)0X8092),
        EdgeFlagArrayPointer = ((int)0X8093),
        AllAttribBits = unchecked((int)0Xffffffff),
        ClientAllAttribBits = unchecked((int)0Xffffffff),
    }

    public enum Version12
    {
        SmoothPointSizeRange = ((int)0X0b12),
        SmoothPointSizeGranularity = ((int)0X0b13),
        SmoothLineWidthRange = ((int)0X0b22),
        SmoothLineWidthGranularity = ((int)0X0b23),
        ConstantColor = ((int)0X8001),
        OneMinusConstantColor = ((int)0X8002),
        ConstantAlpha = ((int)0X8003),
        OneMinusConstantAlpha = ((int)0X8004),
        BlendColor = ((int)0X8005),
        Convolution1D = ((int)0X8010),
        Convolution2D = ((int)0X8011),
        Separable2D = ((int)0X8012),
        ConvolutionBorderMode = ((int)0X8013),
        ConvolutionFilterScale = ((int)0X8014),
        ConvolutionFilterBias = ((int)0X8015),
        Reduce = ((int)0X8016),
        ConvolutionFormat = ((int)0X8017),
        ConvolutionWidth = ((int)0X8018),
        ConvolutionHeight = ((int)0X8019),
        MaxConvolutionWidth = ((int)0X801a),
        MaxConvolutionHeight = ((int)0X801b),
        PostConvolutionRedScale = ((int)0X801c),
        PostConvolutionGreenScale = ((int)0X801d),
        PostConvolutionBlueScale = ((int)0X801e),
        PostConvolutionAlphaScale = ((int)0X801f),
        PostConvolutionRedBias = ((int)0X8020),
        PostConvolutionGreenBias = ((int)0X8021),
        PostConvolutionBlueBias = ((int)0X8022),
        PostConvolutionAlphaBias = ((int)0X8023),
        Histogram = ((int)0X8024),
        ProxyHistogram = ((int)0X8025),
        HistogramWidth = ((int)0X8026),
        HistogramFormat = ((int)0X8027),
        HistogramRedSize = ((int)0X8028),
        HistogramGreenSize = ((int)0X8029),
        HistogramBlueSize = ((int)0X802a),
        HistogramAlphaSize = ((int)0X802b),
        HistogramSink = ((int)0X802d),
        Minmax = ((int)0X802e),
        MinmaxFormat = ((int)0X802f),
        MinmaxSink = ((int)0X8030),
        TableTooLarge = ((int)0X8031),
        UnsignedByte332 = ((int)0X8032),
        UnsignedShort4444 = ((int)0X8033),
        UnsignedShort5551 = ((int)0X8034),
        UnsignedInt8888 = ((int)0X8035),
        UnsignedInt1010102 = ((int)0X8036),
        RescaleNormal = ((int)0X803a),
        TextureBinding3D = ((int)0X806a),
        PackSkipImages = ((int)0X806b),
        PackImageHeight = ((int)0X806c),
        UnpackSkipImages = ((int)0X806d),
        UnpackImageHeight = ((int)0X806e),
        Texture3D = ((int)0X806f),
        ProxyTexture3D = ((int)0X8070),
        TextureDepth = ((int)0X8071),
        TextureWrapR = ((int)0X8072),
        Max3DTextureSize = ((int)0X8073),
        ColorMatrix = ((int)0X80b1),
        ColorMatrixStackDepth = ((int)0X80b2),
        MaxColorMatrixStackDepth = ((int)0X80b3),
        PostColorMatrixRedScale = ((int)0X80b4),
        PostColorMatrixGreenScale = ((int)0X80b5),
        PostColorMatrixBlueScale = ((int)0X80b6),
        PostColorMatrixAlphaScale = ((int)0X80b7),
        PostColorMatrixRedBias = ((int)0X80b8),
        PostColorMatrixGreenBias = ((int)0X80b9),
        PostColorMatrixBlueBias = ((int)0X80ba),
        PostColorMatrixAlphaBias = ((int)0X80bb),
        ColorTable = ((int)0X80d0),
        PostConvolutionColorTable = ((int)0X80d1),
        PostColorMatrixColorTable = ((int)0X80d2),
        ProxyColorTable = ((int)0X80d3),
        ProxyPostConvolutionColorTable = ((int)0X80d4),
        ProxyPostColorMatrixColorTable = ((int)0X80d5),
        ColorTableScale = ((int)0X80d6),
        ColorTableBias = ((int)0X80d7),
        ColorTableFormat = ((int)0X80d8),
        ColorTableWidth = ((int)0X80d9),
        ColorTableRedSize = ((int)0X80da),
        ColorTableGreenSize = ((int)0X80db),
        ColorTableBlueSize = ((int)0X80dc),
        ColorTableAlphaSize = ((int)0X80dd),
        ColorTableLuminanceSize = ((int)0X80de),
        ColorTableIntensitySize = ((int)0X80df),
        Bgr = ((int)0X80e0),
        Bgra = ((int)0X80e1),
        MaxElementsVertices = ((int)0X80e8),
        MaxElementsIndices = ((int)0X80e9),
        ClampToEdge = ((int)0X812f),
        TextureMinLod = ((int)0X813a),
        TextureMaxLod = ((int)0X813b),
        TextureBaseLevel = ((int)0X813c),
        TextureMaxLevel = ((int)0X813d),
        ConstantBorder = ((int)0X8151),
        ReplicateBorder = ((int)0X8153),
        ConvolutionBorderColor = ((int)0X8154),
        LightModelColorControl = ((int)0X81f8),
        SingleColor = ((int)0X81f9),
        SeparateSpecularColor = ((int)0X81fa),
        UnsignedByte233Rev = ((int)0X8362),
        UnsignedShort565 = ((int)0X8363),
        UnsignedShort565Rev = ((int)0X8364),
        UnsignedShort4444Rev = ((int)0X8365),
        UnsignedShort1555Rev = ((int)0X8366),
        UnsignedInt8888Rev = ((int)0X8367),
        UnsignedInt2101010Rev = ((int)0X8368),
        AliasedPointSizeRange = ((int)0X846d),
        AliasedLineWidthRange = ((int)0X846e),
    }

    public enum Version12Deprecated
    {
        RescaleNormal = ((int)0X803a),
        LightModelColorControl = ((int)0X81f8),
        SingleColor = ((int)0X81f9),
        SeparateSpecularColor = ((int)0X81fa),
        AliasedPointSizeRange = ((int)0X846d),
    }

    public enum Version13
    {
        Multisample = ((int)0X809d),
        SampleAlphaToCoverage = ((int)0X809e),
        SampleAlphaToOne = ((int)0X809f),
        SampleCoverage = ((int)0X80a0),
        SampleBuffers = ((int)0X80a8),
        Samples = ((int)0X80a9),
        SampleCoverageValue = ((int)0X80aa),
        SampleCoverageInvert = ((int)0X80ab),
        ClampToBorder = ((int)0X812d),
        Texture0 = ((int)0X84c0),
        Texture1 = ((int)0X84c1),
        Texture2 = ((int)0X84c2),
        Texture3 = ((int)0X84c3),
        Texture4 = ((int)0X84c4),
        Texture5 = ((int)0X84c5),
        Texture6 = ((int)0X84c6),
        Texture7 = ((int)0X84c7),
        Texture8 = ((int)0X84c8),
        Texture9 = ((int)0X84c9),
        Texture10 = ((int)0X84ca),
        Texture11 = ((int)0X84cb),
        Texture12 = ((int)0X84cc),
        Texture13 = ((int)0X84cd),
        Texture14 = ((int)0X84ce),
        Texture15 = ((int)0X84cf),
        Texture16 = ((int)0X84d0),
        Texture17 = ((int)0X84d1),
        Texture18 = ((int)0X84d2),
        Texture19 = ((int)0X84d3),
        Texture20 = ((int)0X84d4),
        Texture21 = ((int)0X84d5),
        Texture22 = ((int)0X84d6),
        Texture23 = ((int)0X84d7),
        Texture24 = ((int)0X84d8),
        Texture25 = ((int)0X84d9),
        Texture26 = ((int)0X84da),
        Texture27 = ((int)0X84db),
        Texture28 = ((int)0X84dc),
        Texture29 = ((int)0X84dd),
        Texture30 = ((int)0X84de),
        Texture31 = ((int)0X84df),
        ActiveTexture = ((int)0X84e0),
        CompressedRgb = ((int)0X84ed),
        CompressedRgba = ((int)0X84ee),
        TextureCompressionHint = ((int)0X84ef),
        TextureCubeMap = ((int)0X8513),
        TextureBindingCubeMap = ((int)0X8514),
        TextureCubeMapPositiveX = ((int)0X8515),
        TextureCubeMapNegativeX = ((int)0X8516),
        TextureCubeMapPositiveY = ((int)0X8517),
        TextureCubeMapNegativeY = ((int)0X8518),
        TextureCubeMapPositiveZ = ((int)0X8519),
        TextureCubeMapNegativeZ = ((int)0X851a),
        ProxyTextureCubeMap = ((int)0X851b),
        MaxCubeMapTextureSize = ((int)0X851c),
        TextureCompressedImageSize = ((int)0X86a0),
        TextureCompressed = ((int)0X86a1),
        NumCompressedTextureFormats = ((int)0X86a2),
        CompressedTextureFormats = ((int)0X86a3),
    }

    public enum Version13Deprecated
    {
        MultisampleBit = ((int)0X20000000),
        ClientActiveTexture = ((int)0X84e1),
        MaxTextureUnits = ((int)0X84e2),
        TransposeModelviewMatrix = ((int)0X84e3),
        TransposeProjectionMatrix = ((int)0X84e4),
        TransposeTextureMatrix = ((int)0X84e5),
        TransposeColorMatrix = ((int)0X84e6),
        Subtract = ((int)0X84e7),
        CompressedAlpha = ((int)0X84e9),
        CompressedLuminance = ((int)0X84ea),
        CompressedLuminanceAlpha = ((int)0X84eb),
        CompressedIntensity = ((int)0X84ec),
        NormalMap = ((int)0X8511),
        ReflectionMap = ((int)0X8512),
        Combine = ((int)0X8570),
        CombineRgb = ((int)0X8571),
        CombineAlpha = ((int)0X8572),
        RgbScale = ((int)0X8573),
        AddSigned = ((int)0X8574),
        Interpolate = ((int)0X8575),
        Constant = ((int)0X8576),
        PrimaryColor = ((int)0X8577),
        Previous = ((int)0X8578),
        Source0Rgb = ((int)0X8580),
        Source1Rgb = ((int)0X8581),
        Source2Rgb = ((int)0X8582),
        Source0Alpha = ((int)0X8588),
        Source1Alpha = ((int)0X8589),
        Source2Alpha = ((int)0X858a),
        Operand0Rgb = ((int)0X8590),
        Operand1Rgb = ((int)0X8591),
        Operand2Rgb = ((int)0X8592),
        Operand0Alpha = ((int)0X8598),
        Operand1Alpha = ((int)0X8599),
        Operand2Alpha = ((int)0X859a),
        Dot3Rgb = ((int)0X86ae),
        Dot3Rgba = ((int)0X86af),
    }

    public enum Version14
    {
        BlendDstRgb = ((int)0X80c8),
        BlendSrcRgb = ((int)0X80c9),
        BlendDstAlpha = ((int)0X80ca),
        BlendSrcAlpha = ((int)0X80cb),
        PointSizeMin = ((int)0X8126),
        PointSizeMax = ((int)0X8127),
        PointFadeThresholdSize = ((int)0X8128),
        PointDistanceAttenuation = ((int)0X8129),
        GenerateMipmap = ((int)0X8191),
        GenerateMipmapHint = ((int)0X8192),
        DepthComponent16 = ((int)0X81a5),
        DepthComponent24 = ((int)0X81a6),
        DepthComponent32 = ((int)0X81a7),
        MirroredRepeat = ((int)0X8370),
        MaxTextureLodBias = ((int)0X84fd),
        TextureLodBias = ((int)0X8501),
        IncrWrap = ((int)0X8507),
        DecrWrap = ((int)0X8508),
        TextureDepthSize = ((int)0X884a),
        TextureCompareMode = ((int)0X884c),
        TextureCompareFunc = ((int)0X884d),
    }

    public enum Version14Deprecated
    {
        PointSizeMin = ((int)0X8126),
        PointSizeMax = ((int)0X8127),
        PointDistanceAttenuation = ((int)0X8129),
        GenerateMipmap = ((int)0X8191),
        GenerateMipmapHint = ((int)0X8192),
        FogCoordinateSource = ((int)0X8450),
        FogCoordinate = ((int)0X8451),
        FragmentDepth = ((int)0X8452),
        CurrentFogCoordinate = ((int)0X8453),
        FogCoordinateArrayType = ((int)0X8454),
        FogCoordinateArrayStride = ((int)0X8455),
        FogCoordinateArrayPointer = ((int)0X8456),
        FogCoordinateArray = ((int)0X8457),
        ColorSum = ((int)0X8458),
        CurrentSecondaryColor = ((int)0X8459),
        SecondaryColorArraySize = ((int)0X845a),
        SecondaryColorArrayType = ((int)0X845b),
        SecondaryColorArrayStride = ((int)0X845c),
        SecondaryColorArrayPointer = ((int)0X845d),
        SecondaryColorArray = ((int)0X845e),
        TextureFilterControl = ((int)0X8500),
        DepthTextureMode = ((int)0X884b),
        CompareRToTexture = ((int)0X884e),
    }

    public enum Version15
    {
        BufferSize = ((int)0X8764),
        BufferUsage = ((int)0X8765),
        QueryCounterBits = ((int)0X8864),
        CurrentQuery = ((int)0X8865),
        QueryResult = ((int)0X8866),
        QueryResultAvailable = ((int)0X8867),
        ArrayBuffer = ((int)0X8892),
        ElementArrayBuffer = ((int)0X8893),
        ArrayBufferBinding = ((int)0X8894),
        ElementArrayBufferBinding = ((int)0X8895),
        VertexAttribArrayBufferBinding = ((int)0X889f),
        ReadOnly = ((int)0X88b8),
        WriteOnly = ((int)0X88b9),
        ReadWrite = ((int)0X88ba),
        BufferAccess = ((int)0X88bb),
        BufferMapped = ((int)0X88bc),
        BufferMapPointer = ((int)0X88bd),
        StreamDraw = ((int)0X88e0),
        StreamRead = ((int)0X88e1),
        StreamCopy = ((int)0X88e2),
        StaticDraw = ((int)0X88e4),
        StaticRead = ((int)0X88e5),
        StaticCopy = ((int)0X88e6),
        DynamicDraw = ((int)0X88e8),
        DynamicRead = ((int)0X88e9),
        DynamicCopy = ((int)0X88ea),
        SamplesPassed = ((int)0X8914),
    }

    public enum Version15Deprecated
    {
        FogCoordSrc = ((int)0X8450),
        FogCoord = ((int)0X8451),
        CurrentFogCoord = ((int)0X8453),
        FogCoordArrayType = ((int)0X8454),
        FogCoordArrayStride = ((int)0X8455),
        FogCoordArrayPointer = ((int)0X8456),
        FogCoordArray = ((int)0X8457),
        Src0Rgb = ((int)0X8580),
        Src1Rgb = ((int)0X8581),
        Src2Rgb = ((int)0X8582),
        Src0Alpha = ((int)0X8588),
        Src1Alpha = ((int)0X8589),
        Src2Alpha = ((int)0X858a),
        VertexArrayBufferBinding = ((int)0X8896),
        NormalArrayBufferBinding = ((int)0X8897),
        ColorArrayBufferBinding = ((int)0X8898),
        IndexArrayBufferBinding = ((int)0X8899),
        TextureCoordArrayBufferBinding = ((int)0X889a),
        EdgeFlagArrayBufferBinding = ((int)0X889b),
        SecondaryColorArrayBufferBinding = ((int)0X889c),
        FogCoordArrayBufferBinding = ((int)0X889d),
        FogCoordinateArrayBufferBinding = ((int)0X889d),
        WeightArrayBufferBinding = ((int)0X889e),
    }

    public enum Version20
    {
        BlendEquationRgb = ((int)0X8009),
        VertexAttribArrayEnabled = ((int)0X8622),
        VertexAttribArraySize = ((int)0X8623),
        VertexAttribArrayStride = ((int)0X8624),
        VertexAttribArrayType = ((int)0X8625),
        CurrentVertexAttrib = ((int)0X8626),
        VertexProgramPointSize = ((int)0X8642),
        VertexAttribArrayPointer = ((int)0X8645),
        StencilBackFunc = ((int)0X8800),
        StencilBackFail = ((int)0X8801),
        StencilBackPassDepthFail = ((int)0X8802),
        StencilBackPassDepthPass = ((int)0X8803),
        MaxDrawBuffers = ((int)0X8824),
        DrawBuffer0 = ((int)0X8825),
        DrawBuffer1 = ((int)0X8826),
        DrawBuffer2 = ((int)0X8827),
        DrawBuffer3 = ((int)0X8828),
        DrawBuffer4 = ((int)0X8829),
        DrawBuffer5 = ((int)0X882a),
        DrawBuffer6 = ((int)0X882b),
        DrawBuffer7 = ((int)0X882c),
        DrawBuffer8 = ((int)0X882d),
        DrawBuffer9 = ((int)0X882e),
        DrawBuffer10 = ((int)0X882f),
        DrawBuffer11 = ((int)0X8830),
        DrawBuffer12 = ((int)0X8831),
        DrawBuffer13 = ((int)0X8832),
        DrawBuffer14 = ((int)0X8833),
        DrawBuffer15 = ((int)0X8834),
        BlendEquationAlpha = ((int)0X883d),
        MaxVertexAttribs = ((int)0X8869),
        VertexAttribArrayNormalized = ((int)0X886a),
        MaxTextureImageUnits = ((int)0X8872),
        FragmentShader = ((int)0X8b30),
        VertexShader = ((int)0X8b31),
        MaxFragmentUniformComponents = ((int)0X8b49),
        MaxVertexUniformComponents = ((int)0X8b4a),
        MaxVaryingFloats = ((int)0X8b4b),
        MaxVertexTextureImageUnits = ((int)0X8b4c),
        MaxCombinedTextureImageUnits = ((int)0X8b4d),
        ShaderType = ((int)0X8b4f),
        FloatVec2 = ((int)0X8b50),
        FloatVec3 = ((int)0X8b51),
        FloatVec4 = ((int)0X8b52),
        IntVec2 = ((int)0X8b53),
        IntVec3 = ((int)0X8b54),
        IntVec4 = ((int)0X8b55),
        Bool = ((int)0X8b56),
        BoolVec2 = ((int)0X8b57),
        BoolVec3 = ((int)0X8b58),
        BoolVec4 = ((int)0X8b59),
        FloatMat2 = ((int)0X8b5a),
        FloatMat3 = ((int)0X8b5b),
        FloatMat4 = ((int)0X8b5c),
        Sampler1D = ((int)0X8b5d),
        Sampler2D = ((int)0X8b5e),
        Sampler3D = ((int)0X8b5f),
        SamplerCube = ((int)0X8b60),
        Sampler1DShadow = ((int)0X8b61),
        Sampler2DShadow = ((int)0X8b62),
        DeleteStatus = ((int)0X8b80),
        CompileStatus = ((int)0X8b81),
        LinkStatus = ((int)0X8b82),
        ValidateStatus = ((int)0X8b83),
        InfoLogLength = ((int)0X8b84),
        AttachedShaders = ((int)0X8b85),
        ActiveUniforms = ((int)0X8b86),
        ActiveUniformMaxLength = ((int)0X8b87),
        ShaderSourceLength = ((int)0X8b88),
        ActiveAttributes = ((int)0X8b89),
        ActiveAttributeMaxLength = ((int)0X8b8a),
        FragmentShaderDerivativeHint = ((int)0X8b8b),
        ShadingLanguageVersion = ((int)0X8b8c),
        CurrentProgram = ((int)0X8b8d),
        PointSpriteCoordOrigin = ((int)0X8ca0),
        LowerLeft = ((int)0X8ca1),
        UpperLeft = ((int)0X8ca2),
        StencilBackRef = ((int)0X8ca3),
        StencilBackValueMask = ((int)0X8ca4),
        StencilBackWritemask = ((int)0X8ca5),
    }

    public enum Version20Deprecated
    {
        VertexProgramTwoSide = ((int)0X8643),
        PointSprite = ((int)0X8861),
        CoordReplace = ((int)0X8862),
        MaxTextureCoords = ((int)0X8871),
    }

    public enum Version21
    {
        PixelPackBuffer = ((int)0X88eb),
        PixelUnpackBuffer = ((int)0X88ec),
        PixelPackBufferBinding = ((int)0X88ed),
        PixelUnpackBufferBinding = ((int)0X88ef),
        FloatMat2x3 = ((int)0X8b65),
        FloatMat2x4 = ((int)0X8b66),
        FloatMat3x2 = ((int)0X8b67),
        FloatMat3x4 = ((int)0X8b68),
        FloatMat4x2 = ((int)0X8b69),
        FloatMat4x3 = ((int)0X8b6a),
        Srgb = ((int)0X8c40),
        Srgb8 = ((int)0X8c41),
        SrgbAlpha = ((int)0X8c42),
        Srgb8Alpha8 = ((int)0X8c43),
        CompressedSrgb = ((int)0X8c48),
        CompressedSrgbAlpha = ((int)0X8c49),
    }

    public enum Version21Deprecated
    {
        CurrentRasterSecondaryColor = ((int)0X845f),
        SluminanceAlpha = ((int)0X8c44),
        Sluminance8Alpha8 = ((int)0X8c45),
        Sluminance = ((int)0X8c46),
        Sluminance8 = ((int)0X8c47),
        CompressedSluminance = ((int)0X8c4a),
        CompressedSluminanceAlpha = ((int)0X8c4b),
    }

    public enum Version30
    {
        ContextFlagForwardCompatibleBit = ((int)0X0001),
        MapReadBit = ((int)0X0001),
        MapWriteBit = ((int)0X0002),
        MapInvalidateRangeBit = ((int)0X0004),
        MapInvalidateBufferBit = ((int)0X0008),
        MapFlushExplicitBit = ((int)0X0010),
        MapUnsynchronizedBit = ((int)0X0020),
        InvalidFramebufferOperation = ((int)0X0506),
        MaxClipDistances = ((int)0X0d32),
        HalfFloat = ((int)0X140b),
        ClipDistance0 = ((int)0X3000),
        ClipDistance1 = ((int)0X3001),
        ClipDistance2 = ((int)0X3002),
        ClipDistance3 = ((int)0X3003),
        ClipDistance4 = ((int)0X3004),
        ClipDistance5 = ((int)0X3005),
        ClipDistance6 = ((int)0X3006),
        ClipDistance7 = ((int)0X3007),
        FramebufferAttachmentColorEncoding = ((int)0X8210),
        FramebufferAttachmentComponentType = ((int)0X8211),
        FramebufferAttachmentRedSize = ((int)0X8212),
        FramebufferAttachmentGreenSize = ((int)0X8213),
        FramebufferAttachmentBlueSize = ((int)0X8214),
        FramebufferAttachmentAlphaSize = ((int)0X8215),
        FramebufferAttachmentDepthSize = ((int)0X8216),
        FramebufferAttachmentStencilSize = ((int)0X8217),
        FramebufferDefault = ((int)0X8218),
        FramebufferUndefined = ((int)0X8219),
        DepthStencilAttachment = ((int)0X821a),
        MajorVersion = ((int)0X821b),
        MinorVersion = ((int)0X821c),
        NumExtensions = ((int)0X821d),
        ContextFlags = ((int)0X821e),
        DepthBuffer = ((int)0X8223),
        StencilBuffer = ((int)0X8224),
        CompressedRed = ((int)0X8225),
        CompressedRg = ((int)0X8226),
        Rg = ((int)0X8227),
        RgInteger = ((int)0X8228),
        R8 = ((int)0X8229),
        R16 = ((int)0X822a),
        Rg8 = ((int)0X822b),
        Rg16 = ((int)0X822c),
        R16f = ((int)0X822D),
        R32f = ((int)0X822e),
        Rg16f = ((int)0X822f),
        Rg32f = ((int)0X8230),
        R8i = ((int)0X8231),
        R8ui = ((int)0X8232),
        R16i = ((int)0X8233),
        R16ui = ((int)0X8234),
        R32i = ((int)0X8235),
        R32ui = ((int)0X8236),
        Rg8i = ((int)0X8237),
        Rg8ui = ((int)0X8238),
        Rg16i = ((int)0X8239),
        Rg16ui = ((int)0X823a),
        Rg32i = ((int)0X823b),
        Rg32ui = ((int)0X823c),
        MaxRenderbufferSize = ((int)0X84e8),
        DepthStencil = ((int)0X84f9),
        UnsignedInt248 = ((int)0X84fa),
        VertexArrayBinding = ((int)0X85b5),
        Rgba32f = ((int)0X8814),
        Rgb32f = ((int)0X8815),
        Rgba16f = ((int)0X881a),
        Rgb16f = ((int)0X881b),
        CompareRefToTexture = ((int)0X884e),
        Depth24Stencil8 = ((int)0X88f0),
        TextureStencilSize = ((int)0X88f1),
        VertexAttribArrayInteger = ((int)0X88fd),
        MaxArrayTextureLayers = ((int)0X88ff),
        MinProgramTexelOffset = ((int)0X8904),
        MaxProgramTexelOffset = ((int)0X8905),
        ClampReadColor = ((int)0X891c),
        FixedOnly = ((int)0X891d),
        MaxVaryingComponents = ((int)0X8b4b),
        TextureRedType = ((int)0X8c10),
        TextureGreenType = ((int)0X8c11),
        TextureBlueType = ((int)0X8c12),
        TextureAlphaType = ((int)0X8c13),
        TextureDepthType = ((int)0X8c16),
        UnsignedNormalized = ((int)0X8c17),
        Texture1DArray = ((int)0X8c18),
        ProxyTexture1DArray = ((int)0X8c19),
        Texture2DArray = ((int)0X8c1a),
        ProxyTexture2DArray = ((int)0X8c1b),
        TextureBinding1DArray = ((int)0X8c1c),
        TextureBinding2DArray = ((int)0X8c1d),
        R11fG11fB10f = ((int)0X8c3a),
        UnsignedInt10F11F11FRev = ((int)0X8c3b),
        Rgb9E5 = ((int)0X8c3d),
        UnsignedInt5999Rev = ((int)0X8c3e),
        TextureSharedSize = ((int)0X8c3f),
        TransformFeedbackVaryingMaxLength = ((int)0X8c76),
        TransformFeedbackBufferMode = ((int)0X8c7f),
        MaxTransformFeedbackSeparateComponents = ((int)0X8c80),
        TransformFeedbackVaryings = ((int)0X8c83),
        TransformFeedbackBufferStart = ((int)0X8c84),
        TransformFeedbackBufferSize = ((int)0X8c85),
        PrimitivesGenerated = ((int)0X8c87),
        TransformFeedbackPrimitivesWritten = ((int)0X8c88),
        RasterizerDiscard = ((int)0X8c89),
        MaxTransformFeedbackInterleavedComponents = ((int)0X8c8a),
        MaxTransformFeedbackSeparateAttribs = ((int)0X8c8b),
        InterleavedAttribs = ((int)0X8c8c),
        SeparateAttribs = ((int)0X8c8d),
        TransformFeedbackBuffer = ((int)0X8c8e),
        TransformFeedbackBufferBinding = ((int)0X8c8f),
        DrawFramebufferBinding = ((int)0X8ca6),
        FramebufferBinding = ((int)0X8ca6),
        RenderbufferBinding = ((int)0X8ca7),
        ReadFramebuffer = ((int)0X8ca8),
        DrawFramebuffer = ((int)0X8ca9),
        ReadFramebufferBinding = ((int)0X8caa),
        RenderbufferSamples = ((int)0X8cab),
        DepthComponent32f = ((int)0X8cac),
        Depth32fStencil8 = ((int)0X8cad),
        FramebufferAttachmentObjectType = ((int)0X8cd0),
        FramebufferAttachmentObjectName = ((int)0X8cd1),
        FramebufferAttachmentTextureLevel = ((int)0X8cd2),
        FramebufferAttachmentTextureCubeMapFace = ((int)0X8cd3),
        FramebufferAttachmentTextureLayer = ((int)0X8cd4),
        FramebufferComplete = ((int)0X8cd5),
        FramebufferIncompleteAttachment = ((int)0X8cd6),
        FramebufferIncompleteMissingAttachment = ((int)0X8cd7),
        FramebufferIncompleteDrawBuffer = ((int)0X8cdb),
        FramebufferIncompleteReadBuffer = ((int)0X8cdc),
        FramebufferUnsupported = ((int)0X8cdd),
        MaxColorAttachments = ((int)0X8cdf),
        ColorAttachment0 = ((int)0X8ce0),
        ColorAttachment1 = ((int)0X8ce1),
        ColorAttachment2 = ((int)0X8ce2),
        ColorAttachment3 = ((int)0X8ce3),
        ColorAttachment4 = ((int)0X8ce4),
        ColorAttachment5 = ((int)0X8ce5),
        ColorAttachment6 = ((int)0X8ce6),
        ColorAttachment7 = ((int)0X8ce7),
        ColorAttachment8 = ((int)0X8ce8),
        ColorAttachment9 = ((int)0X8ce9),
        ColorAttachment10 = ((int)0X8cea),
        ColorAttachment11 = ((int)0X8ceb),
        ColorAttachment12 = ((int)0X8cec),
        ColorAttachment13 = ((int)0X8ced),
        ColorAttachment14 = ((int)0X8cee),
        ColorAttachment15 = ((int)0X8cef),
        DepthAttachment = ((int)0X8D00),
        StencilAttachment = ((int)0X8D20),
        Framebuffer = ((int)0X8D40),
        Renderbuffer = ((int)0X8D41),
        RenderbufferWidth = ((int)0X8D42),
        RenderbufferHeight = ((int)0X8D43),
        RenderbufferInternalFormat = ((int)0X8D44),
        StencilIndex1 = ((int)0X8D46),
        StencilIndex4 = ((int)0X8D47),
        StencilIndex8 = ((int)0X8D48),
        StencilIndex16 = ((int)0X8D49),
        RenderbufferRedSize = ((int)0X8D50),
        RenderbufferGreenSize = ((int)0X8D51),
        RenderbufferBlueSize = ((int)0X8D52),
        RenderbufferAlphaSize = ((int)0X8D53),
        RenderbufferDepthSize = ((int)0X8D54),
        RenderbufferStencilSize = ((int)0X8D55),
        FramebufferIncompleteMultisample = ((int)0X8D56),
        MaxSamples = ((int)0X8D57),
        Rgba32ui = ((int)0X8d70),
        Rgb32ui = ((int)0X8d71),
        Rgba16ui = ((int)0X8d76),
        Rgb16ui = ((int)0X8d77),
        Rgba8ui = ((int)0X8d7c),
        Rgb8ui = ((int)0X8d7d),
        Rgba32i = ((int)0X8d82),
        Rgb32i = ((int)0X8d83),
        Rgba16i = ((int)0X8d88),
        Rgb16i = ((int)0X8d89),
        Rgba8i = ((int)0X8d8e),
        Rgb8i = ((int)0X8d8f),
        RedInteger = ((int)0X8d94),
        GreenInteger = ((int)0X8d95),
        BlueInteger = ((int)0X8d96),
        RgbInteger = ((int)0X8d98),
        RgbaInteger = ((int)0X8d99),
        BgrInteger = ((int)0X8d9a),
        BgraInteger = ((int)0X8d9b),
        Float32UnsignedInt248Rev = ((int)0X8Dad),
        FramebufferSrgb = ((int)0X8Db9),
        CompressedRedRgtc1 = ((int)0X8Dbb),
        CompressedSignedRedRgtc1 = ((int)0X8Dbc),
        CompressedRgRgtc2 = ((int)0X8Dbd),
        CompressedSignedRgRgtc2 = ((int)0X8Dbe),
        Sampler1DArray = ((int)0X8dc0),
        Sampler2DArray = ((int)0X8dc1),
        Sampler1DArrayShadow = ((int)0X8dc3),
        Sampler2DArrayShadow = ((int)0X8dc4),
        SamplerCubeShadow = ((int)0X8dc5),
        UnsignedIntVec2 = ((int)0X8dc6),
        UnsignedIntVec3 = ((int)0X8dc7),
        UnsignedIntVec4 = ((int)0X8dc8),
        IntSampler1D = ((int)0X8dc9),
        IntSampler2D = ((int)0X8dca),
        IntSampler3D = ((int)0X8dcb),
        IntSamplerCube = ((int)0X8dcc),
        IntSampler1DArray = ((int)0X8dce),
        IntSampler2DArray = ((int)0X8dcf),
        UnsignedIntSampler1D = ((int)0X8dd1),
        UnsignedIntSampler2D = ((int)0X8dd2),
        UnsignedIntSampler3D = ((int)0X8dd3),
        UnsignedIntSamplerCube = ((int)0X8dd4),
        UnsignedIntSampler1DArray = ((int)0X8dd6),
        UnsignedIntSampler2DArray = ((int)0X8dd7),
        QueryWait = ((int)0X8e13),
        QueryNoWait = ((int)0X8e14),
        QueryByRegionWait = ((int)0X8e15),
        QueryByRegionNoWait = ((int)0X8e16),
        BufferAccessFlags = ((int)0X911f),
        BufferMapLength = ((int)0X9120),
        BufferMapOffset = ((int)0X9121),
    }

    public enum Version30Deprecated
    {
        ClampVertexColor = ((int)0X891a),
        ClampFragmentColor = ((int)0X891b),
        AlphaInteger = ((int)0X8d97),
    }

    public enum Version31
    {
        TextureRectangle = ((int)0X84f5),
        TextureBindingRectangle = ((int)0X84f6),
        ProxyTextureRectangle = ((int)0X84f7),
        MaxRectangleTextureSize = ((int)0X84f8),
        UniformBuffer = ((int)0X8a11),
        UniformBufferBinding = ((int)0X8a28),
        UniformBufferStart = ((int)0X8a29),
        UniformBufferSize = ((int)0X8a2a),
        MaxVertexUniformBlocks = ((int)0X8a2b),
        MaxFragmentUniformBlocks = ((int)0X8a2D),
        MaxCombinedUniformBlocks = ((int)0X8a2e),
        MaxUniformBufferBindings = ((int)0X8a2f),
        MaxUniformBlockSize = ((int)0X8a30),
        MaxCombinedVertexUniformComponents = ((int)0X8a31),
        MaxCombinedFragmentUniformComponents = ((int)0X8a33),
        UniformBufferOffsetAlignment = ((int)0X8a34),
        ActiveUniformBlockMaxNameLength = ((int)0X8a35),
        ActiveUniformBlocks = ((int)0X8a36),
        UniformType = ((int)0X8a37),
        UniformSize = ((int)0X8a38),
        UniformNameLength = ((int)0X8a39),
        UniformBlockIndex = ((int)0X8a3a),
        UniformOffset = ((int)0X8a3b),
        UniformArrayStride = ((int)0X8a3c),
        UniformMatrixStride = ((int)0X8a3D),
        UniformIsRowMajor = ((int)0X8a3e),
        UniformBlockBinding = ((int)0X8a3f),
        UniformBlockDataSize = ((int)0X8a40),
        UniformBlockNameLength = ((int)0X8a41),
        UniformBlockActiveUniforms = ((int)0X8a42),
        UniformBlockActiveUniformIndices = ((int)0X8a43),
        UniformBlockReferencedByVertexShader = ((int)0X8a44),
        UniformBlockReferencedByFragmentShader = ((int)0X8a46),
        Sampler2DRect = ((int)0X8b63),
        Sampler2DRectShadow = ((int)0X8b64),
        TextureBuffer = ((int)0X8c2a),
        MaxTextureBufferSize = ((int)0X8c2b),
        TextureBindingBuffer = ((int)0X8c2c),
        TextureBufferDataStoreBinding = ((int)0X8c2d),
        TextureBufferFormat = ((int)0X8c2e),
        SamplerBuffer = ((int)0X8dc2),
        IntSampler2DRect = ((int)0X8dcd),
        IntSamplerBuffer = ((int)0X8dd0),
        UnsignedIntSampler2DRect = ((int)0X8dd5),
        UnsignedIntSamplerBuffer = ((int)0X8dd8),
        CopyReadBuffer = ((int)0X8f36),
        CopyWriteBuffer = ((int)0X8f37),
        RedSnorm = ((int)0X8f90),
        RgSnorm = ((int)0X8f91),
        RgbSnorm = ((int)0X8f92),
        RgbaSnorm = ((int)0X8f93),
        R8Snorm = ((int)0X8f94),
        Rg8Snorm = ((int)0X8f95),
        Rgb8Snorm = ((int)0X8f96),
        Rgba8Snorm = ((int)0X8f97),
        R16Snorm = ((int)0X8f98),
        Rg16Snorm = ((int)0X8f99),
        Rgb16Snorm = ((int)0X8f9a),
        Rgba16Snorm = ((int)0X8f9b),
        SignedNormalized = ((int)0X8f9c),
        PrimitiveRestart = ((int)0X8f9d),
        PrimitiveRestartIndex = ((int)0X8f9e),
        InvalidIndex = unchecked((int)0Xffffffff),
    }

    public enum Version32
    {
        ContextCoreProfileBit = ((int)0X00000001),
        SyncFlushCommandsBit = ((int)0X00000001),
        ContextCompatibilityProfileBit = ((int)0X00000002),
        LinesAdjacency = ((int)0X000a),
        LineStripAdjacency = ((int)0X000b),
        TrianglesAdjacency = ((int)0X000c),
        TriangleStripAdjacency = ((int)0X000d),
        ProgramPointSize = ((int)0X8642),
        DepthClamp = ((int)0X864f),
        TextureCubeMapSeamless = ((int)0X884f),
        GeometryVerticesOut = ((int)0X8916),
        GeometryInputType = ((int)0X8917),
        GeometryOutputType = ((int)0X8918),
        MaxVaryingComponents = ((int)0X8b4b),
        MaxGeometryTextureImageUnits = ((int)0X8c29),
        FramebufferAttachmentTextureLayer = ((int)0X8cd4),
        FramebufferAttachmentLayered = ((int)0X8da7),
        FramebufferIncompleteLayerTargets = ((int)0X8da8),
        GeometryShader = ((int)0X8dd9),
        MaxGeometryUniformComponents = ((int)0X8ddf),
        MaxGeometryOutputVertices = ((int)0X8de0),
        MaxGeometryTotalOutputComponents = ((int)0X8de1),
        QuadsFollowProvokingVertexConvention = ((int)0X8e4c),
        FirstVertexConvention = ((int)0X8e4D),
        LastVertexConvention = ((int)0X8e4e),
        ProvokingVertex = ((int)0X8e4f),
        SamplePosition = ((int)0X8e50),
        SampleMask = ((int)0X8e51),
        SampleMaskValue = ((int)0X8e52),
        MaxSampleMaskWords = ((int)0X8e59),
        Texture2DMultisample = ((int)0X9100),
        ProxyTexture2DMultisample = ((int)0X9101),
        Texture2DMultisampleArray = ((int)0X9102),
        ProxyTexture2DMultisampleArray = ((int)0X9103),
        TextureBinding2DMultisample = ((int)0X9104),
        TextureBinding2DMultisampleArray = ((int)0X9105),
        TextureSamples = ((int)0X9106),
        TextureFixedSampleLocations = ((int)0X9107),
        Sampler2DMultisample = ((int)0X9108),
        IntSampler2DMultisample = ((int)0X9109),
        UnsignedIntSampler2DMultisample = ((int)0X910a),
        Sampler2DMultisampleArray = ((int)0X910b),
        IntSampler2DMultisampleArray = ((int)0X910c),
        UnsignedIntSampler2DMultisampleArray = ((int)0X910D),
        MaxColorTextureSamples = ((int)0X910e),
        MaxDepthTextureSamples = ((int)0X910f),
        MaxIntegerSamples = ((int)0X9110),
        MaxServerWaitTimeout = ((int)0X9111),
        ObjectType = ((int)0X9112),
        SyncCondition = ((int)0X9113),
        SyncStatus = ((int)0X9114),
        SyncFlags = ((int)0X9115),
        SyncFence = ((int)0X9116),
        SyncGpuCommandsComplete = ((int)0X9117),
        Unsignaled = ((int)0X9118),
        Signaled = ((int)0X9119),
        AlreadySignaled = ((int)0X911a),
        TimeoutExpired = ((int)0X911b),
        ConditionSatisfied = ((int)0X911c),
        WaitFailed = ((int)0X911D),
        MaxVertexOutputComponents = ((int)0X9122),
        MaxGeometryInputComponents = ((int)0X9123),
        MaxGeometryOutputComponents = ((int)0X9124),
        MaxFragmentInputComponents = ((int)0X9125),
        ContextProfileMask = ((int)0X9126),
        TimeoutIgnored = unchecked((int)0Xffffffffffffffff),
    }

    public enum VertexAttribParameter
    {
        ArrayEnabled = ((int)0X8622),
        ArraySize = ((int)0X8623),
        ArrayStride = ((int)0X8624),
        ArrayType = ((int)0X8625),
        CurrentVertexAttrib = ((int)0X8626),
        ArrayNormalized = ((int)0X886a),
        VertexAttribArrayInteger = ((int)0X88fd),
    }

    public enum VertexAttribParameterArb
    {
        ArrayEnabled = ((int)0X8622),
        ArraySize = ((int)0X8623),
        ArrayStride = ((int)0X8624),
        ArrayType = ((int)0X8625),
        CurrentVertexAttrib = ((int)0X8626),
        ArrayNormalized = ((int)0X886a),
        ArrayDivisor = ((int)0X88fe),
    }

    public enum VertexAttribPointerParameter
    {
        ArrayPointer = ((int)0X8645),
    }

    public enum VertexAttribPointerParameterArb
    {
        ArrayPointer = ((int)0X8645),
    }

    public enum VertexAttribPointerType
    {
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
        HalfFloat = ((int)0X140b),
    }

    public enum VertexAttribPointerTypeArb
    {
        Byte = ((int)0X1400),
        UnsignedByte = ((int)0X1401),
        Short = ((int)0X1402),
        UnsignedShort = ((int)0X1403),
        Int = ((int)0X1404),
        UnsignedInt = ((int)0X1405),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
    }

    public enum VertexPointerType
    {
        Short = ((int)0X1402),
        Int = ((int)0X1404),
        Float = ((int)0X1406),
        Double = ((int)0X140a),
        HalfFloat = ((int)0X140b),
    }

    public enum WinPhongShading
    {
        PhongWin = ((int)0X80ea),
        PhongHintWin = ((int)0X80eb),
    }

    public enum WinSpecularFog
    {
        FogSpecularTextureWin = ((int)0X80ec),
    }

}
