/******************************************************************************
 * Copyright © 2012-2014 Institut für Nachrichtentechnik, Universität Rostock *
 * Copyright © 2006-2012 Quality & Usability Lab,                             *
 *                       Telekom Innovation Laboratories, TU Berlin           *
 *                                                                            *
 * This file is part of the SoundScape Renderer (SSR).                        *
 *                                                                            *
 * The SSR is free software:  you can redistribute it and/or modify it  under *
 * the terms of the  GNU  General  Public  License  as published by the  Free *
 * Software Foundation, either version 3 of the License,  or (at your option) *
 * any later version.                                                         *
 *                                                                            *
 * The SSR is distributed in the hope that it will be useful, but WITHOUT ANY *
 * WARRANTY;  without even the implied warranty of MERCHANTABILITY or FITNESS *
 * FOR A PARTICULAR PURPOSE.                                                  *
 * See the GNU General Public License for more details.                       *
 *                                                                            *
 * You should  have received a copy  of the GNU General Public License  along *
 * with this program.  If not, see <http://www.gnu.org/licenses/>.            *
 *                                                                            *
 * The SSR is a tool  for  real-time  spatial audio reproduction  providing a *
 * variety of rendering algorithms.                                           *
 *                                                                            *
 * http://spatialaudio.net/ssr                           ssr@spatialaudio.net *
 ******************************************************************************/

/// @file
/// QClickTextLabel

#ifndef SSR_QCLICKTEXTLABEL_H
#define SSR_QCLICKTEXTLABEL_H

#include <QtGui/QMouseEvent>
#include <QtWidgets/QLabel>

/// QClickTextLabel
class QClickTextLabel : public QLabel
{
  Q_OBJECT

  public:
    QClickTextLabel( QWidget* parent = 0, int ID = 0);
    QClickTextLabel( const QString& text, QWidget * parent = 0);

  protected:
    int ID;

    void mousePressEvent(QMouseEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);

  signals:
    void clicked();
    void clicked(int);
    void signal_double_clicked();
    void signal_right_clicked(QMouseEvent *);

};

#endif
